/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.panels.table;

import com.topcoder.client.contestApplet.ContestApplet;
import com.topcoder.client.contestApplet.common.MenuItemInfo;
import com.topcoder.client.contestApplet.panels.table.UserNameEntry;
import com.topcoder.client.contestApplet.panels.table.UserTablePanel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public final class ActiveUsersTablePanel
extends UserTablePanel {
    private final MenuItemInfo[] ACTIVE_USER_POPUP = new MenuItemInfo[]{new MenuItemInfo("Info", new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            ActiveUsersTablePanel.this.infoPopupEvent();
        }
    }), new MenuItemInfo("Search..", new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            ActiveUsersTablePanel.this.searchPopupEvent();
        }
    })};
    private JFrame jf = null;

    public ActiveUsersTablePanel(ContestApplet contestApplet, JFrame jFrame) {
        super(contestApplet, "Who's logged in");
        this.jf = jFrame;
        this.setContestPopup("User Info", this.ACTIVE_USER_POPUP);
        this.setToolTipText("List of users who are currently logged into the applet.");
        this.tableModel.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent tableModelEvent) {
                ActiveUsersTablePanel.this.tableCountEvent();
            }
        });
    }

    void tableCountEvent() {
        ((TitledBorder)this.getBorder()).setTitle("Who's logged in [" + this.contestTable.getRowCount() + "]");
        this.revalidate();
        this.repaint();
    }

    void doubleClickEvent(MouseEvent mouseEvent) {
        if (this.isEnabled() && mouseEvent.getClickCount() > 1 && SwingUtilities.isLeftMouseButton(mouseEvent)) {
            this.infoPopupEvent();
        }
    }

    protected void infoPopupEvent() {
        int n = this.contestTable.getSelectedRow();
        String string = ((UserNameEntry)this.contestTable.getValueAt(n, 1)).getName();
        this.ca.setCurrentFrame(this.jf);
        this.ca.requestCoderInfo(string, ((UserNameEntry)this.contestTable.getValueAt(n, 1)).getUserType());
    }

    private void searchPopupEvent() {
        int n = this.contestTable.getSelectedRow();
        String string = ((UserNameEntry)this.contestTable.getValueAt(n, 1)).getName();
        this.ca.setCurrentFrame(this.jf);
        this.ca.getInterFrame().showMessage("Fetching search results...", 41);
        this.ca.getModel().getRequester().requestSearch(string);
    }
}

