/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.panels.room.comp;

import com.topcoder.client.contestApplet.ContestApplet;
import com.topcoder.client.contestApplet.common.Common;
import com.topcoder.client.contestApplet.panels.room.comp.RoomCompPanel;
import com.topcoder.client.contestApplet.widgets.ImageIconPanel;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JLabel;
import javax.swing.JPanel;

public final class CompPanel
extends ImageIconPanel {
    private RoomCompPanel contestPanel = null;
    protected String n = null;
    private JLabel roomName = new JLabel("", 0);
    private JLabel contestName = new JLabel("", 0);

    public CompPanel(ContestApplet contestApplet, RoomCompPanel roomCompPanel, String string, String string2) {
        this(contestApplet, roomCompPanel);
        this.setRoomName(string);
        this.setContestName(string2);
    }

    public CompPanel(ContestApplet contestApplet, RoomCompPanel roomCompPanel, String string) {
        this(contestApplet, roomCompPanel);
        this.setRoomName(string);
        this.setContestName("");
    }

    public CompPanel(ContestApplet contestApplet, RoomCompPanel roomCompPanel) {
        super((LayoutManager)new GridBagLayout(), Common.getImage("comp_area.gif", contestApplet));
        this.roomName.setForeground(Common.COMPS_RN);
        this.contestName.setForeground(Common.COMPS_CN);
        this.setMinimumSize(new Dimension(552, 72));
        this.setPreferredSize(new Dimension(552, 72));
        this.contestPanel = roomCompPanel;
        this.createTitlePanel();
    }

    private void createTitlePanel() {
        GridBagConstraints gridBagConstraints = Common.getDefaultConstraints();
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setMinimumSize(new Dimension(240, 20));
        jPanel.setPreferredSize(new Dimension(240, 20));
        jPanel.setOpaque(false);
        gridBagConstraints.anchor = 16;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        Common.insertInPanel(this.roomName, jPanel, gridBagConstraints, 0, 0, 1, 1, 0.0, 0.1);
        Common.insertInPanel(this.contestName, jPanel, gridBagConstraints, 1, 0, 1, 1, 1.0, 0.1);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 260, 0, 0);
        Common.insertInPanel(jPanel, this, gridBagConstraints, 0, 0, 1, 1, 0.1, 0.1);
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(12, 12, 12, 12);
        Common.insertInPanel(this.contestPanel, this, gridBagConstraints, 0, 1, 1, 1, 0.1, 0.2);
    }

    public void setRoomName(String string) {
        if (string.equals("")) {
            this.roomName.setText("");
        } else {
            this.roomName.setText("> " + string);
        }
    }

    public void setContestName(String string) {
        if (string.equals("")) {
            this.contestName.setText("");
        } else {
            this.contestName.setText(": " + string);
        }
    }

    public RoomCompPanel getContestPanel() {
        return this.contestPanel;
    }

    public void clear() {
        this.setContestName("");
    }
}

