/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.panels.room;

import com.topcoder.client.contestApplet.ContestApplet;
import com.topcoder.client.contestApplet.common.Common;
import com.topcoder.client.contestApplet.frames.RoomListFrame;
import com.topcoder.client.contestApplet.panels.room.BroadcastRoomPanel;
import com.topcoder.client.contestApplet.panels.room.LeaderBoardPanel;
import com.topcoder.client.contestApplet.panels.room.RankPanel;
import com.topcoder.client.contestApplet.panels.room.TimerPanel;
import com.topcoder.client.contestApplet.panels.room.comp.CompPanel;
import com.topcoder.client.contestApplet.panels.room.comp.RoomCompPanel;
import com.topcoder.client.contestApplet.widgets.ImageIconPanel;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class RoomPanel
extends ImageIconPanel {
    private String roomName = null;
    private ContestApplet parentFrame = null;
    private CompPanel cp = null;
    private TimerPanel tp = null;
    private RankPanel rp = null;
    private JPanel wp = null;
    private BroadcastRoomPanel bp = null;
    private LeaderBoardPanel leaderBoardPanel = null;
    private JLabel connStatus = null;
    protected RoomListFrame rlf = null;

    public RoomPanel(String string, ContestApplet contestApplet, JPanel jPanel) {
        this(string, contestApplet, jPanel, new RoomCompPanel());
    }

    public RoomPanel(String string, ContestApplet contestApplet, JPanel jPanel, RoomCompPanel roomCompPanel) {
        super((LayoutManager)new GridBagLayout(), Common.getImage("background_2.jpg", contestApplet));
        this.roomName = string;
        this.parentFrame = contestApplet;
        this.wp = jPanel;
        this.create(roomCompPanel);
    }

    private void create(RoomCompPanel roomCompPanel) {
        GridBagConstraints gridBagConstraints = Common.getDefaultConstraints();
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setOpaque(false);
        this.setBackground(Common.BG_COLOR);
        this.cp = new CompPanel(this.parentFrame, roomCompPanel, this.roomName, "");
        this.tp = new TimerPanel(this.parentFrame);
        this.rp = new RankPanel(this.parentFrame);
        this.bp = new BroadcastRoomPanel(this.parentFrame);
        this.leaderBoardPanel = new LeaderBoardPanel(this.parentFrame);
        if (this.wp == null) {
            this.wp = new JPanel();
        }
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        Common.insertInPanel(this.cp, jPanel, gridBagConstraints, 0, 0, 1, 1, 0.0, 0.0);
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.connStatus = new JLabel(Common.getImage("connected.gif", this.parentFrame));
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setBackground(Common.BG_COLOR);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 12;
        JLabel jLabel = new JLabel("Connection Status: ");
        jLabel.setForeground(Common.TIMER_COLOR);
        jLabel.setFont(new Font("SansSerif", 0, 10));
        Common.insertInPanel(jLabel, jPanel2, gridBagConstraints, 0, 0, 1, 1, 0.1, 0.1);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 12;
        Common.insertInPanel(this.connStatus, jPanel2, gridBagConstraints, 1, 0, 1, 1, 0.1, 0.1);
        gridBagConstraints.insets = new Insets(5, 40, 0, 0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 12;
        Common.insertInPanel(jPanel2, jPanel, gridBagConstraints, 1, 0, 1, 1, 0.0, 0.0);
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        Common.insertInPanel(this.tp, jPanel, gridBagConstraints, 1, 0, 2, 1, 0.0, 0.0);
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        JLabel jLabel2 = new JLabel(Common.getImage("top_rt.gif", this.parentFrame));
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel3.setBackground(Common.WPB_COLOR);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 12;
        Common.insertInPanel(jLabel2, jPanel3, gridBagConstraints, 0, 0, 1, 1, 0.1, 0.1);
        gridBagConstraints.insets = new Insets(50, 0, 0, 0);
        gridBagConstraints.fill = 1;
        Common.insertInPanel(jPanel3, jPanel, gridBagConstraints, 2, 0, 2, 1, 1.0, 0.0);
        gridBagConstraints.insets = new Insets(10, 21, 0, 15);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        Common.insertInPanel(jPanel, this, gridBagConstraints, 0, 0, 2, 1, 0.0, 0.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 21, 0, 0);
        Common.insertInPanel(this.rp, this, gridBagConstraints, 0, 1, 1, 1, 0.0, 0.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 21, 0, 0);
        Common.insertInPanel(this.bp, this, gridBagConstraints, 0, 2, 1, 1, 0.0, 0.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 21, 0, 0);
        Common.insertInPanel(this.leaderBoardPanel, this, gridBagConstraints, 0, 3, 1, 1, 0.0, 0.0);
        JLabel jLabel3 = new JLabel(Common.getImage("bottom_left.gif", this.parentFrame));
        JPanel jPanel4 = new JPanel(new GridBagLayout());
        jPanel4.setBackground(Common.WPB_COLOR);
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 16;
        Common.insertInPanel(jLabel3, jPanel4, gridBagConstraints, 0, 0, 1, 1, 0.1, 0.1);
        gridBagConstraints.insets = new Insets(0, 105, 15, 0);
        gridBagConstraints.fill = 1;
        Common.insertInPanel(jPanel4, this, gridBagConstraints, 0, 3, 1, 1, 0.0, 1.0);
        gridBagConstraints.insets = new Insets(0, 0, 15, 15);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        Common.insertInPanel(this.wp, this, gridBagConstraints, 1, 1, 1, 3, 1.0, 1.0);
        this.tp.setVisible(false);
    }

    public void clear() {
        this.cp.clear();
    }

    public CompPanel getCompPanel() {
        return this.cp;
    }

    public TimerPanel getTimerPanel() {
        return this.tp;
    }

    public void setStatusLabel(boolean bl) {
        if (bl) {
            this.connStatus.setIcon(Common.getImage("connected.gif", this.parentFrame));
        } else {
            this.connStatus.setIcon(Common.getImage("disconnected.gif", this.parentFrame));
        }
        this.bp.setButtonEnabled(bl);
        this.leaderBoardPanel.setButtonEnabled(bl);
    }

    public JPanel getWorkPanel() {
        return this.wp;
    }

    public void showTimer() {
        this.tp.setVisible(true);
    }
}

