/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.panels.question;

import com.topcoder.client.contestApplet.common.Common;
import com.topcoder.client.contestApplet.panels.question.QuestionPanel;
import com.topcoder.client.contestApplet.widgets.DiamondIcon;
import com.topcoder.netCommon.contest.Answer;
import com.topcoder.netCommon.contest.Question;
import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class MultipleChoicePanel
extends QuestionPanel {
    private Question question;
    private List answers = null;
    private JCheckBox[] selections = null;

    public MultipleChoicePanel(String string, Question question) {
        this.question = question;
        JTextArea jTextArea = new JTextArea(question.getQuestionText(), 4, 40);
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        GridBagConstraints gridBagConstraints = Common.getDefaultConstraints();
        this.setLayout(new GridBagLayout());
        this.setBorder(Common.getTitledBorder(string));
        this.setBackground(Color.black);
        jTextArea.setEditable(false);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setMargin(new Insets(5, 5, 5, 5));
        jTextArea.setSelectedTextColor(Common.HF_COLOR);
        jTextArea.setSelectionColor(Common.HB_COLOR);
        jTextArea.setBackground(Common.MB_COLOR);
        jTextArea.setForeground(Common.MF_COLOR);
        DiamondIcon diamondIcon = new DiamondIcon(Color.white, true, 12, 12);
        DiamondIcon diamondIcon2 = new DiamondIcon(Color.white, false, 12, 12);
        int n = 0;
        Common.insertInPanel(jScrollPane, this, gridBagConstraints, 0, n++, 1, 1, 0.1, 0.1);
        gridBagConstraints.insets = new Insets(0, 20, 0, 0);
        this.answers = question.getAnswerText();
        this.selections = new JCheckBox[this.answers.size()];
        for (int i = 0; i < this.answers.size(); ++i) {
            JCheckBox jCheckBox = new JCheckBox((String)this.answers.get(i), false);
            jCheckBox.setBackground(Color.black);
            jCheckBox.setForeground(Color.white);
            jCheckBox.setIcon(diamondIcon2);
            jCheckBox.setSelectedIcon(diamondIcon);
            Common.insertInPanel(jCheckBox, this, gridBagConstraints, 0, n++, 1, 1, 0.1, 0.1);
            this.selections[i] = jCheckBox;
        }
    }

    public Answer getAnswer() {
        ArrayList arrayList = new ArrayList(this.answers.size());
        boolean bl = false;
        for (int i = 0; i < this.answers.size(); ++i) {
            if (!this.selections[i].isSelected()) continue;
            bl = true;
            arrayList.add(this.answers.get(i));
        }
        if (!bl) {
            JOptionPane.showMessageDialog(null, "You must provide an answer to the question: \r\n" + this.question.getQuestionText(), "Error", 0);
            return null;
        }
        return this.question.getAnswer(arrayList);
    }
}

