/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.panels.main;

import com.topcoder.client.contestApplet.common.Common;
import com.topcoder.client.contestApplet.common.LocalPreferences;
import com.topcoder.client.contestApplet.panels.main.TCMenuItem;
import com.topcoder.client.contestant.RoundModel;
import com.topcoder.netCommon.contestantMessages.response.data.CategoryData;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JMenu;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;

public class TCMenu
extends JMenu {
    private LocalPreferences pref = LocalPreferences.getInstance();
    private static final int MENU_SIZE = 25;
    private static DecimalFormat fmt = new DecimalFormat();

    public TCMenu(String string, int n, int n2, char c) {
        this(string);
        Dimension dimension = new Dimension(n, n2);
        this.setMinimumSize(dimension);
        this.setPreferredSize(dimension);
        this.setMnemonic(c);
        this.addObserver();
    }

    private void addObserver() {
        this.pref.addSaveObserver(new Observer(){

            public void update(Observable observable, Object object) {
                TCMenu.this.setFontFromPreferences();
            }
        });
    }

    TCMenu(String string) {
        super(string);
        this.setMenuProperties();
        this.addObserver();
    }

    TCMenu(String string, char c) {
        super(string);
        this.setMnemonic(c);
        this.setMenuProperties();
        this.addObserver();
    }

    private void setFontFromPreferences() {
        String string = this.pref.getFont("com.topcoder.client.contestApplet.common.LocalPreferences.menufont", "");
        int n = this.pref.getFontSize("com.topcoder.client.contestApplet.common.LocalPreferences.menufontsize", 10);
        this.setFont(new Font(string, 0, n));
        this.revalidate();
        this.repaint();
    }

    private void setMenuProperties() {
        this.setFontFromPreferences();
        this.setBorder(new BevelBorder(0));
        this.setBackground(Common.TOP_BACK);
        this.setForeground(Color.white);
        UIManager.put("SubMenu.selectionBackground", Color.decode("0x660000"));
    }

    public void buildIndexedCascadingMenu(String[] stringArray, Object[] objectArray, ActionListener actionListener) {
        UIManager.put("SubMenu.selectionBackground", Color.decode("0x660000"));
        String string = "" + stringArray.length;
        int n = string.length();
        TCMenu.buildMenu(this, stringArray, 0, stringArray.length, n - 1, actionListener, objectArray);
    }

    public void buildCategorizedCascadingMenu(RoundModel[] roundModelArray, CategoryData[] categoryDataArray, ActionListener actionListener) {
        UIManager.put("SubMenu.selectionBackground", Color.decode("0x660000"));
        Map map = TCMenu.getCategoryMap(categoryDataArray);
        Iterator iterator = map.keySet().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int n2;
            Integer n3 = (Integer)iterator.next();
            ArrayList<RoundModel> arrayList = new ArrayList<RoundModel>();
            for (int i = 0; i < roundModelArray.length; ++i) {
                if (roundModelArray[i].getRoundCategoryID() != n3.intValue()) continue;
                arrayList.add(roundModelArray[i]);
            }
            if (arrayList.isEmpty()) continue;
            String string = "" + ++n;
            TCMenu tCMenu = new TCMenu(string + " - " + map.get(n3), 120, 14, string.charAt(0));
            this.add(tCMenu);
            Object[] objectArray = arrayList.toArray();
            if (objectArray.length > 25) {
                int n4 = 0;
                while (n4 * 25 < objectArray.length) {
                    n2 = n4 * 25;
                    int n5 = (n4 + 1) * 25;
                    if (objectArray.length < n5) {
                        n5 = objectArray.length;
                    }
                    string = n2 + 1 + " - " + n5;
                    TCMenu tCMenu2 = new TCMenu(string, 120, 14, string.charAt(0));
                    tCMenu.add(tCMenu2);
                    RoundModel[] roundModelArray2 = new RoundModel[n5 - n2];
                    for (int i = n2; i < n5; ++i) {
                        if (!(objectArray[i] instanceof RoundModel)) continue;
                        roundModelArray2[i - n2] = (RoundModel)objectArray[i];
                    }
                    TCMenu.buildSubMenu(tCMenu2, roundModelArray2, n2, actionListener);
                    ++n4;
                }
                continue;
            }
            RoundModel[] roundModelArray3 = new RoundModel[objectArray.length];
            for (n2 = 0; n2 < objectArray.length; ++n2) {
                if (!(objectArray[n2] instanceof RoundModel)) continue;
                roundModelArray3[n2] = (RoundModel)objectArray[n2];
            }
            TCMenu.buildSubMenu(tCMenu, roundModelArray3, 0, actionListener);
        }
        this.revalidate();
        this.repaint();
    }

    private static void buildSubMenu(JMenu jMenu, RoundModel[] roundModelArray, int n, ActionListener actionListener) {
        for (int i = 0; i < roundModelArray.length; ++i) {
            String string = "" + (i + n + 1);
            TCMenuItem tCMenuItem = new TCMenuItem(i + n + 1 + " - " + roundModelArray[i].getSingleName(), string.charAt(string.length() - 1));
            tCMenuItem.setUserData(roundModelArray[i]);
            tCMenuItem.addActionListener(actionListener);
            jMenu.add(tCMenuItem);
        }
    }

    private static Map getCategoryMap(CategoryData[] categoryDataArray) {
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        for (int i = 0; i < categoryDataArray.length; ++i) {
            hashMap.put(new Integer(categoryDataArray[i].getCategoryID()), categoryDataArray[i].getCategoryName());
        }
        return hashMap;
    }

    private static void buildMenu(JMenu jMenu, String[] stringArray, int n, int n2, int n3, ActionListener actionListener, Object[] objectArray) {
        if (n3 > 0) {
            TCMenu tCMenu;
            String string;
            int n4;
            fmt.setMaximumFractionDigits(0);
            fmt.setMinimumIntegerDigits(n3 + 1);
            int n5 = (int)Math.pow(10.0, n3);
            for (n4 = n + n5; n4 <= n2; n4 += n5) {
                string = fmt.format(n4 - n5 + 1);
                tCMenu = new TCMenu(string + "-" + fmt.format(n4), 120, 14, string.charAt(string.length() - n3 - 1));
                TCMenu.buildMenu(tCMenu, stringArray, n4 - n5, n4, n3 - 1, actionListener, objectArray);
                jMenu.add(tCMenu);
            }
            n4 = (n2 - n) % n5;
            if (n4 > 0) {
                string = fmt.format(n2 - n4 + 1);
                tCMenu = new TCMenu(string + "-" + fmt.format(n2), 120, 14, string.charAt(string.length() - n3 - 1));
                TCMenu.buildMenu(tCMenu, stringArray, n2 - n4, n2, n3 - 1, actionListener, objectArray);
                jMenu.add(tCMenu);
            }
        } else {
            for (int i = n; i < n2; ++i) {
                String string = "" + (i + 1);
                TCMenuItem tCMenuItem = new TCMenuItem(stringArray[i], string.charAt(string.length() - 1));
                tCMenuItem.setUserData(objectArray[i]);
                tCMenuItem.addActionListener(actionListener);
                jMenu.add(tCMenuItem);
            }
        }
        jMenu.revalidate();
        jMenu.repaint();
    }

    public void addToMenu(String[] stringArray, boolean[] blArray, Object[] objectArray, ActionListener actionListener) {
        this.removeAll();
        boolean[] blArray2 = new boolean[26];
        UIManager.put("SubMenu.selectionBackground", Color.decode("0x660000"));
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            String string2 = string.toLowerCase();
            char c = '\u0000';
            for (int j = 0; j < string2.length(); ++j) {
                char c2 = string2.charAt(j);
                if (!Character.isLetter(c2) || blArray2[c2 - 97]) continue;
                blArray2[c2 - 97] = true;
                c = c2;
                break;
            }
            TCMenuItem tCMenuItem = new TCMenuItem(string, c);
            tCMenuItem.setForeground(Color.white);
            tCMenuItem.setBackground(Common.MENU_COLOR);
            tCMenuItem.setBorder(new BevelBorder(0));
            tCMenuItem.addActionListener(actionListener);
            tCMenuItem.setEnabled(blArray[i]);
            tCMenuItem.setMnemonic(c);
            tCMenuItem.setUserData(objectArray[i]);
            this.add(tCMenuItem);
        }
    }
}

