/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.panels.html;

import com.topcoder.client.contestApplet.common.Common;
import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.text.Document;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;

public class HTMLPanel
extends JPanel {
    private String html;
    private JEditorPane pane;
    private URL base;

    private HTMLPanel() {
        super(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setBackground(Color.black);
    }

    public HTMLPanel(String string) throws Exception {
        this();
        this.init(string, this);
    }

    public HTMLPanel(String string, Object object) throws Exception {
        this();
        this.init(string, object);
    }

    private void init(String string, Object object) throws Exception {
        URL uRL = string.startsWith("http:") || string.startsWith("file:") ? new URL(string) : object.getClass().getResource(string);
        this.load(uRL);
    }

    public HTMLPanel(URL uRL) throws Exception {
        this();
        this.load(uRL);
    }

    private void load(URL uRL) throws Exception {
        String string = uRL.toString();
        this.base = new URL(string.substring(0, string.lastIndexOf(47) + 1));
        this.html = HTMLPanel.read(uRL);
        this.initPane();
    }

    protected String getHTML() {
        return this.html;
    }

    protected JEditorPane getPane() {
        return this.pane;
    }

    private void initPane() throws Exception {
        this.pane = new JEditorPane();
        this.pane.setEditable(false);
        SynchronousHTMLEditorKit synchronousHTMLEditorKit = new SynchronousHTMLEditorKit();
        HTMLDocument hTMLDocument = (HTMLDocument)((HTMLEditorKit)synchronousHTMLEditorKit).createDefaultDocument();
        hTMLDocument.setBase(this.base);
        synchronousHTMLEditorKit.read(new StringReader(this.html), (Document)hTMLDocument, 0);
        this.pane.setEditorKit(synchronousHTMLEditorKit);
        this.pane.setDocument(hTMLDocument);
        this.pane.setBorder(null);
        GridBagConstraints gridBagConstraints = Common.getDefaultConstraints();
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(15, 15, 15, 15);
        Common.insertInPanel(this.pane, this, gridBagConstraints, 0, 0, 1, 1, 1.0, 1.0);
    }

    public void replaceVariables(String[] stringArray, String[] stringArray2) {
        StringBuffer stringBuffer = new StringBuffer(this.html);
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            String string2 = stringArray2[i];
            block1: for (int j = 0; j < stringBuffer.length(); ++j) {
                for (int k = 0; k < string.length(); ++k) {
                    if (stringBuffer.charAt(j + k) != string.charAt(k)) continue block1;
                }
                stringBuffer.replace(j, j + string.length(), string2);
                j += string2.length() - 1;
            }
        }
        this.pane.setText(stringBuffer.toString());
        this.pane.revalidate();
        this.pane.repaint();
    }

    private static String read(URL uRL) throws Exception {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
        StringBuffer stringBuffer = new StringBuffer(1000);
        char[] cArray = new char[1000];
        int n = 0;
        while ((n = bufferedReader.read(cArray, 0, cArray.length)) > 0) {
            stringBuffer.append(cArray, 0, n);
        }
        bufferedReader.close();
        return stringBuffer.toString();
    }

    static class SynchronousHTMLEditorKit
    extends HTMLEditorKit {
        SynchronousHTMLEditorKit() {
        }

        public Document createDefaultDocument() {
            HTMLDocument hTMLDocument = (HTMLDocument)super.createDefaultDocument();
            hTMLDocument.setAsynchronousLoadPriority(-1);
            return hTMLDocument;
        }
    }
}

