/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.panels.coding;

import com.topcoder.client.contestApplet.ContestApplet;
import com.topcoder.client.contestApplet.common.Common;
import com.topcoder.client.contestApplet.panels.coding.ProblemInfoComponent;
import com.topcoder.client.contestApplet.widgets.ImageIconPanel;
import com.topcoder.client.contestant.ProblemComponentModel;
import com.topcoder.shared.problem.DataType;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JLabel;
import javax.swing.UIManager;

public final class ProblemInfoPanel
extends ImageIconPanel
implements ProblemInfoComponent {
    private JLabel className = null;
    private JLabel methodName = null;
    private JLabel returnType = null;
    private JLabel argTypes = null;

    public ProblemInfoPanel(ContestApplet contestApplet) {
        super((LayoutManager)new GridBagLayout(), Common.getImage("coding_area.gif", contestApplet));
        this.setMinimumSize(new Dimension(600, 53));
        this.setPreferredSize(new Dimension(600, 53));
        this.create();
    }

    private void create() {
        GridBagConstraints gridBagConstraints = Common.getDefaultConstraints();
        JLabel jLabel = new JLabel("Class Name: ");
        JLabel jLabel2 = new JLabel("");
        JLabel jLabel3 = new JLabel("Method Name: ");
        JLabel jLabel4 = new JLabel("");
        JLabel jLabel5 = new JLabel("Return Type: ");
        JLabel jLabel6 = new JLabel("");
        JLabel jLabel7 = new JLabel("Arg Types: ");
        JLabel jLabel8 = new JLabel("");
        Dimension dimension = new Dimension(105, 13);
        jLabel.setForeground(Color.white);
        jLabel2.setForeground(Color.white);
        jLabel2.setPreferredSize(dimension);
        jLabel2.setMinimumSize(dimension);
        jLabel3.setForeground(Color.white);
        jLabel4.setForeground(Color.white);
        jLabel4.setPreferredSize(dimension);
        jLabel4.setMinimumSize(dimension);
        Font font = UIManager.getSystemLookAndFeelClassName().equals("com.sun.java.swing.plaf.windows.WindowsLookAndFeel") ? new Font("Courier", 0, 11) : new Font("Courier", 0, 10);
        jLabel2.setFont(font);
        jLabel4.setFont(font);
        jLabel6.setFont(font);
        jLabel8.setFont(font);
        Dimension dimension2 = new Dimension(292, 13);
        jLabel5.setForeground(Color.white);
        jLabel6.setForeground(Color.white);
        jLabel6.setPreferredSize(dimension2);
        jLabel6.setMinimumSize(dimension2);
        jLabel7.setForeground(Color.white);
        jLabel8.setForeground(Color.white);
        jLabel8.setPreferredSize(dimension2);
        jLabel8.setMinimumSize(dimension2);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(15, 15, 1, 1);
        Common.insertInPanel(jLabel, this, gridBagConstraints, 0, 0, 1, 1, 1.0, 0.1);
        gridBagConstraints.insets = new Insets(15, 1, 1, 1);
        Common.insertInPanel(jLabel2, this, gridBagConstraints, 1, 0, 1, 1, 1.0, 0.1);
        gridBagConstraints.insets = new Insets(1, 15, 15, 1);
        Common.insertInPanel(jLabel3, this, gridBagConstraints, 0, 1, 1, 1, 1.0, 0.1);
        gridBagConstraints.insets = new Insets(1, 1, 15, 1);
        Common.insertInPanel(jLabel4, this, gridBagConstraints, 1, 1, 1, 1, 1.0, 0.1);
        gridBagConstraints.insets = new Insets(15, 1, 1, 1);
        Common.insertInPanel(jLabel5, this, gridBagConstraints, 2, 0, 1, 1, 1.0, 0.1);
        gridBagConstraints.insets = new Insets(15, 1, 1, 15);
        Common.insertInPanel(jLabel6, this, gridBagConstraints, 3, 0, 1, 1, 1.0, 0.1);
        gridBagConstraints.insets = new Insets(1, 1, 15, 0);
        Common.insertInPanel(jLabel7, this, gridBagConstraints, 2, 1, 1, 1, 1.0, 0.1);
        gridBagConstraints.insets = new Insets(1, 1, 15, 15);
        Common.insertInPanel(jLabel8, this, gridBagConstraints, 3, 1, 1, 1, 1.0, 0.1);
        this.className = jLabel2;
        this.methodName = jLabel4;
        this.returnType = jLabel6;
        this.argTypes = jLabel8;
    }

    public void updateComponentInfo(ProblemComponentModel problemComponentModel, int n) {
        this.className.setText(problemComponentModel.getClassName());
        this.methodName.setText(problemComponentModel.getMethodName());
        this.returnType.setText(problemComponentModel.getReturnType().getDescriptor(n));
        String string = "(";
        DataType[] dataTypeArray = problemComponentModel.getParamTypes();
        if (dataTypeArray.length > 0) {
            string = string + dataTypeArray[0].getDescriptor(n);
            for (int i = 1; i < dataTypeArray.length; ++i) {
                string = string + "," + dataTypeArray[i].getDescriptor(n);
            }
        }
        this.argTypes.setText(string + ")");
        this.argTypes.repaint();
    }

    public void clear() {
    }
}

