/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.panels.coding;

import com.topcoder.client.contestApplet.ContestApplet;
import com.topcoder.client.contestApplet.common.Common;
import com.topcoder.client.contestApplet.panels.coding.ProblemInfoComponent;
import com.topcoder.client.contestApplet.widgets.ImageIconPanel;
import com.topcoder.client.contestant.ProblemComponentModel;
import com.topcoder.shared.language.BaseLanguage;
import com.topcoder.shared.language.Language;
import com.topcoder.shared.problem.DataType;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;

public final class MultiMethodProblemInfoPanel
extends ImageIconPanel
implements ProblemInfoComponent {
    private JTextArea text = null;
    private int firstMethod;

    public MultiMethodProblemInfoPanel(ContestApplet contestApplet) {
        this(contestApplet, 0);
    }

    public MultiMethodProblemInfoPanel(ContestApplet contestApplet, int n) {
        super((LayoutManager)new BorderLayout(), Common.getImage("coding_area.gif", contestApplet));
        this.firstMethod = n;
        this.setMinimumSize(new Dimension(600, 53));
        this.setPreferredSize(new Dimension(600, 53));
        this.create();
    }

    private void create() {
        Font font = UIManager.getSystemLookAndFeelClassName().equals("com.sun.java.swing.plaf.windows.WindowsLookAndFeel") ? new Font("Courier", 0, 11) : new Font("Courier", 0, 10);
        this.text = new JTextArea();
        this.text.setEditable(false);
        this.text.setAutoscrolls(true);
        this.text.setFont(font);
        this.text.setOpaque(false);
        this.text.setForeground(Color.WHITE);
        this.text.setLineWrap(true);
        this.text.setWrapStyleWord(true);
        JScrollPane jScrollPane = new JScrollPane(this.text, 20, 31);
        JScrollBar jScrollBar = jScrollPane.getVerticalScrollBar();
        jScrollBar.setPreferredSize(new Dimension(10, (int)jScrollBar.getPreferredSize().getHeight()));
        jScrollPane.setOpaque(false);
        jScrollPane.getViewport().setOpaque(false);
        jScrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.setBorder(BorderFactory.createEmptyBorder(10, 13, 13, 13));
        this.add((Component)jScrollPane, "Center");
    }

    public void updateComponentInfo(ProblemComponentModel problemComponentModel, int n) {
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append("ClassName: ").append(problemComponentModel.getClassName()).append("\n");
        String[] stringArray = problemComponentModel.getComponent().getAllMethodNames();
        String[][] stringArray2 = problemComponentModel.getComponent().getAllParamNames();
        DataType[][] dataTypeArray = problemComponentModel.getComponent().getAllParamTypes();
        DataType[] dataTypeArray2 = problemComponentModel.getComponent().getAllReturnTypes();
        Language language = BaseLanguage.getLanguage(n);
        for (int i = this.firstMethod; i < stringArray.length; ++i) {
            stringBuffer.append(language.getMethodSignature(stringArray[i], dataTypeArray2[i], dataTypeArray[i], stringArray2[i])).append("\n");
        }
        stringBuffer.setLength(stringBuffer.length() - 1);
        this.text.setText(stringBuffer.toString());
        this.text.setCaretPosition(0);
        this.text.repaint();
    }

    public void clear() {
    }
}

