/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.panels;

import com.topcoder.client.contestApplet.ContestApplet;
import com.topcoder.client.contestApplet.common.Common;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;

public final class TimeLine
extends JPanel {
    private JLabel emptyLabel = null;
    private JLabel codingLabel = null;
    private JLabel intermissionLabel = null;
    private JLabel challengeLabel = null;
    private JLabel systemLabel = null;

    public TimeLine(ContestApplet contestApplet) {
        this(contestApplet, "0.gif", "1.gif", "2.gif", "3.gif", "4.gif");
    }

    public TimeLine(ContestApplet contestApplet, String string, String string2, String string3, String string4, String string5) {
        super(new GridBagLayout());
        this.setOpaque(false);
        this.emptyLabel = new JLabel(Common.getImage(string, contestApplet));
        this.codingLabel = new JLabel(Common.getImage(string2, contestApplet));
        this.intermissionLabel = new JLabel(Common.getImage(string3, contestApplet));
        this.challengeLabel = new JLabel(Common.getImage(string4, contestApplet));
        this.systemLabel = new JLabel(Common.getImage(string5, contestApplet));
        this.setPhase(0);
        this.create();
    }

    private void create() {
        GridBagConstraints gridBagConstraints = Common.getDefaultConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        Common.insertInPanel(this.emptyLabel, this, gridBagConstraints, 0, 0, 1, 1, 0.1, 0.1);
        Common.insertInPanel(this.codingLabel, this, gridBagConstraints, 0, 0, 1, 1, 0.1, 0.1);
        Common.insertInPanel(this.intermissionLabel, this, gridBagConstraints, 0, 0, 1, 1, 0.1, 0.1);
        Common.insertInPanel(this.challengeLabel, this, gridBagConstraints, 0, 0, 1, 1, 0.1, 0.1);
        Common.insertInPanel(this.systemLabel, this, gridBagConstraints, 0, 0, 1, 1, 0.1, 0.1);
    }

    public void setPhase(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 12: {
                this.emptyLabel.setVisible(true);
                this.codingLabel.setVisible(false);
                this.intermissionLabel.setVisible(false);
                this.challengeLabel.setVisible(false);
                this.systemLabel.setVisible(false);
                break;
            }
            case 4: {
                this.codingLabel.setVisible(true);
                this.emptyLabel.setVisible(false);
                this.intermissionLabel.setVisible(false);
                this.challengeLabel.setVisible(false);
                this.systemLabel.setVisible(false);
                break;
            }
            case 5: {
                this.intermissionLabel.setVisible(true);
                this.emptyLabel.setVisible(false);
                this.codingLabel.setVisible(false);
                this.challengeLabel.setVisible(false);
                this.systemLabel.setVisible(false);
                break;
            }
            case 6: {
                this.challengeLabel.setVisible(true);
                this.emptyLabel.setVisible(false);
                this.codingLabel.setVisible(false);
                this.intermissionLabel.setVisible(false);
                this.systemLabel.setVisible(false);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                this.systemLabel.setVisible(true);
                this.emptyLabel.setVisible(false);
                this.codingLabel.setVisible(false);
                this.intermissionLabel.setVisible(false);
                this.challengeLabel.setVisible(false);
                break;
            }
            default: {
                System.err.println("Unknown phase (" + n + ").");
                this.emptyLabel.setVisible(false);
                this.codingLabel.setVisible(false);
                this.intermissionLabel.setVisible(false);
                this.challengeLabel.setVisible(false);
                this.systemLabel.setVisible(false);
            }
        }
    }

    public void updateIcons(String string, String string2, String string3, String string4, String string5, Object object) {
        this.emptyLabel.setIcon(Common.getImage(string, object));
        this.codingLabel.setIcon(Common.getImage(string2, object));
        this.intermissionLabel.setIcon(Common.getImage(string3, object));
        this.challengeLabel.setIcon(Common.getImage(string4, object));
        this.systemLabel.setIcon(Common.getImage(string5, object));
        this.invalidate();
    }
}

