/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.panels;

import com.topcoder.client.contestApplet.common.Common;
import com.topcoder.client.contestApplet.common.CommonData;
import com.topcoder.client.contestApplet.common.LocalPreferences;
import com.topcoder.client.contestApplet.frames.AppletPreferencesFrame;
import com.topcoder.client.contestApplet.widgets.MyTitledBorder;
import com.topcoder.client.contestApplet.widgets.RoundBorder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SummaryConfigurationPanel
extends JPanel {
    private boolean changesPending = false;
    private LocalPreferences localPref = LocalPreferences.getInstance();
    private static int CTR = 0;
    private final int UNOPEN = CTR++;
    private final int OPENED = CTR++;
    private final int COMPILED = CTR++;
    private final int JAVAPOINTS = CTR++;
    private final int JAVACHLPASSED = CTR++;
    private final int JAVACHLFAILED = CTR++;
    private final int JAVASYSPASSED = CTR++;
    private final int JAVASYSFAILED = CTR++;
    private final int CPPPOINTS = CTR++;
    private final int CPPCHLPASSED = CTR++;
    private final int CPPCHLFAILED = CTR++;
    private final int CPPSYSPASSED = CTR++;
    private final int CPPSYSFAILED = CTR++;
    private final int CSHARPPOINTS = CTR++;
    private final int CSHARPCHLPASSED = CTR++;
    private final int CSHARPCHLFAILED = CTR++;
    private final int CSHARPSYSPASSED = CTR++;
    private final int CSHARPSYSFAILED = CTR++;
    private static final int VBPOINTS = CTR++;
    private static final int VBCHLPASSED = CTR++;
    private static final int VBCHLFAILED = CTR++;
    private static final int VBSYSPASSED = CTR++;
    private static final int VBSYSFAILED = CTR++;
    private static final int PYTHONPOINTS = CTR++;
    private static final int PYTHONCHLPASSED = CTR++;
    private static final int PYTHONCHLFAILED = CTR++;
    private static final int PYTHONSYSPASSED = CTR++;
    private static final int PYTHONSYSFAILED = CTR++;
    private JButton[] colors = new JButton[CTR];
    private JCheckBox[] bold = new JCheckBox[CTR];
    private JCheckBox[] italics = new JCheckBox[CTR];
    private AppletPreferencesFrame parentFrame;

    public SummaryConfigurationPanel(JDialog jDialog) {
        super(new GridBagLayout());
        this.parentFrame = (AppletPreferencesFrame)jDialog;
        this.setBackground(Common.BG_COLOR);
        this.setForeground(Common.FG_COLOR);
        JPanel jPanel = this.createPanel("General Settings");
        int n = 0;
        this.createHeader(jPanel, n++);
        this.createRow(jPanel, "com.topcoder.client.contestApplet.common.LocalPreferences.summaryunopened", "Unopened", this.UNOPEN, n++);
        this.createRow(jPanel, "com.topcoder.client.contestApplet.common.LocalPreferences.summaryopened", "Opened", this.OPENED, n++);
        this.createRow(jPanel, "com.topcoder.client.contestApplet.common.LocalPreferences.summarycompiled", "Compiled", this.COMPILED, n);
        JPanel jPanel2 = this.createPanel("Java Settings");
        n = 0;
        this.createHeader(jPanel2, n++);
        this.createRow(jPanel2, "com.topcoder.client.contestApplet.common.LocalPreferences.summaryjavapoints", "Points", this.JAVAPOINTS, n++);
        this.createRow(jPanel2, "com.topcoder.client.contestApplet.common.LocalPreferences.summaryjavachlpassed", "Challenge Succeeded", this.JAVACHLPASSED, n++);
        this.createRow(jPanel2, "com.topcoder.client.contestApplet.common.LocalPreferences.summaryjavachlfailed", "Challenge Failed", this.JAVACHLFAILED, n++);
        this.createRow(jPanel2, "com.topcoder.client.contestApplet.common.LocalPreferences.summaryjavasyspassed", "Passed System Test", this.JAVASYSPASSED, n++);
        this.createRow(jPanel2, "com.topcoder.client.contestApplet.common.LocalPreferences.summaryjavasysfailed", "Failed System Test", this.JAVASYSFAILED, n);
        JPanel jPanel3 = this.createPanel("C++ Settings");
        n = 0;
        this.createHeader(jPanel3, n++);
        this.createRow(jPanel3, "com.topcoder.client.contestApplet.common.LocalPreferences.summarycpppoints", "Points", this.CPPPOINTS, n++);
        this.createRow(jPanel3, "com.topcoder.client.contestApplet.common.LocalPreferences.summarycppchlpassed", "Challenge Succeeded", this.CPPCHLPASSED, n++);
        this.createRow(jPanel3, "com.topcoder.client.contestApplet.common.LocalPreferences.summarycppchlfailed", "Challenge Failed", this.CPPCHLFAILED, n++);
        this.createRow(jPanel3, "com.topcoder.client.contestApplet.common.LocalPreferences.summarycppsyspassed", "Passed System Test", this.CPPSYSPASSED, n++);
        this.createRow(jPanel3, "com.topcoder.client.contestApplet.common.LocalPreferences.summarycppsysfailed", "Failed System Test", this.CPPSYSFAILED, n);
        JPanel jPanel4 = this.createPanel("C# Settings");
        n = 0;
        this.createHeader(jPanel4, n++);
        this.createRow(jPanel4, "com.topcoder.client.contestApplet.common.LocalPreferences.summarycsharppoints", "Points", this.CSHARPPOINTS, n++);
        this.createRow(jPanel4, "com.topcoder.client.contestApplet.common.LocalPreferences.summarycsharpchlpassed", "Challenge Succeeded", this.CSHARPCHLPASSED, n++);
        this.createRow(jPanel4, "com.topcoder.client.contestApplet.common.LocalPreferences.summarycsharpchlfailed", "Challenge Failed", this.CSHARPCHLFAILED, n++);
        this.createRow(jPanel4, "com.topcoder.client.contestApplet.common.LocalPreferences.summarycsharpsyspassed", "Passed System Test", this.CSHARPSYSPASSED, n++);
        this.createRow(jPanel4, "com.topcoder.client.contestApplet.common.LocalPreferences.summarycsharpsysfailed", "Failed System Test", this.CSHARPSYSFAILED, n);
        JPanel jPanel5 = this.createPanel("VB Settings");
        n = 0;
        this.createHeader(jPanel5, n++);
        this.createRow(jPanel5, "com.topcoder.client.contestApplet.common.LocalPreferences.summaryvbpoints", "Points", VBPOINTS, n++);
        this.createRow(jPanel5, "com.topcoder.client.contestApplet.common.LocalPreferences.summaryvbchlpassed", "Challenge Succeeded", VBCHLPASSED, n++);
        this.createRow(jPanel5, "com.topcoder.client.contestApplet.common.LocalPreferences.summaryvbchlfailed", "Challenge Failed", VBCHLFAILED, n++);
        this.createRow(jPanel5, "com.topcoder.client.contestApplet.common.LocalPreferences.summaryvbsyspassed", "Passed System Test", VBSYSPASSED, n++);
        this.createRow(jPanel5, "com.topcoder.client.contestApplet.common.LocalPreferences.summaryvbsysfailed", "Failed System Test", VBSYSFAILED, n);
        JPanel jPanel6 = this.createPanel("Python Settings");
        n = 0;
        this.createHeader(jPanel6, n++);
        this.createRow(jPanel6, "com.topcoder.client.contestApplet.common.LocalPreferences.summarypythonpoints", "Points", PYTHONPOINTS, n++);
        this.createRow(jPanel6, "com.topcoder.client.contestApplet.common.LocalPreferences.summarypythonchlpassed", "Challenge Succeeded", PYTHONCHLPASSED, n++);
        this.createRow(jPanel6, "com.topcoder.client.contestApplet.common.LocalPreferences.summarypythonchlfailed", "Challenge Failed", PYTHONCHLFAILED, n++);
        this.createRow(jPanel6, "com.topcoder.client.contestApplet.common.LocalPreferences.summarypythonsyspassed", "Passed System Test", PYTHONSYSPASSED, n++);
        this.createRow(jPanel6, "com.topcoder.client.contestApplet.common.LocalPreferences.summarypythonsysfailed", "Failed System Test", PYTHONSYSFAILED, n);
        n = 0;
        this.add((Component)jPanel, new GridBagConstraints(0, n++, 1, 1, 0.0, 0.0, 17, 2, new Insets(15, 0, 0, 0), 0, 0));
        if (CommonData.allowsJava(this.parentFrame.getApplet().getCompanyName())) {
            this.add((Component)jPanel2, new GridBagConstraints(0, n++, 1, 1, 0.0, 0.0, 17, 2, new Insets(15, 0, 0, 0), 0, 0));
        }
        if (CommonData.allowsCPP(this.parentFrame.getApplet().getCompanyName())) {
            this.add((Component)jPanel3, new GridBagConstraints(0, n++, 1, 1, 0.0, 0.0, 17, 2, new Insets(15, 0, 0, 0), 0, 0));
        }
        if (CommonData.allowsCS(this.parentFrame.getApplet().getCompanyName())) {
            this.add((Component)jPanel4, new GridBagConstraints(0, n++, 1, 1, 0.0, 0.0, 17, 2, new Insets(15, 0, 0, 0), 0, 0));
        }
        if (CommonData.allowsVB(this.parentFrame.getApplet().getCompanyName())) {
            this.add((Component)jPanel5, new GridBagConstraints(0, n++, 1, 1, 1.0, 1.0, 17, 2, new Insets(15, 0, 0, 0), 0, 0));
        }
        if (CommonData.allowsPython(this.parentFrame.getApplet().getCompanyName())) {
            this.add((Component)jPanel6, new GridBagConstraints(0, n++, 1, 1, 1.0, 1.0, 17, 2, new Insets(15, 0, 0, 0), 0, 0));
        }
    }

    private JPanel createPanel(String string) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBackground(Common.BG_COLOR);
        jPanel.setForeground(Common.FG_COLOR);
        RoundBorder roundBorder = new RoundBorder(Common.LIGHT_GREY, 5, true);
        MyTitledBorder myTitledBorder = new MyTitledBorder(roundBorder, string, 1, 1);
        myTitledBorder.setTitleColor(Common.PT_COLOR);
        jPanel.setBorder(myTitledBorder);
        return jPanel;
    }

    private void createHeader(JPanel jPanel, int n) {
        jPanel.add((Component)this.createJLabel(""), new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 13, 2, new Insets(0, 5, 0, 15), 0, 0));
        jPanel.add((Component)this.createHeaderJLabel("Color"), new GridBagConstraints(1, n, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 15), 0, 0));
        jPanel.add((Component)this.createHeaderJLabel("Bold"), new GridBagConstraints(2, n, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 15), 0, 0));
        jPanel.add((Component)this.createHeaderJLabel("Italic"), new GridBagConstraints(3, n, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 5, 0, 15), 0, 0));
    }

    private JLabel createHeaderJLabel(String string) {
        JLabel jLabel = new JLabel(string);
        jLabel.setForeground(Common.PT_COLOR);
        jLabel.setBackground(Common.BG_COLOR);
        jLabel.setFont(new Font(jLabel.getFont().getFontName(), 1, jLabel.getFont().getSize()));
        return jLabel;
    }

    private void createRow(JPanel jPanel, String string, String string2, int n, int n2) {
        this.colors[n] = this.createColorButton(LocalPreferences.getKeyAttribute(string, "color"));
        this.bold[n] = this.createCheckBox(LocalPreferences.getKeyAttribute(string, "bold"));
        this.italics[n] = this.createCheckBox(LocalPreferences.getKeyAttribute(string, "italic"));
        jPanel.add((Component)this.createJLabel(string2), new GridBagConstraints(0, n2, 1, 1, 0.0, 0.0, 12, 1, new Insets(0, 5, 0, 15), 0, 0));
        jPanel.add((Component)this.colors[n], new GridBagConstraints(1, n2, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 15), 0, 0));
        jPanel.add((Component)this.bold[n], new GridBagConstraints(2, n2, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 15), 0, 0));
        jPanel.add((Component)this.italics[n], new GridBagConstraints(3, n2, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 5, 0, 15), 0, 0));
    }

    private JLabel createJLabel(String string) {
        JLabel jLabel = new JLabel(string);
        jLabel.setForeground(Common.FG_COLOR);
        jLabel.setBackground(Common.BG_COLOR);
        Dimension dimension = jLabel.getPreferredSize();
        dimension.width = 200;
        jLabel.setPreferredSize(dimension);
        return jLabel;
    }

    private JButton createColorButton(String string) {
        Color color = this.localPref.getColor(string);
        JButton jButton = new JButton();
        jButton.setBackground(color);
        jButton.addActionListener(new ActionHandler());
        jButton.setPreferredSize(new Dimension(25, 15));
        return jButton;
    }

    private JCheckBox createCheckBox(String string) {
        JCheckBox jCheckBox = new JCheckBox("");
        jCheckBox.setSelected(this.localPref.isTrue(string));
        jCheckBox.setForeground(Common.FG_COLOR);
        jCheckBox.setBackground(Common.BG_COLOR);
        jCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SummaryConfigurationPanel.this.changesPending = true;
            }
        });
        return jCheckBox;
    }

    public boolean areChangesPending() {
        return this.changesPending;
    }

    public void savePreferences() {
        this.saveType("com.topcoder.client.contestApplet.common.LocalPreferences.summaryunopened", this.UNOPEN);
        this.saveType("com.topcoder.client.contestApplet.common.LocalPreferences.summaryopened", this.OPENED);
        this.saveType("com.topcoder.client.contestApplet.common.LocalPreferences.summarycompiled", this.COMPILED);
        this.saveType("com.topcoder.client.contestApplet.common.LocalPreferences.summaryjavapoints", this.JAVAPOINTS);
        this.saveType("com.topcoder.client.contestApplet.common.LocalPreferences.summaryjavachlpassed", this.JAVACHLPASSED);
        this.saveType("com.topcoder.client.contestApplet.common.LocalPreferences.summaryjavachlfailed", this.JAVACHLFAILED);
        this.saveType("com.topcoder.client.contestApplet.common.LocalPreferences.summaryjavasyspassed", this.JAVASYSPASSED);
        this.saveType("com.topcoder.client.contestApplet.common.LocalPreferences.summaryjavasysfailed", this.JAVASYSFAILED);
        this.saveType("com.topcoder.client.contestApplet.common.LocalPreferences.summarycpppoints", this.CPPPOINTS);
        this.saveType("com.topcoder.client.contestApplet.common.LocalPreferences.summarycppchlpassed", this.CPPCHLPASSED);
        this.saveType("com.topcoder.client.contestApplet.common.LocalPreferences.summarycppchlfailed", this.CPPCHLFAILED);
        this.saveType("com.topcoder.client.contestApplet.common.LocalPreferences.summarycppsyspassed", this.CPPSYSPASSED);
        this.saveType("com.topcoder.client.contestApplet.common.LocalPreferences.summarycppsysfailed", this.CPPSYSFAILED);
        this.saveType("com.topcoder.client.contestApplet.common.LocalPreferences.summarycsharppoints", this.CSHARPPOINTS);
        this.saveType("com.topcoder.client.contestApplet.common.LocalPreferences.summarycsharpchlpassed", this.CSHARPCHLPASSED);
        this.saveType("com.topcoder.client.contestApplet.common.LocalPreferences.summarycsharpchlfailed", this.CSHARPCHLFAILED);
        this.saveType("com.topcoder.client.contestApplet.common.LocalPreferences.summarycsharpsyspassed", this.CSHARPSYSPASSED);
        this.saveType("com.topcoder.client.contestApplet.common.LocalPreferences.summarycsharpsysfailed", this.CSHARPSYSFAILED);
        this.saveType("com.topcoder.client.contestApplet.common.LocalPreferences.summaryvbpoints", VBPOINTS);
        this.saveType("com.topcoder.client.contestApplet.common.LocalPreferences.summaryvbchlpassed", VBCHLPASSED);
        this.saveType("com.topcoder.client.contestApplet.common.LocalPreferences.summaryvbchlfailed", VBCHLFAILED);
        this.saveType("com.topcoder.client.contestApplet.common.LocalPreferences.summaryvbsyspassed", VBSYSPASSED);
        this.saveType("com.topcoder.client.contestApplet.common.LocalPreferences.summaryvbsysfailed", VBSYSFAILED);
        this.saveType("com.topcoder.client.contestApplet.common.LocalPreferences.summarypythonpoints", PYTHONPOINTS);
        this.saveType("com.topcoder.client.contestApplet.common.LocalPreferences.summarypythonchlpassed", PYTHONCHLPASSED);
        this.saveType("com.topcoder.client.contestApplet.common.LocalPreferences.summarypythonchlfailed", PYTHONCHLFAILED);
        this.saveType("com.topcoder.client.contestApplet.common.LocalPreferences.summarypythonsyspassed", PYTHONSYSPASSED);
        this.saveType("com.topcoder.client.contestApplet.common.LocalPreferences.summarypythonsysfailed", PYTHONSYSFAILED);
        try {
            this.localPref.savePreferences();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.changesPending = false;
    }

    public void saveType(String string, int n) {
        this.localPref.setColor(LocalPreferences.getKeyAttribute(string, "color"), this.colors[n].getBackground());
        this.localPref.setTrue(LocalPreferences.getKeyAttribute(string, "bold"), this.bold[n].isSelected());
        this.localPref.setTrue(LocalPreferences.getKeyAttribute(string, "italic"), this.italics[n].isSelected());
    }

    private class ActionHandler
    implements ActionListener {
        private ActionHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Color color = ((JButton)actionEvent.getSource()).getBackground();
            Color color2 = JColorChooser.showDialog(null, "Choose color", color);
            if (color2 == null) {
                return;
            }
            if (!color.equals(color2)) {
                SummaryConfigurationPanel.this.changesPending = true;
            }
            ((JButton)actionEvent.getSource()).setBackground(color2);
        }
    }
}

