/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.panels;

import com.topcoder.client.contestApplet.common.Common;
import com.topcoder.client.contestApplet.common.LocalPreferences;
import com.topcoder.client.contestApplet.editors.Standard.StandardEditorPanel;
import com.topcoder.client.contestApplet.widgets.MyTitledBorder;
import com.topcoder.client.contestApplet.widgets.RoundBorder;
import com.topcoder.util.config.ConfigManager;
import com.topcoder.util.config.ConfigManagerException;
import com.topcoder.util.syntaxhighlighter.ConfigurationException;
import com.topcoder.util.syntaxhighlighter.HighlightingException;
import com.topcoder.util.syntaxhighlighter.RuleMatchException;
import com.topcoder.util.syntaxhighlighter.StatefulJTextPaneOutput;
import com.topcoder.util.syntaxhighlighter.SyntaxHighlighter;
import com.topcoder.util.syntaxhighlighter.TextStyle;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;

public class HighlightConfigurationPanel
extends JPanel {
    private JDialog parent;
    private JTextPane sourcePreview;
    private StatefulJTextPaneOutput sourcePreviewOutput;
    private String sourcePreviewStr = "/* a comment */\npublic int testMethod() {\n  String s = \"123\";\n  return 0;\n}";
    private SyntaxHighlighter highlighter;
    private SimpleEditorFilter editorFilter;
    private MutableAttributeSet attr = new SimpleAttributeSet();
    private ActionHandler handler = new ActionHandler();
    private JComboBox stdCommentsStyle;
    private JComboBox stdLiteralsStyle;
    private JComboBox stdKeywordsStyle;
    private JComboBox stdDefaultStyle;
    private JCheckBox highlightEditorBox;
    private JCheckBox highlightViewerBox;
    private HashMap map = new HashMap();
    int r;
    private boolean changesPending = false;
    private boolean needsNewWindow = false;
    private LocalPreferences localPref = LocalPreferences.getInstance();
    private boolean update = true;

    public HighlightConfigurationPanel(JDialog jDialog) {
        super(false);
        this.setLayout(new BoxLayout(this, 1));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        this.parent = jDialog;
        this.setBackground(Common.BG_COLOR);
        GridBagConstraints gridBagConstraints = Common.getDefaultConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 12;
        JPanel jPanel2 = new JPanel(new GridBagLayout(), false);
        JPanel jPanel3 = new JPanel(new GridLayout(2, 1), false);
        jPanel2.setBackground(Common.BG_COLOR);
        jPanel3.setBackground(Common.BG_COLOR);
        JPanel jPanel4 = new JPanel(new GridBagLayout(), false);
        jPanel4.setBackground(Common.BG_COLOR);
        JPanel jPanel5 = new JPanel(new BorderLayout(), false);
        jPanel5.setBackground(Common.BG_COLOR);
        RoundBorder roundBorder = new RoundBorder(Common.LIGHT_GREY, 5, true);
        MyTitledBorder myTitledBorder = new MyTitledBorder(roundBorder, "Source Preview", 1, 1);
        myTitledBorder.setTitleColor(Common.PT_COLOR);
        jPanel5.setBorder(myTitledBorder);
        this.sourcePreview = new JTextPane();
        this.sourcePreview.setEditable(false);
        jPanel5.add(this.sourcePreview);
        jPanel3.add(jPanel5);
        this.sourcePreviewOutput = new StatefulJTextPaneOutput(this.sourcePreview);
        this.map.put("com.topcoder.client.contestApplet.common.LocalPreferences.edstdsyntaxcomments", this.createJButton(this.localPref.getColor("com.topcoder.client.contestApplet.common.LocalPreferences.edstdsyntaxcomments")));
        this.map.put("com.topcoder.client.contestApplet.common.LocalPreferences.edstdsyntaxliterals", this.createJButton(this.localPref.getColor("com.topcoder.client.contestApplet.common.LocalPreferences.edstdsyntaxliterals")));
        this.map.put("com.topcoder.client.contestApplet.common.LocalPreferences.edstdsyntaxkeywords", this.createJButton(this.localPref.getColor("com.topcoder.client.contestApplet.common.LocalPreferences.edstdsyntaxkeywords")));
        this.map.put("com.topcoder.client.contestApplet.common.LocalPreferences.edstdsyntaxdefault", this.createJButton(this.localPref.getColor("com.topcoder.client.contestApplet.common.LocalPreferences.edstdsyntaxdefault")));
        Object[] objectArray = new Object[]{"Normal", "Bold", "Italic", "Bold Italic"};
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        Common.insertInPanel(this.createHeaderJLabel("Syntax Highlighting"), jPanel4, gridBagConstraints, 0, 0, 1, 1, 0.0, 0.0);
        JPanel jPanel6 = new JPanel();
        jPanel6.setBackground(Common.BG_COLOR);
        this.highlightEditorBox = this.createJCheckBox("Standard Editor", this.localPref.isSyntaxHighlight());
        jPanel6.add(this.highlightEditorBox);
        this.highlightViewerBox = this.createJCheckBox("Source Viewer", this.localPref.isViewerSyntaxHighlight());
        jPanel6.add(this.highlightViewerBox);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        Common.insertInPanel(this.createJLabel("Apply highlighting to: "), jPanel4, gridBagConstraints, 0, 1, 1, 1, 0.0, 0.0);
        Common.insertInPanel(jPanel6, jPanel4, gridBagConstraints, 1, 1, 3, 1, 0.0, 0.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        Common.insertInPanel(this.createJLabel("Comments: "), jPanel4, gridBagConstraints, 0, 2, 1, 1, 0.0, 0.0);
        this.stdCommentsStyle = new JComboBox<Object>(objectArray);
        JPanel jPanel7 = this.createSyntaxPanel("com.topcoder.client.contestApplet.common.LocalPreferences.edstdsyntaxcomments", "com.topcoder.client.contestApplet.common.LocalPreferences.edstdsyntaxcommentsstyle", this.stdCommentsStyle, objectArray, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        Common.insertInPanel(jPanel7, jPanel4, gridBagConstraints, 1, 2, 1, 1, 0.0, 0.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        Common.insertInPanel(this.createJLabel("Literals: "), jPanel4, gridBagConstraints, 2, 2, 1, 1, 0.0, 0.0);
        this.stdLiteralsStyle = new JComboBox<Object>(objectArray);
        JPanel jPanel8 = this.createSyntaxPanel("com.topcoder.client.contestApplet.common.LocalPreferences.edstdsyntaxliterals", "com.topcoder.client.contestApplet.common.LocalPreferences.edstdsyntaxliteralsstyle", this.stdLiteralsStyle, objectArray, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        Common.insertInPanel(jPanel8, jPanel4, gridBagConstraints, 3, 2, 1, 1, 0.0, 0.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        Common.insertInPanel(this.createJLabel("Keywords: "), jPanel4, gridBagConstraints, 0, 3, 1, 1, 0.0, 0.0);
        this.stdKeywordsStyle = new JComboBox<Object>(objectArray);
        JPanel jPanel9 = this.createSyntaxPanel("com.topcoder.client.contestApplet.common.LocalPreferences.edstdsyntaxkeywords", "com.topcoder.client.contestApplet.common.LocalPreferences.edstdsyntaxkeywordsstyle", this.stdKeywordsStyle, objectArray, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        Common.insertInPanel(jPanel9, jPanel4, gridBagConstraints, 1, 3, 1, 1, 0.0, 0.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        Common.insertInPanel(this.createJLabel("Default: "), jPanel4, gridBagConstraints, 2, 3, 1, 1, 0.0, 0.0);
        this.stdDefaultStyle = new JComboBox<Object>(objectArray);
        JPanel jPanel10 = this.createSyntaxPanel("com.topcoder.client.contestApplet.common.LocalPreferences.edstdsyntaxdefault", "com.topcoder.client.contestApplet.common.LocalPreferences.edstdsyntaxdefaultstyle", this.stdDefaultStyle, objectArray, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        Common.insertInPanel(jPanel10, jPanel4, gridBagConstraints, 3, 3, 1, 1, 0.0, 0.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        Common.insertInPanel(this.createJLabel(""), jPanel4, gridBagConstraints, 0, 4, 1, 1, 1.0, 1.0);
        Common.insertInPanel(jPanel4, jPanel2, gridBagConstraints, 1, 1, 1, 1);
        jPanel.add(jPanel2);
        jPanel.add(jPanel3);
        this.add(jPanel);
        AbstractDocument abstractDocument = (AbstractDocument)this.sourcePreview.getDocument();
        this.editorFilter = new SimpleEditorFilter();
        try {
            ConfigManager configManager = this.localPref.getConfigManager();
            if (!configManager.existsNamespace("com.topcoder.util.syntaxhighlighter")) {
                URL uRL = StandardEditorPanel.class.getResource("/syntaxhighlighter/config.xml");
                configManager.add(uRL);
            }
            this.highlighter = new SyntaxHighlighter();
            this.updateHighlighterStyles();
        }
        catch (ConfigurationException configurationException) {
            configurationException.printStackTrace();
        }
        catch (ConfigManagerException configManagerException) {
            configManagerException.printStackTrace();
        }
        if (this.localPref.isSyntaxHighlight()) {
            abstractDocument.setDocumentFilter(this.editorFilter);
        } else {
            abstractDocument.setDocumentFilter(null);
        }
        this.resetPreview();
        this.needsNewWindow = true;
    }

    private JLabel createHeaderJLabel(String string) {
        JLabel jLabel = new JLabel(string);
        jLabel.setForeground(Common.PT_COLOR);
        jLabel.setBackground(Common.BG_COLOR);
        jLabel.setFont(new Font(jLabel.getFont().getFontName(), 1, jLabel.getFont().getSize()));
        return jLabel;
    }

    private JLabel createJLabel(String string) {
        JLabel jLabel = new JLabel(string);
        jLabel.setForeground(Common.FG_COLOR);
        jLabel.setBackground(Common.BG_COLOR);
        return jLabel;
    }

    private JButton createJButton(Color color) {
        JButton jButton = new JButton();
        jButton.setBackground(color);
        jButton.addActionListener(this.handler);
        jButton.setPreferredSize(new Dimension(35, 20));
        return jButton;
    }

    private JCheckBox createJCheckBox(String string, boolean bl) {
        JCheckBox jCheckBox = new JCheckBox(string, bl);
        jCheckBox.setBackground(Common.BG_COLOR);
        jCheckBox.setForeground(Common.FG_COLOR);
        jCheckBox.setOpaque(false);
        jCheckBox.addActionListener(this.handler);
        return jCheckBox;
    }

    private JPanel createSyntaxPanel(String string, String string2, JComboBox jComboBox, Object[] objectArray, GridBagConstraints gridBagConstraints) {
        JPanel jPanel = new JPanel(new GridBagLayout(), false);
        jPanel.setBackground(Common.BG_COLOR);
        Common.insertInPanel((JButton)this.map.get(string), jPanel, gridBagConstraints, 0, 0, 1, 1, 0.0, 0.0);
        jComboBox.setSelectedIndex(Integer.parseInt(this.localPref.getProperty(string2, "0")));
        jComboBox.setEditable(false);
        jComboBox.addActionListener(this.handler);
        Common.insertInPanel(jComboBox, jPanel, gridBagConstraints, 1, 0, 1, 1, 0.0, 0.0);
        return jPanel;
    }

    private void resetPreview() {
        this.sourcePreview.setText("");
        this.sourcePreview.setSelectedTextColor(this.localPref.getColor("com.topcoder.client.contestApplet.common.LocalPreferences.edstdselt"));
        this.sourcePreview.setSelectionColor(this.localPref.getColor("com.topcoder.client.contestApplet.common.LocalPreferences.edstdselb"));
        this.sourcePreview.setBackground(this.localPref.getColor("com.topcoder.client.contestApplet.common.LocalPreferences.edstdback"));
        this.updateHighlighterStyles();
        try {
            this.sourcePreview.getDocument().insertString(this.sourcePreview.getDocument().getLength(), this.sourcePreviewStr, this.attr);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        if (this.needsNewWindow) {
            this.parent.pack();
        }
    }

    public boolean areChangesPending() {
        return this.changesPending;
    }

    public void saveHighlightPreferences() {
        HashMap<String, Color> hashMap = new HashMap<String, Color>();
        Iterator iterator = this.map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            JButton jButton = (JButton)this.map.get(string);
            hashMap.put(string, jButton.getBackground());
        }
        this.localPref.saveColors(hashMap);
        this.localPref.setProperty("com.topcoder.client.contestApplet.common.LocalPreferences.edstdsyntaxcommentsstyle", String.valueOf(this.stdCommentsStyle.getSelectedIndex()));
        this.localPref.setProperty("com.topcoder.client.contestApplet.common.LocalPreferences.edstdsyntaxliteralsstyle", String.valueOf(this.stdLiteralsStyle.getSelectedIndex()));
        this.localPref.setProperty("com.topcoder.client.contestApplet.common.LocalPreferences.edstdsyntaxkeywordsstyle", String.valueOf(this.stdKeywordsStyle.getSelectedIndex()));
        this.localPref.setProperty("com.topcoder.client.contestApplet.common.LocalPreferences.edstdsyntaxdefaultstyle", String.valueOf(this.stdDefaultStyle.getSelectedIndex()));
        this.localPref.setSyntaxHighlight(this.highlightEditorBox.isSelected());
        this.localPref.setViewerSyntaxHighlight(this.highlightViewerBox.isSelected());
        try {
            this.localPref.savePreferences();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.changesPending = false;
    }

    private void rehighlight(int n, int n2, int n3) {
        if (((AbstractDocument)this.sourcePreview.getDocument()).getLength() == 0) {
            return;
        }
        try {
            String string = this.sourcePreviewOutput.getHighlightString(n, n2, n3, 50, 0);
            if (string != null && !string.trim().equals("")) {
                if (!this.update) {
                    this.sourcePreviewOutput.setUpdate(false);
                }
                this.highlighter.highlightText(string, "Java", this.sourcePreviewOutput);
                if (!this.update) {
                    this.sourcePreviewOutput.setUpdate(true);
                }
            }
        }
        catch (RuleMatchException ruleMatchException) {
            ruleMatchException.printStackTrace();
            this.sourcePreviewOutput.resetState();
        }
        catch (HighlightingException highlightingException) {
            highlightingException.printStackTrace();
            this.sourcePreviewOutput.resetState();
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
            this.sourcePreviewOutput.resetState();
        }
    }

    private void updateHighlighterStyles() {
        String string = this.localPref.getFont("com.topcoder.client.contestApplet.common.LocalPreferences.edstdfont");
        int n = 0;
        int n2 = this.localPref.getFontSize("com.topcoder.client.contestApplet.common.LocalPreferences.edstdfontsize");
        for (int i = 0; i < this.highlighter.getLanguages().length; ++i) {
            TextStyle[] textStyleArray = this.highlighter.getLanguages()[i].getStyles();
            for (int j = 0; j < textStyleArray.length; ++j) {
                if (textStyleArray[j].getName().equals("KEYWORD_STYLE")) {
                    textStyleArray[j].setColor(((JButton)this.map.get("com.topcoder.client.contestApplet.common.LocalPreferences.edstdsyntaxkeywords")).getBackground());
                    n = this.stdKeywordsStyle.getSelectedIndex();
                } else if (textStyleArray[j].getName().equals("BLOCK_STYLE")) {
                    textStyleArray[j].setColor(((JButton)this.map.get("com.topcoder.client.contestApplet.common.LocalPreferences.edstdsyntaxcomments")).getBackground());
                    n = this.stdCommentsStyle.getSelectedIndex();
                } else if (textStyleArray[j].getName().equals("LITERAL_STYLE")) {
                    textStyleArray[j].setColor(((JButton)this.map.get("com.topcoder.client.contestApplet.common.LocalPreferences.edstdsyntaxliterals")).getBackground());
                    n = this.stdLiteralsStyle.getSelectedIndex();
                } else if (textStyleArray[j].getName().equals("DEFAULT_STYLE")) {
                    textStyleArray[j].setColor(((JButton)this.map.get("com.topcoder.client.contestApplet.common.LocalPreferences.edstdsyntaxdefault")).getBackground());
                    n = this.stdDefaultStyle.getSelectedIndex();
                }
                textStyleArray[j].setBGColor(this.localPref.getColor("com.topcoder.client.contestApplet.common.LocalPreferences.edstdback"));
                textStyleArray[j].setFont(new Font(string, n, n2));
            }
        }
    }

    public final class SimpleEditorFilter
    extends DocumentFilter {
        public void remove(DocumentFilter.FilterBypass filterBypass, int n, int n2) throws BadLocationException {
            super.remove(filterBypass, n, n2);
            HighlightConfigurationPanel.this.rehighlight(n, n2, 0);
        }

        public void insertString(DocumentFilter.FilterBypass filterBypass, int n, String string, AttributeSet attributeSet) throws BadLocationException {
            super.insertString(filterBypass, n, string, attributeSet);
            HighlightConfigurationPanel.this.rehighlight(n, 0, string.length());
        }

        public void replace(DocumentFilter.FilterBypass filterBypass, int n, int n2, String string, AttributeSet attributeSet) throws BadLocationException {
            super.replace(filterBypass, n, n2, string, attributeSet);
            HighlightConfigurationPanel.this.rehighlight(n, n2, string.length());
        }
    }

    private class ActionHandler
    implements ActionListener {
        private ActionHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object instanceof JButton) {
                Color color = ((JButton)actionEvent.getSource()).getBackground();
                Color color2 = JColorChooser.showDialog(null, "Choose color", color);
                if (color2 == null) {
                    return;
                }
                if (!color.equals(color2)) {
                    HighlightConfigurationPanel.this.changesPending = true;
                }
                ((JButton)actionEvent.getSource()).setBackground(color2);
                HighlightConfigurationPanel.this.resetPreview();
            } else if (object instanceof JComboBox) {
                HighlightConfigurationPanel.this.changesPending = true;
                HighlightConfigurationPanel.this.resetPreview();
            } else if (object instanceof JCheckBox) {
                HighlightConfigurationPanel.this.changesPending = true;
                HighlightConfigurationPanel.this.resetPreview();
            }
        }
    }
}

