/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.frames;

import com.topcoder.client.contestApplet.common.Common;
import com.topcoder.client.contestApplet.frames.VotingElement;
import com.topcoder.netCommon.contestantMessages.response.WLTeamsInfoResponse;
import com.topcoder.netCommon.contestantMessages.response.data.WLTeamInfo;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public final class WLTeamsInfoFrame
extends JFrame {
    private static final Color BACKGROUND = Common.WPB_COLOR;
    private static final Color PANEL_BACKGROUND = Common.PB_COLOR;
    private static final GridBagConstraints GBC = Common.getDefaultConstraints();

    private WLTeamsInfoFrame(WLTeamsInfoResponse wLTeamsInfoResponse) {
        super("Team Info");
        this.setDefaultCloseOperation(2);
        Container container = this.getContentPane();
        container.setBackground(BACKGROUND);
        container.setLayout(new GridBagLayout());
        WLTeamsInfoFrame.GBC.insets = WLTeamsInfoFrame.beginInsets();
        this.insertInContentPane(this.createPanel(wLTeamsInfoResponse), 1);
        WLTeamsInfoFrame.GBC.insets = WLTeamsInfoFrame.endInsets();
        WLTeamsInfoFrame.GBC.fill = 0;
        this.insertInContentPane(this.createOkButton(), 2);
        this.pack();
    }

    private JComponent createPanel(WLTeamsInfoResponse wLTeamsInfoResponse) {
        JPanel jPanel = new JPanel();
        double d = wLTeamsInfoResponse.getPrizeThreshold();
        jPanel.setBorder(Common.getTitledBorder("Teams Info (prize threshold = " + d + "):"));
        jPanel.setBackground(BACKGROUND);
        jPanel.setPreferredSize(new Dimension(250, 190));
        jPanel.setLayout(new BorderLayout());
        jPanel.add(this.createInsidePanel(wLTeamsInfoResponse));
        return jPanel;
    }

    private Component createInsidePanel(WLTeamsInfoResponse wLTeamsInfoResponse) {
        JPanel jPanel = new JPanel();
        jPanel.setBackground(PANEL_BACKGROUND);
        jPanel.setLayout(new GridBagLayout());
        WLTeamsInfoFrame.GBC.anchor = 17;
        WLTeamsInfoFrame.GBC.fill = 17;
        Object[] objectArray = wLTeamsInfoResponse.getTeams();
        Arrays.sort(objectArray);
        for (int i = 0; i < objectArray.length; ++i) {
            boolean bl;
            Object object = objectArray[i];
            boolean bl2 = bl = i == objectArray.length - 1;
            if (i == 0) {
                WLTeamsInfoFrame.GBC.insets = WLTeamsInfoFrame.beginInsets();
            } else if (bl) {
                WLTeamsInfoFrame.GBC.insets = WLTeamsInfoFrame.endInsets();
            } else if (i == 1) {
                WLTeamsInfoFrame.GBC.insets = WLTeamsInfoFrame.middleInsets();
            }
            double d = ((WLTeamInfo)object).getPoints();
            this.addToPanel(jPanel, ((WLTeamInfo)object).getName(), i, d);
        }
        WLTeamsInfoFrame.GBC.anchor = 11;
        return jPanel;
    }

    private void addToPanel(Container container, String string, int n, double d) {
        VotingElement votingElement = new VotingElement(string, PANEL_BACKGROUND, Common.PT_COLOR);
        WLTeamsInfoFrame.insertInPanel(votingElement.getCoderName(), container, 0, n, 1.0);
        WLTeamsInfoFrame.insertInPanel(WLTeamsInfoFrame.createLabel("" + d), container, 1, n, 1.0);
    }

    private static JComponent createLabel(String string) {
        JLabel jLabel = new JLabel(string, 0);
        jLabel.setForeground(Common.PT_COLOR);
        return jLabel;
    }

    private JComponent createOkButton() {
        JButton jButton = new JButton("Ok");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WLTeamsInfoFrame.this.dispose();
            }
        });
        return jButton;
    }

    private void insertInContentPane(JComponent jComponent, int n) {
        WLTeamsInfoFrame.insertInPanel(jComponent, this.getContentPane(), n);
    }

    private static void insertInPanel(JComponent jComponent, Container container, int n) {
        WLTeamsInfoFrame.insertInPanel(jComponent, container, 0, n);
    }

    private static void insertInPanel(JComponent jComponent, Container container, int n, int n2) {
        WLTeamsInfoFrame.insertInPanel(jComponent, container, n, n2, 1.0);
    }

    private static void insertInPanel(JComponent jComponent, Container container, int n, int n2, double d) {
        Common.insertInPanel(jComponent, container, GBC, n, n2, 1, 1, d, 0.0);
    }

    private static Insets beginInsets() {
        return WLTeamsInfoFrame.newInsets(15, 5);
    }

    private static Insets middleInsets() {
        return WLTeamsInfoFrame.newInsets(5, 5);
    }

    private static Insets endInsets() {
        return WLTeamsInfoFrame.newInsets(5, 15);
    }

    private static Insets newInsets(int n, int n2) {
        return new Insets(n, 15, n2, 15);
    }

    public static void showFrame(JFrame jFrame, WLTeamsInfoResponse wLTeamsInfoResponse) {
        WLTeamsInfoFrame wLTeamsInfoFrame = new WLTeamsInfoFrame(wLTeamsInfoResponse);
        if (jFrame != null) {
            Common.setLocationRelativeTo((Component)jFrame, wLTeamsInfoFrame);
        }
        wLTeamsInfoFrame.show();
    }
}

