/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.frames;

import com.topcoder.client.contestApplet.ContestApplet;
import com.topcoder.client.contestApplet.common.Common;
import com.topcoder.client.contestApplet.frames.VoteConfirmDialog;
import com.topcoder.client.contestApplet.frames.VotingElement;
import com.topcoder.netCommon.contestantMessages.UserInfo;
import com.topcoder.netCommon.contestantMessages.response.VoteResponse;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public final class VotingFrame
extends JFrame {
    private static final Color BACKGROUND = Common.WPB_COLOR;
    private static final Color PANEL_BACKGROUND = Common.PB_COLOR;
    private static final GridBagConstraints GBC = Common.getDefaultConstraints();
    private static VotingFrame votingFrame;
    private static JFrame tieBreakVotingFrame;
    private final ButtonGroup buttonGroup = new ButtonGroup();
    private final ContestApplet contestApplet;
    private final int roundId;
    private String selectedName;

    private VotingFrame(ContestApplet contestApplet, VoteResponse voteResponse) {
        super(voteResponse.getTitle());
        this.contestApplet = contestApplet;
        this.roundId = voteResponse.getRoundId();
        this.setDefaultCloseOperation(2);
        Container container = this.getContentPane();
        container.setBackground(BACKGROUND);
        container.setLayout(new GridBagLayout());
        VotingFrame.GBC.insets = VotingFrame.beginInsets();
        this.insertInContentPane(VotingFrame.createLabel("Elimination Round: " + voteResponse.getRoundName()), 0);
        VotingFrame.GBC.insets = VotingFrame.middleInsets();
        this.insertInContentPane(this.createVotingPanel(voteResponse), 1);
        this.insertInContentPane(VotingFrame.createLabel("* Denotes The Round's Winner - Cannot be voted out"), 2);
        VotingFrame.GBC.insets = VotingFrame.endInsets();
        VotingFrame.GBC.fill = 0;
        this.insertInContentPane(this.createVoteButton(), 3);
        this.pack();
    }

    private static Insets endInsets() {
        return VotingFrame.newInsets(5, 15);
    }

    private static Insets beginInsets() {
        return VotingFrame.newInsets(15, 5);
    }

    private static Insets middleInsets() {
        return VotingFrame.newInsets(5, 5);
    }

    private static Insets newInsets(int n, int n2) {
        return new Insets(n, 15, n2, 15);
    }

    private static void insertInPanel(JComponent jComponent, Container container, int n) {
        VotingFrame.insertInPanel(jComponent, container, 0, n, 1.0);
    }

    private static void insertInPanel(JComponent jComponent, Container container, int n, int n2, double d) {
        Common.insertInPanel(jComponent, container, GBC, n, n2, 1, 1, d, 0.0);
    }

    private void insertInContentPane(JComponent jComponent, int n) {
        VotingFrame.insertInPanel(jComponent, this.getContentPane(), n);
    }

    private static JComponent createLabel(String string) {
        JLabel jLabel = new JLabel(string, 0);
        jLabel.setForeground(Common.PT_COLOR);
        return jLabel;
    }

    private JComponent createVotingPanel(VoteResponse voteResponse) {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(Common.getTitledBorder("Choose Which Team Member You Would Like to Vote Out:"));
        jPanel.setBackground(BACKGROUND);
        jPanel.setPreferredSize(new Dimension(355, 260));
        jPanel.setLayout(new BorderLayout());
        jPanel.add(this.createInsideVotingPanel(voteResponse));
        return jPanel;
    }

    private Component createInsideVotingPanel(VoteResponse voteResponse) {
        JPanel jPanel = new JPanel();
        jPanel.setBackground(PANEL_BACKGROUND);
        jPanel.setLayout(new GridBagLayout());
        VotingFrame.GBC.anchor = 17;
        VotingFrame.GBC.fill = 17;
        UserInfo[] userInfoArray = voteResponse.getCoders();
        for (int i = 0; i < userInfoArray.length; ++i) {
            boolean bl;
            UserInfo userInfo = userInfoArray[i];
            int n = userInfo.getRating();
            boolean bl2 = i == 0;
            boolean bl3 = bl = i == userInfoArray.length - 1;
            if (i == 0) {
                VotingFrame.GBC.insets = VotingFrame.beginInsets();
            } else if (bl) {
                VotingFrame.GBC.insets = VotingFrame.endInsets();
            } else if (i == 1) {
                VotingFrame.GBC.insets = VotingFrame.middleInsets();
            }
            Color color = Common.getRankColor(n);
            this.addToVotingPanel(jPanel, userInfo.getHandle(), color, i, bl2, bl, voteResponse.getMaxList());
        }
        VotingFrame.GBC.anchor = 11;
        return jPanel;
    }

    private void addToVotingPanel(Container container, final String string, Color color, int n, boolean bl, boolean bl2, ArrayList arrayList) {
        AbstractButton abstractButton;
        VotingElement votingElement = new VotingElement(string, PANEL_BACKGROUND, color);
        if (bl) {
            VotingFrame.insertInPanel(votingElement.getStar(), container, 0, n, 0.0);
        } else if (arrayList.isEmpty() || arrayList.contains(new Integer(n))) {
            abstractButton = votingElement.getRadioButton();
            abstractButton.setActionCommand(string);
            if (bl2) {
                abstractButton.setSelected(true);
            }
            this.buttonGroup.add(abstractButton);
            VotingFrame.insertInPanel(abstractButton, container, 1, n, 0.0);
        }
        VotingFrame.insertInPanel(votingElement.getCoderName(), container, 2, n, 1.0);
        abstractButton = votingElement.getRoundStats();
        abstractButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                VotingFrame.this.sendRoundStatsRequest(string);
            }
        });
        VotingFrame.insertInPanel(abstractButton, container, 3, n, 1.0);
    }

    private void sendRoundStatsRequest(String string) {
        if (this.contestApplet != null) {
            this.contestApplet.sendRoundStatsRequest(this.roundId, string);
        }
    }

    public static void showFrame(ContestApplet contestApplet, VoteResponse voteResponse) {
        VotingFrame votingFrame = new VotingFrame(contestApplet, voteResponse);
        if (contestApplet != null) {
            Common.setLocationRelativeTo((Component)contestApplet.getCurrentFrame(), votingFrame);
        }
        votingFrame.show();
        byte by = voteResponse.getType();
        switch (by) {
            case 1: {
                VotingFrame.votingFrame = votingFrame;
                break;
            }
            case 2: {
                tieBreakVotingFrame = votingFrame;
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown type: " + by);
            }
        }
    }

    private JComponent createVoteButton() {
        JButton jButton = new JButton("Submit Vote");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ButtonModel buttonModel = VotingFrame.this.buttonGroup.getSelection();
                VotingFrame.this.selectedName = buttonModel.getActionCommand();
                VotingFrame.assertNotNull(VotingFrame.this.selectedName);
                VoteConfirmDialog.showDialog(votingFrame, VotingFrame.this.selectedName);
            }
        });
        return jButton;
    }

    void send() {
        this.dispose();
        if (this.contestApplet != null) {
            VotingFrame.assertNotNull(this.selectedName);
            this.contestApplet.sendVoteBack(this.roundId, this.selectedName);
        }
    }

    private static void assertNotNull(Object object) {
        VotingFrame.assertTrue(object != null);
    }

    private static void assertTrue(boolean bl) {
        if (!bl) {
            throw new RuntimeException();
        }
    }

    private static void disposeFrame(JFrame jFrame) {
        if (jFrame != null) {
            jFrame.dispose();
        }
    }

    public static void disposeVotingFrame() {
        VotingFrame.disposeFrame(votingFrame);
    }

    public static void disposeTieBreakVotingFrame() {
        VotingFrame.disposeFrame(tieBreakVotingFrame);
    }
}

