/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.frames;

import com.topcoder.client.contestApplet.common.Common;
import com.topcoder.client.contestApplet.common.LocalPreferences;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Highlighter;

public class SourceFindDialog
extends KeyAdapter
implements ItemListener,
ActionListener {
    private LocalPreferences localPref = LocalPreferences.getInstance();
    JFrame frame;
    JDialog dial;
    JEditorPane target;
    String text;
    boolean backwardDir = false;
    boolean ignoreCase = true;
    boolean wrapAround = true;
    boolean closeAfterFind = true;
    boolean syntaxHighlight = false;
    JTextField findField = new JTextField(25);
    JCheckBox findOption = new JCheckBox("Find Backwards", this.backwardDir);
    JCheckBox caseOption = new JCheckBox("Ignore Case", this.ignoreCase);
    JCheckBox wrapOption = new JCheckBox("Wrap Around", this.wrapAround);
    JCheckBox closeOption = new JCheckBox("Close After Find", this.closeAfterFind);
    JButton findButton = new JButton("Find");
    Highlighter.HighlightPainter myHighlightPainter = new MyHighlightPainter(this.localPref.getColor("com.topcoder.client.contestApplet.common.LocalPreferences.edstdselb"));

    public SourceFindDialog(JPanel jPanel, JEditorPane jEditorPane) {
        Container container;
        this.target = jEditorPane;
        for (container = jPanel.getParent(); container != null && !(container instanceof JFrame); container = container.getParent()) {
        }
        this.frame = (JFrame)container;
        this.dial = new JDialog(this.frame, "Find Text", false);
        Container container2 = this.dial.getContentPane();
        container2.setBackground(Common.WPB_COLOR);
        this.findOption.addItemListener(this);
        this.caseOption.addItemListener(this);
        this.wrapOption.addItemListener(this);
        this.closeOption.addItemListener(this);
        this.findButton.addActionListener(this);
        this.dial.addKeyListener(this);
        JLabel jLabel = new JLabel("Find:");
        jLabel.setForeground(Common.FG_COLOR);
        this.findOption.setBackground(Common.WPB_COLOR);
        this.caseOption.setBackground(Common.WPB_COLOR);
        this.wrapOption.setBackground(Common.WPB_COLOR);
        this.closeOption.setBackground(Common.WPB_COLOR);
        this.findOption.setForeground(Common.FG_COLOR);
        this.caseOption.setForeground(Common.FG_COLOR);
        this.wrapOption.setForeground(Common.FG_COLOR);
        this.closeOption.setForeground(Common.FG_COLOR);
        Box box = Box.createHorizontalBox();
        box.add(Box.createHorizontalStrut(5));
        box.add(jLabel);
        box.add(Box.createHorizontalStrut(5));
        box.add(this.findField);
        box.add(Box.createHorizontalStrut(10));
        box.add(this.findButton);
        box.add(Box.createHorizontalStrut(10));
        int n = 40;
        Box box2 = Box.createHorizontalBox();
        box2.add(Box.createHorizontalStrut(n));
        box2.add(this.findOption);
        box2.add(Box.createHorizontalGlue());
        Box box3 = Box.createHorizontalBox();
        box3.add(Box.createHorizontalStrut(n));
        box3.add(this.caseOption);
        box3.add(Box.createHorizontalGlue());
        Box box4 = Box.createHorizontalBox();
        box4.add(Box.createHorizontalStrut(n));
        box4.add(this.wrapOption);
        box4.add(Box.createHorizontalGlue());
        Box box5 = Box.createHorizontalBox();
        box5.add(Box.createHorizontalStrut(n));
        box5.add(this.closeOption);
        box5.add(Box.createHorizontalGlue());
        Box box6 = Box.createVerticalBox();
        box6.add(Box.createVerticalStrut(15));
        box6.add(box);
        box6.add(Box.createVerticalStrut(2));
        box6.add(box2);
        box6.add(Box.createVerticalStrut(2));
        box6.add(box3);
        box6.add(Box.createVerticalStrut(2));
        box6.add(box4);
        box6.add(Box.createVerticalStrut(2));
        box6.add(box5);
        this.dial.getContentPane().add(box6);
        this.dial.setResizable(false);
        this.dial.setSize(new Dimension(397, 179));
        this.dial.pack();
        this.dial.setLocationRelativeTo(this.frame);
    }

    public void setText(String string) {
        this.text = string;
    }

    public void setSyntaxHighlight(boolean bl) {
        this.syntaxHighlight = bl;
    }

    public void show() {
        this.dial.setVisible(true);
        this.dial.toFront();
    }

    public void hide() {
        this.dial.setVisible(false);
    }

    public void findAgain() {
        this.findButton.doClick();
    }

    public void keyPressed(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 10: {
                this.findButton.doClick();
                break;
            }
            case 27: {
                this.hide();
            }
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        ItemSelectable itemSelectable = itemEvent.getItemSelectable();
        if (itemSelectable == this.findOption) {
            this.backwardDir = itemEvent.getStateChange() == 1;
        } else if (itemSelectable == this.caseOption) {
            this.ignoreCase = itemEvent.getStateChange() == 1;
        } else if (itemSelectable == this.wrapOption) {
            this.wrapAround = itemEvent.getStateChange() == 1;
        } else if (itemSelectable == this.closeOption) {
            this.closeAfterFind = itemEvent.getStateChange() == 1;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = this.findField.getText();
        int n = string.length();
        String string2 = this.text;
        string2 = string2.replaceAll("\r", "");
        string2 = string2.replaceAll("\\t", "    ");
        int n2 = string2.length();
        int n3 = this.backwardDir ? -1 : 1;
        int n4 = this.target.getCaretPosition();
        int n5 = n4 + n3;
        boolean bl = this.wrapAround;
        while (true) {
            for (int i = n5; i >= 0 && i < n2; i += n3) {
                if (!string2.regionMatches(this.ignoreCase, i, string, 0, n)) continue;
                try {
                    Highlighter highlighter = this.target.getHighlighter();
                    Highlighter.Highlight[] highlightArray = highlighter.getHighlights();
                    for (int j = 0; j < highlightArray.length; ++j) {
                        if (!(highlightArray[j].getPainter() instanceof MyHighlightPainter)) continue;
                        highlighter.removeHighlight(highlightArray[j]);
                    }
                    highlighter.addHighlight(i + 1, i + n + 1, this.myHighlightPainter);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                this.target.setCaretPosition(i);
                if (this.closeAfterFind) {
                    this.hide();
                }
                return;
            }
            if (!bl) break;
            bl = false;
            n5 = this.backwardDir ? n2 - 1 : 0;
        }
        JOptionPane.showMessageDialog(this.frame, "The search string was not found", "Find", 2);
        if (this.closeAfterFind) {
            this.hide();
        }
    }

    class MyHighlightPainter
    extends DefaultHighlighter.DefaultHighlightPainter {
        public MyHighlightPainter(Color color) {
            super(color);
        }
    }
}

