/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.frames;

import com.topcoder.client.contestApplet.frames.MessageDialog;
import com.topcoder.client.contestant.RoundModel;
import com.topcoder.netCommon.contestantMessages.response.data.PhaseData;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import javax.swing.JFrame;

public class RoundScheduleFrame
extends MessageDialog {
    public RoundScheduleFrame(RoundModel roundModel, JFrame jFrame) {
        super(jFrame, "Schedule - " + roundModel.getDisplayName(), RoundScheduleFrame.buildMessage(roundModel), false, true);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static String buildMessage(RoundModel roundModel) {
        if (!roundModel.hasSchedule()) {
            throw new IllegalStateException("Expected round to have schedule: " + roundModel);
        }
        PhaseData[] phaseDataArray = (PhaseData[])roundModel.getSchedule().clone();
        Arrays.sort(phaseDataArray, new Comparator(){

            public int compare(Object object, Object object2) {
                PhaseData phaseData = (PhaseData)object;
                PhaseData phaseData2 = (PhaseData)object2;
                long l = phaseData.getStartTime() - phaseData2.getStartTime();
                return l == 0L ? 0 : (l < 0L ? -1 : 1);
            }
        });
        String string = "";
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE MMM d, h:mm a z");
        int n = 0;
        while (true) {
            block13: {
                if (n >= phaseDataArray.length) {
                    return string;
                }
                PhaseData phaseData = phaseDataArray[n];
                String string2 = null;
                switch (phaseData.getPhaseType()) {
                    case 2: {
                        if (RoundScheduleFrame.hasAssignedTime(phaseData)) {
                            string2 = "REGISTRATION";
                            break;
                        }
                        break block13;
                    }
                    case 4: {
                        string2 = "CODING";
                        break;
                    }
                    case 5: {
                        if (RoundScheduleFrame.hasAssignedTime(phaseData)) {
                            string2 = "INTERMISSION";
                            break;
                        }
                        break block13;
                    }
                    case 6: {
                        if (RoundScheduleFrame.hasAssignedTime(phaseData)) {
                            string2 = "CHALLENGE";
                            break;
                        }
                        break block13;
                    }
                    case 8: {
                        string2 = "SYSTEM TEST";
                    }
                }
                string = string + simpleDateFormat.format(new Date(phaseData.getStartTime())) + "  " + string2 + '\n';
            }
            ++n;
        }
    }

    private static boolean hasAssignedTime(PhaseData phaseData) {
        return phaseData.getEndTime() - phaseData.getStartTime() >= 0L;
    }
}

