/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.frames;

import com.topcoder.client.contestApplet.ContestApplet;
import com.topcoder.client.contestApplet.common.Common;
import com.topcoder.client.contestApplet.panels.table.AbstractSummaryTablePanel;
import com.topcoder.client.contestApplet.panels.table.DivSummaryTablePanel;
import com.topcoder.client.contestApplet.panels.table.LongSummaryTablePanel;
import com.topcoder.client.contestApplet.widgets.ResultDisplayTypeSelectionPanel;
import com.topcoder.client.contestant.RoomModel;
import com.topcoder.client.contestant.RoundModel;
import com.topcoder.client.contestant.TimeOutException;
import com.topcoder.client.contestant.view.ChallengeView;
import com.topcoder.netCommon.contest.ResultDisplayType;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class DivSummaryFrame
extends JFrame {
    private ContestApplet parentFrame = null;
    private AbstractSummaryTablePanel challengePanel = null;
    private RoundModel roundModel = null;
    private boolean once = true;
    private JRadioButton jrb2 = null;
    private Integer divisionID;
    private boolean open = false;
    private JComboBox divisionList;
    private JFrame frame = null;
    private boolean enabled = true;
    private ResultDisplayTypeSelectionPanel resultDisplayTypeSelectionPanel;

    public void setPanelEnabled(boolean bl) {
        this.enabled = bl;
        this.divisionList.setEnabled(bl);
        if (this.challengePanel != null) {
            this.challengePanel.setPanelEnabled(bl);
        }
    }

    public DivSummaryFrame(RoundModel roundModel, ContestApplet contestApplet) {
        super("TopCoder Competition Arena - Competition Details");
        this.parentFrame = contestApplet;
        this.roundModel = roundModel;
        this.divisionID = roundModel.getRoundProperties().hasDivisions() && contestApplet.getModel().getUserInfo().getRating() != -1 && contestApplet.getModel().getUserInfo().getRating() < 1200 && this.roundModel.hasProblems(new Integer(2)) ? new Integer(2) : new Integer(1);
        this.create();
    }

    public void showFrame(boolean bl) {
        if (this.once) {
            Common.setLocationRelativeTo((Component)this.parentFrame.getMainFrame(), this);
            this.once = false;
        }
        if (!this.open) {
            // empty if block
        }
        this.open = true;
        this.show();
    }

    private void create() {
        JComponent jComponent;
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().setBackground(Common.WPB_COLOR);
        this.divisionList = Common.createComboBox();
        for (int i = 1; i <= 10; ++i) {
            if (!this.roundModel.hasProblems(new Integer(i)) || this.roundModel.getProblems(new Integer(i)).length <= 0) continue;
            this.divisionList.addItem(new Integer(i));
        }
        this.divisionList.setSelectedItem(this.divisionID);
        this.divisionList.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DivSummaryFrame.this.divisionListEvent();
            }
        });
        this.divisionList.setRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                if (object instanceof Integer) {
                    Integer n2 = (Integer)object;
                    object = "Division " + n2;
                }
                return super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            }
        });
        this.divisionListEvent();
        if (this.roundModel.getRoundProperties().hasDivisions()) {
            jComponent = new JLabel("Select a division:");
            jComponent.setBackground(Common.THB_COLOR);
            jComponent.setForeground(Common.THF_COLOR);
            jComponent.setFont(jComponent.getFont().deriveFont(1));
            this.getContentPane().add((Component)jComponent, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(15, 28, 5, 5), 0, 0));
            this.getContentPane().add((Component)this.divisionList, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(15, 15, 5, 5), 0, 0));
        } else {
            jComponent = new JPanel();
            jComponent.setOpaque(false);
            this.getContentPane().add((Component)jComponent, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(15, 28, 5, 5), 0, 0));
            jComponent = new JPanel();
            jComponent.setOpaque(false);
            this.getContentPane().add((Component)jComponent, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(15, 15, 5, 5), 0, 0));
        }
        if (!this.roundModel.getRoundType().isLongRound()) {
            jComponent = this.createPrettyTogglePanel();
            this.getContentPane().add((Component)jComponent, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 1, new Insets(5, 5, 0, 15), 0, 0));
        }
        this.setSize(new Dimension(720, 430));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                DivSummaryFrame.this.unsetModel();
            }
        });
    }

    private void createChallengePanel() {
        AbstractSummaryTablePanel abstractSummaryTablePanel = this.roundModel.getRoundType().isLongRound() ? new LongSummaryTablePanel(this.parentFrame, this.roundModel.getCoderRooms()[0], this, false) : new DivSummaryTablePanel(this.parentFrame, this.roundModel, this, false, this.divisionID);
        abstractSummaryTablePanel.setPreferredSize(new Dimension(675, 310));
        if (this.challengePanel != null) {
            this.getContentPane().remove(this.challengePanel);
        }
        this.getContentPane().add((Component)abstractSummaryTablePanel, new GridBagConstraints(0, 1, 3, 1, 1.0, 1.0, 10, 1, new Insets(5, 15, 15, 15), 0, 0));
        this.challengePanel = abstractSummaryTablePanel;
    }

    public boolean getPrettyToggle() {
        return this.jrb2.isSelected();
    }

    private JPanel createPrettyTogglePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setOpaque(false);
        if (this.roundModel.getRoundType().isLongRound()) {
            return jPanel;
        }
        GridBagConstraints gridBagConstraints = Common.getDefaultConstraints();
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        JLabel jLabel = new JLabel("Pretty : ", 2);
        JRadioButton jRadioButton = new JRadioButton("Off", true);
        JRadioButton jRadioButton2 = new JRadioButton("On", false);
        jLabel.setToolTipText("Reformat source code for readability.");
        jLabel.setForeground(Color.white);
        jRadioButton.setBackground(Common.WPB_COLOR);
        jRadioButton2.setBackground(Common.WPB_COLOR);
        jRadioButton.setForeground(Color.white);
        jRadioButton2.setForeground(Color.white);
        jRadioButton.setOpaque(false);
        jRadioButton2.setOpaque(false);
        jRadioButton.setActionCommand("Standard");
        jRadioButton2.setActionCommand("VI");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton2);
        this.jrb2 = jRadioButton2;
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        jPanel2.setOpaque(false);
        jPanel2.add(jRadioButton);
        jPanel2.add(jRadioButton2);
        Common.insertInPanel(jLabel, jPanel, gridBagConstraints, 0, 0, 1, 1, 0.3, 0.1);
        Common.insertInPanel(jPanel2, jPanel, gridBagConstraints, 1, 0, 2, 1, 0.1, 0.1);
        JLabel jLabel2 = new JLabel("View : ", 2);
        jLabel2.setToolTipText("View challenge/test status or point values.");
        jLabel2.setForeground(Color.white);
        this.resultDisplayTypeSelectionPanel = new ResultDisplayTypeSelectionPanel(this.roundModel, new ResultDisplayTypeSelectionPanel.Listener(){

            public void typeChanged(ResultDisplayType resultDisplayType) {
                DivSummaryFrame.this.challengePanel.updateView(resultDisplayType);
            }
        });
        Common.insertInPanel(jLabel2, jPanel, gridBagConstraints, 0, 1, 1, 1, 0.3, 0.1);
        Common.insertInPanel(this.resultDisplayTypeSelectionPanel, jPanel, gridBagConstraints, 1, 1, 2, 1, 0.1, 0.1);
        return jPanel;
    }

    private void setModel() {
        try {
            this.parentFrame.getRequester().requestDivSummary(this.roundModel.getRoundID(), this.divisionID.longValue());
        }
        catch (TimeOutException timeOutException) {
            timeOutException.printStackTrace();
        }
        int n = 0;
        RoomModel[] roomModelArray = this.roundModel.getCoderRooms();
        for (int i = 0; i < roomModelArray.length; ++i) {
            if (roomModelArray[i].getDivisionID().intValue() != this.divisionID.intValue()) continue;
            ++n;
            roomModelArray[i].addChallengeView(this.challengePanel);
        }
        if (this.challengePanel instanceof DivSummaryTablePanel) {
            DivSummaryTablePanel divSummaryTablePanel = (DivSummaryTablePanel)this.challengePanel;
            divSummaryTablePanel.totalRooms = n;
            divSummaryTablePanel.setUpdate(true);
        } else if (this.challengePanel instanceof LongSummaryTablePanel) {
            LongSummaryTablePanel longSummaryTablePanel = (LongSummaryTablePanel)this.challengePanel;
            longSummaryTablePanel.setUpdate(true);
        }
    }

    private void unsetModel() {
        RoomModel[] roomModelArray = this.roundModel.getCoderRooms();
        for (int i = 0; i < roomModelArray.length; ++i) {
            if (roomModelArray[i].getDivisionID().intValue() != this.divisionID.intValue()) continue;
            roomModelArray[i].removeChallengeView(this.challengePanel);
        }
        if (this.enabled) {
            this.parentFrame.getRequester().requestCloseDivSummary(this.roundModel.getRoundID(), this.divisionID.longValue());
        }
    }

    public void hide() {
        super.hide();
        if (this.open) {
            this.unsetModel();
        }
        this.challengePanel.closeSourceViewer();
    }

    public ChallengeView getChallengePanel() {
        return this.challengePanel;
    }

    private void divisionListEvent() {
        int n = this.divisionList.getSelectedIndex();
        if (n < 0) {
            return;
        }
        Object e = this.divisionList.getItemAt(n);
        Integer n2 = (Integer)e;
        this.unsetModel();
        this.divisionID = n2;
        this.createChallengePanel();
        this.setModel();
        this.validate();
        this.repaint();
    }
}

