/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.editors.Standard;

import com.topcoder.client.contestApplet.common.Common;
import com.topcoder.client.contestApplet.common.LocalPreferences;
import com.topcoder.client.contestApplet.editors.Standard.FindAction;
import com.topcoder.client.contestApplet.editors.Standard.FindAgainAction;
import com.topcoder.client.contestApplet.editors.Standard.FindDialog;
import com.topcoder.client.contestApplet.editors.Standard.GotoAction;
import com.topcoder.client.contestApplet.editors.Standard.RedoAction;
import com.topcoder.client.contestApplet.editors.Standard.StandardEditor;
import com.topcoder.client.contestApplet.editors.Standard.UndoAction;
import com.topcoder.util.config.ConfigManager;
import com.topcoder.util.config.ConfigManagerException;
import com.topcoder.util.syntaxhighlighter.ConfigurationException;
import com.topcoder.util.syntaxhighlighter.HighlightingException;
import com.topcoder.util.syntaxhighlighter.RuleMatchException;
import com.topcoder.util.syntaxhighlighter.StatefulJTextPaneOutput;
import com.topcoder.util.syntaxhighlighter.SyntaxHighlighter;
import com.topcoder.util.syntaxhighlighter.TextStyle;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.Serializable;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.TabSet;
import javax.swing.text.TabStop;
import javax.swing.undo.UndoManager;

public class StandardEditorPanel
extends JPanel
implements CaretListener,
Observer {
    private int position;
    private boolean update = true;
    private JLabel lineLabel;
    private JTextPane textPane;
    private StatefulJTextPaneOutput textPaneOutput;
    private FindDialog findDialog;
    private FindAction findAction;
    private UndoAction undoAction;
    private RedoAction redoAction;
    private FindAgainAction findAgainAction;
    private GotoAction gotoAction;
    protected UndoManager undo;
    private LocalPreferences pref = LocalPreferences.getInstance();
    private SyntaxHighlighter highlighter;
    private SimpleEditorFilter editorFilter;
    private String highlightLanguage;
    private boolean autoIndent = true;
    HashMap keyPrefs = new HashMap();
    HashMap keyButtons = new HashMap();
    private static final int TAB_COUNT = 20;

    public void update(Observable observable, Object object) {
        MutableAttributeSet mutableAttributeSet;
        this.autoIndent = this.pref.isTrue("com.topcoder.client.contestApplet.common.LocalPreferences.edstdindent");
        AbstractDocument abstractDocument = (AbstractDocument)this.textPane.getDocument();
        if (this.pref.isSyntaxHighlight()) {
            abstractDocument.setDocumentFilter(this.editorFilter);
            this.updateHighlighterStyles();
        } else {
            abstractDocument.setDocumentFilter(null);
            mutableAttributeSet = new SimpleAttributeSet();
            StyleConstants.setBold(mutableAttributeSet, false);
            StyleConstants.setItalic(mutableAttributeSet, false);
            StyleConstants.setForeground(mutableAttributeSet, this.pref.getColor("com.topcoder.client.contestApplet.common.LocalPreferences.edstdfore"));
            StyleConstants.setFontFamily(mutableAttributeSet, this.pref.getFont("com.topcoder.client.contestApplet.common.LocalPreferences.edstdfont"));
            StyleConstants.setFontSize(mutableAttributeSet, this.pref.getFontSize("com.topcoder.client.contestApplet.common.LocalPreferences.edstdfontsize"));
            this.textPane.getStyledDocument().setCharacterAttributes(35221, 21, mutableAttributeSet, true);
        }
        mutableAttributeSet = this.textPane.getLogicalStyle();
        StyleConstants.setTabSet(mutableAttributeSet, this.getTabSet(this.pref.getTabSize()));
    }

    public StandardEditorPanel(JTextPane jTextPane) {
        Serializable serializable;
        Object object;
        this.setLayout(new BoxLayout(this, 1));
        this.textPane = jTextPane;
        this.textPaneOutput = new StatefulJTextPaneOutput(this.textPane);
        AbstractDocument abstractDocument = (AbstractDocument)this.textPane.getDocument();
        this.editorFilter = new SimpleEditorFilter();
        try {
            object = this.pref.getConfigManager();
            if (!((ConfigManager)object).existsNamespace("com.topcoder.util.syntaxhighlighter")) {
                serializable = StandardEditorPanel.class.getResource("/syntaxhighlighter/config.xml");
                ((ConfigManager)object).add((URL)serializable);
            }
            this.highlighter = new SyntaxHighlighter();
            this.updateHighlighterStyles();
        }
        catch (ConfigurationException configurationException) {
            configurationException.printStackTrace();
        }
        catch (ConfigManagerException configManagerException) {
            configManagerException.printStackTrace();
        }
        if (this.pref.isSyntaxHighlight()) {
            abstractDocument.setDocumentFilter(this.editorFilter);
        } else {
            abstractDocument.setDocumentFilter(null);
        }
        object = this.textPane.getLogicalStyle();
        StyleConstants.setTabSet((MutableAttributeSet)object, this.getTabSet(this.pref.getTabSize()));
        this.undo = new UndoManager();
        this.undo.setLimit(5000);
        this.textPane.getDocument().addUndoableEditListener(new StandardUndoableEditListener());
        this.textPane.addCaretListener(this);
        this.setBackground(Common.BG_COLOR);
        this.findAction = new FindAction(this);
        this.findAgainAction = new FindAgainAction(this);
        this.gotoAction = new GotoAction(this);
        this.undoAction = new UndoAction(this);
        this.redoAction = new RedoAction(this);
        serializable = Common.getImageButton("g_find_but.gif", this);
        ((AbstractButton)serializable).addActionListener(this.findAction);
        ((JComponent)serializable).setToolTipText("Find text");
        JButton jButton = Common.getImageButton("g_goto_but.gif", this);
        jButton.addActionListener(this.gotoAction);
        jButton.setToolTipText("Goto Line");
        JButton jButton2 = Common.getImageButton("g_undo_but.gif", this);
        jButton2.addActionListener(this.undoAction);
        jButton2.setToolTipText("Undo");
        JButton jButton3 = Common.getImageButton("g_redo_but.gif", this);
        jButton3.addActionListener(this.redoAction);
        jButton3.setToolTipText("Redo");
        this.lineLabel = new JLabel("Line : 1");
        this.lineLabel.setForeground(Color.white);
        this.lineLabel.setMinimumSize(new Dimension(70, 18));
        this.lineLabel.setPreferredSize(new Dimension(70, 18));
        this.textPane.addKeyListener(new KeyHandler());
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add(this.textPane);
        JScrollPane jScrollPane = new JScrollPane(jPanel);
        jScrollPane.getVerticalScrollBar().setUnitIncrement(13);
        jScrollPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        jScrollPane.setBackground(Common.BG_COLOR);
        Box box = Box.createHorizontalBox();
        box.add((Component)serializable);
        box.add(jButton);
        box.add(jButton2);
        box.add(jButton3);
        box.add(Box.createHorizontalGlue());
        box.add(this.lineLabel);
        this.add(jScrollPane);
        this.add(Box.createVerticalStrut(2));
        this.add(box);
        this.findDialog = new FindDialog(this, this.textPane);
        this.keyPrefs.put("com.topcoder.client.contestApplet.common.LocalPreferences.edstdkeyfind", this.pref.getHotKey("com.topcoder.client.contestApplet.common.LocalPreferences.edstdkeyfind"));
        this.keyPrefs.put("com.topcoder.client.contestApplet.common.LocalPreferences.edstdkeygoto", this.pref.getHotKey("com.topcoder.client.contestApplet.common.LocalPreferences.edstdkeygoto"));
        this.keyPrefs.put("com.topcoder.client.contestApplet.common.LocalPreferences.edstdkeyundo", this.pref.getHotKey("com.topcoder.client.contestApplet.common.LocalPreferences.edstdkeyundo"));
        this.keyPrefs.put("com.topcoder.client.contestApplet.common.LocalPreferences.edstdkeyredo", this.pref.getHotKey("com.topcoder.client.contestApplet.common.LocalPreferences.edstdkeyredo"));
        this.keyButtons.put("com.topcoder.client.contestApplet.common.LocalPreferences.edstdkeyfind", serializable);
        this.keyButtons.put("com.topcoder.client.contestApplet.common.LocalPreferences.edstdkeygoto", jButton);
        this.keyButtons.put("com.topcoder.client.contestApplet.common.LocalPreferences.edstdkeyundo", jButton2);
        this.keyButtons.put("com.topcoder.client.contestApplet.common.LocalPreferences.edstdkeyredo", jButton3);
    }

    private boolean checkValue(KeyEvent keyEvent, String string) {
        String[] stringArray = string.split("\\+");
        for (int i = 0; i < stringArray.length - 1; ++i) {
            if (stringArray[i].equals("Ctrl")) {
                if ((keyEvent.getModifiers() & 2) != 0) continue;
                return false;
            }
            if (stringArray[i].equals("Alt")) {
                if ((keyEvent.getModifiers() & 8) != 0) continue;
                return false;
            }
            if (!stringArray[i].equals("Shift")) continue;
            if ((keyEvent.getModifiers() & 1) != 0) continue;
            return false;
        }
        return stringArray[stringArray.length - 1].equals(KeyEvent.getKeyText(keyEvent.getKeyCode()));
    }

    public void doUndo() {
        while (this.undo.canUndo() && this.undo.getUndoPresentationName().equals("Undo style change")) {
            this.undo.undo();
        }
        if (this.undo.canUndo()) {
            String string = this.undo.getUndoPresentationName();
            int n = this.position;
            this.undo.undo();
            int n2 = this.position;
            this.update = false;
            if (string.equals("Undo addition")) {
                this.rehighlight(n2, Math.abs(n - n2), 0);
            }
            if (string.equals("Undo deletion")) {
                this.rehighlight(n, 0, Math.abs(n2 - n));
            }
            this.update = true;
            this.textPane.requestFocusInWindow();
            this.textPane.setCaretPosition(n2);
        }
    }

    public void doRedo() {
        int n = -1;
        if (this.undo.canRedo()) {
            String string = this.undo.getRedoPresentationName();
            int n2 = this.position;
            this.undo.redo();
            n = this.position;
            this.update = false;
            if (string.equals("Redo addition")) {
                this.rehighlight(n2, 0, Math.abs(n - n2));
            }
            if (string.equals("Redo deletion")) {
                this.rehighlight(n, Math.abs(n2 - n), 0);
            }
            this.update = true;
        }
        while (this.undo.canRedo() && this.undo.getRedoPresentationName().equals("Redo style change")) {
            this.undo.redo();
        }
        if (n >= 0) {
            this.textPane.requestFocusInWindow();
            this.textPane.setCaretPosition(n);
        }
    }

    public FindDialog getFindDialog() {
        return this.findDialog;
    }

    public JTextPane getTextPane() {
        return this.textPane;
    }

    public void caretUpdate(CaretEvent caretEvent) {
        try {
            int n = caretEvent.getDot();
            this.position = caretEvent.getDot();
            Document document = this.textPane.getDocument();
            if (n < document.getStartPosition().getOffset() || n >= document.getEndPosition().getOffset()) {
                throw new BadLocationException("offset outside of document", n);
            }
            int n2 = document.getDefaultRootElement().getElementIndex(n) + 1;
            this.lineLabel.setText("Line : " + n2);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        jFrame.setDefaultCloseOperation(3);
        StandardEditor standardEditor = new StandardEditor("ababab");
        StandardEditorPanel standardEditorPanel = new StandardEditorPanel(standardEditor);
        jFrame.getContentPane().add(standardEditorPanel);
        jFrame.pack();
        jFrame.show();
    }

    private void rehighlight(int n, int n2, int n3) {
        if (((AbstractDocument)this.textPane.getDocument()).getLength() == 0) {
            return;
        }
        try {
            String string = this.textPaneOutput.getHighlightString(n, n2, n3, 50, 0);
            if (string != null && !string.trim().equals("")) {
                if (!this.update) {
                    this.textPaneOutput.setUpdate(false);
                }
                this.highlighter.highlightText(string, ((StandardEditor)this.textPane).getLanguage().getName(), this.textPaneOutput);
                if (!this.update) {
                    this.textPaneOutput.setUpdate(true);
                }
            }
        }
        catch (RuleMatchException ruleMatchException) {
            ruleMatchException.printStackTrace();
            this.textPaneOutput.resetState();
        }
        catch (HighlightingException highlightingException) {
            highlightingException.printStackTrace();
            this.textPaneOutput.resetState();
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
            this.textPaneOutput.resetState();
        }
    }

    private TabSet getTabSet(int n) {
        String string = this.pref.getFont("com.topcoder.client.contestApplet.common.LocalPreferences.edstdfont");
        int n2 = 0;
        int n3 = this.pref.getFontSize("com.topcoder.client.contestApplet.common.LocalPreferences.edstdfontsize");
        Font font = new Font(string, n2, n3);
        int n4 = StyleContext.getDefaultStyleContext().getFontMetrics(font).stringWidth(" ");
        TabStop[] tabStopArray = new TabStop[20];
        for (int i = 0; i < 20; ++i) {
            tabStopArray[i] = new TabStop(n * n4 * (i + 1), 0, 1);
        }
        return new TabSet(tabStopArray);
    }

    private void updateHighlighterStyles() {
        String string = this.pref.getFont("com.topcoder.client.contestApplet.common.LocalPreferences.edstdfont");
        int n = 0;
        int n2 = this.pref.getFontSize("com.topcoder.client.contestApplet.common.LocalPreferences.edstdfontsize");
        for (int i = 0; i < this.highlighter.getLanguages().length; ++i) {
            TextStyle[] textStyleArray = this.highlighter.getLanguages()[i].getStyles();
            for (int j = 0; j < textStyleArray.length; ++j) {
                if (textStyleArray[j].getName().equals("KEYWORD_STYLE")) {
                    textStyleArray[j].setColor(this.pref.getColor("com.topcoder.client.contestApplet.common.LocalPreferences.edstdsyntaxkeywords"));
                    n = Integer.parseInt(this.pref.getProperty("com.topcoder.client.contestApplet.common.LocalPreferences.edstdsyntaxkeywordsstyle", "0"));
                } else if (textStyleArray[j].getName().equals("BLOCK_STYLE")) {
                    textStyleArray[j].setColor(this.pref.getColor("com.topcoder.client.contestApplet.common.LocalPreferences.edstdsyntaxcomments"));
                    n = Integer.parseInt(this.pref.getProperty("com.topcoder.client.contestApplet.common.LocalPreferences.edstdsyntaxcommentsstyle", "0"));
                } else if (textStyleArray[j].getName().equals("LITERAL_STYLE")) {
                    textStyleArray[j].setColor(this.pref.getColor("com.topcoder.client.contestApplet.common.LocalPreferences.edstdsyntaxliterals"));
                    n = Integer.parseInt(this.pref.getProperty("com.topcoder.client.contestApplet.common.LocalPreferences.edstdsyntaxliteralsstyle", "0"));
                } else if (textStyleArray[j].getName().equals("DEFAULT_STYLE")) {
                    textStyleArray[j].setColor(this.pref.getColor("com.topcoder.client.contestApplet.common.LocalPreferences.edstdsyntaxdefault"));
                    n = Integer.parseInt(this.pref.getProperty("com.topcoder.client.contestApplet.common.LocalPreferences.edstdsyntaxdefaultstyle", "0"));
                }
                textStyleArray[j].setBGColor(this.pref.getColor("com.topcoder.client.contestApplet.common.LocalPreferences.edstdback"));
                textStyleArray[j].setFont(new Font(string, n, n2));
            }
        }
    }

    protected class StandardUndoableEditListener
    implements UndoableEditListener {
        protected StandardUndoableEditListener() {
        }

        public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
            if (!StandardEditorPanel.this.update) {
                return;
            }
            StandardEditorPanel.this.undo.addEdit(undoableEditEvent.getEdit());
            StandardEditorPanel.this.undoAction.updateUndoState();
            StandardEditorPanel.this.redoAction.updateRedoState();
        }
    }

    private class KeyHandler
    extends KeyAdapter {
        private KeyHandler() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            Iterator iterator = StandardEditorPanel.this.keyPrefs.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (!StandardEditorPanel.this.checkValue(keyEvent, (String)StandardEditorPanel.this.keyPrefs.get(string))) continue;
                keyEvent.consume();
                JButton jButton = (JButton)StandardEditorPanel.this.keyButtons.get(string);
                jButton.doClick();
                return;
            }
            switch (keyEvent.getKeyCode()) {
                case 10: {
                    keyEvent.consume();
                    StandardEditorPanel.this.textPane.replaceSelection("\n");
                    if (StandardEditorPanel.this.textPane.getSelectionEnd() - StandardEditorPanel.this.textPane.getSelectionStart() > 0) {
                        return;
                    }
                    if (!StandardEditorPanel.this.autoIndent) {
                        return;
                    }
                    try {
                        String string;
                        int n;
                        int n2 = StandardEditorPanel.this.textPane.getCaretPosition();
                        for (n = n2 - 2; n >= 0 && !(string = StandardEditorPanel.this.textPane.getDocument().getText(n, 1)).equals("\n"); --n) {
                        }
                        if (n <= 0) break;
                        string = StandardEditorPanel.this.textPane.getDocument().getText(n + 1, n2 - n - 2);
                        String string2 = "";
                        for (int i = 0; i < string.length() && (string.charAt(i) == ' ' || string.charAt(i) == '\t'); ++i) {
                            string2 = string2 + string.charAt(i);
                        }
                        StandardEditorPanel.this.textPane.replaceSelection(string2);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    break;
                }
                case 114: {
                    keyEvent.consume();
                    StandardEditorPanel.this.findAgainAction.actionPerformed(new ActionEvent(this, keyEvent.getID(), ""));
                    return;
                }
            }
        }
    }

    public final class SimpleEditorFilter
    extends DocumentFilter {
        public void remove(DocumentFilter.FilterBypass filterBypass, int n, int n2) throws BadLocationException {
            super.remove(filterBypass, n, n2);
            StandardEditorPanel.this.rehighlight(n, n2, 0);
        }

        public void insertString(DocumentFilter.FilterBypass filterBypass, int n, String string, AttributeSet attributeSet) throws BadLocationException {
            super.insertString(filterBypass, n, string, attributeSet);
            StandardEditorPanel.this.rehighlight(n, 0, string.length());
        }

        public void replace(DocumentFilter.FilterBypass filterBypass, int n, int n2, String string, AttributeSet attributeSet) throws BadLocationException {
            super.replace(filterBypass, n, n2, string, attributeSet);
            StandardEditorPanel.this.rehighlight(n, n2, string.length());
        }
    }
}

