/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.defaults;

import com.topcoder.client.contestApplet.common.Common;
import com.topcoder.client.contestApplet.common.LocalPreferences;
import com.topcoder.client.contestApplet.widgets.CheckBoxIcon;
import java.awt.Color;
import java.awt.Font;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.border.LineBorder;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalTheme;

public final class ContestUIDefaults {
    public static final String STEEL_THEME_CLASS = "javax.swing.plaf.metal.DefaultMetalTheme";
    public static final String OCEAN_THEME_CLASS = "javax.swing.plaf.metal.OceanTheme";

    private ContestUIDefaults() {
    }

    public static void set() {
        String string = UIManager.getSystemLookAndFeelClassName();
        Font font = null;
        Font font2 = null;
        if (string.equals("com.sun.java.swing.plaf.windows.WindowsLookAndFeel")) {
            font = new Font("Arial", 0, 12);
            font2 = new Font("Arial", 0, 10);
        } else {
            font = new Font("Arial", 0, 12);
            font2 = new Font("Arial", 0, 10);
        }
        LocalPreferences localPreferences = LocalPreferences.getInstance();
        UIManager.put("Text.font", new FontUIResource(font));
        UIManager.put("TextField.font", new FontUIResource(font));
        UIManager.put("PasswordField.font", new FontUIResource(font));
        UIManager.put("Label.font", new FontUIResource(font));
        UIManager.put("Button.font", new FontUIResource(font));
        UIManager.put("List.font", new FontUIResource(font));
        UIManager.put("Menu.font", new FontUIResource(font2));
        UIManager.put("MenuItem.font", new FontUIResource(font2));
        UIManager.put("MenuBar.font", new FontUIResource(font2));
        UIManager.put("ToolTip.font", new FontUIResource(font));
        UIManager.put("PopupMenu.font", new FontUIResource(font));
        UIManager.put("ComboBox.font", new FontUIResource(font));
        UIManager.put("Table.font", new FontUIResource(font));
        UIManager.put("Panel.background", Common.WPB_COLOR);
        UIManager.put("OptionPane.background", Common.WPB_COLOR);
        UIManager.put("OptionPane.messageForeground", Color.white);
        UIManager.put("PopupMenu.border", new LineBorder(Common.PB_COLOR));
        UIManager.put("PopupMenu.background", Common.MB_COLOR);
        UIManager.put("MenuItem.foreground", Common.MF_COLOR);
        UIManager.put("MenuItem.background", Common.MB_COLOR);
        UIManager.put("CheckBoxMenuItem.selectionForeground", Common.HF_COLOR);
        UIManager.put("CheckBoxMenuItem.selectionBackground", Color.decode("0x660000"));
        UIManager.put("MenuItem.selectionForeground", Common.HF_COLOR);
        UIManager.put("MenuItem.selectionBackground", Color.decode("0x660000"));
        UIManager.put("MenuItem.border", new BevelBorder(0));
        UIManager.put("ToolTip.foreground", Common.HF_COLOR);
        UIManager.put("ToolTip.background", Common.HB_COLOR);
        UIManager.put("Menu.selectionForeground", Common.FG_COLOR);
        UIManager.put("Menu.selectionBackground", Common.MENU_COLOR);
        UIManager.put("TextField.selectionForeground", Common.HF_COLOR);
        UIManager.put("TextField.selectionBackground", Common.HB_COLOR);
        UIManager.put("TextArea.selectionForeground", Common.HF_COLOR);
        UIManager.put("TextArea.selectionBackground", Common.HB_COLOR);
        UIManager.put("PasswordField.selectionForeground", Common.HF_COLOR);
        UIManager.put("PasswordField.selectionBackground", Common.HB_COLOR);
        UIManager.put("ScrollPane.background", Common.THB_COLOR);
        UIManager.put("ScrollPane.foreground", Common.THF_COLOR);
        UIManager.put("AbstractDocument.additionText", "addition");
        UIManager.put("AbstractDocument.deletionText", "deletion");
        UIManager.put("AbstractDocument.redoText", "Redo");
        UIManager.put("AbstractDocument.styleChangeText", "style change");
        UIManager.put("AbstractDocument.undoText", "Undo");
        UIManager.put("CheckBox.icon", new CheckBoxIcon());
        try {
            UIManager.put("ContestScrollBarUI", Class.forName("com.topcoder.client.contestApplet.defaults.ContestScrollBarUI"));
            UIManager.put("ScrollBarUI", "ContestScrollBarUI");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            ContestUIDefaults.changeMetalTheme(STEEL_THEME_CLASS);
            if (!string.equals("javax.swing.plaf.metal.MetalLookAndFeel")) {
                UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
            } else {
                UIManager.setLookAndFeel(string);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void changeMetalTheme(String string) {
        try {
            MetalTheme metalTheme = (MetalTheme)Class.forName(string).newInstance();
            MetalLookAndFeel.setCurrentTheme(metalTheme);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

