/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.common;

import com.topcoder.client.contestApplet.common.Common;
import com.topcoder.client.contestApplet.editors.EditorPlugin;
import com.topcoder.client.ui.UIFactory;
import com.topcoder.client.ui.UIManager;
import com.topcoder.util.config.ConfigManager;
import com.topcoder.util.config.ConfigManagerException;
import com.topcoder.util.config.Property;
import com.topcoder.util.config.UnknownNamespaceException;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.JOptionPane;

public final class LocalPreferences {
    private static LocalPreferences localPref = null;
    private ConfigManager configManager = null;
    private PrefObservable saveObserver = new PrefObservable();
    private UIManager[] managers = null;
    private static final String PLUGINNUMBER = "editor.numplugins";
    private static final String PLUGINDEFAULTNAME = "editor.defaultname";
    private static final String PLUGINCACHED = "editor.cache";
    private static final String PLUGINDEBUG = "editor.debug";
    private static final String PLUGINNAME = "name";
    private static final String PLUGINENTRYPOINT = "entrypoint";
    private static final String PLUGINCLASSPATH = "classpath";
    private static final String PLUGINEAGER = "eager";
    private static final String PLUGINCOMMONPATH = "com.topcoder.client.contestApplet.common.LocalPreferences.commonclasspath";
    public static final String DISABLEBROADCASTPOPUP = "com.topcoder.jmaContestApplet.ContestApplet.disableBroadcastPopup";
    public static final String DISABLEBROADCASTBEEP = "com.topcoder.jmaContestApplet.ContestApplet.disableBroadcastBeep";
    public static final String ENABLETIMESTAMPS = "com.topcoder.jmaContestApplet.ContestApplet.enableTimestamps";
    public static final String IGNORELIST = "com.topcoder.jmaContestApplet.ContestApplet.ignoreList";
    public static final String IGNORENUMBER = "com.topcoder.jmaContestApplet.ContestApplet.ignoreNumber";
    public static final String ALLOWEDLIST = "com.topcoder.jmaContestApplet.ContestApplet.allowedList";
    public static final String LEADER_TICKER_DISABLED = "com.topcoder.client.contestApplet.panels.main.FaderPanel.enabled";
    public static final String CHAT_SCROLLING = "com.topcoder.jmaContestApplet.ContestApplet.disableChatScrolling";
    public static final String CHATSYSTEMFORE = "com.topcoder.client.contestApplet.panels.ChatPanel.systemfore";
    public static final String CHATSYSTEMBACK = "com.topcoder.client.contestApplet.panels.ChatPanel.systemback";
    public static final String CHATEMPHSYSTEMFORE = "com.topcoder.client.contestApplet.panels.ChatPanel.emphsystemfore";
    public static final String CHATEMPHSYSTEMBACK = "com.topcoder.client.contestApplet.panels.ChatPanel.emphsystemback";
    public static final String CHATGENERALFORE = "com.topcoder.client.contestApplet.panels.ChatPanel.generalfore";
    public static final String CHATGENERALBACK = "com.topcoder.client.contestApplet.panels.ChatPanel.generalback";
    public static final String CHATGENERALTOFORE = "com.topcoder.client.contestApplet.panels.ChatPanel.generaltofore";
    public static final String CHATGENERALTOBACK = "com.topcoder.client.contestApplet.panels.ChatPanel.generaltoback";
    public static final String CHATMEFORE = "com.topcoder.client.contestApplet.panels.ChatPanel.mefore";
    public static final String CHATMEBACK = "com.topcoder.client.contestApplet.panels.ChatPanel.meback";
    public static final String CHATWHISPERFORE = "com.topcoder.client.contestApplet.panels.ChatPanel.whisperfore";
    public static final String CHATWHISPERBACK = "com.topcoder.client.contestApplet.panels.ChatPanel.whisperback";
    public static final String CHATWHISPERTOFORE = "com.topcoder.client.contestApplet.panels.ChatPanel.whispertofore";
    public static final String CHATWHISPERTOBACK = "com.topcoder.client.contestApplet.panels.ChatPanel.whispertoback";
    public static final String CHATHANDLEBACK = "com.topcoder.client.contestApplet.panels.ChatPanel.handleback";
    public static final String CHATPANELBACK = "com.topcoder.client.contestApplet.common.LocalPreferences.chatpanelback";
    public static final String CHATFONT = "com.topcoder.client.contestApplet.common.LocalPreferences.chatfont";
    public static final String CHATFONTSIZE = "com.topcoder.client.contestApplet.common.LocalPreferences.chatfontsize";
    public static final String CHATFINDHIGHLIGHT = "com.topcoder.client.contestApplet.common.LocalPreferences.chatfindhighlight";
    public static final String CHATFINDBACK = "com.topcoder.client.contestApplet.common.LocalPreferences.chatfindback";
    public static final String EDSTDFONT = "com.topcoder.client.contestApplet.common.LocalPreferences.edstdfont";
    public static final String EDSTDFONTSIZE = "com.topcoder.client.contestApplet.common.LocalPreferences.edstdfontsize";
    public static final String EDSTDFORE = "com.topcoder.client.contestApplet.common.LocalPreferences.edstdfore";
    public static final String EDSTDBACK = "com.topcoder.client.contestApplet.common.LocalPreferences.edstdback";
    public static final String EDSTDSELT = "com.topcoder.client.contestApplet.common.LocalPreferences.edstdselt";
    public static final String EDSTDSELB = "com.topcoder.client.contestApplet.common.LocalPreferences.edstdselb";
    public static final String EDSTDINDENT = "com.topcoder.client.contestApplet.common.LocalPreferences.edstdindent";
    public static final String EDSTDSYNTAXHIGHLIGHT = "com.topcoder.client.contestApplet.common.LocalPreferences.edstdsyntaxhighlight";
    public static final String EDSTDTABSIZE = "com.topcoder.client.contestApplet.common.LocalPreferences.edstdtabsize";
    public static final String EDSTDSYNTAXCOMMENTS = "com.topcoder.client.contestApplet.common.LocalPreferences.edstdsyntaxcomments";
    public static final String EDSTDSYNTAXLITERALS = "com.topcoder.client.contestApplet.common.LocalPreferences.edstdsyntaxliterals";
    public static final String EDSTDSYNTAXKEYWORDS = "com.topcoder.client.contestApplet.common.LocalPreferences.edstdsyntaxkeywords";
    public static final String EDSTDSYNTAXDEFAULT = "com.topcoder.client.contestApplet.common.LocalPreferences.edstdsyntaxdefault";
    public static final String EDSTDSYNTAXCOMMENTSSTYLE = "com.topcoder.client.contestApplet.common.LocalPreferences.edstdsyntaxcommentsstyle";
    public static final String EDSTDSYNTAXLITERALSSTYLE = "com.topcoder.client.contestApplet.common.LocalPreferences.edstdsyntaxliteralsstyle";
    public static final String EDSTDSYNTAXKEYWORDSSTYLE = "com.topcoder.client.contestApplet.common.LocalPreferences.edstdsyntaxkeywordsstyle";
    public static final String EDSTDSYNTAXDEFAULTSTYLE = "com.topcoder.client.contestApplet.common.LocalPreferences.edstdsyntaxdefaultstyle";
    public static final String EDSTDKEYFIND = "com.topcoder.client.contestApplet.common.LocalPreferences.edstdkeyfind";
    public static final String EDSTDKEYGOTO = "com.topcoder.client.contestApplet.common.LocalPreferences.edstdkeygoto";
    public static final String EDSTDKEYUNDO = "com.topcoder.client.contestApplet.common.LocalPreferences.edstdkeyundo";
    public static final String EDSTDKEYREDO = "com.topcoder.client.contestApplet.common.LocalPreferences.edstdkeyredo";
    public static final String KEYSAVE = "com.topcoder.client.contestApplet.common.LocalPreferences.keysave";
    public static final String KEYCOMPILE = "com.topcoder.client.contestApplet.common.LocalPreferences.keycompile";
    public static final String KEYTEST = "com.topcoder.client.contestApplet.common.LocalPreferences.keytest";
    public static final String KEYBATCHTEST = "com.topcoder.client.contestApplet.common.LocalPreferences.keybatchtest";
    public static final String KEYSUBMIT = "com.topcoder.client.contestApplet.common.LocalPreferences.keysubmit";
    public static final String PROBLEMFONT = "com.topcoder.client.contestApplet.common.LocalPreferences.problemfont";
    public static final String PROBLEMFONTSIZE = "com.topcoder.client.contestApplet.common.LocalPreferences.problemfontsize";
    public static final String PROBLEMFORE = "com.topcoder.client.contestApplet.common.LocalPreferences.problemfore";
    public static final String PROBLEMBACK = "com.topcoder.client.contestApplet.common.LocalPreferences.problemback";
    public static final String PROBLEMFIXEDFONT = "com.topcoder.client.contestApplet.common.LocalPreferences.problemfixedfont";
    public static final String PROBLEMFIXEDFONTSIZE = "com.topcoder.client.contestApplet.common.LocalPreferences.problemfixedfontsize";
    public static final String PROBLEMFIXEDFORE = "com.topcoder.client.contestApplet.common.LocalPreferences.problemfixedfore";
    public static final String PROBLEMFIXEDBACK = "com.topcoder.client.contestApplet.common.LocalPreferences.problemfixedback";
    public static final String MESSAGEFONT = "com.topcoder.client.contestApplet.common.LocalPreferences.messagefont";
    public static final String MESSAGEFONTSIZE = "com.topcoder.client.contestApplet.common.LocalPreferences.messagefontsize";
    public static final String MESSAGEFORE = "com.topcoder.client.contestApplet.common.LocalPreferences.messagefore";
    public static final String MESSAGEBACK = "com.topcoder.client.contestApplet.common.LocalPreferences.messageback";
    public static final String CHALSRCFONT = "com.topcoder.client.contestApplet.common.LocalPreferences.chalsrcfont";
    public static final String CHALSRCFONTSIZE = "com.topcoder.client.contestApplet.common.LocalPreferences.chalsrcfontsize";
    public static final String CHALSRCFORE = "com.topcoder.client.contestApplet.common.LocalPreferences.chalsrcfore";
    public static final String CHALSRCBACK = "com.topcoder.client.contestApplet.common.LocalPreferences.chalsrcback";
    public static final String CHALSRCSYNTAXHIGHLIGHT = "com.topcoder.client.contestApplet.common.LocalPreferences.chalsrcsyntaxhighlight";
    public static final String CHALPROBFONT = "com.topcoder.client.contestApplet.common.LocalPreferences.chalprobfont";
    public static final String CHALPROBFONTSIZE = "com.topcoder.client.contestApplet.common.LocalPreferences.chalprobontsize";
    public static final String CHALPROBFIXEDFONT = "com.topcoder.client.contestApplet.common.LocalPreferences.chalprobfixedfont";
    public static final String CHALPROBFIXEDFONTSIZE = "com.topcoder.client.contestApplet.common.LocalPreferences.chalprobfixedfontsize";
    public static final String CHALPROBFORE = "com.topcoder.client.contestApplet.common.LocalPreferences.chalprobfore";
    public static final String CHALPROBBACK = "com.topcoder.client.contestApplet.common.LocalPreferences.chalprobback";
    public static final String MENUFONT = "com.topcoder.client.contestApplet.common.LocalPreferences.menufont";
    public static final String MENUFONTSIZE = "com.topcoder.client.contestApplet.common.LocalPreferences.menufontsize";
    public static final String USERTABLEFONT = "com.topcoder.client.contestApplet.common.LocalPreferences.usertablefont";
    public static final String USERTABLEFONTSIZE = "com.topcoder.client.contestApplet.common.LocalPreferences.usertablefontsize";
    public static final String SUMMARYFONT = "com.topcoder.client.contestApplet.common.LocalPreferences.summaryfont";
    public static final String SUMMARYFONTSIZE = "com.topcoder.client.contestApplet.common.LocalPreferences.summaryfontsize";
    public static final String MODERATED_CHAT_QUESTION_FOREGROUND = "com.topcoder.client.contentApplet.panels.ChatPanel.moderatedChatQuestionFore";
    public static final String MODERATED_CHAT_QUESTION_BACKGROUND = "com.topcoder.client.contentApplet.panels.ChatPanel.moderatedChatQuestionBack";
    public static final String MODERATED_CHAT_SPEAKER_FOREGROUND = "com.topcoder.client.contentApplet.panels.ChatPanel.moderatedChatSpeakerFore";
    public static final String MODERATED_CHAT_SPEAKER_BACKGROUND = "com.topcoder.client.contentApplet.panels.ChatPanel.moderatedChatSpeakerBack";
    public static final String SUMMARYUNOPENED = "com.topcoder.client.contestApplet.common.LocalPreferences.summaryunopened";
    public static final String SUMMARYOPENED = "com.topcoder.client.contestApplet.common.LocalPreferences.summaryopened";
    public static final String SUMMARYCOMPILED = "com.topcoder.client.contestApplet.common.LocalPreferences.summarycompiled";
    public static final String SUMMARYJAVAPOINTS = "com.topcoder.client.contestApplet.common.LocalPreferences.summaryjavapoints";
    public static final String SUMMARYJAVACHLPASSED = "com.topcoder.client.contestApplet.common.LocalPreferences.summaryjavachlpassed";
    public static final String SUMMARYJAVACHLFAILED = "com.topcoder.client.contestApplet.common.LocalPreferences.summaryjavachlfailed";
    public static final String SUMMARYJAVASYSPASSED = "com.topcoder.client.contestApplet.common.LocalPreferences.summaryjavasyspassed";
    public static final String SUMMARYJAVASYSFAILED = "com.topcoder.client.contestApplet.common.LocalPreferences.summaryjavasysfailed";
    public static final String SUMMARYCPPPOINTS = "com.topcoder.client.contestApplet.common.LocalPreferences.summarycpppoints";
    public static final String SUMMARYCPPCHLPASSED = "com.topcoder.client.contestApplet.common.LocalPreferences.summarycppchlpassed";
    public static final String SUMMARYCPPCHLFAILED = "com.topcoder.client.contestApplet.common.LocalPreferences.summarycppchlfailed";
    public static final String SUMMARYCPPSYSPASSED = "com.topcoder.client.contestApplet.common.LocalPreferences.summarycppsyspassed";
    public static final String SUMMARYCPPSYSFAILED = "com.topcoder.client.contestApplet.common.LocalPreferences.summarycppsysfailed";
    public static final String SUMMARYCSHARPPOINTS = "com.topcoder.client.contestApplet.common.LocalPreferences.summarycsharppoints";
    public static final String SUMMARYCSHARPCHLPASSED = "com.topcoder.client.contestApplet.common.LocalPreferences.summarycsharpchlpassed";
    public static final String SUMMARYCSHARPCHLFAILED = "com.topcoder.client.contestApplet.common.LocalPreferences.summarycsharpchlfailed";
    public static final String SUMMARYCSHARPSYSPASSED = "com.topcoder.client.contestApplet.common.LocalPreferences.summarycsharpsyspassed";
    public static final String SUMMARYCSHARPSYSFAILED = "com.topcoder.client.contestApplet.common.LocalPreferences.summarycsharpsysfailed";
    public static final String SUMMARYVBPOINTS = "com.topcoder.client.contestApplet.common.LocalPreferences.summaryvbpoints";
    public static final String SUMMARYVBCHLPASSED = "com.topcoder.client.contestApplet.common.LocalPreferences.summaryvbchlpassed";
    public static final String SUMMARYVBCHLFAILED = "com.topcoder.client.contestApplet.common.LocalPreferences.summaryvbchlfailed";
    public static final String SUMMARYVBSYSPASSED = "com.topcoder.client.contestApplet.common.LocalPreferences.summaryvbsyspassed";
    public static final String SUMMARYVBSYSFAILED = "com.topcoder.client.contestApplet.common.LocalPreferences.summaryvbsysfailed";
    public static final String SUMMARYPYTHONPOINTS = "com.topcoder.client.contestApplet.common.LocalPreferences.summarypythonpoints";
    public static final String SUMMARYPYTHONCHLPASSED = "com.topcoder.client.contestApplet.common.LocalPreferences.summarypythonchlpassed";
    public static final String SUMMARYPYTHONCHLFAILED = "com.topcoder.client.contestApplet.common.LocalPreferences.summarypythonchlfailed";
    public static final String SUMMARYPYTHONSYSPASSED = "com.topcoder.client.contestApplet.common.LocalPreferences.summarypythonsyspassed";
    public static final String SUMMARYPYTHONSYSFAILED = "com.topcoder.client.contestApplet.common.LocalPreferences.summarypythonsysfailed";
    public static final String UNUSEDCODECHECK = "com.topcoder.client.contestApplet.common.LocalPreferences.UnusedCodeCheckEnabled";
    public static final String ATTRIBUTECOLOR = "color";
    public static final String ATTRIBUTEBOLD = "bold";
    public static final String ATTRIBUTEITALIC = "italic";
    public static final String BROWSERLOCATION = "com.topcoder.client.contestApplet.common.LocalPreferences.browserlocation";
    public static final String FILELOCATION = "com.topcoder.client.contestApplet.common.LocalPreferences.filelocation";
    public static final String FILENAME = "com.topcoder.client.contestApplet.common.LocalPreferences.filename";
    public static final String CONFIG_NAMESPACE = "contestapplet.conf";
    public static final String CONFIG_USER = "user";
    public static final String CONNECTION_TYPE = "com.topcoder.client.contestApplet.LocalPreferences.connectionType";
    public static final String CONNECTION_USERNAME = "com.topcoder.client.contestApplet.LocalPreferences.connection.username";
    public static final String CONNECTION_PASSWORD = "com.topcoder.client.contestApplet.LocalPreferences.connection.password";
    public static final String CONNECTION_PROXY_TYPE = "com.topcoder.client.contestApplet.LocalPreferences.connection.type";
    public static final String CONNECTION_HOST = "com.topcoder.client.contestApplet.LocalPreferences.connection.host";
    public static final String CONNECTION_PORT = "com.topcoder.client.contestApplet.LocalPreferences.connection.port";
    public static final String CONNECTION_SSL = "com.topcoder.client.contestApplet.LocalPreferences.connection.ssl";
    public static final String UI_THEME = "ui.theme";
    private static final String UI_THEME_DIRECTORY = "arenaui";
    private static final String[] UI_THEME_EMBEDDED = new String[]{"/ui/default.xml"};
    private Vector propertiesList;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFile(File file, File file2) throws IOException {
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            int n;
            inputStream = new BufferedInputStream(new FileInputStream(file));
            outputStream = new BufferedOutputStream(new FileOutputStream(file2));
            byte[] byArray = new byte[1024];
            while ((n = inputStream.read(byArray)) != -1) {
                outputStream.write(byArray, 0, n);
            }
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private LocalPreferences() {
        try {
            this.reload();
            try {
                File file = LocalPreferences.getPreferencesBackupFile();
                File file2 = LocalPreferences.getPreferencesFile();
                LocalPreferences.copyFile(file2, file);
            }
            catch (IOException iOException) {}
        }
        catch (IOException iOException) {
            block8: {
                File file = null;
                File file3 = null;
                try {
                    file = LocalPreferences.getPreferencesBackupFile();
                    file3 = LocalPreferences.getPreferencesFile();
                    if (file.isFile() && JOptionPane.showConfirmDialog(null, "The preference file is corrupted. Do you want to restore the backup file?", "Confirm", 0) == 0) {
                        LocalPreferences.copyFile(file, file3);
                        this.reload();
                    }
                }
                catch (IOException iOException2) {
                    if (file3 != null) {
                        file3.delete();
                    }
                    if (file == null) break block8;
                    file.delete();
                }
            }
            LocalPreferences.printError(iOException.toString());
        }
    }

    public final void reload() throws IOException {
        File file = LocalPreferences.getPreferencesFile();
        this.configManager = ConfigManager.getInstance();
        if (!file.exists()) {
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)bufferedOutputStream, "ISO-8859-1"));
            printWriter.println("#TopCoder ContestApplet Preferences File");
            printWriter.println("#" + Calendar.getInstance().getTime());
            printWriter.println("com.topcoder.client.contestApplet.common.LocalPreferences.menufont=Arial");
            printWriter.println("com.topcoder.client.contestApplet.common.LocalPreferences.menufontsize=10");
            printWriter.flush();
        }
        this.configManager.add(CONFIG_NAMESPACE, file.getPath(), ".properties");
    }

    private final void setNestedProperties(String string) {
        try {
            Property property = this.configManager.getPropertyObject(CONFIG_NAMESPACE, string);
            if (property.getValue() != null) {
                this.propertiesList.add(string);
            }
            Enumeration enumeration = property.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                String string3 = string + "." + string2;
                if (string.equals("")) {
                    string3 = string2;
                }
                this.setNestedProperties(string3);
            }
        }
        catch (UnknownNamespaceException unknownNamespaceException) {
            unknownNamespaceException.printStackTrace();
        }
    }

    private final Vector getNestedProperties(String string) {
        this.propertiesList = new Vector();
        this.setNestedProperties(string);
        return this.propertiesList;
    }

    public static final synchronized LocalPreferences getInstance() {
        if (localPref != null) {
            return localPref;
        }
        localPref = new LocalPreferences();
        return localPref;
    }

    public final ConfigManager getConfigManager() {
        return this.configManager;
    }

    public final void addSaveObserver(Observer observer) {
        this.saveObserver.addObserver(observer);
    }

    public final void removeSaveObserver(Observer observer) {
        this.saveObserver.deleteObserver(observer);
    }

    public final void savePreferences() throws IOException {
        File file = LocalPreferences.getPreferencesFile();
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)bufferedOutputStream, "ISO-8859-1"));
        printWriter.println("#TopCoder ContestApplet Preferences File");
        printWriter.println("#" + Calendar.getInstance().getTime());
        Enumeration enumeration = this.getNestedProperties("").elements();
        StringBuffer stringBuffer = new StringBuffer();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = this.configManager.getString(CONFIG_NAMESPACE, string);
            if (string2 == null) continue;
            this.formatForOutput(string, stringBuffer, true);
            stringBuffer.append('=');
            this.formatForOutput(string2, stringBuffer, false);
            printWriter.println(stringBuffer);
        }
        printWriter.flush();
        this.saveObserver.fireIt();
    }

    public final void saveColors(HashMap hashMap) {
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Color color = (Color)hashMap.get(string);
            this.setProperty(string, String.valueOf(color.getRGB()));
        }
        try {
            this.savePreferences();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public final void setColor(String string, Color color) {
        this.setProperty(string, String.valueOf(color.getRGB()));
    }

    public final String getFont(String string) {
        if (string.equals(USERTABLEFONT)) {
            return this.getFont(string, "Arial");
        }
        if (string.equals(SUMMARYFONT)) {
            return this.getFont(string, "Arial");
        }
        return this.getFont(string, "Monospaced");
    }

    public final String getFont(String string, String string2) {
        String string3 = this.getProperty(string, string2);
        if (string3 == null || string3.equals("")) {
            return string2;
        }
        return string3;
    }

    public final void setFont(String string, String string2) {
        this.setProperty(string, string2);
    }

    public final int getFontSize(String string) {
        if (string.equals(USERTABLEFONTSIZE)) {
            return this.getFontSize(string, 12);
        }
        if (string.equals(SUMMARYFONTSIZE)) {
            return this.getFontSize(string, 12);
        }
        return this.getFontSize(string, 12);
    }

    public final int getFontSize(String string, int n) {
        String string2 = this.getProperty(string);
        if (string2 == null || string2.equals("")) {
            return n;
        }
        return Integer.parseInt(string2);
    }

    public final void setFontSize(String string, String string2) {
        this.setProperty(string, string2);
    }

    public final Color getColor(String string) {
        return this.getColor(string, Color.black);
    }

    public final Color getColor(String string, Color color) {
        Object object;
        try {
            object = this.getProperty(string);
            if (object != null) {
                return new Color(Integer.parseInt((String)object));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (string.equals(CHATSYSTEMFORE)) {
            return Color.green;
        }
        if (string.equals(CHATSYSTEMBACK)) {
            return Color.black;
        }
        if (string.equals(CHATEMPHSYSTEMFORE)) {
            return Color.green;
        }
        if (string.equals(CHATEMPHSYSTEMBACK)) {
            return Color.black;
        }
        if (string.equals(CHATGENERALFORE)) {
            return Color.white;
        }
        if (string.equals(CHATGENERALBACK)) {
            return Color.black;
        }
        if (string.equals(CHATGENERALTOFORE)) {
            return Color.white;
        }
        if (string.equals(CHATGENERALTOBACK)) {
            return Color.red;
        }
        if (string.equals(CHATMEFORE)) {
            return Common.LIGHT_GREY;
        }
        if (string.equals(CHATMEBACK)) {
            return Color.black;
        }
        if (string.equals(CHATWHISPERFORE)) {
            return Common.LIGHT_GREY;
        }
        if (string.equals(CHATWHISPERBACK)) {
            return Color.black;
        }
        if (string.equals(CHATWHISPERTOFORE)) {
            return Common.LIGHT_GREY;
        }
        if (string.equals(CHATWHISPERTOBACK)) {
            return Color.red;
        }
        if (string.equals(CHATHANDLEBACK)) {
            return Color.black;
        }
        if (string.equals(CHATFINDBACK)) {
            return Color.BLUE;
        }
        if (string.equals(CHATFINDHIGHLIGHT)) {
            return Color.GRAY;
        }
        if (string.equals(EDSTDFORE)) {
            return Color.white;
        }
        if (string.equals(EDSTDBACK)) {
            return Color.black;
        }
        if (string.equals(EDSTDSELT)) {
            return Common.HF_COLOR;
        }
        if (string.equals(EDSTDSELB)) {
            return Common.LIGHT_GREEN;
        }
        if (string.equals(EDSTDSYNTAXCOMMENTS)) {
            return Color.decode("0x00CC00");
        }
        if (string.equals(EDSTDSYNTAXLITERALS)) {
            return Color.decode("0xFF00FF");
        }
        if (string.equals(EDSTDSYNTAXKEYWORDS)) {
            return Color.decode("0x9999FF");
        }
        if (string.equals(EDSTDSYNTAXDEFAULT)) {
            return Color.decode("0xFFFFFF");
        }
        if (string.equals(PROBLEMFORE)) {
            return Color.white;
        }
        if (string.equals(PROBLEMBACK)) {
            return Color.black;
        }
        if (string.equals(PROBLEMFIXEDFORE)) {
            return Color.white;
        }
        if (string.equals(PROBLEMFIXEDBACK)) {
            return Color.black;
        }
        if (string.equals(MESSAGEFORE)) {
            return Color.white;
        }
        if (string.equals(MESSAGEBACK)) {
            return Color.black;
        }
        if (string.equals(CHALSRCFORE)) {
            return Color.white;
        }
        if (string.equals(CHALSRCBACK)) {
            return Color.black;
        }
        if (string.equals(CHALPROBFORE)) {
            return Color.white;
        }
        if (string.equals(CHALPROBBACK)) {
            return Color.black;
        }
        if (string.equals(MODERATED_CHAT_QUESTION_FOREGROUND)) {
            return Color.green;
        }
        if (string.equals(MODERATED_CHAT_QUESTION_BACKGROUND)) {
            return Color.black;
        }
        if (string.equals(MODERATED_CHAT_SPEAKER_FOREGROUND)) {
            return Color.white;
        }
        if (string.equals(MODERATED_CHAT_SPEAKER_BACKGROUND)) {
            return Color.black;
        }
        if (string.startsWith(SUMMARYUNOPENED)) {
            return new Color(255, 255, 255);
        }
        if (string.startsWith(SUMMARYOPENED)) {
            return new Color(255, 255, 255);
        }
        if (string.startsWith(SUMMARYCOMPILED)) {
            return new Color(255, 255, 255);
        }
        if (string.startsWith(SUMMARYJAVAPOINTS)) {
            return new Color(0, 255, 0);
        }
        if (string.startsWith(SUMMARYJAVACHLPASSED)) {
            return new Color(0, 255, 0);
        }
        if (string.startsWith(SUMMARYJAVACHLFAILED)) {
            return new Color(0, 255, 0);
        }
        if (string.startsWith(SUMMARYJAVASYSPASSED)) {
            return new Color(0, 255, 0);
        }
        if (string.startsWith(SUMMARYJAVASYSFAILED)) {
            return new Color(255, 0, 51);
        }
        if (string.startsWith(SUMMARYCPPPOINTS)) {
            return new Color(255, 255, 153);
        }
        if (string.startsWith(SUMMARYCPPCHLPASSED)) {
            return new Color(255, 255, 153);
        }
        if (string.startsWith(SUMMARYCPPCHLFAILED)) {
            return new Color(255, 255, 153);
        }
        if (string.startsWith(SUMMARYCPPSYSPASSED)) {
            return new Color(255, 255, 153);
        }
        if (string.startsWith(SUMMARYCPPSYSFAILED)) {
            return new Color(255, 0, 51);
        }
        if (string.startsWith(SUMMARYCSHARPPOINTS)) {
            return new Color(102, 102, 255);
        }
        if (string.startsWith(SUMMARYCSHARPCHLPASSED)) {
            return new Color(102, 102, 255);
        }
        if (string.startsWith(SUMMARYCSHARPCHLFAILED)) {
            return new Color(102, 102, 255);
        }
        if (string.startsWith(SUMMARYCSHARPSYSPASSED)) {
            return new Color(102, 102, 255);
        }
        if (string.startsWith(SUMMARYCSHARPSYSFAILED)) {
            return new Color(255, 0, 51);
        }
        object = new Color(129, 217, 255);
        if (string.startsWith(SUMMARYVBPOINTS)) {
            return object;
        }
        if (string.startsWith(SUMMARYVBCHLPASSED)) {
            return object;
        }
        if (string.startsWith(SUMMARYVBCHLFAILED)) {
            return object;
        }
        if (string.startsWith(SUMMARYVBSYSPASSED)) {
            return object;
        }
        if (string.startsWith(SUMMARYVBSYSFAILED)) {
            return new Color(255, 0, 51);
        }
        Color color2 = new Color(255, 102, 255);
        if (string.startsWith(SUMMARYPYTHONPOINTS)) {
            return color2;
        }
        if (string.startsWith(SUMMARYPYTHONCHLPASSED)) {
            return color2;
        }
        if (string.startsWith(SUMMARYPYTHONCHLFAILED)) {
            return color2;
        }
        if (string.startsWith(SUMMARYPYTHONSYSPASSED)) {
            return color2;
        }
        if (string.startsWith(SUMMARYPYTHONSYSFAILED)) {
            return new Color(255, 0, 51);
        }
        return color;
    }

    public final boolean isTrue(String string) {
        String string2 = this.getProperty(string);
        if (string2 != null) {
            return new Boolean(string2);
        }
        if (string.equals(LocalPreferences.getKeyAttribute(SUMMARYJAVACHLPASSED, ATTRIBUTEBOLD))) {
            return true;
        }
        if (string.equals(LocalPreferences.getKeyAttribute(SUMMARYJAVASYSPASSED, ATTRIBUTEBOLD))) {
            return true;
        }
        if (string.equals(LocalPreferences.getKeyAttribute(SUMMARYCPPCHLPASSED, ATTRIBUTEBOLD))) {
            return true;
        }
        if (string.equals(LocalPreferences.getKeyAttribute(SUMMARYCPPSYSPASSED, ATTRIBUTEBOLD))) {
            return true;
        }
        if (string.equals(LocalPreferences.getKeyAttribute(SUMMARYCSHARPCHLPASSED, ATTRIBUTEBOLD))) {
            return true;
        }
        if (string.equals(LocalPreferences.getKeyAttribute(SUMMARYCSHARPSYSPASSED, ATTRIBUTEBOLD))) {
            return true;
        }
        if (string.equals(LocalPreferences.getKeyAttribute(SUMMARYJAVACHLPASSED, ATTRIBUTEITALIC))) {
            return true;
        }
        if (string.equals(LocalPreferences.getKeyAttribute(SUMMARYJAVASYSPASSED, ATTRIBUTEITALIC))) {
            return true;
        }
        if (string.equals(LocalPreferences.getKeyAttribute(SUMMARYJAVASYSFAILED, ATTRIBUTEITALIC))) {
            return true;
        }
        if (string.equals(LocalPreferences.getKeyAttribute(SUMMARYCPPCHLPASSED, ATTRIBUTEITALIC))) {
            return true;
        }
        if (string.equals(LocalPreferences.getKeyAttribute(SUMMARYCPPSYSPASSED, ATTRIBUTEITALIC))) {
            return true;
        }
        if (string.equals(LocalPreferences.getKeyAttribute(SUMMARYCPPSYSFAILED, ATTRIBUTEITALIC))) {
            return true;
        }
        if (string.equals(LocalPreferences.getKeyAttribute(SUMMARYCSHARPCHLPASSED, ATTRIBUTEITALIC))) {
            return true;
        }
        if (string.equals(LocalPreferences.getKeyAttribute(SUMMARYCSHARPSYSPASSED, ATTRIBUTEITALIC))) {
            return true;
        }
        if (string.equals(LocalPreferences.getKeyAttribute(SUMMARYCSHARPSYSFAILED, ATTRIBUTEITALIC))) {
            return true;
        }
        if (string.equals(LocalPreferences.getKeyAttribute(SUMMARYVBCHLPASSED, ATTRIBUTEBOLD))) {
            return true;
        }
        if (string.equals(LocalPreferences.getKeyAttribute(SUMMARYVBSYSPASSED, ATTRIBUTEBOLD))) {
            return true;
        }
        if (string.equals(LocalPreferences.getKeyAttribute(SUMMARYVBCHLPASSED, ATTRIBUTEITALIC))) {
            return true;
        }
        if (string.equals(LocalPreferences.getKeyAttribute(SUMMARYVBSYSPASSED, ATTRIBUTEITALIC))) {
            return true;
        }
        if (string.equals(LocalPreferences.getKeyAttribute(SUMMARYVBSYSFAILED, ATTRIBUTEITALIC))) {
            return true;
        }
        if (string.equals(LocalPreferences.getKeyAttribute(SUMMARYPYTHONCHLPASSED, ATTRIBUTEBOLD))) {
            return true;
        }
        if (string.equals(LocalPreferences.getKeyAttribute(SUMMARYPYTHONSYSPASSED, ATTRIBUTEBOLD))) {
            return true;
        }
        if (string.equals(LocalPreferences.getKeyAttribute(SUMMARYPYTHONCHLPASSED, ATTRIBUTEITALIC))) {
            return true;
        }
        if (string.equals(LocalPreferences.getKeyAttribute(SUMMARYPYTHONSYSPASSED, ATTRIBUTEITALIC))) {
            return true;
        }
        if (string.equals(LocalPreferences.getKeyAttribute(SUMMARYPYTHONSYSFAILED, ATTRIBUTEITALIC))) {
            return true;
        }
        if (string.equals(EDSTDINDENT)) {
            return true;
        }
        return string.equals(UNUSEDCODECHECK);
    }

    public final void setTrue(String string, boolean bl) {
        this.setProperty(string, bl ? "true" : "false");
    }

    public final List getPlugins() {
        ArrayList<EditorPlugin> arrayList = new ArrayList<EditorPlugin>();
        int n = 0;
        try {
            String string = this.getProperty(PLUGINNUMBER);
            if (string != null) {
                n = Integer.parseInt(string);
            }
        }
        catch (NumberFormatException numberFormatException) {
            LocalPreferences.printError("editor.numplugins is not a valid number");
        }
        for (int i = n; i > 0; --i) {
            String string = this.getProperty(LocalPreferences.getPluginKey(i, PLUGINNAME));
            String string2 = this.getProperty(LocalPreferences.getPluginKey(i, PLUGINENTRYPOINT));
            String string3 = this.getProperty(LocalPreferences.getPluginKey(i, PLUGINCLASSPATH));
            String string4 = this.getProperty(LocalPreferences.getPluginKey(i, PLUGINEAGER));
            if (string == null) {
                LocalPreferences.printError(LocalPreferences.getPluginKey(i, PLUGINNAME) + " is not defined");
                continue;
            }
            if (string2 == null) {
                LocalPreferences.printError(LocalPreferences.getPluginKey(i, PLUGINENTRYPOINT) + " is not defined");
                continue;
            }
            if (string3 == null) {
                LocalPreferences.printError(LocalPreferences.getPluginKey(i, PLUGINCLASSPATH) + " is not defined");
                continue;
            }
            if (string4 == null) {
                string4 = "0";
            }
            arrayList.add(new EditorPlugin(string, string2, string3, string4.equals("1")));
        }
        return arrayList;
    }

    public final void setPluginCommonPath(String string) {
        this.setProperty(PLUGINCOMMONPATH, string);
    }

    public final String getPluginCommonPath() {
        return this.getProperty(PLUGINCOMMONPATH);
    }

    public final void setPlugins(List list) {
        int n = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            EditorPlugin editorPlugin;
            try {
                editorPlugin = (EditorPlugin)iterator.next();
            }
            catch (ClassCastException classCastException) {
                LocalPreferences.printError("Plugins list contained a non-plugin!");
                continue;
            }
            this.setProperty(LocalPreferences.getPluginKey(++n, PLUGINNAME), editorPlugin.getName());
            this.setProperty(LocalPreferences.getPluginKey(n, PLUGINENTRYPOINT), editorPlugin.getEntryPoint());
            this.setProperty(LocalPreferences.getPluginKey(n, PLUGINCLASSPATH), editorPlugin.getClassPath());
            this.setProperty(LocalPreferences.getPluginKey(n, PLUGINEAGER), editorPlugin.getEager() ? "1" : "0");
        }
        this.setProperty(PLUGINNUMBER, String.valueOf(n));
    }

    public final HashSet getAllowedList() {
        HashSet<String> hashSet = new HashSet<String>();
        String string = this.getProperty(ALLOWEDLIST);
        if (null != string) {
            String[] stringArray = string.split(",");
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i].trim();
                if (string2.length() <= 0) continue;
                hashSet.add(string2);
            }
        }
        return hashSet;
    }

    public final HashSet getIgnoreList() {
        HashSet<String> hashSet = new HashSet<String>();
        String string = this.getProperty(IGNORENUMBER);
        if (string == null) {
            string = "0";
        }
        int n = Integer.parseInt(string);
        for (int i = 0; i < n; ++i) {
            String string2 = this.getProperty("com.topcoder.jmaContestApplet.ContestApplet.ignoreList." + i);
            if (string2 == null) continue;
            hashSet.add(string2);
        }
        return hashSet;
    }

    public final void addToIgnoreList(String string) {
        String string2 = this.getProperty(IGNORENUMBER);
        if (string2 == null) {
            string2 = "0";
        }
        int n = Integer.parseInt(string2);
        this.setProperty("com.topcoder.jmaContestApplet.ContestApplet.ignoreList." + n++, string);
        this.setProperty(IGNORENUMBER, "" + n);
        try {
            this.savePreferences();
        }
        catch (Exception exception) {
            System.err.println("Error saving preferences file");
            exception.printStackTrace();
        }
    }

    public final void clearIgnore() {
        this.setProperty(IGNORENUMBER, "0");
        try {
            this.savePreferences();
        }
        catch (Exception exception) {
            System.err.println("Error saving preferences file");
            exception.printStackTrace();
        }
    }

    public final void removeFromIgnoreList(String string) {
        String string2 = this.getProperty(IGNORENUMBER);
        if (string2 == null) {
            string2 = "0";
        }
        int n = Integer.parseInt(string2);
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            String string3 = this.getProperty("com.topcoder.jmaContestApplet.ContestApplet.ignoreList." + i);
            if (bl) {
                this.setProperty("com.topcoder.jmaContestApplet.ContestApplet.ignoreList." + (i - 1), string3);
            }
            if (!string3.equals(string)) continue;
            bl = true;
        }
        this.setProperty(IGNORENUMBER, "" + (n - (bl ? 1 : 0)));
        try {
            this.savePreferences();
        }
        catch (Exception exception) {
            System.err.println("Error saving preferences file");
            exception.printStackTrace();
        }
    }

    public void setProperty(String string, String string2) {
        if (string.equals("popsedit.config.javatemplate")) {
            System.out.println(string2);
        }
        try {
            this.configManager.createTemporaryProperties(CONFIG_NAMESPACE);
            this.configManager.setProperty(CONFIG_NAMESPACE, string, string2);
            this.configManager.commit(CONFIG_NAMESPACE, CONFIG_USER);
        }
        catch (UnknownNamespaceException unknownNamespaceException) {
            unknownNamespaceException.printStackTrace();
        }
        catch (ConfigManagerException configManagerException) {
            configManagerException.printStackTrace();
        }
    }

    public String getProperty(String string) {
        try {
            String string2 = this.configManager.getString(CONFIG_NAMESPACE, string);
            if (string2 == null) {
                return null;
            }
            return string2.replaceAll("\\\\;", ";");
        }
        catch (UnknownNamespaceException unknownNamespaceException) {
            unknownNamespaceException.printStackTrace();
            return "";
        }
    }

    public String getHotKey(String string) {
        if (string == EDSTDKEYFIND) {
            return this.getProperty(string, "Alt+F");
        }
        if (string == EDSTDKEYGOTO) {
            return this.getProperty(string, "Alt+G");
        }
        if (string == EDSTDKEYUNDO) {
            return this.getProperty(string, "Ctrl+Z");
        }
        if (string == EDSTDKEYREDO) {
            return this.getProperty(string, "Ctrl+Y");
        }
        if (string == KEYSAVE) {
            return this.getProperty(string, "Alt+S");
        }
        if (string == KEYCOMPILE) {
            return this.getProperty(string, "Alt+C");
        }
        if (string == KEYTEST) {
            return this.getProperty(string, "Alt+T");
        }
        if (string == KEYBATCHTEST) {
            return this.getProperty(string, "Alt+B");
        }
        if (string == KEYSUBMIT) {
            return this.getProperty(string, "Alt+U");
        }
        return this.getProperty(string);
    }

    public String getProperty(String string, String string2) {
        try {
            String string3 = this.configManager.getString(CONFIG_NAMESPACE, string);
            if (string3 == null || string3.equals("")) {
                return string2;
            }
            return string3.replaceAll("\\\\;", ";");
        }
        catch (UnknownNamespaceException unknownNamespaceException) {
            unknownNamespaceException.printStackTrace();
            return string2;
        }
    }

    public boolean getBoolean(String string, boolean bl) {
        return new Boolean(this.getProperty(string, "" + bl));
    }

    public final Enumeration getKeys() {
        return this.getNestedProperties("com").elements();
    }

    public final String removeProperty(String string) {
        String string2 = "";
        try {
            this.configManager.createTemporaryProperties(CONFIG_NAMESPACE);
            string2 = this.getProperty(string);
            this.configManager.removeProperty(CONFIG_NAMESPACE, string);
            this.configManager.commit(CONFIG_NAMESPACE, CONFIG_USER);
        }
        catch (UnknownNamespaceException unknownNamespaceException) {
            unknownNamespaceException.printStackTrace();
        }
        catch (ConfigManagerException configManagerException) {
            configManagerException.printStackTrace();
        }
        return string2;
    }

    private static final String getPluginKey(int n, String string) {
        StringBuffer stringBuffer = new StringBuffer("editor.");
        stringBuffer.append(n);
        stringBuffer.append(".");
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public final int getTabSize() {
        String string = this.getProperty(EDSTDTABSIZE);
        return string == null ? 4 : Integer.parseInt(string);
    }

    public final boolean isEditorCache() {
        String string = this.getProperty(PLUGINCACHED);
        return string == null ? true : !string.equals("false");
    }

    public final boolean isEditorDebug() {
        String string = this.getProperty(PLUGINDEBUG);
        return string == null ? false : string.equals("true");
    }

    public final boolean isSyntaxHighlight() {
        String string = this.getProperty(EDSTDSYNTAXHIGHLIGHT);
        return string == null ? true : !string.equals("false");
    }

    public final void setSyntaxHighlight(boolean bl) {
        this.setProperty(EDSTDSYNTAXHIGHLIGHT, String.valueOf(bl));
    }

    public final boolean isViewerSyntaxHighlight() {
        String string = this.getProperty(CHALSRCSYNTAXHIGHLIGHT);
        return string == null ? true : !string.equals("false");
    }

    public final void setViewerSyntaxHighlight(boolean bl) {
        this.setProperty(CHALSRCSYNTAXHIGHLIGHT, String.valueOf(bl));
    }

    public final String getDefaultEditorName() {
        String string = this.getProperty(PLUGINDEFAULTNAME);
        return string == null ? "" : string;
    }

    public final void setDefaultEditorName(String string) {
        this.setProperty(PLUGINDEFAULTNAME, string);
    }

    public final Dimension getSize(String string) {
        String string2 = this.getProperty(string);
        if (string2 == null) {
            return null;
        }
        int n = string2.indexOf(":");
        if (n < 0) {
            return null;
        }
        try {
            return new Dimension(Integer.parseInt(string2.substring(0, n)), Integer.parseInt(string2.substring(n + 1)));
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public final void setSize(String string, Dimension dimension) {
        this.setProperty(string, (int)dimension.getWidth() + ":" + (int)dimension.getHeight());
    }

    public final Point getLocation(String string) {
        String string2 = this.getProperty(string);
        if (string2 == null) {
            return null;
        }
        int n = string2.indexOf(":");
        if (n < 0) {
            return null;
        }
        try {
            return new Point(Integer.parseInt(string2.substring(0, n)), Integer.parseInt(string2.substring(n + 1)));
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public final void setLocation(String string, Point point) {
        this.setProperty(string, (int)point.getX() + ":" + (int)point.getY());
    }

    private static final void printError(String string) {
        System.err.println("LocalPreferences: " + string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final UIManager[] getAllUIManagers() {
        if (this.managers != null) {
            return this.managers;
        }
        LocalPreferences localPreferences = this;
        synchronized (localPreferences) {
            if (this.managers == null) {
                ArrayList<UIManager> arrayList = new ArrayList<UIManager>();
                for (int i = 0; i < UI_THEME_EMBEDDED.length; ++i) {
                    arrayList.add(UIFactory.getUIManagerFromResource(this.getClass(), UI_THEME_EMBEDDED[i]));
                }
                try {
                    File file = new File(LocalPreferences.getPreferencesFile().getParent(), UI_THEME_DIRECTORY);
                    arrayList.addAll(Arrays.asList(UIFactory.getAllUIManagers(file)));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.managers = arrayList.toArray(new UIManager[arrayList.size()]);
            }
        }
        return this.managers;
    }

    private static final File getPreferencesFile() throws IOException {
        try {
            String string;
            String string2 = System.getProperty(FILELOCATION);
            if (string2 == null) {
                string2 = System.getProperty("user.home");
            }
            if (string2 == null) {
                string2 = System.getProperty("java.home");
            }
            if ((string = System.getProperty(FILENAME)) == null) {
                string = CONFIG_NAMESPACE;
            }
            return new File(string2, string);
        }
        catch (Exception exception) {
            throw new IOException("Cannot access local properties file");
        }
    }

    private static final File getPreferencesBackupFile() throws IOException {
        try {
            String string;
            String string2 = System.getProperty(FILELOCATION);
            if (string2 == null) {
                string2 = System.getProperty("user.home");
            }
            if (string2 == null) {
                string2 = System.getProperty("java.home");
            }
            if ((string = System.getProperty(FILENAME)) == null) {
                string = CONFIG_NAMESPACE;
            }
            string = string + ".bak";
            return new File(string2, string);
        }
        catch (Exception exception) {
            throw new IOException("Cannot access local properties file");
        }
    }

    public void toggleBroadcastPopup() {
        String string = this.getProperty(DISABLEBROADCASTPOPUP);
        if (string == null) {
            string = "false";
        }
        this.setProperty(DISABLEBROADCASTPOPUP, string.equals("true") ? "false" : "true");
        try {
            this.savePreferences();
        }
        catch (Exception exception) {
            System.err.println("Error saving preferences file");
            exception.printStackTrace();
        }
    }

    public void toggleLeaderTicker() {
        String string = this.getProperty(LEADER_TICKER_DISABLED);
        if (string == null) {
            string = "false";
        }
        this.setProperty(LEADER_TICKER_DISABLED, string.equals("true") ? "false" : "true");
        try {
            this.savePreferences();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void toggleBroadcastBeep() {
        String string = this.getProperty(DISABLEBROADCASTBEEP);
        if (string == null) {
            string = "false";
        }
        this.setProperty(DISABLEBROADCASTBEEP, string.equals("true") ? "false" : "true");
        try {
            this.savePreferences();
        }
        catch (Exception exception) {
            System.err.println("Error saving preferences file");
            exception.printStackTrace();
        }
    }

    public void toggleEnableTimestamps() {
        String string = this.getProperty(ENABLETIMESTAMPS);
        if (string == null) {
            string = "false";
        }
        this.setProperty(ENABLETIMESTAMPS, string.equals("true") ? "false" : "true");
        try {
            this.savePreferences();
        }
        catch (Exception exception) {
            System.err.println("Error saving preferences file");
            exception.printStackTrace();
        }
    }

    public void toggleEnableUnusedCodeCheck() {
        String string = this.getProperty(UNUSEDCODECHECK);
        if (string == null) {
            string = "true";
        }
        this.setProperty(UNUSEDCODECHECK, string.equals("true") ? "false" : "true");
        try {
            this.savePreferences();
        }
        catch (Exception exception) {
            System.err.println("Error saving preferences file");
            exception.printStackTrace();
        }
    }

    public void toggleDisableChatScrolling() {
        String string = this.getProperty(CHAT_SCROLLING);
        if (string == null) {
            string = "false";
        }
        this.setProperty(CHAT_SCROLLING, string.equals("true") ? "false" : "true");
        try {
            this.savePreferences();
        }
        catch (Exception exception) {
            System.err.println("Error saving preferences file");
            exception.printStackTrace();
        }
    }

    public static String getKeyAttribute(String string, String string2) {
        return string + "." + string2;
    }

    private void formatForOutput(String string, StringBuffer stringBuffer, boolean bl) {
        string = string.replaceAll("\\\\;", ";");
        if (bl) {
            stringBuffer.setLength(0);
            stringBuffer.ensureCapacity(string.length());
        } else {
            stringBuffer.ensureCapacity(stringBuffer.length() + string.length());
        }
        boolean bl2 = true;
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\n': {
                    stringBuffer.append("\\n");
                    break;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    break;
                }
                case '\t': {
                    stringBuffer.append("\\t");
                    break;
                }
                case ' ': {
                    stringBuffer.append(bl2 ? "\\ " : " ");
                    break;
                }
                case '!': 
                case '#': 
                case ':': 
                case '=': 
                case '\\': {
                    stringBuffer.append('\\').append(c);
                    break;
                }
                default: {
                    if (c < ' ' || c > '~') {
                        String string2 = Integer.toHexString(c);
                        stringBuffer.append("\\u0000".substring(0, 6 - string2.length()));
                        stringBuffer.append(string2);
                        break;
                    }
                    stringBuffer.append(c);
                }
            }
            if (c == ' ') continue;
            bl2 = bl;
        }
    }

    public static String resolveStatusPropertyFormat(int n, int n2) {
        String string;
        String string2;
        switch (n) {
            case 1: {
                string2 = "java";
                break;
            }
            case 3: {
                string2 = "cpp";
                break;
            }
            case 4: {
                string2 = "csharp";
                break;
            }
            case 5: {
                string2 = "vb";
                break;
            }
            case 6: {
                string2 = "python";
                break;
            }
            default: {
                string2 = "";
            }
        }
        switch (n2) {
            case 110: {
                string2 = "";
                string = "unopened";
                break;
            }
            case 120: {
                string = "opened";
                string2 = "";
                break;
            }
            case 121: {
                string = "compiled";
                string2 = "";
                break;
            }
            case 130: {
                string = "";
                string2 = string2 + "points";
                break;
            }
            case 131: {
                string = "chlfailed";
                break;
            }
            case 140: {
                string = "chlpassed";
                break;
            }
            case 150: {
                string = "syspassed";
                break;
            }
            case 160: {
                string = "sysfailed";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown component status " + n2);
            }
        }
        String string3 = "com.topcoder.client.contestApplet.common.LocalPreferences.summary" + string2 + string;
        return string3;
    }

    private static class PrefObservable
    extends Observable {
        private PrefObservable() {
        }

        public void fireIt() {
            this.setChanged();
            this.notifyObservers();
        }
    }
}

