/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.common;

import com.topcoder.client.contestant.RoomModel;
import com.topcoder.client.contestant.RoundModel;
import java.lang.reflect.Field;
import java.util.Properties;

public final class CommonData {
    public static final String[][] dataTypeMap = new String[][]{{"int[]", "vector<int>", "int[]"}, {"long[]", "vector<long>", "long[]"}, {"double[]", "vector<double>", "double[]"}, {"String[]", "vector<string>", "string[]"}, {"long", "long long", "long"}, {"boolean", "bool", "bool"}, {"String", "string", "string"}};
    public static final String[] matrixHeader = new String[]{"0", "1"};
    public static final String[] contestantHeader = new String[]{"R", "Handle"};
    public static final String[] teamContestantHeader = new String[]{"R", "Team Name"};
    public static final String[] userHeader = new String[]{"R", "Handle"};
    public static final String[] registrantsHeader = new String[]{"R", "Handle", "Country"};
    public static final String[] hsRegistrantsHeader = new String[]{"R", "Handle", "Country", "School"};
    public static final String[] historyHeader = new String[]{"Summary", "Points"};
    public static final String[] teamInfoHeader = new String[]{"Team", "Captain", "Available", "Members", "Status"};
    public static final Properties VERSIONS = CommonData.getVersionProperties();
    private static final String VERSION_PROP_FILE = "version.properties";
    private static final String BASE = CommonData.getImageBaseURL();
    private static final String SPONSORLOGIN = BASE + "AppletLogin.png";
    private static final String SPONSORLOBBY = BASE + "AppletLobby.png";
    private static final String SPONSORCODINGFRAME = BASE + "AppletCodingFrame.png";
    private static final String SPONSORSCOREBOARD = BASE + "AppletScoreBoard.png";
    private static final String SPONSORWATCHROOM = BASE + "AppletWatchRoom.png";
    private static final String ROUND_SUFFIX = "&rd=";
    private static final boolean useRoundSuffix = CommonData.getUseRoundSuffix();
    private static final String[] companyNames = new String[]{"Oracle", "TopCoder", "Google", "TopCoderHS", "Nvidia", "CSFB", "Verizon", "DblClk", "VeriSign", "TCO05Sponsor", "TCO07Sponsor", "TCCC07Sponsor"};
    private static final int[] companyIDs = new int[]{26, 1, 1865, 41, 38, 44, 1747, 2998, 17942, 4, 5, 6};
    public static final boolean[] OracleAllows = new boolean[]{true, false, false, false, false};
    public static final boolean[] TopCoderAllows = new boolean[]{true, true, true, true, true};
    public static final boolean[] TopCoderHSAllows = new boolean[]{true, true, true, true, true};
    public static final boolean[] GoogleAllows = new boolean[]{true, true, true, true, true};
    public static final boolean[] VerizonAllows = new boolean[]{true, true, true, true, true};
    public static final boolean[] SunAllows = new boolean[]{true, false, false, false, false};
    public static final boolean[] SunPracticeAllows = new boolean[]{true, false, false, false, false};
    public static final boolean[] SunOnsiteAllows = new boolean[]{true, false, false, false, false};
    public static final boolean[] SunOnsiteFinalsAllows = new boolean[]{true, false, false, false, false};
    public static final boolean[] NvidiaAllows = new boolean[]{true, true, true, true, true};
    public static final boolean[] CSFBAllows = new boolean[]{true, true, true, true, true};
    public static final boolean[] DblClkAllows = new boolean[]{true, true, true, true, true};
    public static final boolean[] VeriSignAllows = new boolean[]{true, true, true, true, true};
    private static final int JAVA = 0;
    private static final int CPP = 1;
    private static final int CS = 2;
    private static final int VB = 3;
    private static final int PYTHON = 4;
    public static final String CURRENT_VERSION = VERSIONS.getProperty("currentVersion", "N/A");
    public static final String UPDATE_DATE = VERSIONS.getProperty("updateDate", "N/A");

    public static String getSponsorLoginImageAddr(int n) {
        return SPONSORLOGIN + n;
    }

    private static boolean getUseRoundSuffix() {
        try {
            return Boolean.valueOf(System.getProperty("com.topcoder.client.images.useRoundSuffix", "true"));
        }
        catch (Exception exception) {
            return true;
        }
    }

    private static String getImageBaseURL() {
        return System.getProperty("com.topcoder.client.images.baseURL", "http://community.topcoder.com/contest/sponsor/");
    }

    public static String getSponsorLobbyImageAddr(int n) {
        return SPONSORLOBBY;
    }

    public static String getSponsorCodingFrameImageAddr(int n) {
        return SPONSORCODINGFRAME;
    }

    public static String getSponsorScoreBoardImageAddr(int n) {
        return SPONSORSCOREBOARD;
    }

    public static String getSponsorWatchRoomImageAddr(int n) {
        return SPONSORWATCHROOM;
    }

    public static String getSponsorLoginImageAddr(String string) {
        return SPONSORLOGIN;
    }

    public static String getSponsorLobbyImageAddr(String string, RoomModel roomModel) {
        return SPONSORLOBBY;
    }

    public static String getSponsorCodingFrameImageAddr(String string, RoomModel roomModel) {
        return SPONSORCODINGFRAME;
    }

    public static String getSponsorWatchRoomImageAddr(String string, RoomModel roomModel) {
        return SPONSORWATCHROOM;
    }

    public static String getSponsorScoreBoardImageAddr(String string, RoundModel roundModel) {
        return SPONSORSCOREBOARD;
    }

    private static String buildRoundSuffix(RoomModel roomModel) {
        if (roomModel != null) {
            return CommonData.buildRoundSuffix(roomModel.getRoundModel());
        }
        return "";
    }

    private static String buildRoundSuffix(RoundModel roundModel) {
        if (roundModel != null && useRoundSuffix) {
            return ROUND_SUFFIX + roundModel.getRoundID();
        }
        return "";
    }

    public static int companyNameToID(String string) {
        for (int i = 0; i < companyNames.length; ++i) {
            if (!companyNames[i].equalsIgnoreCase(string)) continue;
            return companyIDs[i];
        }
        return -1;
    }

    public static String companyIDToName(int n) {
        for (int i = 0; i < companyIDs.length; ++i) {
            if (companyIDs[i] != n) continue;
            return companyNames[i];
        }
        return null;
    }

    private static boolean allows(String string, int n) {
        try {
            Field field = Class.forName("com.topcoder.client.contestApplet.common.CommonData").getField(string + "Allows");
            boolean[] blArray = (boolean[])field.get(null);
            return blArray[n];
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return true;
        }
    }

    public static boolean allowsJava(String string) {
        return CommonData.allows(string, 0);
    }

    public static boolean allowsCPP(String string) {
        return CommonData.allows(string, 1);
    }

    public static boolean allowsCS(String string) {
        return CommonData.allows(string, 2);
    }

    public static boolean allowsVB(String string) {
        return CommonData.allows(string, 3);
    }

    public static boolean allowsPython(String string) {
        return CommonData.allows(string, 4);
    }

    public static int[] parseVersion(String string) {
        String[] stringArray = string.split("\\.");
        int[] nArray = new int[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            nArray[i] = Integer.parseInt(stringArray[i]);
        }
        return nArray;
    }

    public static boolean isVersionCurrent(String string) {
        return CommonData.isVersionCurrent(CommonData.parseVersion(CURRENT_VERSION), CommonData.parseVersion(string));
    }

    public static boolean isVersionCurrent(int[] nArray, int[] nArray2) {
        for (int i = 0; i < nArray.length; ++i) {
            if (i >= nArray2.length) {
                return true;
            }
            if (nArray[i] > nArray2[i]) {
                return true;
            }
            if (nArray[i] >= nArray2[i]) continue;
            return false;
        }
        return nArray.length >= nArray2.length;
    }

    public static boolean showSystemTestsPerCoder(String string) {
        return "Showdown".equals(string);
    }

    private static Properties getVersionProperties() {
        Properties properties = new Properties();
        try {
            properties.load(CommonData.class.getClassLoader().getResourceAsStream(VERSION_PROP_FILE));
        }
        catch (Exception exception) {
            System.err.println("Error loading version.properties");
            exception.printStackTrace();
        }
        return properties;
    }
}

