/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client;

import com.topcoder.client.SortElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public abstract class SortedTableModel
extends AbstractTableModel
implements Comparator {
    private String[] COLUMN_NAME;
    private Class[] columnClasses;
    private boolean zeroAllowed = false;
    private final List itemList = new ArrayList();
    private final List sortList = new ArrayList();
    private List clonedSortList = new ArrayList();

    protected SortedTableModel(String[] stringArray, Class[] classArray) {
        this.COLUMN_NAME = stringArray;
        this.columnClasses = classArray;
    }

    public int getColumnCount() {
        return this.COLUMN_NAME.length;
    }

    public Class getColumnClass(int n) {
        return this.columnClasses[n];
    }

    public String getColumnName(int n) {
        return this.COLUMN_NAME[n];
    }

    public Object get(int n) {
        return this.itemList.get(n);
    }

    protected Iterator getSortListIterator() {
        return this.clonedSortList.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void sort(int n, boolean bl) {
        List list = this.sortList;
        synchronized (list) {
            SortElement sortElement = new SortElement(n, bl);
            int n2 = this.sortList.indexOf(sortElement);
            if (n2 == 0) {
                SortElement sortElement2 = (SortElement)this.sortList.get(0);
                this.sortList.set(0, new SortElement(n, !sortElement2.isOpposite()));
            } else if (n2 > 0) {
                this.sortList.remove(n2);
                this.sortList.add(0, sortElement);
            }
            this.syncClone();
        }
        this.processItemListChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncClone() {
        List list = this.sortList;
        synchronized (list) {
            ArrayList arrayList = new ArrayList();
            for (int i = 0; i < this.sortList.size(); ++i) {
                arrayList.add(this.sortList.get(i));
            }
            this.clonedSortList = arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addSortElement(SortElement sortElement) {
        List list = this.sortList;
        synchronized (list) {
            this.sortList.add(sortElement);
            this.syncClone();
        }
    }

    public int getRowCount() {
        return this.itemList.size();
    }

    protected Collection getItemList() {
        return this.itemList;
    }

    protected final void sort() {
        Collections.sort(this.itemList, this);
    }

    protected static int compareStrings(String string, String string2) {
        if (string == null) {
            return string2 == null ? 0 : -1;
        }
        if (string2 == null) {
            return 1;
        }
        return string.compareToIgnoreCase(string2);
    }

    public void clear() {
        this.itemList.clear();
        this.fireTableDataChanged();
    }

    public void update(Collection collection) {
        this.itemList.clear();
        this.itemList.addAll(collection);
        this.processItemListChanged();
    }

    public void add(Object object) {
        this.itemList.add(object);
        this.processItemListChanged();
    }

    public boolean remove(Object object) {
        boolean bl = this.itemList.remove(object);
        this.processItemListChanged();
        return bl;
    }

    protected void processItemListChanged() {
        this.sort();
        this.fireTableDataChanged();
    }

    public Object remove(int n) {
        Object e = this.itemList.remove(n);
        this.processItemListChanged();
        return e;
    }

    public void setZeroAllowed(boolean bl) {
        this.zeroAllowed = bl;
    }

    public void swapRows(int n, int n2) {
        if (!(n > 0 && n <= this.itemList.size() || n != 0 || this.zeroAllowed)) {
            throw new IllegalArgumentException("Invalid row: " + n);
        }
        if (!(n2 > 0 && n2 <= this.itemList.size() || n2 != 0 || this.zeroAllowed)) {
            throw new IllegalArgumentException("Invalid row: " + n2);
        }
        Object e = this.itemList.get(n);
        Object e2 = this.itemList.get(n2);
        this.itemList.set(n, e2);
        this.itemList.set(n2, e);
        this.fireTableDataChanged();
    }
}

