/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Random;
import javax.imageio.ImageIO;

public class WaterfallFishingVis {
    SecureRandom r;
    int width;
    int length;
    int rockCount;
    boolean[][] rocks;
    int[] fishCount;
    String[] data;
    int[] truth;
    static String exec;
    static Process proc;
    static boolean vis;
    InputStream is;
    OutputStream os;
    BufferedReader br;

    private boolean canPlaceRock(int n, int n2) {
        if (this.rocks[n][n2]) {
            return false;
        }
        if (n > 0 && this.rocks[n - 1][n2]) {
            return false;
        }
        if (n < this.length - 1 && this.rocks[n + 1][n2]) {
            return false;
        }
        if (n2 > 0 && this.rocks[n][n2 - 1]) {
            return false;
        }
        return n2 >= this.width - 1 || !this.rocks[n][n2 + 1];
    }

    private int[] getDailyFish(String string, int n) {
        int n2;
        int n3;
        int n4 = 5 + this.r.nextInt(96);
        int n5 = this.r.nextInt(this.width);
        int n6 = 2 + this.r.nextInt(this.width / 4 - 1);
        int[] nArray = new int[this.width];
        int n7 = 10;
        BufferedImage bufferedImage = new BufferedImage(n7 * this.width + 1, n7 * (this.length + 2) + 1, 1);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        Random random = new Random(n);
        if (vis) {
            graphics2D.setColor(Color.WHITE);
            graphics2D.fillRect(0, 0, n7 * this.width + 1, n7 * (this.length + 2) + 1);
            graphics2D.setColor(Color.BLACK);
            for (n3 = 0; n3 <= this.width; ++n3) {
                graphics2D.drawLine(n7 * n3, n7, n7 * n3, n7 * (this.length + 1));
            }
            for (n3 = 1; n3 < this.length + 2; ++n3) {
                graphics2D.drawLine(0, n7 * n3, n7 * this.width, n7 * n3);
            }
            for (n3 = 0; n3 < this.length; ++n3) {
                for (n2 = 0; n2 < this.width; ++n2) {
                    if (!this.rocks[n3][n2]) continue;
                    graphics2D.fillRect(n2 * n7, (n3 + 1) * n7, n7, n7);
                }
            }
            graphics2D.setStroke(new BasicStroke(2.0f));
        }
        while (n4 > 0) {
            n3 = (int)Math.round(this.r.nextGaussian() * (double)n6 + (double)n5);
            if (n3 < 0 || n3 > this.width - 1) continue;
            n2 = n3;
            if (vis) {
                graphics2D.setColor(new Color(random.nextInt(0xDDDDDD) + 0x111111));
            }
            for (int i = 0; i < this.length; ++i) {
                if (vis && i > 0) {
                    graphics2D.drawLine(n2 * n7 + n7 / 2, (i - 1) * n7 + n7 / 2, n3 * n7 + n7 / 2, i * n7 + n7 / 2);
                    n2 = n3;
                }
                if (!this.rocks[i][n3]) continue;
                if (n3 == 0) {
                    ++n3;
                    continue;
                }
                if (n3 == this.width - 1) {
                    --n3;
                    continue;
                }
                n3 += this.r.nextInt(2) * 2 - 1;
            }
            if (vis) {
                graphics2D.drawLine(n2 * n7 + n7 / 2, (this.length - 1) * n7 + n7 / 2, n3 * n7 + n7 / 2, this.length * n7 + n7 / 2);
                graphics2D.drawLine(n3 * n7 + n7 / 2, this.length * n7 + n7 / 2, n3 * n7 + n7 / 2, (this.length + 1) * n7 + n7 / 2);
            }
            int n8 = n3;
            nArray[n8] = nArray[n8] + 1;
            if (nArray[n3] > 35) {
                nArray[n3] = 35;
            }
            --n4;
        }
        if (vis) {
            try {
                ImageIO.write((RenderedImage)bufferedImage, "png", new File(string + "_" + n + ".png"));
            }
            catch (IOException iOException) {
                System.err.println("Failed to write " + string + "_" + n + " visualization to file.");
                iOException.printStackTrace();
            }
        }
        return nArray;
    }

    private char convertCountToChar(int n) {
        if (n >= 35) {
            return 'Z';
        }
        if (n < 10) {
            return (char)(48 + n);
        }
        return (char)(65 + n - 10);
    }

    private void generateTestCase(String string) throws NoSuchAlgorithmException {
        int n;
        int n2;
        long l = Long.parseLong(string);
        this.r = SecureRandom.getInstance("SHA1PRNG");
        this.r.setSeed(l);
        this.width = 20 + this.r.nextInt(181);
        this.length = 5 + this.r.nextInt(96);
        if (l == 1L) {
            this.width = 20;
            this.length = 10;
        }
        if (l == 2L) {
            this.width = 40;
            this.length = 15;
        }
        if (l == 3L) {
            this.width = 80;
            this.length = 25;
        }
        if (l == 4L) {
            this.width = 100;
            this.length = 30;
        }
        this.rockCount = 5 + this.r.nextInt(this.width * this.length / 10 - 4);
        this.rocks = new boolean[this.length][this.width];
        while (this.rockCount > 0) {
            n2 = this.r.nextInt(this.width);
            int n3 = this.r.nextInt(this.length);
            if (!this.canPlaceRock(n3, n2)) continue;
            this.rocks[n3][n2] = true;
            --this.rockCount;
        }
        this.data = new String[4 + this.r.nextInt(17)];
        for (n2 = 0; n2 < this.data.length; ++n2) {
            this.data[n2] = "";
            int[] nArray = this.getDailyFish("data", n2);
            for (n = 0; n < this.width; ++n) {
                int n4 = n2;
                this.data[n4] = this.data[n4] + this.convertCountToChar(nArray[n]);
            }
        }
        this.truth = new int[this.width];
        for (n2 = 0; n2 < 3; ++n2) {
            int[] nArray = this.getDailyFish("test", n2);
            for (n = 0; n < this.width; ++n) {
                this.truth[n] = Math.min(35, this.truth[n] + nArray[n]);
            }
        }
    }

    public double runTest(String string) {
        try {
            int n;
            this.generateTestCase(string);
            int[] nArray = this.placeTraps(this.data);
            if (nArray == null) {
                this.addFatalError("failed to get result from placeTraps()");
                return -1.0;
            }
            if (nArray.length < 1 || nArray.length > this.width) {
                this.addFatalError("the length of the return must be between 1 and W");
                return -1.0;
            }
            Arrays.sort(nArray);
            for (n = 0; n < nArray.length; ++n) {
                if (nArray[n] < 0 || nArray[n] >= this.width) {
                    this.addFatalError("value " + nArray[n] + " is outside the bounds of the river.");
                    return -1.0;
                }
                if (n <= 0 || nArray[n - 1] != nArray[n]) continue;
                this.addFatalError("value " + nArray[n] + " is duplicated in the result.");
                return -1.0;
            }
            n = 0;
            for (int i = 0; i < nArray.length; ++i) {
                n += this.truth[nArray[i]];
            }
            return 1.0 * (double)n / (double)nArray.length;
        }
        catch (Exception exception) {
            System.err.println("An exception occurred while trying to get your program's results.");
            exception.printStackTrace();
            return -1.0;
        }
    }

    int[] placeTraps(String[] stringArray) throws IOException {
        int n;
        if (proc == null) {
            return new int[0];
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(stringArray.length).append("\n");
        String[] stringArray2 = stringArray;
        int n2 = stringArray2.length;
        for (n = 0; n < n2; ++n) {
            String string = stringArray2[n];
            stringBuffer.append(string).append("\n");
        }
        this.os.write(stringBuffer.toString().getBytes());
        this.os.flush();
        int n3 = Integer.parseInt(this.br.readLine());
        int[] nArray = new int[n3];
        for (n = 0; n < n3; ++n) {
            nArray[n] = Integer.parseInt(this.br.readLine());
        }
        return nArray;
    }

    public WaterfallFishingVis(String string) {
        try {
            if (exec != null) {
                try {
                    Runtime runtime = Runtime.getRuntime();
                    proc = runtime.exec(exec);
                    this.os = proc.getOutputStream();
                    this.is = proc.getInputStream();
                    this.br = new BufferedReader(new InputStreamReader(this.is));
                    new ErrorReader(proc.getErrorStream()).start();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            System.out.println("Score = " + this.runTest(string));
            if (proc != null) {
                try {
                    proc.destroy();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        String string = "1";
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-seed")) {
                string = stringArray[++i];
            }
            if (stringArray[i].equals("-exec")) {
                exec = stringArray[++i];
            }
            if (!stringArray[i].equals("-vis")) continue;
            vis = true;
        }
        WaterfallFishingVis waterfallFishingVis = new WaterfallFishingVis(string);
    }

    void addFatalError(String string) {
        System.out.println(string);
    }
}

