/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.security.SecureRandom;
import java.util.HashMap;

public class TwistedGameTester {
    final int[] dr = new int[]{-1, 0, 1, 0};
    final int[] dc = new int[]{0, 1, 0, -1};
    int nTiles;
    HashMap<Integer, int[]> placedTiles;
    int[] validPlacements;
    int tileIndex;
    Chain[] chains;
    int row;
    int col;
    int rot;
    String errorMessage;
    SecureRandom rnd;
    static String exec;
    static String dumpFile;
    static boolean dump;
    static Process proc;
    InputStream is;
    OutputStream os;
    PrintWriter dmp;
    BufferedReader br;

    int[] generateRandomTile() {
        int n;
        int[] nArray = new int[8];
        for (n = 0; n < 8; ++n) {
            nArray[n] = n;
        }
        for (n = 0; n < 7; ++n) {
            int n2 = this.rnd.nextInt(8 - n) + n;
            if (n == n2) continue;
            int n3 = nArray[n];
            nArray[n] = nArray[n2];
            nArray[n2] = n3;
        }
        return nArray;
    }

    int[] rotateTile(int[] nArray, int n) {
        int[] nArray2 = new int[8];
        for (int i = 0; i < 8; ++i) {
            nArray2[i] = (nArray[i] + 2 * n) % 8;
        }
        return nArray2;
    }

    int cellPlace(int n, int n2) {
        return n * (2 * this.nTiles + 1) + n2;
    }

    int adjacentPlace(int n, int n2) {
        return n + this.dr[n2] * (2 * this.nTiles + 1) + this.dc[n2];
    }

    int matchingContact(int n) {
        if (n < 2 || n == 4 || n == 5) {
            return 5 - n;
        }
        return 9 - n;
    }

    int connectedContact(int[] nArray, int n) {
        for (int i = 0; i < 8; ++i) {
            if (nArray[i] != n) continue;
            return nArray[i + 1 - 2 * (i % 2)];
        }
        return -1;
    }

    boolean isValidMove() {
        if (this.rot < 0 || this.rot > 3) {
            this.errorMessage = "ROT must be between 0 and 3, inclusive.";
            return false;
        }
        int n = this.cellPlace(this.row, this.col);
        if (this.placedTiles.containsKey(n)) {
            this.errorMessage = "Placed tiles must not overlap.";
            return false;
        }
        for (int i = 0; i < 4; ++i) {
            if (this.validPlacements[i] != n) continue;
            return true;
        }
        this.errorMessage = "Invalid tile position.";
        return false;
    }

    boolean isValidReturn(String string) {
        this.errorMessage = "";
        if (string.equals("GIVE UP")) {
            return true;
        }
        try {
            String[] stringArray = string.split(" ");
            if (stringArray.length != 3) {
                this.errorMessage = "Your return must be formatted as \"ROW COL ROT\".";
                return false;
            }
            this.row = Integer.parseInt(stringArray[0]);
            this.col = Integer.parseInt(stringArray[1]);
            this.rot = Integer.parseInt(stringArray[2]);
        }
        catch (Exception exception) {
            this.errorMessage = "Your return must be formatted as \"ROW COL ROT\".";
            return false;
        }
        return this.isValidMove();
    }

    public double runTest(String string) {
        try {
            int n;
            this.rnd = SecureRandom.getInstance("SHA1PRNG");
            this.rnd.setSeed(Long.parseLong(string));
            this.nTiles = 10000;
            if (string.equals("1")) {
                this.nTiles = 10;
            }
            if (string.equals("2")) {
                this.nTiles = 100;
            }
            if (string.equals("3")) {
                this.nTiles = 1000;
            }
            this.placedTiles = new HashMap();
            int[] nArray = new int[this.nTiles];
            if (dump) {
                this.dmp.println(this.nTiles);
            }
            this.tileIndex = 0;
            int[] nArray2 = this.generateRandomTile();
            this.init(this.nTiles, nArray2);
            this.row = this.nTiles;
            this.col = this.nTiles;
            nArray[this.tileIndex] = this.cellPlace(this.row, this.col);
            this.placedTiles.put(nArray[this.tileIndex], nArray2);
            this.dumpTile(nArray[this.tileIndex], nArray2);
            this.validPlacements = new int[4];
            for (int i = 0; i < 4; ++i) {
                this.validPlacements[i] = this.cellPlace(this.row + this.dr[i], this.col + this.dc[i]);
            }
            ++this.tileIndex;
            nArray2 = this.generateRandomTile();
            String string2 = this.placeTile(nArray2);
            if (string2.equals("GIVE UP")) {
                this.addFatalError("You gave up. Tile index = 1 (0-based).");
                return 0.0;
            }
            if (!this.isValidReturn(string2)) {
                this.addFatalError(this.errorMessage + " Tile index = " + this.tileIndex + " (0-based).");
                return 0.0;
            }
            nArray[this.tileIndex] = this.cellPlace(this.row, this.col);
            this.placedTiles.put(nArray[this.tileIndex], this.rotateTile(nArray2, this.rot));
            this.dumpTile(nArray[this.tileIndex], this.rotateTile(nArray2, this.rot));
            for (n = 0; n < 4 && this.validPlacements[n] != nArray[this.tileIndex]; ++n) {
            }
            this.chains = new Chain[2];
            for (int i = 0; i < 2; ++i) {
                this.chains[i] = new Chain(nArray[0], n * 2 + i);
            }
            ++this.tileIndex;
            while (this.tileIndex < this.nTiles) {
                if (this.chains[0].looped && this.chains[1].looped) {
                    this.addFatalError("No possible moves for tile index = " + this.tileIndex + " (0-based).");
                    this.addFatalError("Chain 0 = " + this.chains[0].chainLength);
                    this.addFatalError("Chain 1 = " + this.chains[1].chainLength);
                    return Math.max(this.chains[0].chainLength, this.chains[1].chainLength);
                }
                for (n = 0; n < 4; ++n) {
                    this.validPlacements[n] = this.chains[n / 2].looped ? -1 : this.chains[n / 2].activeContacts[n % 2][0];
                }
                nArray2 = this.generateRandomTile();
                string2 = this.placeTile(nArray2);
                if (string2.equals("GIVE UP")) {
                    this.addFatalError("You gave up. Tile index = " + this.tileIndex + " (0-based).");
                    this.addFatalError("Chain 0 = " + this.chains[0].chainLength);
                    this.addFatalError("Chain 1 = " + this.chains[1].chainLength);
                    return Math.max(this.chains[0].chainLength, this.chains[1].chainLength);
                }
                if (!this.isValidReturn(string2)) {
                    this.addFatalError(this.errorMessage + " Tile index = " + this.tileIndex + " (0-based).");
                    this.addFatalError("Chain 0 = " + this.chains[0].chainLength);
                    this.addFatalError("Chain 1 = " + this.chains[1].chainLength);
                    return Math.max(this.chains[0].chainLength, this.chains[1].chainLength);
                }
                nArray[this.tileIndex] = this.cellPlace(this.row, this.col);
                this.placedTiles.put(nArray[this.tileIndex], this.rotateTile(nArray2, this.rot));
                this.dumpTile(nArray[this.tileIndex], this.rotateTile(nArray2, this.rot));
                for (n = 0; n < 4; ++n) {
                    this.chains[n / 2].extend(n % 2);
                }
                ++this.tileIndex;
            }
            this.addFatalError("Chain 0 = " + this.chains[0].chainLength);
            this.addFatalError("Chain 1 = " + this.chains[1].chainLength);
            return Math.max(this.chains[0].chainLength, this.chains[1].chainLength);
        }
        catch (Exception exception) {
            System.err.println("An exception occurred while trying to get your program's results.");
            exception.printStackTrace();
            return 0.0;
        }
    }

    int init(int n, int[] nArray) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(n + "\n");
        stringBuffer.append(this.tileToString(nArray)).append('\n');
        this.os.write(stringBuffer.toString().getBytes());
        this.os.flush();
        return 0;
    }

    String placeTile(int[] nArray) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.tileToString(nArray)).append('\n');
        this.os.write(stringBuffer.toString().getBytes());
        this.os.flush();
        return this.br.readLine();
    }

    public TwistedGameTester(String string) {
        try {
            if (exec != null) {
                try {
                    Runtime runtime = Runtime.getRuntime();
                    proc = runtime.exec(exec);
                    this.os = proc.getOutputStream();
                    this.is = proc.getInputStream();
                    this.br = new BufferedReader(new InputStreamReader(this.is));
                    new ErrorReader(proc.getErrorStream()).start();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            if (dumpFile != null) {
                try {
                    this.dmp = new PrintWriter(new FileWriter(dumpFile));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            System.out.println("Score = " + this.runTest(string));
            if (proc != null) {
                try {
                    proc.destroy();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            if (dumpFile != null) {
                try {
                    this.dmp.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        String string = "1";
        dump = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-seed")) {
                string = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-exec")) {
                exec = stringArray[++i];
                continue;
            }
            if (!stringArray[i].equals("-dump")) continue;
            dump = true;
            dumpFile = stringArray[++i];
        }
        TwistedGameTester twistedGameTester = new TwistedGameTester(string);
    }

    String tileToString(int[] nArray) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(nArray[0]);
        for (int i = 1; i < 8; ++i) {
            stringBuilder.append(" ");
            stringBuilder.append(nArray[i]);
        }
        return stringBuilder.toString();
    }

    String placeToString(int n) {
        return n / (2 * this.nTiles + 1) + " " + n % (2 * this.nTiles + 1);
    }

    void dumpTile(int n, int[] nArray) {
        if (dump) {
            for (int i = 0; i < 4; ++i) {
                this.dmp.println(this.placeToString(n) + " " + nArray[2 * i] + " " + nArray[2 * i + 1] + " B");
            }
        }
    }

    void addFatalError(String string) {
        System.out.println(string);
    }

    class Chain {
        public int chainLength = 0;
        public int[][] activeContacts;
        public boolean looped = false;

        public Chain() {
        }

        public Chain(int n, int n2) {
            this.activeContacts = new int[2][2];
            this.activeContacts[0][0] = n;
            this.activeContacts[0][1] = n2;
            this.activeContacts[1][0] = TwistedGameTester.this.adjacentPlace(n, n2 / 2);
            this.activeContacts[1][1] = TwistedGameTester.this.matchingContact(n2);
            this.extend(0);
            this.extend(1);
        }

        public void extend(int n) {
            if (this.looped) {
                return;
            }
            while (TwistedGameTester.this.placedTiles.containsKey(this.activeContacts[n][0])) {
                int n2;
                if (dump) {
                    TwistedGameTester.this.dmp.print(TwistedGameTester.this.placeToString(this.activeContacts[n][0]) + " " + this.activeContacts[n][1] + " ");
                }
                this.activeContacts[n][1] = TwistedGameTester.this.connectedContact(TwistedGameTester.this.placedTiles.get(this.activeContacts[n][0]), this.activeContacts[n][1]);
                ++this.chainLength;
                if (dump) {
                    TwistedGameTester.this.dmp.println(this.activeContacts[n][1] + " R");
                }
                if (this.activeContacts[n][0] == this.activeContacts[1 - n][0] && this.activeContacts[n][1] == this.activeContacts[1 - n][1]) {
                    this.looped = true;
                    break;
                }
                int n3 = this.activeContacts[n][1] / 2;
                this.activeContacts[n][0] = n2 = TwistedGameTester.this.adjacentPlace(this.activeContacts[n][0], n3);
                this.activeContacts[n][1] = TwistedGameTester.this.matchingContact(this.activeContacts[n][1]);
            }
        }
    }
}

