/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.imageio.ImageIO;

public class TwistedGameDrawer {
    int ADD_LEN = 5;
    int BASIC_LEN = 10;
    int[] dx;
    int[] dy;
    String dumpFile = "res.dmp";
    String resFile = "pic.gif";
    int base;
    int black = 40000;
    Set<String> takenCells = new HashSet<String>();

    void drawActiveContact(Graphics2D graphics2D, int n, int n2, int n3, int n4, int n5) {
        int n6;
        int n7 = n3 / 2 == 0 ? -1 : (n6 = n3 / 2 == 2 ? 1 : 0);
        int n8 = n3 / 2 == 1 ? 1 : (n3 / 2 == 3 ? -1 : 0);
        String string = n + n6 + " " + (n2 + n8);
        if (this.takenCells.contains(string)) {
            return;
        }
        graphics2D.setColor(Color.BLUE);
        graphics2D.fillRect(n4 - 2, n5 - 2, 5, 5);
    }

    public void processData() {
        int n;
        int n2;
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(this.dumpFile));
        }
        catch (Exception exception) {
            System.out.println("ERROR: Unable to open " + this.dumpFile + " for reading.");
            System.exit(0);
        }
        ArrayList arrayList = new ArrayList();
        try {
            this.base = Integer.parseInt(bufferedReader.readLine());
        }
        catch (Exception exception) {
            System.out.println("ERROR: Dump file has improper format (problem in line 0).");
            System.exit(0);
        }
        int n3 = 1;
        ArrayList<Instruction> arrayList2 = new ArrayList<Instruction>();
        while (true) {
            String string = null;
            try {
                string = bufferedReader.readLine();
            }
            catch (Exception exception) {
                System.out.println("ERROR: Unable to read line " + n3 + " (0-based) from dump file.");
                System.exit(0);
            }
            if (string == null) break;
            Instruction instruction = null;
            try {
                instruction = new Instruction(string);
            }
            catch (Exception exception) {
                System.out.println("ERROR: Line " + n3 + " (0-based) in dump file does not contain a valid drawing instruction.");
                System.out.println("This line contains: \"" + string + "\".");
                System.out.println("The detailed error is: " + exception.getMessage());
                System.exit(0);
            }
            ++n3;
            if (instruction.color == 'B') {
                --this.black;
                if (this.black < 0) break;
            }
            arrayList2.add(instruction);
        }
        int n4 = 2 * this.base;
        int n5 = 0;
        int n6 = 2 * this.base;
        int n7 = 0;
        for (Instruction object2 : arrayList2) {
            this.takenCells.add(object2.row + " " + object2.col);
            n4 = Math.min(n4, object2.row);
            n5 = Math.max(n5, object2.row);
            n6 = Math.min(n6, object2.col);
            n7 = Math.max(n7, object2.col);
        }
        BufferedImage bufferedImage = new BufferedImage(3 * (n7 - n6 + 1) * this.BASIC_LEN + 1 + 2 * this.ADD_LEN, 3 * (n5 - n4 + 1) * this.BASIC_LEN + 1 + 2 * this.ADD_LEN, 5);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setColor(Color.WHITE);
        graphics2D.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        graphics2D.setColor(new Color(150, 150, 150));
        for (Instruction instruction : arrayList2) {
            n2 = 3 * (instruction.col - n6) * this.BASIC_LEN + this.ADD_LEN;
            n = 3 * (instruction.row - n4) * this.BASIC_LEN + this.ADD_LEN;
            graphics2D.drawLine(n2, n, n2 + 3 * this.BASIC_LEN, n);
            graphics2D.drawLine(n2 + 3 * this.BASIC_LEN, n, n2 + 3 * this.BASIC_LEN, n + 3 * this.BASIC_LEN);
            graphics2D.drawLine(n2 + 3 * this.BASIC_LEN, n + 3 * this.BASIC_LEN, n2, n + 3 * this.BASIC_LEN);
            graphics2D.drawLine(n2, n + 3 * this.BASIC_LEN, n2, n);
        }
        this.dx = new int[]{this.BASIC_LEN, 2 * this.BASIC_LEN, 3 * this.BASIC_LEN, 3 * this.BASIC_LEN, 2 * this.BASIC_LEN, this.BASIC_LEN, 0, 0};
        this.dy = new int[]{0, 0, this.BASIC_LEN, 2 * this.BASIC_LEN, 3 * this.BASIC_LEN, 3 * this.BASIC_LEN, 2 * this.BASIC_LEN, this.BASIC_LEN};
        for (Instruction instruction : arrayList2) {
            if (instruction.c1 > instruction.c2) {
                n2 = instruction.c1;
                instruction.c1 = instruction.c2;
                instruction.c2 = n2;
            }
            n2 = 3 * (instruction.col - n6) * this.BASIC_LEN + this.ADD_LEN;
            n = 3 * (instruction.row - n4) * this.BASIC_LEN + this.ADD_LEN;
            int n8 = n2 + this.dx[instruction.c1];
            int n9 = n + this.dy[instruction.c1];
            int n10 = n2 + this.dx[instruction.c2];
            int n11 = n + this.dy[instruction.c2];
            graphics2D.setColor(instruction.color == 'B' ? Color.BLACK : Color.RED);
            if (instruction.c1 / 2 != instruction.c2 / 2) {
                graphics2D.drawLine(n8, n9, n10, n11);
            } else {
                int n12 = -1;
                int n13 = -1;
                if (instruction.c1 / 2 == 0) {
                    n12 = (n8 + n10) / 2;
                    n13 = n9 + this.BASIC_LEN / 3;
                }
                if (instruction.c1 / 2 == 1) {
                    n12 = n8 - this.BASIC_LEN / 3;
                    n13 = (n9 + n11) / 2;
                }
                if (instruction.c1 / 2 == 2) {
                    n12 = (n8 + n10) / 2;
                    n13 = n9 - this.BASIC_LEN / 3;
                }
                if (instruction.c1 / 2 == 3) {
                    n12 = n8 + this.BASIC_LEN / 3;
                    n13 = (n9 + n11) / 2;
                }
                graphics2D.drawLine(n8, n9, n12, n13);
                graphics2D.drawLine(n12, n13, n10, n11);
            }
            if (instruction.color != 'R') continue;
            this.drawActiveContact(graphics2D, instruction.row, instruction.col, instruction.c1, n8, n9);
            this.drawActiveContact(graphics2D, instruction.row, instruction.col, instruction.c2, n10, n11);
        }
        try {
            ImageIO.write((RenderedImage)bufferedImage, "gif", new File(this.resFile));
        }
        catch (Exception exception) {
            System.out.println("ERROR: unable to save resulted image to " + this.resFile + ".");
            System.exit(0);
        }
    }

    public static void printUsage() {
        System.out.println("USAGE: java TwistedGameDrawer dump_file res_file [moves_to_draw]");
        System.exit(0);
    }

    public static void main(String[] stringArray) throws Exception {
        TwistedGameDrawer twistedGameDrawer = new TwistedGameDrawer();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-dump")) {
                twistedGameDrawer.dumpFile = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-res")) {
                twistedGameDrawer.resFile = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-mv")) {
                twistedGameDrawer.black = 4 * Integer.parseInt(stringArray[++i]);
                continue;
            }
            if (!stringArray[i].equals("-sz")) continue;
            twistedGameDrawer.BASIC_LEN = Integer.parseInt(stringArray[++i]);
        }
        twistedGameDrawer.processData();
    }

    class Instruction {
        int row;
        int col;
        int c1;
        int c2;
        char color;

        public Instruction(String string) throws Exception {
            String[] stringArray = string.split(" ");
            this.row = Integer.parseInt(stringArray[0]);
            this.col = Integer.parseInt(stringArray[1]);
            this.c1 = Integer.parseInt(stringArray[2]);
            this.c2 = Integer.parseInt(stringArray[3]);
            if (this.row < 0 || this.row > 2 * TwistedGameDrawer.this.base) {
                throw new Exception("row must be between 0 and " + 2 * TwistedGameDrawer.this.base + ", inclusive.");
            }
            if (this.col < 0 || this.col > 2 * TwistedGameDrawer.this.base) {
                throw new Exception("column must be between 0 and " + 2 * TwistedGameDrawer.this.base + ", inclusive.");
            }
            if (this.c1 < 0 || this.c1 >= 8) {
                throw new Exception("contact1 must be between 0 and 7, inclusive.");
            }
            if (this.c2 < 0 || this.c2 >= 8) {
                throw new Exception("contact2 must be between 0 and 7, inclusive.");
            }
            if (this.c1 == this.c2) {
                throw new Exception("contact1 and contact2 must be different.");
            }
            if (!stringArray[4].equals("B") && !stringArray[4].equals("R")) {
                throw new Exception("color must be 'R' or 'B'.");
            }
            this.color = stringArray[4].charAt(0);
        }
    }
}

