/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.security.SecureRandom;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Random;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Traffic {
    Controller c;
    View v;
    String[] paramNames = new String[]{"seed", "height", "width", "numCars"};
    static Object runlock = new Object();

    public String getProcess() {
        if (this.v != null) {
            return this.v.fileName.getText();
        }
        return this.c.process;
    }

    public void setProcess(String string) {
        this.c.process = string;
        if (this.v != null) {
            this.v.fileName.setText(string);
        }
    }

    public static void main(String[] stringArray) {
        new Traffic(stringArray);
    }

    public Traffic(String[] stringArray) {
        int n = 1000;
        int n2 = 1000;
        boolean bl = false;
        boolean bl2 = false;
        this.c = new Controller();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-exec")) {
                bl2 = true;
                this.setProcess(stringArray[++i]);
                continue;
            }
            if (stringArray[i].equals("-drop")) {
                this.c.setDrop(true);
                continue;
            }
            if (stringArray[i].equals("-go")) {
                bl = true;
                continue;
            }
            if (stringArray[i].equals("-novis")) {
                bl = true;
                this.c.novis = true;
                continue;
            }
            if (stringArray[i].equals("-windowWidth")) {
                n2 = Integer.parseInt(stringArray[++i]);
                continue;
            }
            if (stringArray[i].equals("-windowHeight")) {
                n = Integer.parseInt(stringArray[++i]);
                continue;
            }
            if (stringArray[i].equals("-speed")) {
                int n3 = Integer.parseInt(stringArray[++i]);
                this.c.setSlide(n3);
                if (n3 >= 80) {
                    this.c.setPause(100 - n3);
                    continue;
                }
                this.c.setPause((int)(5000.0 * Math.pow(0.9333096363135965, n3)));
                continue;
            }
            if (!stringArray[i].startsWith("-")) continue;
            String string = stringArray[i].substring(1);
            String string2 = stringArray[++i];
            try {
                Field field = this.c.getClass().getDeclaredField(string);
                field.set(this.c, new Integer(string2));
                continue;
            }
            catch (Exception exception) {
                System.err.println("Invalid parameters");
                return;
            }
        }
        if (this.c.novis && !bl2) {
            System.err.println("You must specify the executable when using -novis");
            return;
        }
        this.c.generate(false, this.c.getSeed());
        if (!this.c.novis) {
            this.v = new View(n);
            this.v.setSize(n2, n);
            this.v.setVisible(true);
        }
        if (bl) {
            while (!this.c.novis && !this.v.sim.ready) {
                try {
                    Thread.sleep(10L);
                }
                catch (Exception exception) {}
            }
            this.c.start();
        }
    }

    class View
    extends JFrame
    implements WindowListener,
    ChangeListener {
        JTextArea err;
        JTextField fileName;
        JScrollPane scroll;
        JTextField[] params;
        int position;
        Vis sim;

        public void windowActivated(WindowEvent windowEvent) {
        }

        public void windowDeactivated(WindowEvent windowEvent) {
        }

        public void windowOpened(WindowEvent windowEvent) {
        }

        public void windowClosing(WindowEvent windowEvent) {
            Traffic.this.c.stop();
            System.exit(0);
        }

        public void windowClosed(WindowEvent windowEvent) {
        }

        public void windowIconified(WindowEvent windowEvent) {
        }

        public void windowDeiconified(WindowEvent windowEvent) {
        }

        public View(int n) {
            JSlider jSlider = new JSlider(0, 0, 100, Traffic.this.c.getSlide());
            jSlider.addChangeListener(this);
            jSlider.setMajorTickSpacing(20);
            jSlider.setMinorTickSpacing(5);
            jSlider.setPaintTicks(true);
            jSlider.setPaintLabels(true);
            jSlider.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
            this.sim = new Vis();
            this.err = new JTextArea("Standard Error from your program, as well as other messages will appear here");
            this.scroll = new JScrollPane(this.err);
            JSplitPane jSplitPane = new JSplitPane(0, this.sim, this.scroll);
            jSplitPane.setDividerLocation(n - 300);
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 3));
            JLabel jLabel = new JLabel("Speed");
            jLabel.setAlignmentX(0.5f);
            jSplitPane.setAlignmentX(0.5f);
            jPanel.add(jLabel);
            jPanel.add(jSlider);
            this.err.setEditable(false);
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new BoxLayout(jPanel2, 2));
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout(new BoxLayout(jPanel3, 2));
            this.params = new JTextField[Traffic.this.paramNames.length];
            for (int i = 0; i < Traffic.this.paramNames.length; ++i) {
                this.params[i] = new JTextField(Traffic.this.c.getParameter(Traffic.this.paramNames[i]).toString());
                if (i <= this.params.length / 2) {
                    jPanel2.add(new Label(Traffic.this.paramNames[i] + ": "));
                    jPanel2.add(this.params[i]);
                    continue;
                }
                jPanel3.add(new Label(Traffic.this.paramNames[i] + ": "));
                jPanel3.add(this.params[i]);
            }
            jPanel2.setAlignmentX(0.5f);
            jPanel3.setAlignmentX(0.5f);
            JPanel jPanel4 = new JPanel();
            jPanel4.setLayout(new BoxLayout(jPanel4, 2));
            JButton jButton = new JButton("Generate Map");
            JButton jButton2 = new JButton("New Parameters and Map");
            JButton jButton3 = new JButton("Start Simulation");
            JButton jButton4 = new JButton("Stop Simulation");
            jPanel4.add(jButton);
            jPanel4.add(jButton2);
            jPanel4.add(jButton3);
            jPanel4.add(jButton4);
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Traffic.this.c.stop();
                    Traffic.this.c.generate(false, Integer.parseInt(View.this.params[0].getText()));
                    View.this.sim.reset();
                    View.this.repaintSim(false);
                }
            });
            jButton2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Traffic.this.c.stop();
                    if (Traffic.this.c.getSeed() == Integer.parseInt(View.this.params[0].getText())) {
                        View.this.params[0].setText(String.valueOf(Traffic.this.c.newSeed()));
                        Traffic.this.c.generate(true, Integer.parseInt(View.this.params[0].getText()));
                    } else {
                        Traffic.this.c.generate(true, Integer.parseInt(View.this.params[0].getText()));
                    }
                    for (int i = 1; i < View.this.params.length; ++i) {
                        View.this.params[i].setText(Traffic.this.c.getParameter(Traffic.this.paramNames[i]).toString());
                    }
                    View.this.sim.reset();
                    View.this.repaintSim(false);
                }
            });
            jButton3.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Traffic.this.c.stop();
                    try {
                        Thread.sleep(20L);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    Traffic.this.c.generate(false, Integer.parseInt(View.this.params[0].getText()));
                    View.this.sim.reset();
                    View.this.repaintSim(false);
                    Traffic.this.c.start();
                }
            });
            jButton4.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Traffic.this.c.stop();
                }
            });
            JPanel jPanel5 = new JPanel();
            JButton jButton5 = new JButton("Select Executable");
            this.fileName = new JTextField(Traffic.this.c.process);
            jPanel5.add(jButton5);
            jPanel5.add(this.fileName);
            jPanel5.setLayout(new BoxLayout(jPanel5, 2));
            jButton5.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JFileChooser jFileChooser = new JFileChooser();
                    int n = jFileChooser.showOpenDialog(View.this);
                    if (n == 0) {
                        View.this.fileName.setText(jFileChooser.getSelectedFile().getPath());
                        Traffic.this.c.process = jFileChooser.getSelectedFile().getPath();
                    }
                }
            });
            JPanel jPanel6 = new JPanel();
            jPanel6.setLayout(new BoxLayout(jPanel6, 3));
            jPanel6.add(jPanel2);
            jPanel6.add(jPanel3);
            jPanel6.add(jPanel4);
            jPanel6.add(jPanel5);
            this.add((Component)jPanel, "North");
            this.add((Component)jSplitPane, "Center");
            this.add((Component)jPanel6, "South");
            this.addWindowListener(this);
        }

        public void stateChanged(ChangeEvent changeEvent) {
            JSlider jSlider = (JSlider)changeEvent.getSource();
            if (jSlider.getValue() >= 80) {
                Traffic.this.c.setPause(100 - jSlider.getValue());
            } else {
                Traffic.this.c.setPause((int)(5000.0 * Math.pow(0.9333096363135965, jSlider.getValue())));
            }
        }

        void addMessage(final String string) {
            final JScrollBar jScrollBar = this.scroll.getVerticalScrollBar();
            if (!(jScrollBar.getValueIsAdjusting() || jScrollBar.getValue() + jScrollBar.getVisibleAmount() != jScrollBar.getMaximum() && jScrollBar.getValue() != this.position)) {
                Runnable runnable = new Runnable(){

                    public void run() {
                        View.this.err.append(string);
                        View.this.position = jScrollBar.getMaximum() - jScrollBar.getVisibleAmount();
                        jScrollBar.setValue(View.this.position);
                    }
                };
                try {
                    SwingUtilities.invokeAndWait(runnable);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else {
                this.position = -1;
                this.err.append(string);
            }
        }

        void repaintSim(boolean bl) {
            Runnable runnable = new Runnable(){

                public void run() {
                    View.this.sim.paintImmediately(0, 0, View.this.sim.getWidth(), View.this.sim.getHeight());
                }
            };
            if (bl && !Traffic.this.c.drop()) {
                try {
                    SwingUtilities.invokeAndWait(runnable);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else {
                this.sim.repaint();
            }
        }

        public String getParam(int n) {
            String string = this.params[n].getText();
            return string;
        }

        class Vis
        extends JPanel {
            BufferedImage bi = null;
            double xoff;
            double yoff;
            double scale;
            DecimalFormat df = new DecimalFormat("0.00");
            boolean ready = false;

            Vis() {
            }

            void reset() {
                this.bi = null;
                this.rebuffer();
            }

            public void paint(Graphics graphics) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.setColor(Color.white);
                graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
                this.rebuffer();
                AffineTransform affineTransform = new AffineTransform();
                double d = Math.min((double)this.getWidth() / (double)this.bi.getWidth(), (double)this.getHeight() / (double)this.bi.getHeight());
                AffineTransformOp affineTransformOp = null;
                if (d < 1.0) {
                    double d2 = ((double)this.getWidth() - (double)this.bi.getWidth() * d) / 2.0 / d;
                    double d3 = ((double)this.getHeight() - (double)this.bi.getHeight() * d) / 2.0 / d;
                    affineTransform.scale(d, d);
                    affineTransform.translate(d2, d3);
                    affineTransformOp = new AffineTransformOp(affineTransform, 2);
                } else {
                    d = (int)d;
                    double d4 = ((double)this.getWidth() - (double)this.bi.getWidth() * d) / 2.0 / d;
                    double d5 = ((double)this.getHeight() - (double)this.bi.getHeight() * d) / 2.0 / d;
                    affineTransform.scale((int)d, (int)d);
                    affineTransform.translate(d4, d5);
                    affineTransformOp = new AffineTransformOp(affineTransform, 1);
                }
                AffineTransform affineTransform2 = graphics2D.getTransform();
                graphics2D.drawImage(this.bi, affineTransformOp, 0, 0);
                Font font = new Font(graphics2D.getFont().getName(), 0, 40);
                graphics2D.setFont(font);
                FontMetrics fontMetrics = graphics2D.getFontMetrics();
                int n = fontMetrics.getAscent();
                String string = "Time = " + Traffic.this.c.time;
                String string2 = "Arrived = " + Traffic.this.c.cd;
                int n2 = fontMetrics.stringWidth(string);
                graphics2D.setColor(Color.black);
                graphics2D.drawString(string, 0, n);
                graphics2D.drawString(string2, 0, 2 * n + 1);
                this.ready = true;
            }

            public void rebuffer() {
                int n;
                int n2;
                int n3;
                int n4;
                boolean[][][] blArray = Traffic.this.c.carPresent;
                this.bi = new BufferedImage(2 * (blArray[0].length + 1), 2 * (blArray.length + 1), 1);
                Graphics2D graphics2D = (Graphics2D)this.bi.getGraphics();
                for (n4 = 0; n4 <= blArray[0].length; ++n4) {
                    for (n3 = 0; n3 <= blArray.length; ++n3) {
                        for (n2 = 0; n2 < 2; ++n2) {
                            for (n = 0; n < 2; ++n) {
                                if (n4 == 0 || n3 == 0 || n4 == blArray[0].length || n3 == blArray.length) {
                                    this.bi.setRGB(n4 * 2 + n2, n3 * 2 + n, 0xFFFFFF);
                                    continue;
                                }
                                if (n4 % 10 == 0 || n3 % 10 == 0) {
                                    this.bi.setRGB(n4 * 2 + n2, n3 * 2 + n, 0xAFAFAF);
                                    continue;
                                }
                                this.bi.setRGB(n4 * 2 + n2, n3 * 2 + n, 0xFFFFFF);
                            }
                        }
                    }
                }
                for (n4 = 0; n4 < Traffic.this.c.carX.length; ++n4) {
                    n3 = Traffic.this.c.carX[n4];
                    n2 = Traffic.this.c.carY[n4];
                    if (Traffic.this.c.fullPaths[n4].length() == 0 && !Traffic.this.c.carDone[n4]) {
                        this.bi.setRGB(n3 * 2, n2 * 2, 0xFF00FF);
                        this.bi.setRGB(n3 * 2, n2 * 2 + 1, 0xFF00FF);
                        this.bi.setRGB(n3 * 2 + 1, n2 * 2, 0xFF00FF);
                        this.bi.setRGB(n3 * 2 + 1, n2 * 2 + 1, 0xFF00FF);
                        continue;
                    }
                    if (Traffic.this.c.carDone[n4]) continue;
                    n = "NESW".indexOf(Traffic.this.c.fullPaths[n4].substring(0, 1));
                    if (n == 3) {
                        this.bi.setRGB(n3 * 2, n2 * 2, 0xFF0000);
                        this.bi.setRGB(n3 * 2 + 1, n2 * 2, 0xFF0000);
                        continue;
                    }
                    if (n == 2) {
                        this.bi.setRGB(n3 * 2, n2 * 2, 0xFF0000);
                        this.bi.setRGB(n3 * 2, n2 * 2 + 1, 0xFF0000);
                        continue;
                    }
                    if (n == 1) {
                        this.bi.setRGB(n3 * 2, n2 * 2 + 1, 255);
                        this.bi.setRGB(n3 * 2 + 1, n2 * 2 + 1, 255);
                        continue;
                    }
                    if (n != 0) continue;
                    this.bi.setRGB(n3 * 2 + 1, n2 * 2, 255);
                    this.bi.setRGB(n3 * 2 + 1, n2 * 2 + 1, 255);
                }
            }
        }
    }

    class Controller {
        String process = "Enter your executable and its arguments here";
        Runner current;
        Random r;
        int ST = 20;
        int slide = 80;
        int seed;
        boolean running;
        boolean novis;
        boolean drop;
        int height;
        int width;
        int numCars;
        int time;
        int cd;
        String[][] lightTime;
        boolean[][][] carPresent;
        boolean[][][] newCar;
        int[] carX;
        int[] carY;
        int[] carD;
        String[] carPaths;
        String[] fullPaths;
        boolean[] carDone;
        String lastFullPath;
        int[] lastStart;
        double[][][] inter;

        Controller() {
        }

        public void generate(boolean bl, int n) {
            this.seed = n;
            try {
                this.r = SecureRandom.getInstance("SHA1PRNG");
                this.r.setSeed(n);
                if (bl) {
                    this.width = this.r.nextInt(16) * 10 + 49;
                    this.height = this.r.nextInt(16) * 10 + 49;
                    this.numCars = this.r.nextInt(this.width * this.height / 10 - 199) + 200;
                    if (n == 1) {
                        this.numCars = 1;
                    }
                    if (n == 2) {
                        this.numCars = 10;
                    }
                    if (n == 3) {
                        this.numCars = 30;
                    }
                    if (n == 4) {
                        this.numCars = 100;
                    }
                } else if (Traffic.this.v != null) {
                    for (int i = 1; i < Traffic.this.paramNames.length; ++i) {
                        Field field = this.getClass().getDeclaredField(Traffic.this.paramNames[i]);
                        field.set(this, new Integer(Traffic.this.v.getParam(i)));
                    }
                    this.r.nextInt(16);
                    this.r.nextInt(16);
                    this.r.nextInt(this.width * this.height / 20 - 99);
                } else {
                    if (this.width == 0) {
                        this.width = this.r.nextInt(16) * 10 + 49;
                    } else {
                        this.r.nextInt(16);
                    }
                    if (this.height == 0) {
                        this.height = this.r.nextInt(16) * 10 + 49;
                    } else {
                        this.r.nextInt(16);
                    }
                    if (this.numCars == 0) {
                        this.numCars = this.r.nextInt(this.width * this.height / 10 - 199) + 200;
                        if (n == 1) {
                            this.numCars = 1;
                        }
                        if (n == 2) {
                            this.numCars = 10;
                        }
                        if (n == 3) {
                            this.numCars = 30;
                        }
                        if (n == 4) {
                            this.numCars = 100;
                        }
                    } else {
                        this.r.nextInt(this.width * this.height / 10 - 199);
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.cd = 0;
            this.time = 0;
            this.generateTestCase();
        }

        int[] generatePoint() {
            int n = 0;
            int n2 = 0;
            while (n % 10 == 0 && n2 % 10 == 0 || n % 10 > 0 && n2 % 10 > 0 || this.carPresent[n2][n][0] || this.carPresent[n2][n][1] || this.carPresent[n2][n][2] || this.carPresent[n2][n][3]) {
                n = this.r.nextInt(this.width) + 1;
                n2 = this.r.nextInt(this.height) + 1;
            }
            return new int[]{n, n2};
        }

        String generateRandomPath() {
            int[] nArray = this.generatePoint();
            this.lastStart = new int[]{nArray[0], nArray[1]};
            int[] nArray2 = this.generatePoint();
            while (nArray[0] == nArray2[0] && nArray[1] == nArray2[1]) {
                nArray2 = this.generatePoint();
            }
            String string = nArray[0] + "," + nArray[1] + " ";
            this.lastFullPath = "";
            boolean bl = false;
            if (nArray[0] % 10 == 0) {
                if (nArray[1] < this.height - 10 && this.r.nextInt(2) == 0) {
                    bl = true;
                }
                if (nArray[1] < 10) {
                    bl = true;
                }
                if (bl) {
                    string = string + "S";
                    while (nArray[1] % 10 > 0) {
                        nArray[1] = nArray[1] + 1;
                        this.lastFullPath = this.lastFullPath + "S";
                    }
                } else {
                    string = string + "N";
                    while (nArray[1] % 10 > 0) {
                        nArray[1] = nArray[1] - 1;
                        this.lastFullPath = this.lastFullPath + "N";
                    }
                }
            } else {
                if (nArray[0] < this.width - 10 && this.r.nextInt(2) == 0) {
                    bl = true;
                }
                if (nArray[0] < 10) {
                    bl = true;
                }
                if (bl) {
                    string = string + "E";
                    while (nArray[0] % 10 > 0) {
                        nArray[0] = nArray[0] + 1;
                        this.lastFullPath = this.lastFullPath + "E";
                    }
                } else {
                    string = string + "W";
                    while (nArray[0] % 10 > 0) {
                        nArray[0] = nArray[0] - 1;
                        this.lastFullPath = this.lastFullPath + "W";
                    }
                }
            }
            double d = this.r.nextDouble();
            int n = 0;
            int n2 = 0;
            while (d > this.inter[nArray[1] / 10 - 1][nArray[0] / 10 - 1][0]) {
                ++n;
                if (d < this.inter[nArray[1] / 10 - 1][nArray[0] / 10 - 1][1]) {
                    if (nArray[0] < this.width - 10 && !string.endsWith("W")) {
                        ++n2;
                        nArray[0] = nArray[0] + 10;
                        string = string + "E";
                        this.lastFullPath = this.lastFullPath + "EEEEEEEEEE";
                    }
                } else if (d < this.inter[nArray[1] / 10 - 1][nArray[0] / 10 - 1][2]) {
                    if (nArray[0] > 10 && !string.endsWith("E")) {
                        ++n2;
                        nArray[0] = nArray[0] - 10;
                        string = string + "W";
                        this.lastFullPath = this.lastFullPath + "WWWWWWWWWW";
                    }
                } else if (d < this.inter[nArray[1] / 10 - 1][nArray[0] / 10 - 1][3]) {
                    if (nArray[1] < this.height - 10 && !string.endsWith("N")) {
                        ++n2;
                        nArray[1] = nArray[1] + 10;
                        string = string + "S";
                        this.lastFullPath = this.lastFullPath + "SSSSSSSSSS";
                    }
                } else if (nArray[1] > 10 && !string.endsWith("S")) {
                    ++n2;
                    nArray[1] = nArray[1] - 10;
                    string = string + "N";
                    this.lastFullPath = this.lastFullPath + "NNNNNNNNNN";
                }
                d = this.r.nextDouble();
            }
            return string;
        }

        void generateTestCase() {
            int n;
            this.lightTime = new String[this.height / 10][this.width / 10];
            this.carPresent = new boolean[this.height + 1][this.width + 1][4];
            this.carPaths = new String[this.numCars];
            this.fullPaths = new String[this.numCars];
            this.carDone = new boolean[this.numCars];
            this.carX = new int[this.numCars];
            this.carY = new int[this.numCars];
            this.carD = new int[this.numCars];
            this.inter = new double[this.height / 10][this.width / 10][4];
            for (n = 0; n < this.height / 10; ++n) {
                for (int i = 0; i < this.width / 10; ++i) {
                    for (int j = 0; j < 4; ++j) {
                        this.inter[n][i][j] = this.r.nextDouble();
                    }
                    Arrays.sort(this.inter[n][i]);
                }
            }
            for (n = 0; n < this.carPaths.length; ++n) {
                this.carPaths[n] = this.generateRandomPath();
                this.fullPaths[n] = this.lastFullPath;
                this.carX[n] = this.lastStart[0];
                this.carY[n] = this.lastStart[1];
                switch (this.lastFullPath.charAt(0)) {
                    case 'N': {
                        this.carD[n] = 0;
                        break;
                    }
                    case 'E': {
                        this.carD[n] = 1;
                        break;
                    }
                    case 'S': {
                        this.carD[n] = 2;
                        break;
                    }
                    case 'W': {
                        this.carD[n] = 3;
                    }
                }
                this.carPresent[this.carY[n]][this.carX[n]][this.carD[n]] = true;
            }
        }

        boolean isClear(int n, int n2, int n3) {
            int n4 = n;
            int n5 = n2;
            if (n3 == 0) {
                --n5;
            }
            if (n3 == 1) {
                ++n4;
            }
            if (n3 == 2) {
                ++n5;
            }
            if (n3 == 3) {
                --n4;
            }
            if (n4 % 10 == 0 && n5 % 10 == 0) {
                String string = this.lightTime[n5 / 10 - 1][n4 / 10 - 1];
                char c = string.charAt(this.time % string.length());
                if ("NESW".charAt(n3) != c) {
                    return false;
                }
                return !this.carPresent[n5][n4][0] && !this.carPresent[n5][n4][1] && !this.carPresent[n5][n4][2] && !this.carPresent[n5][n4][3];
            }
            return !this.carPresent[n5][n4][n3];
        }

        boolean allDone() {
            for (int i = 0; i < this.carDone.length; ++i) {
                if (this.carDone[i]) continue;
                return false;
            }
            return true;
        }

        void start() {
            if (Traffic.this.v != null) {
                Traffic.this.v.err.setText("");
            }
            this.current = new Runner();
            this.current.start();
        }

        void stop() {
            this.running = false;
            if (this.current != null) {
                try {
                    if (this.current.pr != null) {
                        this.current.pr.destroy();
                        this.current.pr.waitFor();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                this.current = null;
            }
        }

        public int newSeed() {
            return this.r.nextInt();
        }

        public void setSeed(int n) {
            this.seed = n;
        }

        public int getSeed() {
            return this.seed;
        }

        public Object getParameter(String string) {
            try {
                Field field = this.getClass().getDeclaredField(string);
                return field.get(this);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
        }

        public void setParameter(String string, String string2) {
            try {
                Field field = this.getClass().getDeclaredField(string);
                if (field.getType().getName().equals("int")) {
                    field.set(this, new Integer(string2));
                }
                if (field.getType().getName().equals("double")) {
                    field.set(this, new Double(string2));
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public int getSlide() {
            return this.slide;
        }

        public void setSlide(int n) {
            this.slide = n;
        }

        public void setPause(int n) {
            this.ST = n;
        }

        public void addMessage(String string) {
            if (this.novis) {
                System.out.print(string);
            } else {
                Traffic.this.v.addMessage(string);
            }
        }

        public void addFatalError(String string) {
            this.addMessage(string + "\n");
        }

        public boolean drop() {
            return this.drop;
        }

        public void setDrop(boolean bl) {
            this.drop = bl;
        }

        class Runner
        extends Thread {
            Process pr;
            BufferedReader input;
            InputStream error;
            DataOutputStream os;

            Runner() {
            }

            public void run() {
                this.runTest();
                this.pr.destroy();
            }

            public String[] setTimings(int n, int n2, String[] stringArray) throws IOException {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(n).append(' ').append(n2).append(' ').append(stringArray.length).append('\n');
                for (int i = 0; i < stringArray.length; ++i) {
                    stringBuffer.append(stringArray[i]).append('\n');
                }
                this.os.write(stringBuffer.toString().getBytes());
                this.os.flush();
                String[] stringArray2 = new String[n / 10 * (n2 / 10)];
                for (int i = 0; i < stringArray2.length; ++i) {
                    stringArray2[i] = this.input.readLine();
                }
                return stringArray2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void runTest() {
                Controller.this.running = true;
                try {
                    Object object = runlock;
                    synchronized (object) {
                        int n;
                        int n2;
                        this.pr = Runtime.getRuntime().exec(Traffic.this.getProcess());
                        this.input = new BufferedReader(new InputStreamReader(this.pr.getInputStream()));
                        this.error = this.pr.getErrorStream();
                        this.os = new DataOutputStream(this.pr.getOutputStream());
                        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                            public void run() {
                                Runner.this.pr.destroy();
                            }
                        }));
                        Thread thread = new Thread(new Runnable(){

                            public void run() {
                                try {
                                    int n;
                                    byte[] byArray = new byte[50000];
                                    while ((n = Runner.this.error.read(byArray)) > 0 && Controller.this.running) {
                                        Controller.this.addMessage(new String(byArray, 0, n));
                                    }
                                    Controller.this.addMessage("\n");
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        });
                        thread.start();
                        String[] stringArray = this.setTimings(Controller.this.width, Controller.this.height, Controller.this.carPaths);
                        int n3 = 0;
                        if (stringArray.length != Controller.this.height / 10 * (Controller.this.width / 10)) {
                            Controller.this.addFatalError("Return value must have exactly " + Controller.this.height / 10 * (Controller.this.width / 10) + " elements.");
                            return;
                        }
                        for (n2 = 0; n2 < Controller.this.height / 10; ++n2) {
                            for (n = 0; n < Controller.this.width / 10; ++n) {
                                Controller.this.lightTime[n2][n] = stringArray[n3++];
                                if (Controller.this.lightTime[n2][n].length() < 1 || Controller.this.lightTime[n2][n].length() > 20) {
                                    Controller.this.addFatalError("Light timings must all have 1-20 characters.");
                                    return;
                                }
                                for (int i = 0; i < Controller.this.lightTime[n2][n].length(); ++i) {
                                    char c = Controller.this.lightTime[n2][n].charAt(i);
                                    if (c == 'E' || c == 'N' || c == 'S' || c == 'W') continue;
                                    Controller.this.addFatalError("Each light timing instruction must be 'E','W','N' or 'S'.");
                                    return;
                                }
                            }
                        }
                        while (Controller.this.running && !Controller.this.allDone() && Controller.this.time < 1000) {
                            Controller.this.newCar = new boolean[Controller.this.height + 1][Controller.this.width + 1][4];
                            for (n2 = 0; n2 < Controller.this.numCars; ++n2) {
                                if (Controller.this.fullPaths[n2].length() == 0) {
                                    if (!Controller.this.carDone[n2]) {
                                        ++Controller.this.cd;
                                    }
                                    Controller.this.carDone[n2] = true;
                                    continue;
                                }
                                n = "NESW".indexOf(Controller.this.fullPaths[n2].substring(0, 1));
                                if (Controller.this.isClear(Controller.this.carX[n2], Controller.this.carY[n2], n)) {
                                    Controller.this.carD[n2] = n;
                                    if (n == 0) {
                                        int n4 = n2;
                                        Controller.this.carY[n4] = Controller.this.carY[n4] - 1;
                                    }
                                    if (n == 1) {
                                        int n5 = n2;
                                        Controller.this.carX[n5] = Controller.this.carX[n5] + 1;
                                    }
                                    if (n == 2) {
                                        int n6 = n2;
                                        Controller.this.carY[n6] = Controller.this.carY[n6] + 1;
                                    }
                                    if (n == 3) {
                                        int n7 = n2;
                                        Controller.this.carX[n7] = Controller.this.carX[n7] - 1;
                                    }
                                    Controller.this.fullPaths[n2] = Controller.this.fullPaths[n2].substring(1);
                                    Controller.this.newCar[Controller.this.carY[n2]][Controller.this.carX[n2]][Controller.this.carD[n2]] = true;
                                    continue;
                                }
                                Controller.this.newCar[Controller.this.carY[n2]][Controller.this.carX[n2]][Controller.this.carD[n2]] = true;
                            }
                            ++Controller.this.time;
                            Controller.this.carPresent = Controller.this.newCar;
                            if (Controller.this.novis) continue;
                            Traffic.this.v.repaintSim(true);
                            if (Controller.this.ST == 0) continue;
                            Thread.sleep(Controller.this.ST);
                        }
                    }
                    if (Controller.this.novis) {
                        System.out.println("time = " + Controller.this.time);
                        System.out.println("arrived = " + Controller.this.cd + "/" + Controller.this.carDone.length);
                    }
                }
                catch (IOException iOException) {
                    Controller.this.addMessage("Simulation over because communication between the visualizer and your process ended.\n");
                    Controller.this.addMessage(iOException.getMessage() + "\n");
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }
}

