/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.security.SecureRandom;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class TilesPuzzleVis {
    SecureRandom r;
    int[][] tile;
    int[][][] board;
    boolean[][][] match;
    int N;
    int C;
    String[] tileString;
    String[] ret;
    static String exec;
    static String file;
    static String diff;
    static double diffsc;
    static Process proc;
    InputStream is;
    OutputStream os;

    static int join(int n, int n2, int n3) {
        return n << 16 | n2 << 8 | n3;
    }

    static int color(double d) {
        double d2;
        double d3;
        double d4;
        if (d < 0.16666666666666666) {
            d4 = d * 6.0;
            d3 = 0.0;
            d2 = 0.0;
        } else if (d < 0.3333333333333333) {
            d4 = 1.0;
            d3 = 0.0;
            d2 = (d - 0.16666666666666666) * 6.0;
        } else if (d < 0.5) {
            d4 = 1.0 - (d - 0.3333333333333333) * 6.0;
            d3 = 0.0;
            d2 = 1.0;
        } else if (d < 0.6666666666666666) {
            d4 = 0.0;
            d3 = (d - 0.5) * 6.0;
            d2 = 1.0;
        } else if (d < 0.8333333333333334) {
            d4 = 0.0;
            d3 = 1.0;
            d2 = 1.0 - (d - 0.6666666666666666) * 6.0;
        } else {
            d3 = 1.0;
            d4 = (d - 0.8333333333333334) * 6.0;
            d2 = (d - 0.8333333333333334) * 6.0;
        }
        return TilesPuzzleVis.join((int)(255.99 * d3), (int)(255.99 * d2), (int)(255.99 * d4));
    }

    void generate(String string) {
        try {
            int n;
            int n2;
            int n3;
            this.r = SecureRandom.getInstance("SHA1PRNG");
            this.r.setSeed(Long.parseLong(string));
            this.N = this.r.nextInt(13) + 8;
            this.C = this.r.nextInt(21) + 10;
            this.tile = new int[this.N * this.N][4];
            this.board = new int[this.N][this.N][4];
            this.match = new boolean[this.N][this.N][4];
            int[][] nArray = new int[this.N][this.N];
            for (n3 = 0; n3 < this.N; ++n3) {
                for (n2 = 0; n2 < this.N; ++n2) {
                    nArray[n2][n3] = 0;
                    this.board[n2][n3][0] = n3 == 0 ? this.r.nextInt(this.C) : this.board[n2][n3 - 1][2];
                    this.board[n2][n3][1] = this.r.nextInt(this.C);
                    this.board[n2][n3][2] = this.r.nextInt(this.C);
                    this.board[n2][n3][3] = n2 == 0 ? this.r.nextInt(this.C) : this.board[n2 - 1][n3][1];
                    for (n = 0; n < 4; ++n) {
                        this.match[n2][n3][n] = false;
                    }
                }
            }
            System.out.println("N = " + this.N + "\nC = " + this.C);
            this.tileString = new String[this.N * this.N];
            for (n3 = 0; n3 < this.N * this.N; ++n3) {
                while (nArray[n2 = this.r.nextInt(this.N)][n = this.r.nextInt(this.N)] == 1) {
                }
                nArray[n2][n] = 1;
                int n4 = this.r.nextInt(4);
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < 4; ++i) {
                    this.tile[n3][i] = this.board[n2][n][i + n4 & 3];
                    stringBuffer.append(this.tile[n3][i]);
                    if (i >= 3) continue;
                    stringBuffer.append(' ');
                }
                this.tileString[n3] = stringBuffer.toString();
            }
        }
        catch (Exception exception) {
            System.err.println("An exception occured while generating the test case.");
            exception.printStackTrace();
        }
    }

    public double runTest(String string) {
        try {
            int n;
            int n2;
            this.generate(string);
            this.ret = this.solvePuzzle(this.N, this.tileString);
            if (this.ret.length != this.N * this.N) {
                throw new Exception("Not enough elements in return.");
            }
            int[] nArray = new int[this.N * this.N];
            for (n2 = 0; n2 < this.N * this.N; ++n2) {
                nArray[n2] = 0;
            }
            for (n2 = 0; n2 < this.N * this.N; ++n2) {
                String[] stringArray = this.ret[n2].split(" ");
                if (stringArray.length != 2) {
                    throw new Exception("Your return must be formatted as \"TileNumber Rotation\".");
                }
                n = Integer.parseInt(stringArray[0]);
                int n3 = Integer.parseInt(stringArray[1]);
                if (n < 0 || n >= this.N * this.N) {
                    throw new Exception("Tile Number " + n + " out of range.");
                }
                if (n3 < 0 || n3 >= 4) {
                    throw new Exception("Tile Number " + n + " rotation of " + n3 + " is out of range.");
                }
                if (nArray[n] == 1) {
                    throw new Exception("Tile Number " + n + " used more than once.");
                }
                for (int i = 0; i < 4; ++i) {
                    this.board[n2 % this.N][n2 / this.N][i] = this.tile[n][(4 + i - n3) % 4];
                }
                nArray[n] = 1;
            }
            n2 = 0;
            for (int i = 0; i < this.N; ++i) {
                for (n = 0; n < this.N; ++n) {
                    if (n < this.N - 1 && this.board[n][i][1] == this.board[n + 1][i][3]) {
                        this.match[n + 1][i][3] = true;
                        this.match[n][i][1] = true;
                        ++n2;
                    }
                    if (i >= this.N - 1 || this.board[n][i][2] != this.board[n][i + 1][0]) continue;
                    this.match[n][i + 1][0] = true;
                    this.match[n][i][2] = true;
                    ++n2;
                }
            }
            System.out.println("Number of edges matched = " + n2 + " of " + this.N * (this.N - 1) * 2);
            double d = (double)n2 / ((double)this.N * ((double)this.N - 1.0) * 2.0);
            return d;
        }
        catch (Exception exception) {
            System.err.println("An exception occurred while trying to get your program's results.");
            exception.printStackTrace();
            return 0.0;
        }
    }

    public String[] solvePuzzle(int n, String[] stringArray) throws IOException {
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(n).append('\n');
        for (n2 = 0; n2 < n * n; ++n2) {
            stringBuffer.append(stringArray[n2]).append('\n');
        }
        this.os.write(stringBuffer.toString().getBytes());
        this.os.flush();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.is));
        String[] stringArray2 = new String[n * n];
        for (n2 = 0; n2 < n * n; ++n2) {
            stringArray2[n2] = bufferedReader.readLine();
        }
        return stringArray2;
    }

    BufferedImage drawPuzzle() {
        int n = 40;
        int n2 = n / 2;
        BufferedImage bufferedImage = new BufferedImage(this.N * n, this.N * n, 1);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.setFont(new Font("Arial", 1, 10));
        int[] nArray = new int[4];
        int[] nArray2 = new int[4];
        for (int i = 0; i < this.N; ++i) {
            for (int j = 0; j < this.N; ++j) {
                nArray[0] = j * n + n2;
                nArray2[0] = i * n + n2;
                nArray[1] = nArray[0] - n2;
                nArray2[1] = nArray2[0] - n2;
                nArray[2] = nArray[1] + n;
                nArray2[2] = nArray2[1];
                graphics2D.setColor(new Color(TilesPuzzleVis.color((double)this.board[j][i][0] / (double)this.C)));
                graphics2D.fillPolygon(nArray, nArray2, 3);
                nArray[1] = nArray[0] + n2;
                nArray2[1] = nArray2[0] - n2;
                nArray[2] = nArray[1];
                nArray2[2] = nArray2[1] + n;
                graphics2D.setColor(new Color(TilesPuzzleVis.color((double)this.board[j][i][1] / (double)this.C)));
                graphics2D.fillPolygon(nArray, nArray2, 3);
                nArray[1] = nArray[0] - n2;
                nArray2[1] = nArray2[0] + n2;
                nArray[2] = nArray[1] + n;
                nArray2[2] = nArray2[1];
                graphics2D.setColor(new Color(TilesPuzzleVis.color((double)this.board[j][i][2] / (double)this.C)));
                graphics2D.fillPolygon(nArray, nArray2, 3);
                nArray[1] = nArray[0] - n2;
                nArray2[1] = nArray2[0] - n2;
                nArray[2] = nArray[1];
                nArray2[2] = nArray2[1] + n;
                graphics2D.setColor(new Color(TilesPuzzleVis.color((double)this.board[j][i][3] / (double)this.C)));
                graphics2D.fillPolygon(nArray, nArray2, 3);
                graphics2D.setColor(Color.BLACK);
                graphics2D.drawRect(j * n, i * n, n, n);
                graphics2D.setColor(this.match[j][i][0] ? Color.WHITE : Color.RED);
                String string = Integer.toString(this.board[j][i][0]);
                char[] cArray = string.toCharArray();
                graphics2D.drawChars(cArray, 0, string.length(), j * n + n2 + 3 - string.length() * 5, i * n + n2 / 2);
                graphics2D.setColor(this.match[j][i][1] ? Color.WHITE : Color.RED);
                string = Integer.toString(this.board[j][i][1]);
                cArray = string.toCharArray();
                graphics2D.drawChars(cArray, 0, string.length(), j * n + n - 3 - string.length() * 5, i * n + n2 + 5);
                graphics2D.setColor(this.match[j][i][2] ? Color.WHITE : Color.RED);
                string = Integer.toString(this.board[j][i][2]);
                cArray = string.toCharArray();
                graphics2D.drawChars(cArray, 0, string.length(), j * n + n2 + 3 - string.length() * 5, i * n + n2 + n2 / 2 + 5);
                graphics2D.setColor(this.match[j][i][3] ? Color.WHITE : Color.RED);
                string = Integer.toString(this.board[j][i][3]);
                cArray = string.toCharArray();
                graphics2D.drawChars(cArray, 0, string.length(), j * n + n2 / 2 + 3 - string.length() * 5, i * n + n2 + 5);
            }
        }
        return bufferedImage;
    }

    public TilesPuzzleVis(String string) throws IOException {
        Object object;
        if (exec != null) {
            try {
                object = Runtime.getRuntime();
                proc = ((Runtime)object).exec(exec);
                this.os = proc.getOutputStream();
                this.is = proc.getInputStream();
                new ErrorReader(proc.getErrorStream()).start();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        System.out.println("Score = " + this.runTest(string));
        if (file != null) {
            object = this.drawPuzzle();
            if (file.equals("-")) {
                JFrame jFrame = new JFrame();
                jFrame.setSize(40 * this.N, 40 * this.N);
                jFrame.getContentPane().add(new JPanel((BufferedImage)object){
                    final /* synthetic */ BufferedImage val$bi;
                    {
                        this.val$bi = bufferedImage;
                    }

                    public void paint(Graphics graphics) {
                        graphics.drawImage(this.val$bi, 0, 0, null);
                    }
                });
                jFrame.setDefaultCloseOperation(3);
                jFrame.setVisible(true);
            } else {
                ImageIO.write((RenderedImage)object, "png", new File(file + ".png"));
            }
        }
    }

    public static void main(String[] stringArray) throws IOException {
        String string = "1";
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-seed")) {
                string = stringArray[++i];
            }
            if (stringArray[i].equals("-exec")) {
                exec = stringArray[++i];
            }
            if (!stringArray[i].equals("-vis")) continue;
            file = stringArray[++i];
        }
        TilesPuzzleVis tilesPuzzleVis = new TilesPuzzleVis(string);
    }

    void addFatalError(String string) {
        System.out.println(string);
    }
}

