/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.security.SecureRandom;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class TilesMatchingVis {
    int N;
    int S;
    int D;
    int nd;
    int nt;
    int nm;
    int sc;
    String[][] board;
    String newt;
    String errmes;
    static String exec;
    static boolean vis;
    static boolean manual;
    static Process proc;
    static int del;
    int phase;
    InputStream is;
    OutputStream os;
    BufferedReader br;
    JFrame jf;
    Vis v;
    String visret;

    boolean validMove(int n, int n2) {
        int[] nArray = new int[]{1, 0, -1, 0};
        int[] nArray2 = new int[]{0, -1, 0, 1};
        this.errmes = null;
        if (n < 0 || n >= this.S) {
            this.errmes = "row must be between 0 and " + (this.S - 1) + ", inclusive.";
            return false;
        }
        if (n2 < 0 || n2 >= this.S) {
            this.errmes = "col must be between 0 and " + (this.S - 1) + ", inclusive.";
            return false;
        }
        if (this.newt.equals("R")) {
            if (this.board[n][n2] == null) {
                this.errmes = "A tile can not be removed from an empty cell.";
                return false;
            }
            return true;
        }
        if (this.nt == 0) {
            return true;
        }
        if (this.board[n][n2] != null) {
            this.errmes = "A tile can be placed only in an empty cell.";
            return false;
        }
        boolean bl = false;
        for (int i = 0; i < 4; ++i) {
            if (n + nArray[i] < 0 || n + nArray[i] >= this.S || n2 + nArray2[i] < 0 || n2 + nArray2[i] >= this.S || this.board[n + nArray[i]][n2 + nArray2[i]] == null) continue;
            bl = true;
            if (this.newt.equals("W") || this.board[n + nArray[i]][n2 + nArray2[i]].equals("W")) continue;
            boolean bl2 = false;
            for (int j = 0; j < 2; ++j) {
                if (this.newt.charAt(j) != this.board[n + nArray[i]][n2 + nArray2[i]].charAt(j)) continue;
                bl2 = true;
            }
            if (bl2) continue;
            this.errmes = "Placed tile must match all neighboring tiles.";
            return false;
        }
        if (!bl) {
            this.errmes = "Placed tile must neighbor at least one tile.";
            return false;
        }
        return true;
    }

    boolean validReturn(String string) {
        int n;
        int n2;
        this.errmes = null;
        if (string.equals("GIVE UP")) {
            return true;
        }
        if (string.equals("DISCARD")) {
            if (this.nd == this.D) {
                this.errmes = "You can't discard more than " + this.D + " tiles.";
                return false;
            }
            return true;
        }
        try {
            String[] stringArray = string.split(" ");
            if (stringArray.length != 2) {
                this.errmes = "Your return must be formatted as \"ROW COL\".";
                return false;
            }
            n2 = Integer.parseInt(stringArray[0]);
            n = Integer.parseInt(stringArray[1]);
        }
        catch (Exception exception) {
            this.errmes = "Your return must be formatted as \"ROW COL\".";
            return false;
        }
        return this.validMove(n2, n);
    }

    /*
     * Unable to fully structure code
     */
    public double runTest(String var1_1) {
        try {
            var2_2 = SecureRandom.getInstance("SHA1PRNG");
            var2_2.setSeed(Long.parseLong(var1_1));
            this.N = var2_2.nextInt(7) + 4;
            this.S = var2_2.nextInt(5) + 8;
            this.D = var2_2.nextInt(3) + 2;
            if (TilesMatchingVis.vis) {
                this.jf.setSize(this.S * 40 + 200, this.S * 40 + 30);
                this.v.repaint();
                this.jf.setVisible(true);
            }
            this.init(this.N, this.S, this.D);
            this.board = new String[this.S][this.S];
            this.sc = 0;
            this.nm = 0;
            this.nd = 0;
            this.nt = 0;
            var3_4 = 10000;
            do lbl-1000:
            // 3 sources

            {
                block18: {
                    var4_5 = var2_2.nextInt(30 - this.N + 2);
                    this.newt = this.nt == 0 || var4_5 == 0 ? "W" : (var4_5 == 1 ? "R" : new String(new char[]{(char)(var2_2.nextInt(this.N) + 48), (char)(var2_2.nextInt(this.N) + 48)}));
                    if (TilesMatchingVis.del > 0 || TilesMatchingVis.manual) {
                        this.draw(1);
                    }
                    if (!this.validReturn(var9_10 = this.placeTile(this.newt))) {
                        this.addFatalError(this.errmes);
                        return 0.0;
                    }
                    if (var9_10.equals("GIVE UP")) break;
                    ++this.nm;
                    if (!var9_10.equals("DISCARD")) break block18;
                    ++this.nd;
                    this.draw(2);
                    if (this.nm != var3_4) ** GOTO lbl-1000
                    break;
                }
                var10_11 = var9_10.split(" ");
                var5_6 = Integer.parseInt(var10_11[0]);
                var6_7 = Integer.parseInt(var10_11[1]);
                if (this.newt.equals("R")) {
                    this.board[var5_6][var6_7] = null;
                    --this.nt;
                } else {
                    this.board[var5_6][var6_7] = this.newt;
                    ++this.nt;
                    var8_9 = true;
                    var7_8 = true;
                    for (var4_5 = 0; var4_5 < this.S; ++var4_5) {
                        if (this.board[var5_6][var4_5] == null) {
                            var7_8 = false;
                        }
                        if (this.board[var4_5][var6_7] != null) continue;
                        var8_9 = false;
                    }
                    if (var7_8) {
                        for (var4_5 = 0; var4_5 < this.S; ++var4_5) {
                            this.board[var5_6][var4_5] = null;
                        }
                    }
                    if (var8_9) {
                        for (var4_5 = 0; var4_5 < this.S; ++var4_5) {
                            this.board[var4_5][var6_7] = null;
                        }
                    }
                    if (var7_8 & var8_9) {
                        this.nt -= 2 * this.S - 1;
                        this.sc += 3 * this.S;
                    } else if (var7_8 || var8_9) {
                        this.nt -= this.S;
                        this.sc += this.S;
                    }
                }
                ++this.sc;
                if (this.nd > 0) {
                    --this.nd;
                }
                this.draw(2);
            } while (this.nm != var3_4);
            return this.sc;
        }
        catch (Exception var2_3) {
            System.err.println("An exception occurred while trying to get your program's results.");
            var2_3.printStackTrace();
            return 0.0;
        }
    }

    public String checkData(String string) {
        return "";
    }

    public String displayTestCase(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("seed = " + string);
        return stringBuffer.toString();
    }

    public double[] score(double[][] dArray) {
        int n;
        double[] dArray2 = new double[dArray.length];
        for (n = 0; n < dArray.length; ++n) {
            dArray2[n] = 0.0;
        }
        if (dArray.length <= 1) {
            return dArray2;
        }
        for (int i = 0; i < dArray[0].length; ++i) {
            for (n = 0; n < dArray.length; ++n) {
                for (int j = n + 1; j < dArray.length; ++j) {
                    if (dArray[n][i] > dArray[j][i]) {
                        int n2 = n;
                        dArray2[n2] = dArray2[n2] + 1.0;
                        continue;
                    }
                    if (dArray[n][i] < dArray[j][i]) {
                        int n3 = j;
                        dArray2[n3] = dArray2[n3] + 1.0;
                        continue;
                    }
                    int n4 = n;
                    dArray2[n4] = dArray2[n4] + 0.5;
                    int n5 = j;
                    dArray2[n5] = dArray2[n5] + 0.5;
                }
            }
        }
        n = 0;
        while (n < dArray.length) {
            int n6 = n++;
            dArray2[n6] = dArray2[n6] / (double)(dArray.length - 1);
        }
        return dArray2;
    }

    int init(int n, int n2, int n3) throws IOException {
        if (!manual) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(n).append('\n');
            stringBuffer.append(n2).append('\n');
            stringBuffer.append(n3).append('\n');
            this.os.write(stringBuffer.toString().getBytes());
            this.os.flush();
        }
        return 0;
    }

    String placeTile(String string) throws IOException {
        if (!manual) {
            this.os.write((string + "\n").getBytes());
            this.os.flush();
            return this.br.readLine();
        }
        while (this.visret == null) {
            try {
                Thread.sleep(50L);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        String string2 = this.visret;
        this.visret = null;
        return string2;
    }

    int color(char c) {
        if (c == '0') {
            return 0x4040D0;
        }
        if (c == '1') {
            return 0xF0F080;
        }
        if (c == '2') {
            return 14315734;
        }
        if (c == '3') {
            return 65407;
        }
        if (c == '4') {
            return 6335728;
        }
        if (c == '5') {
            return 16750866;
        }
        if (c == '6') {
            return 9448432;
        }
        if (c == '7') {
            return 0xF03030;
        }
        if (c == '8') {
            return 1089296;
        }
        if (c == '9') {
            return 11554829;
        }
        return 0xFFFFFF;
    }

    void drawTile(Graphics2D graphics2D, String string, int n, int n2) {
        graphics2D.setColor(new Color(this.color(string.charAt(0))));
        graphics2D.fillRect(n2, n, 39, 39);
        graphics2D.setColor(Color.BLACK);
        char[] cArray = string.equals("W") || string.equals("R") ? new char[]{string.charAt(0)} : new char[]{string.charAt(1)};
        graphics2D.setFont(new Font("Arial", 1, 18));
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        graphics2D.drawChars(cArray, 0, 1, n2 + 19 - fontMetrics.charWidth(cArray[0]) / 2, n + 15 + fontMetrics.getHeight() / 2);
    }

    void draw(int n) {
        if (!vis) {
            return;
        }
        this.phase = n;
        this.v.repaint();
        if (del > 0) {
            try {
                Thread.sleep(del);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public TilesMatchingVis(String string) {
        if (vis) {
            this.jf = new JFrame();
            this.v = new Vis();
            this.jf.getContentPane().add(this.v);
        }
        if (exec != null) {
            try {
                Runtime runtime = Runtime.getRuntime();
                proc = runtime.exec(exec);
                this.os = proc.getOutputStream();
                this.is = proc.getInputStream();
                this.br = new BufferedReader(new InputStreamReader(this.is));
                new ErrorReader(proc.getErrorStream()).start();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        System.out.println("Score = " + this.runTest(string));
        if (proc != null) {
            try {
                proc.destroy();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (manual) {
            System.exit(0);
        }
    }

    public static void main(String[] stringArray) {
        String string = "1";
        vis = true;
        manual = false;
        del = 100;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-seed")) {
                string = stringArray[++i];
            }
            if (stringArray[i].equals("-exec")) {
                exec = stringArray[++i];
            }
            if (stringArray[i].equals("-novis")) {
                vis = false;
            }
            if (stringArray[i].equals("-manual")) {
                manual = true;
            }
            if (!stringArray[i].equals("-delay")) continue;
            del = Integer.parseInt(stringArray[++i]);
        }
        if (exec == null) {
            manual = true;
        }
        if (manual) {
            vis = true;
            del = 0;
            exec = null;
        }
        TilesMatchingVis tilesMatchingVis = new TilesMatchingVis(string);
    }

    void addFatalError(String string) {
        System.out.println(string);
    }

    public class Vis
    extends JPanel
    implements MouseListener,
    WindowListener {
        public void paint(Graphics graphics) {
            if (TilesMatchingVis.this.newt == null) {
                return;
            }
            BufferedImage bufferedImage = new BufferedImage(TilesMatchingVis.this.S * 40 + 200, TilesMatchingVis.this.S * 40 + 10, 1);
            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
            graphics2D.setColor(Color.LIGHT_GRAY);
            graphics2D.fillRect(0, 0, TilesMatchingVis.this.S * 40 + 200, TilesMatchingVis.this.S * 40 + 10);
            graphics2D.setColor(Color.BLACK);
            for (int i = 0; i <= TilesMatchingVis.this.S; ++i) {
                graphics2D.drawLine(i * 40, 0, i * 40, TilesMatchingVis.this.S * 40);
                graphics2D.drawLine(0, i * 40, TilesMatchingVis.this.S * 40, i * 40);
            }
            for (int i = 0; i < TilesMatchingVis.this.S; ++i) {
                for (int j = 0; j < TilesMatchingVis.this.S; ++j) {
                    if (TilesMatchingVis.this.board[i][j] == null) {
                        if (TilesMatchingVis.this.phase != 1 || !TilesMatchingVis.this.validMove(i, j)) continue;
                        graphics2D.setColor(new Color(0xDDDDDD));
                        graphics2D.fillRect(j * 40 + 1, i * 40 + 1, 39, 39);
                        continue;
                    }
                    TilesMatchingVis.this.drawTile(graphics2D, TilesMatchingVis.this.board[i][j], i * 40 + 1, j * 40 + 1);
                }
            }
            if (TilesMatchingVis.this.phase == 1) {
                graphics2D.setColor(Color.BLACK);
                graphics2D.drawRect(TilesMatchingVis.this.S * 40 + 80, 0, 40, 40);
                TilesMatchingVis.this.drawTile(graphics2D, TilesMatchingVis.this.newt, 1, TilesMatchingVis.this.S * 40 + 81);
            }
            graphics2D.setColor(Color.BLACK);
            graphics2D.setFont(new Font("Arial", 1, 18));
            char[] cArray = "Next:".toCharArray();
            graphics2D.drawChars(cArray, 0, 5, TilesMatchingVis.this.S * 40 + 20, 28);
            cArray = (TilesMatchingVis.this.N + " colors").toCharArray();
            graphics2D.drawChars(cArray, 0, cArray.length, TilesMatchingVis.this.S * 40 + 20, 68);
            cArray = ("Discarded: " + TilesMatchingVis.this.nd + " of " + TilesMatchingVis.this.D).toCharArray();
            graphics2D.drawChars(cArray, 0, cArray.length, TilesMatchingVis.this.S * 40 + 20, 108);
            cArray = ("Score: " + TilesMatchingVis.this.sc).toCharArray();
            graphics2D.drawChars(cArray, 0, cArray.length, TilesMatchingVis.this.S * 40 + 20, 148);
            graphics.drawImage(bufferedImage, 0, 0, TilesMatchingVis.this.S * 40 + 200, TilesMatchingVis.this.S * 40 + 10, null);
        }

        public Vis() {
            this.addMouseListener(this);
            TilesMatchingVis.this.jf.addWindowListener(this);
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (!manual) {
                return;
            }
            int n = mouseEvent.getY() / 40;
            int n2 = mouseEvent.getX() / 40;
            TilesMatchingVis.this.visret = null;
            if (n == 3 && n2 >= TilesMatchingVis.this.S) {
                TilesMatchingVis.this.visret = "GIVE UP";
            }
            if (n == 2 && n2 >= TilesMatchingVis.this.S) {
                if (TilesMatchingVis.this.nd < TilesMatchingVis.this.D) {
                    TilesMatchingVis.this.visret = "DISCARD";
                } else {
                    System.out.println("You can't discard more than " + TilesMatchingVis.this.D + " tiles.");
                }
            }
            if (n >= 0 && n < TilesMatchingVis.this.S && n2 >= 0 && n2 < TilesMatchingVis.this.S) {
                if (TilesMatchingVis.this.validMove(n, n2)) {
                    TilesMatchingVis.this.visret = n + " " + n2;
                } else if (TilesMatchingVis.this.errmes != null) {
                    System.out.println(TilesMatchingVis.this.errmes);
                }
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void windowClosing(WindowEvent windowEvent) {
            if (proc != null) {
                try {
                    proc.destroy();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            System.exit(0);
        }

        public void windowActivated(WindowEvent windowEvent) {
        }

        public void windowDeactivated(WindowEvent windowEvent) {
        }

        public void windowOpened(WindowEvent windowEvent) {
        }

        public void windowClosed(WindowEvent windowEvent) {
        }

        public void windowIconified(WindowEvent windowEvent) {
        }

        public void windowDeiconified(WindowEvent windowEvent) {
        }
    }
}

