/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.security.SecureRandom;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class TerrainCrossingVis {
    static int maxSize = 50;
    static int minSize = 10;
    static int maxTypes = 10;
    static int minTypes = 2;
    static int minItems = 5;
    static int maxCap = 10;
    static int minCap = 1;
    int maxItems;
    int S;
    int T;
    String[] map;
    int N;
    Location[] loc;
    boolean[] locused;
    int C;
    Location[] path;
    JFrame jf;
    Vis v;
    static String exec;
    static boolean vis;
    static boolean debug;
    static Process proc;
    InputStream is;
    OutputStream os;
    BufferedReader br;
    static int SZ;
    static int W;
    static int H;
    int[] cs = new int[]{15060895, 15119466, 15179830, 14388245, 12549157, 10315301, 7818523, 5976327, 3547655, 1576450};

    double getRandInsideCell(SecureRandom secureRandom) {
        return (double)secureRandom.nextInt(this.S) + 0.001 + secureRandom.nextDouble() * 0.998;
    }

    void generate(String string) {
        try {
            int n;
            int n2;
            int n3;
            int n4;
            SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
            long l = Long.parseLong(string);
            secureRandom.setSeed(l);
            this.S = secureRandom.nextInt(maxSize - minSize + 1) + minSize;
            this.maxItems = this.S * this.S / 10;
            this.T = secureRandom.nextInt(maxTypes - minTypes + 1) + minTypes;
            this.N = secureRandom.nextInt(this.maxItems - minItems + 1) + minItems;
            this.C = secureRandom.nextInt(maxCap - minCap + 1) + minCap;
            if (l == 1L) {
                this.S = 5;
                this.T = 3;
                this.N = 4;
                this.C = 2;
            } else if (l <= 3L) {
                this.S = minSize * (int)l;
                this.T = minTypes + 2 * (int)(l - 1L);
                this.N = minItems * (int)l;
                this.C = minCap * (int)l;
            } else if (l == 4L) {
                this.S = maxSize;
                this.T = maxTypes;
                this.N = this.S * this.S / 10;
                this.C = maxCap;
            }
            char[][] cArray = new char[this.S][this.S];
            double[][] dArray = new double[this.S + 2][this.S + 2];
            for (n4 = 0; n4 < this.S + 2; ++n4) {
                for (n3 = 0; n3 < this.S + 2; ++n3) {
                    dArray[n4][n3] = secureRandom.nextDouble();
                }
            }
            n4 = secureRandom.nextInt(this.T);
            if (l == 1L) {
                n4 = 0;
            }
            for (n3 = 0; n3 < n4; ++n3) {
                for (int i = 1; i <= this.S; ++i) {
                    for (n2 = 1; n2 <= this.S; ++n2) {
                        dArray[i][n2] = 0.6 * dArray[i][n2] + 0.1 * (dArray[i - 1][n2] + dArray[i + 1][n2] + dArray[i][n2 - 1] + dArray[i][n2 + 1]);
                    }
                }
            }
            double d = 0.0;
            for (n2 = 1; n2 <= this.S; ++n2) {
                for (n = 1; n <= this.S; ++n) {
                    d = Math.max(d, dArray[n2][n]);
                }
            }
            for (n2 = 0; n2 < this.S; ++n2) {
                for (n = 0; n < this.S; ++n) {
                    cArray[n2][n] = (char)(48 + (int)(dArray[n2 + 1][n + 1] * (double)(this.T - 1) / d));
                }
            }
            this.map = new String[this.S];
            for (n2 = 0; n2 < this.S; ++n2) {
                this.map[n2] = new String(cArray[n2]);
            }
            this.locused = new boolean[2 * this.N];
            this.loc = new Location[2 * this.N];
            for (n2 = 0; n2 < 2 * this.N; ++n2) {
                block13: do {
                    n = 1;
                    this.loc[n2] = new Location(this.getRandInsideCell(secureRandom), this.getRandInsideCell(secureRandom));
                    for (int i = 0; i < n2; ++i) {
                        if (!this.loc[n2].near(this.loc[i], 0.003)) continue;
                        n = 0;
                        continue block13;
                    }
                } while (n == 0);
            }
            if (debug) {
                System.out.println("Size of terrain S = " + this.S);
                System.out.println("Number of terrain types T = " + this.T);
                System.out.println("Terrain: ");
                for (String object : this.map) {
                    System.out.println(object);
                }
                System.out.println("Capacity C = " + this.C);
                System.out.println("Number of items N = " + this.N);
                System.out.println("Locations:");
                for (Location location : this.loc) {
                    System.out.println(location.toString());
                }
            }
            if (vis) {
                W = this.S * SZ + 40;
                H = this.S * SZ + 40;
                this.jf.setSize(W, H);
                this.jf.setVisible(true);
                this.v.repaint();
            }
        }
        catch (Exception exception) {
            System.err.println("An exception occurred while generating test case.");
            exception.printStackTrace();
        }
    }

    boolean isNearOuterBorder(Location location) {
        return !(location.x >= 0.001 && location.x <= (double)this.S - 0.001 && location.y >= 0.001 && location.y <= (double)this.S - 0.001);
    }

    boolean isNearInnerBorder(Location location) {
        double d = location.x - (double)location.xi;
        double d2 = location.y - (double)location.yi;
        return location.xi > 0 && d < 0.001 || location.yi > 0 && d2 < 0.001 || location.xi < this.S - 1 && 1.0 - d < 0.001 || location.yi < this.S - 1 && 1.0 - d2 < 0.001;
    }

    int terrainType(Location location) {
        return this.map[location.yi].charAt(location.xi) - 48;
    }

    double scoreSeg(Location location, Location location2) {
        double d;
        double d2;
        if (location.manhattan(location2) == 0) {
            return location.dist(location2) * (double)this.terrainType(location);
        }
        int n = this.terrainType(location);
        int n2 = this.terrainType(location2);
        double d3 = Math.pow(n - n2, 2.0);
        if (location.yi == location2.yi) {
            d2 = Math.max(location.xi, location2.xi);
            d = location.y + (location2.y - location.y) * (d2 - location.x) / (location2.x - location.x);
        } else {
            d = Math.max(location.yi, location2.yi);
            d2 = location.x + (location2.x - location.x) * (d - location.y) / (location2.y - location.y);
        }
        Location location3 = new Location(d2, d);
        return d3 + location.dist(location3) * (double)n + location2.dist(location3) * (double)n2;
    }

    public double runTest(String string) {
        try {
            int n;
            int n2;
            int n3;
            this.generate(string);
            double[] dArray = new double[4 * this.N];
            for (int i = 0; i < 2 * this.N; ++i) {
                dArray[2 * i] = this.loc[i].x;
                dArray[2 * i + 1] = this.loc[i].y;
            }
            double[] dArray2 = this.getPath(this.map, dArray, this.C);
            if (dArray2 == null || dArray2.length == 0) {
                this.addFatalError("Failed to get result from getPath.");
                return -1.0;
            }
            if (dArray2.length % 2 == 1) {
                this.addFatalError("Return from getPath must have even number of elements.");
                return -1.0;
            }
            int n4 = dArray2.length / 2;
            if (n4 < 2) {
                this.addFatalError("The path must have at least 2 points.");
                return -1.0;
            }
            int n5 = 4 * this.N * this.S * this.S;
            if (n4 > n5) {
                this.addFatalError("The path can have at most " + n5 + " points.");
                return -1.0;
            }
            this.path = new Location[n4];
            for (n3 = 0; n3 < n4; ++n3) {
                if (!(dArray2[2 * n3] > 0.0 && dArray2[2 * n3] < (double)this.S && dArray2[2 * n3 + 1] > 0.0 && dArray2[2 * n3 + 1] < (double)this.S)) {
                    this.addFatalError("Each point of path must be within the terrain.");
                    return -1.0;
                }
                this.path[n3] = new Location(dArray2[2 * n3], dArray2[2 * n3 + 1]);
            }
            if (vis) {
                this.v.repaint();
            }
            if (!this.isNearOuterBorder(this.path[0])) {
                this.addFatalError("The start point of the path must be within 0.001 from outer border.");
                return -1.0;
            }
            if (!this.isNearOuterBorder(this.path[n4 - 1])) {
                this.addFatalError("The end point of the path must be within 0.001 from outer border.");
                return -1.0;
            }
            for (n3 = 0; n3 < n4; ++n3) {
                if (!this.isNearInnerBorder(this.path[n3])) continue;
                this.addFatalError("Point " + n3 + " of the path cannot be within " + 0.001 + " from any inner cell border.");
                return -1.0;
            }
            for (n3 = 1; n3 < n4; ++n3) {
                if (!this.path[n3].near(this.path[n3 - 1], 0.001)) continue;
                this.addFatalError("Consecutive points of the path cannot be within 0.001 from each other.");
                return -1.0;
            }
            for (n3 = 1; n3 < n4; ++n3) {
                if (this.path[n3].manhattan(this.path[n3 - 1]) <= 1) continue;
                this.addFatalError("Each segment of the path cannot cross more than one cell boundary.");
                return -1.0;
            }
            n3 = 0;
            for (n2 = 0; n2 < n4; ++n2) {
                n = -1;
                for (int i = 0; i < 2 * this.N; ++i) {
                    if (!this.path[n2].near(this.loc[i], 0.001)) continue;
                    n = i;
                    break;
                }
                if (n == -1 || this.locused[n]) continue;
                if (n < this.N && n3 < this.C) {
                    ++n3;
                    this.locused[n] = true;
                    if (debug) {
                        System.out.println("Picked up item at location " + n + ". Carry = " + n3);
                    }
                }
                if (n < this.N || n3 <= 0) continue;
                --n3;
                this.locused[n] = true;
                if (!debug) continue;
                System.out.println("Dropped off item at location " + n + ". Carry = " + n3);
            }
            if (n3 != 0) {
                this.addFatalError("In the end of the path you must carry no items; you carry " + n3);
                return -1.0;
            }
            n2 = 0;
            for (n = 0; n < 2 * this.N; ++n) {
                n2 += this.locused[n] ? 0 : 1;
            }
            if (n2 > 0) {
                this.addFatalError("You must pick up all items and deliver them to all locations; you have " + n2 + " unused locations.");
                return -1.0;
            }
            double d = 0.0;
            for (int i = 1; i < n4; ++i) {
                d += this.scoreSeg(this.path[i - 1], this.path[i]);
            }
            return d;
        }
        catch (Exception exception) {
            System.err.println("An exception occurred while trying to get your program's results.");
            exception.printStackTrace();
            return -1.0;
        }
    }

    double[] getPath(String[] stringArray, double[] dArray, int n) throws IOException {
        int n2;
        if (proc == null) {
            return new double[0];
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(stringArray.length).append("\n");
        for (String string : stringArray) {
            stringBuffer.append(string).append("\n");
        }
        stringBuffer.append(dArray.length).append("\n");
        double[] n4 = dArray;
        int dArray2 = n4.length;
        for (n2 = 0; n2 < dArray2; ++n2) {
            double d = n4[n2];
            stringBuffer.append(d).append("\n");
        }
        stringBuffer.append(n).append("\n");
        this.os.write(stringBuffer.toString().getBytes());
        this.os.flush();
        int n3 = Integer.parseInt(this.br.readLine());
        double[] dArray3 = new double[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            dArray3[n2] = Double.parseDouble(this.br.readLine());
        }
        return dArray3;
    }

    int getCoord(double d) {
        return (int)Math.floor(d * (double)SZ);
    }

    public TerrainCrossingVis(String string) {
        try {
            if (vis) {
                this.jf = new JFrame();
                this.v = new Vis();
                this.jf.getContentPane().add(this.v);
            }
            if (exec != null) {
                try {
                    Runtime runtime = Runtime.getRuntime();
                    proc = runtime.exec(exec);
                    this.os = proc.getOutputStream();
                    this.is = proc.getInputStream();
                    this.br = new BufferedReader(new InputStreamReader(this.is));
                    new ErrorReader(proc.getErrorStream()).start();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            System.out.println("Score = " + this.runTest(string));
            if (proc != null) {
                try {
                    proc.destroy();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        String string = "1";
        vis = true;
        SZ = 20;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-seed")) {
                string = stringArray[++i];
            }
            if (stringArray[i].equals("-exec")) {
                exec = stringArray[++i];
            }
            if (stringArray[i].equals("-novis")) {
                vis = false;
            }
            if (stringArray[i].equals("-size")) {
                SZ = Integer.parseInt(stringArray[++i]);
            }
            if (!stringArray[i].equals("-debug")) continue;
            debug = true;
        }
        TerrainCrossingVis terrainCrossingVis = new TerrainCrossingVis(string);
    }

    void addFatalError(String string) {
        System.out.println(string);
    }

    public class Vis
    extends JPanel
    implements WindowListener {
        @Override
        public void paint(Graphics graphics) {
            int n;
            int n2;
            int n3;
            BufferedImage bufferedImage = new BufferedImage(W, H, 1);
            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
            graphics2D.setColor(new Color(0xDDDDDD));
            graphics2D.fillRect(0, 0, W, H);
            for (n3 = 0; n3 < TerrainCrossingVis.this.S; ++n3) {
                for (n2 = 0; n2 < TerrainCrossingVis.this.S; ++n2) {
                    graphics2D.setColor(new Color(TerrainCrossingVis.this.cs[TerrainCrossingVis.this.map[n3].charAt(n2) - 48]));
                    graphics2D.fillRect(n2 * SZ, n3 * SZ, SZ, SZ);
                }
            }
            graphics2D.setColor(Color.GREEN);
            for (n3 = 0; n3 < TerrainCrossingVis.this.N; ++n3) {
                n2 = TerrainCrossingVis.this.getCoord(TerrainCrossingVis.this.loc[n3].x);
                n = TerrainCrossingVis.this.getCoord(TerrainCrossingVis.this.loc[n3].y);
                graphics2D.fillOval(n2 - 2, n - 2, 4, 4);
            }
            graphics2D.setColor(Color.RED);
            for (n3 = 0; n3 < TerrainCrossingVis.this.N; ++n3) {
                n2 = TerrainCrossingVis.this.getCoord(TerrainCrossingVis.this.loc[n3 + TerrainCrossingVis.this.N].x);
                n = TerrainCrossingVis.this.getCoord(TerrainCrossingVis.this.loc[n3 + TerrainCrossingVis.this.N].y);
                graphics2D.fillOval(n2 - 2, n - 2, 4, 4);
            }
            if (TerrainCrossingVis.this.path != null) {
                graphics2D.setColor(Color.BLUE);
                for (n3 = 0; n3 < TerrainCrossingVis.this.path.length - 1; ++n3) {
                    graphics2D.drawLine(TerrainCrossingVis.this.getCoord(TerrainCrossingVis.this.path[n3].x), TerrainCrossingVis.this.getCoord(TerrainCrossingVis.this.path[n3].y), TerrainCrossingVis.this.getCoord(TerrainCrossingVis.this.path[n3 + 1].x), TerrainCrossingVis.this.getCoord(TerrainCrossingVis.this.path[n3 + 1].y));
                }
            }
            graphics.drawImage(bufferedImage, 0, 0, W, H, null);
        }

        public Vis() {
            TerrainCrossingVis.this.jf.addWindowListener(this);
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            if (proc != null) {
                try {
                    proc.destroy();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            System.exit(0);
        }

        @Override
        public void windowActivated(WindowEvent windowEvent) {
        }

        @Override
        public void windowDeactivated(WindowEvent windowEvent) {
        }

        @Override
        public void windowOpened(WindowEvent windowEvent) {
        }

        @Override
        public void windowClosed(WindowEvent windowEvent) {
        }

        @Override
        public void windowIconified(WindowEvent windowEvent) {
        }

        @Override
        public void windowDeiconified(WindowEvent windowEvent) {
        }
    }
}

