/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Random;

public class Tester {
    Random r;
    static boolean useCache = true;
    int[][] graph;
    int[] degree;
    int[] x;
    int[] y;
    int[] ids;
    int N;
    static Process proc;
    InputStream is;
    OutputStream os;
    BufferedReader br;

    int[] realloc(int[] nArray, int n) {
        int[] nArray2 = new int[n];
        System.arraycopy(nArray, 0, nArray2, 0, Math.min(nArray.length, n));
        return nArray2;
    }

    void addEdge(int n, int n2) {
        if (this.degree[n] == this.graph[n].length) {
            this.graph[n] = this.realloc(this.graph[n], this.degree[n] * 2);
        }
        int n3 = n;
        int n4 = this.degree[n3];
        this.degree[n3] = n4 + 1;
        this.graph[n][n4] = n2;
    }

    int[] uniq(int[] nArray, int n, boolean bl) {
        Arrays.sort(nArray, 0, n);
        int n2 = 0;
        for (int i = 1; i < n; ++i) {
            if (nArray[i] == nArray[i - 1]) {
                ++n2;
                continue;
            }
            nArray[i - n2] = nArray[i];
        }
        n -= n2;
        if (bl) {
            int[] nArray2 = new int[n];
            System.arraycopy(nArray, 0, nArray2, 0, n);
            return nArray2;
        }
        return new int[]{n};
    }

    double sq(double d) {
        return d * d;
    }

    void generate(String string) {
        int n;
        int n2;
        Object object;
        try {
            this.r = SecureRandom.getInstance("SHA1PRNG");
            this.r.setSeed(Long.parseLong(string));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        double d = -(this.r.nextDouble() * 2.0 + 1.0);
        int n3 = this.r.nextInt(29) + 2;
        this.N = this.r.nextInt(19001) + 1000;
        System.out.println("N = " + this.N);
        System.out.println("alpha = " + -d);
        System.out.println("deg = " + n3);
        if (useCache) {
            try {
                object = new File("cache." + string);
                if (((File)object).exists()) {
                    ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream((File)object));
                    this.graph = (int[][])objectInputStream.readObject();
                    this.degree = (int[])objectInputStream.readObject();
                    return;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.graph = new int[this.N][];
        this.degree = new int[this.N];
        this.x = new int[this.N];
        this.y = new int[this.N];
        object = new double[this.N];
        for (n2 = 0; n2 < this.N; ++n2) {
            this.x[n2] = this.r.nextInt(0x100000);
            this.y[n2] = this.r.nextInt(0x100000);
            this.graph[n2] = new int[1];
        }
        for (n2 = 0; n2 < this.N; ++n2) {
            double d2;
            for (n = 0; n < this.N; ++n) {
                d2 = this.sq(this.x[n2] - this.x[n]) + this.sq(this.y[n2] - this.y[n]);
                object[n] = n2 == n ? (Object)0.0 : (Object)Math.pow(Math.sqrt(d2) + 1.0, d);
            }
            for (n = 1; n < this.N; ++n) {
                Object object2 = object;
                int n4 = n;
                object2[n4] = object2[n4] + object[n - 1];
            }
            for (n = 0; n < n3; ++n) {
                d2 = this.r.nextDouble() * object[this.N - 1];
                int n5 = Arrays.binarySearch((double[])object, d2);
                if (n5 < 0) {
                    n5 = -n5 - 1;
                }
                this.addEdge(n2, n5);
                this.addEdge(n5, n2);
            }
        }
        n2 = 0;
        for (n = 0; n < this.N; ++n) {
            this.graph[n] = this.uniq(this.graph[n], this.degree[n], true);
            this.degree[n] = this.graph[n].length;
            n2 += this.degree[n];
        }
        System.out.println("Total degree of all vertices = " + n2);
        if (useCache) {
            try {
                File file = new File("cache." + string);
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(file));
                objectOutputStream.writeObject(this.graph);
                objectOutputStream.writeObject(this.degree);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    int bfs() {
        int[] nArray = new int[this.N];
        boolean[] blArray = new boolean[this.N];
        int n = 0;
        for (int i = 0; i < this.N; ++i) {
            if (blArray[i]) continue;
            int n2 = 0;
            int n3 = 1;
            nArray[0] = i;
            blArray[i] = true;
            while (n2 < n3) {
                int n4 = nArray[n2++];
                for (int j = 0; j < this.graph[n4].length; ++j) {
                    int n5 = this.graph[n4][j];
                    if (blArray[n5]) continue;
                    blArray[n5] = true;
                    nArray[n3++] = n5;
                }
            }
            if (n3 <= n) continue;
            n = n3;
        }
        return n;
    }

    void shuffle(int[] nArray) {
        for (int i = 1; i < nArray.length; ++i) {
            int n = this.r.nextInt(i + 1);
            int n2 = nArray[i];
            nArray[i] = nArray[n];
            nArray[n] = n2;
        }
    }

    int[][] sample(int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int[] nArray = new int[this.N];
        this.ids = new int[n];
        int[] nArray2 = new int[0x100000];
        int n6 = 0;
        int n7 = this.r.nextInt(this.N);
        nArray[n7] = 1;
        this.ids[0] = n7;
        for (n5 = 1; n5 < n; ++n5) {
            n4 = this.ids[n5 - 1];
            for (n3 = 0; n3 < this.degree[n4]; ++n3) {
                if (n6 == nArray2.length) {
                    nArray2 = this.realloc(nArray2, nArray2.length * 2);
                }
                nArray2[n6++] = this.graph[n4][n3];
            }
            n3 = 0;
            for (n2 = 0; n2 < n6; ++n2) {
                if (nArray[nArray2[n2]] != 0) continue;
                n3 = 1;
                break;
            }
            if (n3 == 0) {
                return null;
            }
            do {
                this.ids[n5] = nArray2[this.r.nextInt(n6)];
            } while (nArray[this.ids[n5]] == 1);
            nArray[this.ids[n5]] = 1;
        }
        this.shuffle(this.ids);
        for (n5 = 0; n5 < n; ++n5) {
            nArray[this.ids[n5]] = n5 + 1;
        }
        int[][] nArrayArray = new int[this.ids.length][];
        n4 = 0;
        for (n3 = 0; n3 < n; ++n3) {
            n2 = this.ids[n3];
            nArrayArray[n3] = new int[1];
            int n8 = 0;
            for (int i = 0; i < this.graph[n2].length; ++i) {
                int n9 = this.graph[n2][i];
                if (nArray[n9] <= 0) continue;
                if (n8 == nArrayArray[n3].length) {
                    nArrayArray[n3] = this.realloc(nArrayArray[n3], n8 * 2);
                }
                nArrayArray[n3][n8++] = nArray[n9] - 1;
            }
            nArrayArray[n3] = this.realloc(nArrayArray[n3], n8);
            n4 += n8;
            Arrays.sort(nArrayArray[n3]);
        }
        return nArrayArray;
    }

    int[] encode(int[][] nArray) {
        int n = 1;
        for (int i = 0; i < nArray.length; ++i) {
            n += nArray[i].length + 1;
        }
        int[] nArray2 = new int[n];
        int n2 = 0;
        nArray2[n2++] = nArray.length;
        for (int i = 0; i < nArray.length; ++i) {
            nArray2[n2++] = nArray[i].length;
            for (int j = 0; j < nArray[i].length; ++j) {
                nArray2[n2++] = nArray[i][j];
            }
        }
        return nArray2;
    }

    public boolean[][] subgraph(int[] nArray) {
        int n;
        int[] nArray2 = new int[this.N];
        boolean[][] blArray = new boolean[nArray.length][nArray.length];
        for (n = 0; n < nArray.length; ++n) {
            nArray2[nArray[n]] = n + 1;
        }
        for (n = 0; n < nArray.length; ++n) {
            int n2 = nArray[n];
            for (int i = 0; i < this.graph[n2].length; ++i) {
                int n3 = this.graph[n2][i];
                if (nArray2[n3] <= 0) continue;
                blArray[n][nArray2[n3] - 1] = true;
            }
        }
        return blArray;
    }

    public boolean[][] densify(int[][] nArray) {
        boolean[][] blArray = new boolean[nArray.length][nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < nArray[i].length; ++j) {
                blArray[i][nArray[i][j]] = true;
            }
        }
        return blArray;
    }

    int[] query(int[] nArray) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(nArray.length).append('\n');
        for (int i = 0; i < nArray.length; ++i) {
            stringBuffer.append(nArray[i]).append('\n');
        }
        this.os.write(stringBuffer.toString().getBytes());
        this.os.flush();
        int[] nArray2 = new int[nArray[0]];
        for (int i = 0; i < nArray2.length; ++i) {
            nArray2[i] = Integer.parseInt(this.br.readLine());
            if (nArray2[i] != -1) continue;
            return null;
        }
        return nArray2;
    }

    void initialize(int[] nArray) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(nArray.length).append('\n');
        for (int i = 0; i < nArray.length; ++i) {
            stringBuffer.append(nArray[i]).append('\n');
        }
        this.os.write(stringBuffer.toString().getBytes());
        this.os.flush();
    }

    boolean startProcess(String string) {
        try {
            Runtime runtime = Runtime.getRuntime();
            proc = runtime.exec(string);
            this.os = proc.getOutputStream();
            this.is = proc.getInputStream();
            this.br = new BufferedReader(new InputStreamReader(this.is));
            new ErrorReader(proc.getErrorStream()).start();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    public double runTest(String string, String string2) {
        if (!this.startProcess(string)) {
            return 0.0;
        }
        this.generate(string2);
        try {
            this.r = SecureRandom.getInstance("SHA1PRNG");
            this.r.setSeed(new Long(new Long(string2).hashCode()));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.initialize(this.encode(this.graph));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 0.0;
        }
        int n = this.bfs();
        for (int i = 5; i <= n; ++i) {
            int[][] nArray = this.sample(i);
            while (nArray == null) {
                nArray = this.sample(i);
            }
            int[] nArray2 = null;
            try {
                nArray2 = this.query(this.encode(nArray));
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return i - 5;
            }
            if (nArray2 == null) {
                return i - 5;
            }
            if (nArray2.length != i) {
                System.err.println("Invalid return");
                return i - 5;
            }
            for (int j = 0; j < i; ++j) {
                if (nArray2[j] < 0 || nArray2[j] >= this.N) {
                    System.err.println("Invalid return");
                    return i - 5;
                }
                for (int k = 0; k < j; ++k) {
                    if (nArray2[j] != nArray2[k]) continue;
                    System.err.println("Non-distinct elements in return.");
                    return i - 5;
                }
            }
            boolean[][] blArray = this.densify(nArray);
            boolean[][] blArray2 = this.subgraph(nArray2);
            for (int j = 0; j < i; ++j) {
                if (Arrays.equals(blArray2[j], blArray[j])) continue;
                System.err.println("Mismatch for query H" + i);
                return i - 5;
            }
            System.out.println("H" + i + " matched correctly!");
        }
        return n - 4;
    }

    static void usage() {
        System.err.println("Usage: java -jar Tester.jar -exec <cmd> -seed <seed> [-nocache]");
        System.exit(1);
    }

    public static void main(String[] stringArray) {
        Tester tester = new Tester();
        String string = null;
        String string2 = null;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-exec")) {
                if (i + 1 == stringArray.length) {
                    Tester.usage();
                }
                string = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-seed")) {
                if (i + 1 == stringArray.length) {
                    Tester.usage();
                }
                string2 = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-nocache")) {
                useCache = false;
                continue;
            }
            Tester.usage();
        }
        if (string == null || string2 == null) {
            Tester.usage();
        }
        System.out.println("Score = " + tester.runTest(string, string2));
        System.exit(0);
    }
}

