/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.security.SecureRandom;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class StarTravellerVis {
    final int SZ = 1024;
    int NStar;
    int NShip;
    int NUfo;
    Pnt[] star;
    int[] ship;
    int[] ufoParm;
    int[] starParm;
    int visited;
    double energy;
    int[] ufoRange;
    ArrayList<Integer> progress = new ArrayList();
    public static int delay = 100;
    public static boolean startPaused = true;
    public static boolean drawUfo = true;
    final Object worldLock = new Object();
    SecureRandom rnd = null;
    static String exec;
    static boolean vis;
    static Process proc;
    static String saveFile;
    JFrame jf;
    Vis v;
    InputStream is;
    OutputStream os;
    BufferedReader br;
    final int SZX = 1026;
    final int SZY = 1026;
    volatile boolean ready;
    volatile int Ncur;
    volatile int[] Pcur;
    int[][] coordToPoint;

    void calculateNextStar(int n) {
        for (int i = 0; i < this.NUfo; ++i) {
            int n2 = this.ufoParm[i * 3 + n - 1];
            int n3 = 0x40000000;
            int n4 = this.rnd.nextInt(this.NStar);
            for (int j = 0; j < this.ufoRange[i]; ++j) {
                int n5 = this.rnd.nextInt(this.NStar);
                int n6 = (this.star[n5].x - this.star[n2].x) * (this.star[n5].x - this.star[n2].x) + (this.star[n5].y - this.star[n2].y) * (this.star[n5].y - this.star[n2].y);
                if (n6 >= n3 || n6 <= 0) continue;
                n3 = n6;
                n4 = n5;
            }
            this.ufoParm[i * 3 + n] = n4;
        }
    }

    void generate(String string) {
        try {
            int n;
            int n2;
            this.rnd = SecureRandom.getInstance("SHA1PRNG");
            this.rnd.setSeed(Long.parseLong(string));
            if (string.equals("1")) {
                this.NStar = 20;
                this.NShip = 1;
                this.NUfo = 4;
                n2 = 3;
            } else {
                this.NStar = 100 + this.rnd.nextInt(1901);
                this.NShip = 1 + this.rnd.nextInt(10);
                this.NUfo = this.rnd.nextInt(this.NStar / 100);
                n2 = 1 + this.rnd.nextInt(16);
            }
            this.star = new Pnt[this.NStar];
            this.ship = new int[this.NShip];
            this.ufoParm = new int[3 * this.NUfo];
            this.starParm = new int[2 * this.NStar];
            System.out.println("NStar = " + this.NStar + " NShip = " + this.NShip + " NUfo = " + this.NUfo + " NGalaxy = " + n2);
            Pnt[] pntArray = new Pnt[n2];
            for (n = 0; n < n2; ++n) {
                pntArray[n] = new Pnt(this.rnd.nextInt(1024), this.rnd.nextInt(1024));
            }
            for (n = 0; n < this.NStar; ++n) {
                int n3 = 0;
                int n4 = 0;
                int n5 = this.rnd.nextInt(n2);
                do {
                    n3 = (int)(this.rnd.nextGaussian() * 100.0) + pntArray[n5].x;
                    n4 = (int)(this.rnd.nextGaussian() * 100.0) + pntArray[n5].y;
                } while (n3 < 0 || n4 < 0 || n3 >= 1024 || n4 >= 1024);
                this.star[n] = new Pnt(n3, n4);
            }
            for (n = 0; n < this.NShip; ++n) {
                this.ship[n] = this.rnd.nextInt(this.NStar);
            }
            this.ufoRange = new int[this.NUfo];
            for (n = 0; n < this.NUfo; ++n) {
                this.ufoRange[n] = 10 + this.rnd.nextInt(this.NStar / 10);
                this.ufoParm[n * 3] = this.rnd.nextInt(this.NStar);
            }
            this.calculateNextStar(1);
            this.calculateNextStar(2);
            for (n = 0; n < this.NStar; ++n) {
                this.starParm[n * 2] = this.star[n].x;
                this.starParm[n * 2 + 1] = this.star[n].y;
            }
            this.energy = 0.0;
            this.visited = 0;
        }
        catch (Exception exception) {
            this.addFatalError("An exception occurred while generating test case.");
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double runTest(String string) {
        try {
            this.generate(string);
            double d = -1.0;
            int n = 0;
            if (proc != null) {
                try {
                    int n2 = this.init(this.starParm);
                }
                catch (Exception exception) {
                    this.addFatalError("Failed to get result from init.");
                    return -1.0;
                }
                if (vis) {
                    this.jf.setSize(1026, 1026);
                    this.jf.setVisible(true);
                    this.draw();
                    if (startPaused) {
                        this.v.pauseMode = true;
                    }
                    this.v.processPause();
                }
                while (n < this.NStar * 4 && this.visited < this.NStar) {
                    int n3;
                    int[] nArray;
                    try {
                        nArray = this.makeMoves(this.ufoParm, this.ship);
                    }
                    catch (Exception exception) {
                        this.addFatalError("Move #" + n + ": Failed to get result from makeMoves.");
                        return -1.0;
                    }
                    if (nArray.length != this.NShip) {
                        this.addFatalError("Move #" + n + ": Return should have one move for each ship. Length is " + nArray.length + " and should be " + this.NShip + ".");
                        return -1.0;
                    }
                    for (n3 = 0; n3 < this.NShip; ++n3) {
                        if (nArray[n3] < 0 || nArray[n3] >= this.NStar) {
                            this.addFatalError("Move #" + n + ": Return values should in the range of [0," + (this.NStar - 1) + "]. Your value was " + nArray[n3] + ".");
                            return -1.0;
                        }
                        Object object = this.worldLock;
                        synchronized (object) {
                            if (this.star[this.ship[n3]].x != this.star[nArray[n3]].x || this.star[this.ship[n3]].y != this.star[nArray[n3]].y) {
                                double d2 = (double)(this.star[this.ship[n3]].x - this.star[nArray[n3]].x) * (double)(this.star[this.ship[n3]].x - this.star[nArray[n3]].x);
                                d2 += (double)(this.star[this.ship[n3]].y - this.star[nArray[n3]].y) * (double)(this.star[this.ship[n3]].y - this.star[nArray[n3]].y);
                                d2 = Math.sqrt(d2);
                                this.progress.add(this.ship[n3]);
                                this.progress.add(nArray[n3]);
                                int n4 = 0;
                                for (int i = 0; i < this.NUfo; ++i) {
                                    if (this.ufoParm[i * 3] != this.ship[n3] || this.ufoParm[i * 3 + 1] != nArray[n3]) continue;
                                    d2 *= 0.001;
                                    n4 = 1;
                                }
                                this.progress.add(n4);
                                this.energy += d2;
                            }
                            this.ship[n3] = nArray[n3];
                            if (!this.star[this.ship[n3]].visited) {
                                this.star[this.ship[n3]].visited = true;
                                ++this.visited;
                            }
                            continue;
                        }
                    }
                    for (n3 = 0; n3 < this.NUfo * 3; n3 += 3) {
                        this.ufoParm[n3] = this.ufoParm[n3 + 1];
                        this.ufoParm[n3 + 1] = this.ufoParm[n3 + 2];
                    }
                    this.calculateNextStar(2);
                    ++n;
                    if (!vis) continue;
                    this.draw();
                    this.v.processPause();
                    try {
                        Thread.sleep(delay);
                    }
                    catch (Exception exception) {}
                }
                this.signalEnd();
                if (this.visited != this.NStar) {
                    this.addFatalError("All stars not visited after " + this.NStar * 4 + " turns.");
                    return -1.0;
                }
            }
            if (vis) {
                this.jf.setSize(1026, 1026);
                this.jf.setVisible(true);
                this.draw();
            }
            if (saveFile != null) {
                this.saveCase(saveFile);
            }
            System.out.println("Ended at turn " + n + " out of a maximum of " + this.NStar * 4 + ".");
            return this.energy;
        }
        catch (Exception exception) {
            this.addFatalError("An exception occurred while trying to process your program's results.");
            exception.printStackTrace();
            return -1.0;
        }
    }

    int init(int[] nArray) throws IOException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(nArray.length).append('\n');
        for (n = 0; n < nArray.length; ++n) {
            stringBuffer.append(nArray[n]).append('\n');
        }
        this.os.write(stringBuffer.toString().getBytes());
        this.os.flush();
        n = Integer.parseInt(this.br.readLine());
        return n;
    }

    int[] makeMoves(int[] nArray, int[] nArray2) throws IOException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(nArray.length).append('\n');
        for (n = 0; n < nArray.length; ++n) {
            stringBuffer.append(nArray[n]).append('\n');
        }
        stringBuffer.append(nArray2.length).append('\n');
        for (n = 0; n < nArray2.length; ++n) {
            stringBuffer.append(nArray2[n]).append('\n');
        }
        this.os.write(stringBuffer.toString().getBytes());
        this.os.flush();
        n = Integer.parseInt(this.br.readLine());
        int[] nArray3 = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray3[i] = Integer.parseInt(this.br.readLine());
        }
        return nArray3;
    }

    void signalEnd() throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("-1").append('\n');
        this.os.write(stringBuffer.toString().getBytes());
        this.os.flush();
    }

    void draw() {
        if (!vis) {
            return;
        }
        this.v.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BufferedImage drawCase(boolean bl) {
        BufferedImage bufferedImage = new BufferedImage(1036, 1036, 1);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        Object object = this.worldLock;
        synchronized (object) {
            int n;
            graphics2D.setColor(new Color(0xD3D3D3));
            graphics2D.fillRect(0, 0, 1036, 1036);
            graphics2D.setColor(Color.BLACK);
            graphics2D.fillRect(0, 0, 1025, 1025);
            graphics2D.setColor(Color.WHITE);
            graphics2D.drawRect(0, 0, 1025, 1025);
            for (n = 0; n < this.progress.size(); n += 3) {
                graphics2D.setColor(this.progress.get(n + 2) == 0 ? Color.GRAY : Color.GREEN);
                int n2 = this.progress.get(n);
                int n3 = this.progress.get(n + 1);
                graphics2D.drawLine(this.star[n2].x, this.star[n2].y, this.star[n3].x, this.star[n3].y);
            }
            for (n = 0; n < this.NStar; ++n) {
                if (this.star[n].visited) {
                    graphics2D.setColor(Color.GREEN);
                    graphics2D.fillOval(this.star[n].x - 1, this.star[n].y - 1, 3, 3);
                    continue;
                }
                graphics2D.setColor(Color.WHITE);
                graphics2D.fillOval(this.star[n].x - 2, this.star[n].y - 2, 5, 5);
            }
            if (bl) {
                for (n = 0; n < this.NUfo; ++n) {
                    graphics2D.setColor(new Color(1.0f, 1.0f, 0.0f));
                    graphics2D.fillOval(this.star[this.ufoParm[n * 3]].x - 3, this.star[this.ufoParm[n * 3]].y - 3, 7, 7);
                    graphics2D.drawLine(this.star[this.ufoParm[n * 3]].x, this.star[this.ufoParm[n * 3]].y, this.star[this.ufoParm[n * 3 + 1]].x, this.star[this.ufoParm[n * 3 + 1]].y);
                    graphics2D.setColor(new Color(0.5f, 0.5f, 0.0f));
                    graphics2D.drawLine(this.star[this.ufoParm[n * 3 + 1]].x, this.star[this.ufoParm[n * 3 + 1]].y, this.star[this.ufoParm[n * 3 + 2]].x, this.star[this.ufoParm[n * 3 + 2]].y);
                }
            }
            for (n = 0; n < this.NShip; ++n) {
                float f = (float)n / (float)this.NShip;
                graphics2D.setColor(Color.getHSBColor(f, 0.9f, 1.0f));
                graphics2D.drawOval(this.star[this.ship[n]].x - 5, this.star[this.ship[n]].y - 5, 11, 11);
                graphics2D.setColor(Color.RED);
                graphics2D.drawOval(this.star[this.ship[n]].x - 3, this.star[this.ship[n]].y - 3, 7, 7);
            }
        }
        return bufferedImage;
    }

    void saveCase(String string) {
        try {
            BufferedImage bufferedImage = this.drawCase(false);
            File file = new File(string);
            ImageIO.write((RenderedImage)bufferedImage, "png", file);
        }
        catch (IOException iOException) {
            this.addFatalError("An exception occurred while trying to save the image.");
            iOException.printStackTrace();
        }
    }

    public StarTravellerVis(String string) {
        if (vis) {
            this.jf = new JFrame();
            this.v = new Vis();
            this.jf.getContentPane().add(this.v);
        }
        if (exec != null) {
            try {
                Runtime runtime = Runtime.getRuntime();
                proc = runtime.exec(exec);
                this.os = proc.getOutputStream();
                this.is = proc.getInputStream();
                this.br = new BufferedReader(new InputStreamReader(this.is));
                new ErrorReader(proc.getErrorStream()).start();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        System.out.println("Score = " + this.runTest(string));
        if (proc != null) {
            try {
                proc.destroy();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public static void main(String[] stringArray) {
        String string = "1";
        vis = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-seed")) {
                string = stringArray[++i];
            }
            if (stringArray[i].equals("-exec")) {
                exec = stringArray[++i];
            }
            if (stringArray[i].equals("-save")) {
                saveFile = stringArray[++i];
            }
            if (stringArray[i].equals("-vis")) {
                vis = true;
            }
            if (stringArray[i].equals("-delay")) {
                delay = Integer.parseInt(stringArray[++i]);
            }
            if (!stringArray[i].equals("-noufo")) continue;
            drawUfo = false;
        }
        StarTravellerVis starTravellerVis = new StarTravellerVis(string);
    }

    void addFatalError(String string) {
        System.out.println(string);
    }

    static {
        saveFile = null;
    }

    public class Vis
    extends JPanel
    implements WindowListener {
        final Object keyMutex = new Object();
        boolean keyPressed;
        public boolean pauseMode = false;

        @Override
        public void paint(Graphics graphics) {
            try {
                BufferedImage bufferedImage = StarTravellerVis.this.drawCase(drawUfo);
                graphics.drawImage(bufferedImage, 0, 0, 1036, 1036, null);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public Vis() {
            StarTravellerVis.this.jf.addWindowListener(this);
            StarTravellerVis.this.jf.addKeyListener(new DrawerKeyListener());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void processPause() {
            Object object = this.keyMutex;
            synchronized (object) {
                if (!this.pauseMode) {
                    return;
                }
                this.keyPressed = false;
                while (!this.keyPressed) {
                    try {
                        this.keyMutex.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            if (proc != null) {
                try {
                    proc.destroy();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            System.exit(0);
        }

        @Override
        public void windowActivated(WindowEvent windowEvent) {
        }

        @Override
        public void windowDeactivated(WindowEvent windowEvent) {
        }

        @Override
        public void windowOpened(WindowEvent windowEvent) {
        }

        @Override
        public void windowClosed(WindowEvent windowEvent) {
        }

        @Override
        public void windowIconified(WindowEvent windowEvent) {
        }

        @Override
        public void windowDeiconified(WindowEvent windowEvent) {
        }

        class DrawerKeyListener
        extends KeyAdapter {
            DrawerKeyListener() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void keyPressed(KeyEvent keyEvent) {
                Object object = Vis.this.keyMutex;
                synchronized (object) {
                    if (keyEvent.getKeyChar() == ' ') {
                        Vis.this.pauseMode = !Vis.this.pauseMode;
                    }
                    Vis.this.keyPressed = true;
                    Vis.this.keyMutex.notifyAll();
                }
            }
        }
    }
}

