/*
 * Decompiled with CFR 0.152.
 */
class World {
    static final int[] DR = new int[]{-1, 0, 1, 0};
    static final int[] DC = new int[]{0, 1, 0, -1};
    int N;
    int[][] board;
    PseudorandomGenerator pg;
    int score;
    int curMove;
    int removeR = -1;
    int removeC = -1;
    int exchangeR1 = -1;
    int exchangeC1 = -1;
    int exchangeR2 = -1;
    int exchangeC2 = -1;
    final Object worldLock = new Object();
    SquareRemoverVis parent;

    public World(TestCase testCase, SquareRemoverVis squareRemoverVis) {
        this.parent = squareRemoverVis;
        this.N = testCase.N;
        this.board = new int[this.N][this.N];
        for (int i = 0; i < this.N; ++i) {
            for (int j = 0; j < this.N; ++j) {
                this.board[i][j] = testCase.board[i].charAt(j) - 48;
            }
        }
        this.pg = new PseudorandomGenerator(testCase.startSeed, testCase.colors);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSquares() {
        boolean bl;
        do {
            bl = false;
            int n = 0;
            while (n + 1 < this.N && !bl) {
                int n2 = 0;
                while (n2 + 1 < this.N && !bl) {
                    if (this.board[n][n2] == this.board[n][n2 + 1] && this.board[n][n2] == this.board[n + 1][n2] && this.board[n][n2] == this.board[n + 1][n2 + 1]) {
                        bl = true;
                        Object object = this.worldLock;
                        synchronized (object) {
                            this.removeR = n;
                            this.removeC = n2;
                        }
                        this.parent.updateDrawer();
                        object = this.worldLock;
                        synchronized (object) {
                            this.removeR = -1;
                            this.removeC = -1;
                            ++this.score;
                            this.board[n][n2] = this.pg.getNextColor();
                            this.board[n][n2 + 1] = this.pg.getNextColor();
                            this.board[n + 1][n2] = this.pg.getNextColor();
                            this.board[n + 1][n2 + 1] = this.pg.getNextColor();
                        }
                        this.parent.updateDrawer();
                    }
                    ++n2;
                }
                ++n;
            }
        } while (bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyMove(int n, int n2, int n3, int n4) throws Exception {
        if (n2 < 0 || n2 >= this.N || n3 < 0 || n3 >= this.N) {
            throw new Exception("In move " + n + " (0-based), the cell chosen by your solution is outside" + " the board: row = " + n2 + ", col = " + n3 + ".");
        }
        int n5 = n2 + DR[n4];
        int n6 = n3 + DC[n4];
        if (n5 < 0 || n5 >= this.N || n6 < 0 || n6 >= this.N) {
            throw new Exception("In move " + n + " (0-based), the direction chosen by your solution" + " points to a cell outside the board: row = " + n5 + ", col = " + n6 + ".");
        }
        Object object = this.worldLock;
        synchronized (object) {
            ++this.curMove;
            this.exchangeR1 = n2;
            this.exchangeC1 = n3;
            this.exchangeR2 = n5;
            this.exchangeC2 = n6;
        }
        this.parent.updateDrawer();
        object = this.worldLock;
        synchronized (object) {
            int n7 = this.board[n2][n3];
            this.board[n2][n3] = this.board[n5][n6];
            this.board[n5][n6] = n7;
            this.exchangeR1 = -1;
            this.exchangeC1 = -1;
            this.exchangeR2 = -1;
            this.exchangeC2 = -1;
        }
        this.parent.updateDrawer();
    }
}

