/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ListIterator;
import javax.swing.JFrame;
import javax.swing.JPanel;

class Drawer
extends JFrame {
    public boolean pauseMode = false;
    final Object keyMutex = new Object();
    boolean keyPressed;
    World world;
    int cellSize;
    int boardSize;
    int width;
    int height;
    DrawerPanel panel = new DrawerPanel();
    final int NEXT_TILES_CNT = 20;
    final int EXTRA_HEIGHT = 150;
    final int EXTRA_WIDTH = 200;
    final int EXTRA_WIDTH_NEXT = 50;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processPause() {
        Object object = this.keyMutex;
        synchronized (object) {
            if (!this.pauseMode) {
                return;
            }
            this.keyPressed = false;
            while (!this.keyPressed) {
                try {
                    this.keyMutex.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public Drawer(World world, int n) {
        this.getContentPane().add(this.panel);
        this.addWindowListener(new DrawerWindowListener());
        this.addKeyListener(new DrawerKeyListener());
        this.world = world;
        this.cellSize = n;
        this.boardSize = world.board.length;
        this.width = Math.max(this.boardSize * n + 200, 20 * n * 5 / 8 + 50);
        this.height = (this.boardSize + 2) * n + 150;
        this.setSize(this.width, this.height);
        this.setTitle("TCO'14 Marathon Round 1");
        this.setResizable(false);
        this.setVisible(true);
    }

    class DrawerPanel
    extends JPanel {
        final Color[] colors = new Color[]{new Color(255, 127, 127), new Color(127, 255, 127), new Color(127, 127, 255), new Color(255, 255, 127), new Color(127, 255, 255), new Color(255, 127, 255)};

        DrawerPanel() {
        }

        public void drawGrid(Graphics graphics, int n, int n2) {
            int n3;
            int n4;
            graphics.setColor(Color.BLACK);
            for (n4 = 0; n4 <= Drawer.this.boardSize; ++n4) {
                graphics.drawLine(n + n4 * Drawer.this.cellSize, n2, n + n4 * Drawer.this.cellSize, n2 + Drawer.this.cellSize * Drawer.this.boardSize);
                graphics.drawLine(n, n2 + n4 * Drawer.this.cellSize, n + Drawer.this.cellSize * Drawer.this.boardSize, n2 + n4 * Drawer.this.cellSize);
            }
            for (n4 = 0; n4 < Drawer.this.boardSize; ++n4) {
                for (n3 = 0; n3 < Drawer.this.boardSize; ++n3) {
                    graphics.setColor(this.colors[Drawer.this.world.board[n4][n3]]);
                    graphics.fillRect(n + n3 * Drawer.this.cellSize + 1, n2 + n4 * Drawer.this.cellSize + 1, Drawer.this.cellSize - 1, Drawer.this.cellSize - 1);
                }
            }
            if (Drawer.this.world.removeR != -1) {
                graphics.setColor(Color.BLACK);
                for (n4 = 0; n4 < 4; ++n4) {
                    for (n3 = 0; n3 < 4; ++n3) {
                        graphics.drawLine(n + Drawer.this.world.removeC * Drawer.this.cellSize + n3 * Drawer.this.cellSize / 2, n2 + Drawer.this.world.removeR * Drawer.this.cellSize + n4 * Drawer.this.cellSize / 2, n + Drawer.this.world.removeC * Drawer.this.cellSize + (n3 + 1) * Drawer.this.cellSize / 2, n2 + Drawer.this.world.removeR * Drawer.this.cellSize + (n4 + 1) * Drawer.this.cellSize / 2);
                        graphics.drawLine(n + Drawer.this.world.removeC * Drawer.this.cellSize + (n3 + 1) * Drawer.this.cellSize / 2, n2 + Drawer.this.world.removeR * Drawer.this.cellSize + n4 * Drawer.this.cellSize / 2, n + Drawer.this.world.removeC * Drawer.this.cellSize + n3 * Drawer.this.cellSize / 2, n2 + Drawer.this.world.removeR * Drawer.this.cellSize + (n4 + 1) * Drawer.this.cellSize / 2);
                    }
                }
            }
            if (Drawer.this.world.exchangeR1 != -1) {
                n4 = (Drawer.this.world.exchangeR2 - Drawer.this.world.exchangeR1) * Drawer.this.cellSize / 6;
                n3 = (Drawer.this.world.exchangeC2 - Drawer.this.world.exchangeC1) * Drawer.this.cellSize / 6;
                int n5 = n + Drawer.this.world.exchangeC1 * Drawer.this.cellSize + Drawer.this.cellSize / 2;
                int n6 = n2 + Drawer.this.world.exchangeR1 * Drawer.this.cellSize + Drawer.this.cellSize / 2;
                int n7 = n + Drawer.this.world.exchangeC2 * Drawer.this.cellSize + Drawer.this.cellSize / 2;
                int n8 = n2 + Drawer.this.world.exchangeR2 * Drawer.this.cellSize + Drawer.this.cellSize / 2;
                graphics.setColor(Color.BLACK);
                graphics.drawLine(n5, n6, n7, n8);
                graphics.drawLine(n7, n8, n7 - n4 * 3 / 4 - n3, n8 + n3 * 3 / 4 - n4);
                graphics.drawLine(n7, n8, n7 + n4 * 3 / 4 - n3, n8 - n3 * 3 / 4 - n4);
                n4 = -n4;
                n3 = -n3;
                graphics.drawLine(n5, n6, n5 - n4 * 3 / 4 - n3, n6 + n3 * 3 / 4 - n4);
                graphics.drawLine(n5, n6, n5 + n4 * 3 / 4 - n3, n6 - n3 * 3 / 4 - n4);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paint(Graphics graphics) {
            Object object = Drawer.this.world.worldLock;
            synchronized (object) {
                this.drawGrid(graphics, 15, 15);
                int n = 40 + Drawer.this.boardSize * Drawer.this.cellSize;
                graphics.setColor(Color.BLACK);
                graphics.setFont(new Font("Arial", 1, 16));
                graphics.drawString("Current score:", n, 30);
                graphics.setFont(new Font("Arial", 1, 30));
                graphics.drawString("" + Drawer.this.world.score, n, 60);
                graphics.setFont(new Font("Arial", 1, 16));
                graphics.drawString("Current move:", n, 90);
                graphics.setFont(new Font("Arial", 1, 30));
                graphics.drawString("" + Drawer.this.world.curMove, n, 120);
                graphics.setFont(new Font("Arial", 1, 16));
                graphics.drawString("Next 5 squares to appear:", 15, 50 + Drawer.this.cellSize * Drawer.this.boardSize);
                ListIterator<Integer> listIterator = Drawer.this.world.pg.next.listIterator(0);
                for (int i = 0; i < 5; ++i) {
                    for (int j = 0; j < 2; ++j) {
                        for (int k = 0; k < 2; ++k) {
                            int n2 = listIterator.next();
                            int n3 = 15 + k * Drawer.this.cellSize + i * 5 * Drawer.this.cellSize / 2;
                            int n4 = 70 + Drawer.this.cellSize * (Drawer.this.boardSize + j);
                            graphics.setColor(Color.BLACK);
                            graphics.drawRect(n3, n4, Drawer.this.cellSize, Drawer.this.cellSize);
                            graphics.setColor(this.colors[n2]);
                            graphics.fillRect(n3 + 1, n4 + 1, Drawer.this.cellSize - 1, Drawer.this.cellSize - 1);
                        }
                    }
                }
            }
        }
    }

    class DrawerWindowListener
    extends WindowAdapter {
        DrawerWindowListener() {
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            System.exit(0);
        }
    }

    class DrawerKeyListener
    extends KeyAdapter {
        DrawerKeyListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void keyPressed(KeyEvent keyEvent) {
            Object object = Drawer.this.keyMutex;
            synchronized (object) {
                if (keyEvent.getKeyChar() == ' ') {
                    Drawer.this.pauseMode = !Drawer.this.pauseMode;
                }
                Drawer.this.keyPressed = true;
                Drawer.this.keyMutex.notifyAll();
            }
        }
    }
}

