/*
 * Decompiled with CFR 0.152.
 */
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Label;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.util.Random;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Snake
extends JFrame
implements WindowListener,
ChangeListener {
    boolean novis;
    static int ST = 20;
    Vis c;
    int[] fx;
    int[] fy;
    int[] ox;
    int[] oy;
    int N;
    int M;
    int K;
    double p = -1.0;
    int sx;
    int sy;
    int dir;
    int[] dy = new int[]{1, 0, -1, 0};
    int[] dx = new int[]{0, 1, 0, -1};
    int[] bx;
    int[] by;
    int head;
    int tail;
    int ate;
    int[][] board;
    StringBuffer msg = new StringBuffer("Standard Error from your program, as well as other messages will appear here");
    Random r;
    int moves = 0;
    int food = 0;
    boolean running;
    int used = 0;
    JTextArea err;
    JTextField fileName;
    int seed = 1;
    Runner current;
    String procname = "";

    void swap(int[] nArray, int n, int n2) {
        int n3 = nArray[n];
        nArray[n] = nArray[n2];
        nArray[n2] = n3;
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        if (this.current != null && this.current.pr != null) {
            this.current.pr.destroy();
        }
        System.exit(0);
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    void addMessage(String string) {
        if (!this.novis) {
            this.addMessage(string, false);
        } else {
            System.out.println(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addMessage(String string, boolean bl) {
        StringBuffer stringBuffer = this.msg;
        synchronized (stringBuffer) {
            if (bl) {
                System.out.println(string);
            }
            if (!this.novis) {
                this.msg.append('\n').append(string);
            }
        }
        if (!this.novis) {
            this.err.setText(this.msg.toString());
        }
    }

    int ff(int n, int n2) {
        int[] nArray = new int[this.N * this.N];
        int[] nArray2 = new int[this.N * this.N];
        int n3 = 0;
        int n4 = 1;
        nArray[0] = n;
        nArray2[0] = n2;
        this.board[n][n2] = -2;
        int n5 = 0;
        while (n3 < n4) {
            n = nArray[n3];
            n2 = nArray2[n3];
            ++n3;
            ++n5;
            if (n < this.N - 1 && this.board[n + 1][n2] == 0) {
                nArray[n4] = n + 1;
                nArray2[n4++] = n2;
                this.board[n + 1][n2] = -2;
            }
            if (n > 0 && this.board[n - 1][n2] == 0) {
                nArray[n4] = n - 1;
                nArray2[n4++] = n2;
                this.board[n - 1][n2] = -2;
            }
            if (n2 < this.N - 1 && this.board[n][n2 + 1] == 0) {
                nArray[n4] = n;
                nArray2[n4++] = n2 + 1;
                this.board[n][n2 + 1] = -2;
            }
            if (n2 <= 0 || this.board[n][n2 - 1] != 0) continue;
            nArray[n4] = n;
            nArray2[n4++] = n2 - 1;
            this.board[n][n2 - 1] = -2;
        }
        return n5;
    }

    public void generate(boolean bl) {
        int n;
        int n2;
        int n3;
        int n4;
        if (bl) {
            this.N = this.r.nextInt(81) + 20;
            this.M = this.r.nextInt(16) + 5;
            this.K = this.r.nextInt(8) + 3;
            this.p = this.r.nextDouble() / 2.0;
        } else {
            this.r.nextInt(81);
            this.r.nextInt(16);
            this.r.nextInt(8);
            this.r.nextDouble();
        }
        this.food = 0;
        this.moves = 0;
        this.used = 0;
        this.ate = 0;
        this.dir = 0;
        this.tail = 0;
        this.head = 0;
        this.fx = new int[this.M];
        this.fy = new int[this.M];
        this.board = new int[this.N][this.N];
        int[] nArray = new int[this.N * this.N];
        int[] nArray2 = new int[this.N * this.N];
        int n5 = 0;
        for (n4 = 0; n4 < this.N; ++n4) {
            for (n3 = 0; n3 < this.N; ++n3) {
                if (!(this.r.nextDouble() < this.p)) continue;
                nArray[n5] = n4;
                nArray2[n5] = n3;
                n2 = this.r.nextInt(n5 + 1);
                this.swap(nArray, n5, n2);
                this.swap(nArray2, n5, n2);
                ++n5;
            }
        }
        n4 = 0;
        for (n3 = 0; n3 < n5; ++n3) {
            int n6;
            this.board[nArray[n3]][nArray2[n3]] = -1;
            n2 = 0;
            block3: for (n = 0; n < this.N; ++n) {
                for (n6 = 0; n6 < this.N; ++n6) {
                    if (this.board[n][n6] != 0) continue;
                    if (this.ff(n, n6) != this.N * this.N - n4 - 1) break block3;
                    n2 = 1;
                    break block3;
                }
            }
            if (n2 == 0) {
                this.board[nArray[n3]][nArray2[n3]] = 0;
            } else {
                ++this.used;
                ++n4;
            }
            for (n = 0; n < this.N; ++n) {
                for (n6 = 0; n6 < this.N; ++n6) {
                    if (this.board[n][n6] != -2) continue;
                    this.board[n][n6] = 0;
                }
            }
        }
        System.out.println("N=" + this.N + ", M=" + this.M + ", K=" + this.K + ", p=" + this.p);
        this.ox = new int[n4];
        this.oy = new int[n4];
        n5 = 0;
        for (n3 = 0; n3 < this.N; ++n3) {
            for (n2 = 0; n2 < this.N; ++n2) {
                if (this.board[n3][n2] != -1) continue;
                this.ox[n5] = n3;
                this.oy[n5] = n2;
                ++n5;
            }
        }
        for (n3 = 0; n3 < this.fx.length; ++n3) {
            n2 = this.r.nextInt(this.N);
            if (this.board[n2][n = this.r.nextInt(this.N)] != 0) {
                --n3;
                continue;
            }
            this.board[n2][n] = 1;
            ++this.used;
            this.fx[n3] = n2;
            this.fy[n3] = n;
        }
        this.dir = 0;
        do {
            this.sx = this.r.nextInt(this.N);
            this.sy = this.r.nextInt(this.N);
        } while (this.board[this.sx][this.sy] != 0);
        this.bx = new int[this.N * this.N];
        this.by = new int[this.N * this.N];
        this.bx[0] = this.sx;
        this.by[0] = this.sy;
        this.head = 0;
        this.tail = 0;
        ++this.used;
        this.board[this.sx][this.sy] = 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int[] moveSnake(String string) {
        int[] nArray = new int[20000];
        int n = 0;
        for (int i = 0; i < string.length() && this.running; ++i) {
            if (string.charAt(i) == 'R') {
                this.dir = (this.dir + 1) % 4;
            } else if (string.charAt(i) == 'L') {
                this.dir = (this.dir + 3) % 4;
            } else if (string.charAt(i) != 'S') {
                this.addMessage("Game over due to invalid character: " + string.charAt(i) + " in string: " + string);
                this.running = false;
                return new int[]{-1};
            }
            this.sx += this.dx[this.dir];
            this.sy += this.dy[this.dir];
            if (this.sx < 0 || this.sx >= this.N || this.sy < 0 || this.sy >= this.N || this.board[this.sx][this.sy] == -1) {
                this.addMessage("Game over due to snake death");
                this.running = false;
                return new int[]{-1};
            }
            if (this.ate == 0) {
                this.board[this.bx[this.tail]][this.by[this.tail]] = 0;
                this.tail = (this.tail + 1) % this.bx.length;
            } else {
                ++this.used;
                --this.ate;
            }
            if (this.board[this.sx][this.sy] == 2) {
                this.addMessage("Game over due to snake death");
                this.running = false;
                return new int[]{-1};
            }
            this.head = (this.head + 1) % this.bx.length;
            this.bx[this.head] = this.sx;
            this.by[this.head] = this.sy;
            if (this.board[this.sx][this.sy] == 1) {
                int n2;
                if (this.used <= this.N * this.N) {
                    int n3;
                    int n4;
                    while (this.board[n4 = this.r.nextInt(this.N)][n3 = this.r.nextInt(this.N)] != 0) {
                    }
                    this.board[n4][n3] = 1;
                    nArray[n++] = n4;
                    nArray[n++] = n3;
                    for (n2 = 0; n2 < this.fx.length; ++n2) {
                        if (this.fx[n2] != this.sx || this.fy[n2] != this.sy) continue;
                        this.fx[n2] = n4;
                        this.fy[n2] = n3;
                    }
                } else {
                    for (n2 = 0; n2 < this.fx.length; ++n2) {
                        if (this.fx[n2] != this.sx || this.fy[n2] != this.sy) continue;
                        this.fx[n2] = -1;
                        this.fy[n2] = -1;
                    }
                }
                this.ate += this.K;
                ++this.food;
            }
            this.board[this.sx][this.sy] = 2;
            ++this.moves;
            if (this.moves == 20000) {
                this.addMessage("Game over due to 20,000 moves.");
                this.running = false;
                return new int[]{-1};
            }
            if (this.novis) continue;
            Object object = this.c.painting;
            synchronized (object) {
                this.c.repaint();
            }
            try {
                Thread.sleep(ST);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        int[] nArray2 = new int[n];
        System.arraycopy(nArray, 0, nArray2, 0, n);
        return nArray2;
    }

    public void stateChanged(ChangeEvent changeEvent) {
        JSlider jSlider = (JSlider)changeEvent.getSource();
        ST = jSlider.getValue() >= 80 ? 100 - jSlider.getValue() : (int)(5000.0 * Math.pow(0.9333096363135965, jSlider.getValue()));
    }

    void stop() {
        this.running = false;
        if (this.current != null) {
            this.current.running = false;
            try {
                if (this.current.pr != null) {
                    this.current.pr.destroy();
                }
                this.current.join();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public static void main(String[] stringArray) {
        final Snake snake = new Snake();
        snake.seed = new Random().nextInt();
        snake.r = new Random(snake.seed);
        boolean bl = false;
        snake.procname = "Enter your executable and its arguments here";
        int n = 80;
        int n2 = 600;
        int n3 = 800;
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals("-N")) {
                    snake.N = Integer.parseInt(stringArray[i + 1]);
                    continue;
                }
                if (stringArray[i].equals("-M")) {
                    snake.M = Integer.parseInt(stringArray[i + 1]);
                    continue;
                }
                if (stringArray[i].equals("-K")) {
                    snake.K = Integer.parseInt(stringArray[i + 1]);
                    continue;
                }
                if (stringArray[i].equals("-p")) {
                    snake.p = Double.parseDouble(stringArray[i + 1]);
                    continue;
                }
                if (stringArray[i].equals("-s")) {
                    snake.seed = Integer.parseInt(stringArray[i + 1]);
                    snake.r = new Random(snake.seed);
                    continue;
                }
                if (stringArray[i].equals("-t")) {
                    n = Integer.parseInt(stringArray[i + 1]);
                    if (n > 100) {
                        n = 100;
                    } else if (n < 0) {
                        n = 0;
                    }
                    if (n >= 80) {
                        ST = 100 - n;
                        continue;
                    }
                    ST = (int)(5000.0 * Math.pow(0.9333096363135965, n));
                    continue;
                }
                if (stringArray[i].equals("-exec")) {
                    snake.procname = stringArray[i + 1];
                    continue;
                }
                if (stringArray[i].equals("-novis")) {
                    bl = true;
                    snake.novis = true;
                    continue;
                }
                if (stringArray[i].equals("-go")) {
                    bl = true;
                    continue;
                }
                if (stringArray[i].equals("-width")) {
                    n2 = Integer.parseInt(stringArray[i + 1]);
                    continue;
                }
                if (!stringArray[i].equals("-height")) continue;
                n3 = Integer.parseInt(stringArray[i + 1]);
            }
        }
        catch (Exception exception) {
            System.err.println("Your command line parameters are invalid.");
            System.exit(1);
        }
        if ((snake.novis || bl) && snake.procname.startsWith("Enter your exec")) {
            System.err.println("You must specify an executable when using the -novis or -go options");
            if (snake.novis) {
                System.exit(1);
            } else {
                bl = false;
            }
        }
        if (snake.N == 0) {
            snake.N = snake.r.nextInt(81) + 20;
        }
        if (snake.M == 0) {
            snake.M = snake.r.nextInt(16) + 5;
        }
        if (snake.K == 0) {
            snake.K = snake.r.nextInt(8) + 3;
        }
        if (snake.p == -1.0) {
            snake.p = snake.r.nextDouble() / 2.0;
        }
        if (!snake.novis) {
            snake.r = new Random(snake.seed);
            snake.generate(false);
            snake.c = snake.new Vis();
            JSlider jSlider = new JSlider(0, 0, 100, n);
            jSlider.addChangeListener(snake);
            jSlider.setMajorTickSpacing(20);
            jSlider.setMinorTickSpacing(5);
            jSlider.setPaintTicks(true);
            jSlider.setPaintLabels(true);
            jSlider.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
            snake.err = new JTextArea(10, 60);
            snake.err.setText(snake.msg.toString());
            JScrollPane jScrollPane = new JScrollPane(snake.err);
            JSplitPane jSplitPane = new JSplitPane(0, snake.c, jScrollPane);
            jSplitPane.setDividerLocation(n3 - 300);
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 3));
            JLabel jLabel = new JLabel("Speed");
            jLabel.setAlignmentX(0.5f);
            jSplitPane.setAlignmentX(0.5f);
            jPanel.add(jLabel);
            jPanel.add(jSlider);
            snake.err.setEditable(false);
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new BoxLayout(jPanel2, 2));
            final JTextField jTextField = new JTextField("" + snake.N);
            final JTextField jTextField2 = new JTextField("" + snake.M);
            final JTextField jTextField3 = new JTextField("" + snake.K);
            final JTextField jTextField4 = new JTextField("" + snake.p);
            final JTextField jTextField5 = new JTextField("" + snake.seed);
            jPanel2.add(new Label("N: "));
            jPanel2.add(jTextField);
            jPanel2.add(new Label("M: "));
            jPanel2.add(jTextField2);
            jPanel2.add(new Label("K: "));
            jPanel2.add(jTextField3);
            jPanel2.add(new Label("p: "));
            jPanel2.add(jTextField4);
            jPanel2.add(new Label("seed: "));
            jPanel2.add(jTextField5);
            jPanel2.setAlignmentX(0.5f);
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout(new BoxLayout(jPanel3, 2));
            JButton jButton = new JButton("Generate Map");
            JButton jButton2 = new JButton("New Parameters and Map");
            JButton jButton3 = new JButton("Start Simulation");
            JButton jButton4 = new JButton("Stop Simulation");
            jPanel3.add(jButton);
            jPanel3.add(jButton2);
            jPanel3.add(jButton3);
            jPanel3.add(jButton4);
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    snake.stop();
                    snake.seed = Integer.parseInt(jTextField5.getText());
                    snake.N = Integer.parseInt(jTextField.getText());
                    snake.M = Integer.parseInt(jTextField2.getText());
                    snake.K = Integer.parseInt(jTextField3.getText());
                    snake.p = Double.parseDouble(jTextField4.getText());
                    snake.r = new Random(snake.seed);
                    snake.generate(false);
                    snake.c.repaint();
                }
            });
            jButton2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    snake.stop();
                    snake.seed = snake.seed == Integer.parseInt(jTextField5.getText()) ? snake.r.nextInt() : Integer.parseInt(jTextField5.getText());
                    snake.r = new Random(snake.seed);
                    snake.generate(true);
                    jTextField.setText("" + snake.N);
                    jTextField2.setText("" + snake.M);
                    jTextField3.setText("" + snake.K);
                    jTextField4.setText("" + snake.p);
                    jTextField5.setText("" + snake.seed);
                    snake.c.repaint();
                }
            });
            jButton3.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    snake.stop();
                    snake.r = new Random(snake.seed);
                    snake.generate(false);
                    snake.procname = snake.fileName.getText();
                    snake.current = new Runner(snake);
                    snake.current.start();
                }
            });
            jButton4.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    snake.stop();
                }
            });
            JPanel jPanel4 = new JPanel();
            JButton jButton5 = new JButton("Select Executable");
            snake.fileName = new JTextField(snake.procname);
            jPanel4.add(jButton5);
            jPanel4.add(snake.fileName);
            jPanel4.setLayout(new BoxLayout(jPanel4, 2));
            jButton5.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JFileChooser jFileChooser = new JFileChooser();
                    int n = jFileChooser.showOpenDialog(snake);
                    if (n == 0) {
                        snake.procname = jFileChooser.getSelectedFile().getPath();
                        snake.fileName.setText(snake.procname);
                    }
                }
            });
            JPanel jPanel5 = new JPanel();
            jPanel5.setLayout(new BoxLayout(jPanel5, 3));
            jPanel5.add(jPanel2);
            jPanel5.add(jPanel3);
            jPanel5.add(jPanel4);
            snake.add((Component)jPanel, "North");
            snake.add((Component)jSplitPane, "Center");
            snake.add((Component)jPanel5, "South");
            snake.addWindowListener(snake);
            snake.setSize(n2, n3);
            snake.setVisible(true);
            if (bl) {
                snake.procname = snake.fileName.getText();
                snake.current = new Runner(snake);
                snake.current.start();
            }
        } else {
            snake.r = new Random(snake.seed);
            snake.generate(false);
            snake.current = new Runner(snake);
            snake.current.start();
        }
    }

    String getProcessName() {
        return this.procname;
    }

    public class Vis
    extends JPanel {
        BufferedImage bi;
        Object painting = new Object();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void paint(Graphics graphics) {
            if (Snake.this.novis) {
                return;
            }
            Object object = this.painting;
            synchronized (object) {
                int n;
                if (Snake.this.fx == null) {
                    return;
                }
                int n2 = Math.min(this.getWidth() / Snake.this.N, this.getHeight() / Snake.this.N);
                int n3 = (this.getWidth() - Snake.this.N * n2) / 2;
                int n4 = (this.getHeight() - Snake.this.N * n2) / 2 + n2;
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics2D.setColor(Color.white);
                graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
                graphics2D.setColor(Color.black);
                graphics2D.drawLine(n3 - 1, this.getHeight() - n4 + 1 + n2, n3 - 1, this.getHeight() - n4 - n2 * Snake.this.N - 1 + n2);
                graphics2D.drawLine(n3 + 1 + n2 * Snake.this.N, this.getHeight() - n4 + 1 + n2, n3 + 1 + n2 * Snake.this.N, this.getHeight() - n4 - n2 * Snake.this.N - 1 + n2);
                graphics2D.drawLine(n3 - 1, this.getHeight() - n4 + 1 + n2, n3 + n2 * Snake.this.N + 1, this.getHeight() - n4 + 1 + n2);
                graphics2D.drawLine(n3 - 1, this.getHeight() - n4 - n2 * Snake.this.N - 1 + n2, n3 + n2 * Snake.this.N + 1, this.getHeight() - n4 - n2 * Snake.this.N - 1 + n2);
                graphics2D.setColor(Color.green);
                for (n = 0; n < Snake.this.fx.length; ++n) {
                    if (Snake.this.fx[n] == -1) continue;
                    graphics2D.fillOval(Snake.this.fx[n] * n2 + n3, this.getHeight() - Snake.this.fy[n] * n2 - n4, n2, n2);
                }
                graphics2D.setColor(Color.black);
                for (n = 0; n < Snake.this.ox.length; ++n) {
                    graphics2D.fillRect(Snake.this.ox[n] * n2 + n3, this.getHeight() - n4 - Snake.this.oy[n] * n2, n2, n2);
                }
                n = Snake.this.head - Snake.this.tail + 1;
                if (n < 0) {
                    n += Snake.this.N * Snake.this.N;
                }
                for (int i = 0; i < n; ++i) {
                    graphics2D.setColor(new Color((n - i - 1) * 255 / n, 0, (i + 1) * 255 / n));
                    graphics2D.fillOval(Snake.this.bx[(i + Snake.this.tail) % Snake.this.bx.length] * n2 + n3, this.getHeight() - n4 - Snake.this.by[(i + Snake.this.tail) % Snake.this.bx.length] * n2, n2, n2);
                }
                graphics2D.setColor(Color.gray);
                graphics2D.setComposite(AlphaComposite.getInstance(3, 0.5f));
                Font font = new Font(graphics2D.getFont().getName(), 0, n2 * Snake.this.N / 6);
                graphics2D.setFont(font);
                FontMetrics fontMetrics = graphics2D.getFontMetrics();
                String string = "" + Snake.this.moves;
                int n5 = fontMetrics.stringWidth(string);
                int n6 = fontMetrics.getAscent();
                graphics2D.drawString(string, this.getWidth() / 2 - n5 / 2, this.getHeight() / 2 + n6 / 2);
            }
        }
    }
}

