/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.HashSet;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class SmallPolygonsVis {
    final int SZ = 700;
    int NP;
    int N;
    int Npoly;
    Pnt[] p;
    int[] pointsPar;
    int[][] polys;
    int[] polysVert;
    boolean[] valid;
    int[] used;
    HashSet<Integer> badEdges = new HashSet();
    static String exec;
    static boolean vis;
    static boolean manual;
    static boolean debug;
    static boolean strict;
    static Process proc;
    JFrame jf;
    Vis v;
    InputStream is;
    OutputStream os;
    BufferedReader br;
    final int SZX = 802;
    final int SZY = 702;
    volatile boolean ready;
    volatile int Ncur;
    volatile int[] Pcur;
    int[][] coordToPoint;

    void generate(String string) {
        try {
            int n;
            int n2;
            int n3;
            SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
            secureRandom.setSeed(Long.parseLong(string));
            this.NP = string.equals("1") ? 10 : ((n3 = secureRandom.nextInt(3)) == 0 ? secureRandom.nextInt(80) + 20 : (n3 == 1 ? secureRandom.nextInt(400) + 100 : secureRandom.nextInt(1001) + 500));
            System.out.println("NP = " + this.NP);
            this.p = new Pnt[this.NP];
            for (n2 = 0; n2 < this.NP; ++n2) {
                do {
                    this.p[n2] = new Pnt(secureRandom.nextInt(700), secureRandom.nextInt(700));
                    n3 = 1;
                    for (n = 0; n < n2 && n3 != 0; ++n) {
                        if (!this.p[n2].equals(this.p[n])) continue;
                        n3 = 0;
                    }
                } while (n3 == 0);
            }
            this.pointsPar = new int[2 * this.NP];
            for (n2 = 0; n2 < this.NP; ++n2) {
                this.pointsPar[2 * n2] = this.p[n2].x;
                this.pointsPar[2 * n2 + 1] = this.p[n2].y;
            }
            if (manual) {
                this.coordToPoint = new int[700][700];
                for (n2 = 0; n2 < 700; ++n2) {
                    Arrays.fill(this.coordToPoint[n2], -1);
                }
                for (n2 = 0; n2 < this.NP; ++n2) {
                    for (n = -1; n <= 1; ++n) {
                        for (int i = -1; i <= 1; ++i) {
                            int n4 = this.p[n2].x + n;
                            int n5 = this.p[n2].y + i;
                            if (n4 < 0 || n4 >= 700 || n5 < 0 || n5 >= 700) continue;
                            this.coordToPoint[n4][n5] = n2;
                        }
                    }
                }
            }
            this.N = secureRandom.nextInt(19) + 2;
            if (string.equals("1")) {
                this.N = 3;
            }
            System.out.println("N = " + this.N);
        }
        catch (Exception exception) {
            this.addFatalError("An exception occurred while generating test case.");
            exception.printStackTrace();
        }
    }

    String validatePoly(int[] nArray, int n) {
        if (n < 3) {
            return "a polygon must have at least 3 vertices.";
        }
        for (int i = 0; i < n; ++i) {
            for (int j = i + 1; j < n; ++j) {
                Edge edge = new Edge(this.p[nArray[i]], this.p[nArray[(i + 1) % n]]);
                Edge edge2 = new Edge(this.p[nArray[j]], this.p[nArray[(j + 1) % n]]);
                if (!edge.intersect(edge2)) continue;
                this.badEdges.add(nArray[i]);
                this.badEdges.add(nArray[j]);
                return "edges " + nArray[i] + "-" + nArray[(i + 1) % n] + " and " + nArray[j] + "-" + nArray[(j + 1) % n] + " intersect";
            }
        }
        return "";
    }

    double area(int[] nArray, int n) {
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            d += (double)((this.p[nArray[(i + 1) % n]].y + this.p[nArray[i]].y) * (this.p[nArray[(i + 1) % n]].x - this.p[nArray[i]].x)) / 2.0;
        }
        return Math.abs(d);
    }

    double calcScore() {
        int n;
        int n2;
        if (this.Npoly > this.N) {
            this.addFatalError("You can have at most " + this.N + " polygons.");
            return 0.0;
        }
        for (n2 = 0; n2 < this.used.length; ++n2) {
            if (this.used[n2] != -2) continue;
            this.addFatalError("Point " + n2 + " is not used in any polygon.");
            return 0.0;
        }
        for (n2 = 0; n2 < this.polys.length; ++n2) {
            if (manual && this.polysVert[n2] == 0 || this.valid[n2] || !strict) continue;
            this.addFatalError("Polygon " + n2 + " is not valid: " + this.validatePoly(this.polys[n2], this.polysVert[n2]));
            return 0.0;
        }
        for (n2 = 0; n2 < this.polys.length; ++n2) {
            for (int i = 0; i < this.polysVert[n2]; ++i) {
                for (n = n2 + 1; n < this.polys.length; ++n) {
                    for (int j = 0; j < this.polysVert[n]; ++j) {
                        Edge edge = new Edge(this.p[this.polys[n2][i]], this.p[this.polys[n2][(i + 1) % this.polysVert[n2]]]);
                        Edge edge2 = new Edge(this.p[this.polys[n][j]], this.p[this.polys[n][(j + 1) % this.polysVert[n]]]);
                        if (!edge.intersect(edge2)) continue;
                        this.badEdges.add(this.polys[n2][i]);
                        this.badEdges.add(this.polys[n][j]);
                        this.addFatalError("edges " + this.polys[n2][i] + "-" + this.polys[n2][(i + 1) % this.polysVert[n2]] + " and " + this.polys[n][j] + "-" + this.polys[n][(j + 1) % this.polysVert[n]] + " intersect");
                        return 0.0;
                    }
                }
            }
        }
        double d = 0.0;
        for (n = 0; n < this.polys.length; ++n) {
            d += this.area(this.polys[n], this.polysVert[n]);
        }
        return d;
    }

    public double runTest(String string) {
        try {
            this.generate(string);
            this.used = new int[this.NP];
            Arrays.fill(this.used, -2);
            this.badEdges.clear();
            if (proc != null) {
                String[] stringArray;
                try {
                    stringArray = this.choosePolygons(this.pointsPar, this.N);
                }
                catch (Exception exception) {
                    this.addFatalError("Failed to get result from choosePolygons.");
                    return 0.0;
                }
                int n = this.Npoly = stringArray.length;
                if (manual) {
                    n = Math.max(n, this.N);
                }
                this.polys = new int[n][];
                this.polysVert = new int[n];
                this.valid = new boolean[n];
                for (int i = 0; i < this.Npoly; ++i) {
                    Object object;
                    try {
                        if (debug) {
                            System.out.println(stringArray[i]);
                        }
                        object = stringArray[i].split(" ");
                        int n2 = ((String[])object).length;
                        this.polys[i] = manual ? new int[Math.max(n2, this.NP)] : new int[n2];
                        this.polysVert[i] = n2;
                        for (int j = 0; j < n2; ++j) {
                            this.polys[i][j] = Integer.parseInt(object[j]);
                            if (this.used[this.polys[i][j]] > -2) {
                                this.addFatalError("Polygon " + i + " reuses point " + this.polys[i][j] + ".");
                                return 0.0;
                            }
                            this.used[this.polys[i][j]] = i;
                        }
                    }
                    catch (Exception exception) {
                        this.addFatalError("Polygon " + i + " parses with errors.");
                        return 0.0;
                    }
                    object = this.validatePoly(this.polys[i], this.polysVert[i]);
                    if (((String)object).length() != 0) {
                        this.addFatalError("Polygon " + i + " is invalid: " + (String)object);
                        this.valid[i] = false;
                        continue;
                    }
                    this.valid[i] = true;
                }
            } else {
                this.Npoly = 0;
                this.polys = new int[this.N][];
                this.polysVert = new int[this.N];
                this.valid = new boolean[this.N];
            }
            if (vis) {
                this.jf.setSize(819, 739);
                this.jf.setVisible(true);
                this.draw();
            }
            if (manual) {
                this.ready = false;
                this.Pcur = new int[2000];
                this.Ncur = 0;
                while (!this.ready) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
            return this.calcScore();
        }
        catch (Exception exception) {
            this.addFatalError("An exception occurred while trying to process your program's results.");
            exception.printStackTrace();
            return 0.0;
        }
    }

    String[] choosePolygons(int[] nArray, int n) throws IOException {
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(nArray.length).append('\n');
        for (n2 = 0; n2 < nArray.length; ++n2) {
            stringBuffer.append(nArray[n2]).append('\n');
        }
        stringBuffer.append(n).append('\n');
        this.os.write(stringBuffer.toString().getBytes());
        this.os.flush();
        int n3 = Integer.parseInt(this.br.readLine());
        System.out.println(n3);
        String[] stringArray = new String[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            stringArray[n2] = this.br.readLine();
        }
        return stringArray;
    }

    void draw() {
        if (!vis) {
            return;
        }
        this.v.repaint();
    }

    public SmallPolygonsVis(String string) {
        if (vis) {
            this.jf = new JFrame();
            this.v = new Vis();
            this.jf.getContentPane().add(this.v);
        }
        if (exec != null) {
            try {
                Runtime runtime = Runtime.getRuntime();
                proc = runtime.exec(exec);
                this.os = proc.getOutputStream();
                this.is = proc.getInputStream();
                this.br = new BufferedReader(new InputStreamReader(this.is));
                new ErrorReader(proc.getErrorStream()).start();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        System.out.println("Score = " + this.runTest(string));
        if (proc != null) {
            try {
                proc.destroy();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public static void main(String[] stringArray) {
        String string = "1";
        vis = false;
        manual = false;
        strict = true;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-seed")) {
                string = stringArray[++i];
            }
            if (stringArray[i].equals("-exec")) {
                exec = stringArray[++i];
            }
            if (stringArray[i].equals("-vis")) {
                vis = true;
            }
            if (stringArray[i].equals("-manual")) {
                manual = true;
            }
            if (stringArray[i].equals("-debug")) {
                debug = true;
            }
            if (!stringArray[i].equals("-nostrict")) continue;
            strict = false;
        }
        if (manual) {
            vis = true;
        }
        SmallPolygonsVis smallPolygonsVis = new SmallPolygonsVis(string);
    }

    void addFatalError(String string) {
        System.out.println(string);
    }

    public class Vis
    extends JPanel
    implements MouseListener,
    WindowListener {
        @Override
        public void paint(Graphics graphics) {
            try {
                char[] cArray;
                int n;
                BufferedImage bufferedImage = new BufferedImage(812, 712, 1);
                Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
                graphics2D.setColor(new Color(0xD3D3D3));
                graphics2D.fillRect(0, 0, 812, 712);
                graphics2D.setColor(Color.WHITE);
                graphics2D.fillRect(0, 0, 701, 701);
                graphics2D.setColor(Color.BLACK);
                graphics2D.drawRect(0, 0, 701, 701);
                for (n = 0; n < SmallPolygonsVis.this.polys.length; ++n) {
                    int n2;
                    int n3 = SmallPolygonsVis.this.polysVert[n];
                    if (SmallPolygonsVis.this.valid[n]) {
                        float f = (float)n / (float)SmallPolygonsVis.this.polys.length;
                        graphics2D.setColor(Color.getHSBColor(f, 0.9f, 1.0f));
                        int[] nArray = new int[n3];
                        int[] nArray2 = new int[n3];
                        for (n2 = 0; n2 < n3; ++n2) {
                            nArray[n2] = SmallPolygonsVis.this.p[SmallPolygonsVis.this.polys[n][n2]].x;
                            nArray2[n2] = 699 - SmallPolygonsVis.this.p[SmallPolygonsVis.this.polys[n][n2]].y;
                        }
                        graphics2D.fillPolygon(nArray, nArray2, n3);
                    }
                    if (SmallPolygonsVis.this.valid[n]) {
                        graphics2D.setColor(Color.GREEN);
                    } else {
                        graphics2D.setColor(Color.RED);
                    }
                    for (n2 = 0; n2 < n3; ++n2) {
                        graphics2D.drawLine(SmallPolygonsVis.this.p[SmallPolygonsVis.this.polys[n][n2]].x, 699 - SmallPolygonsVis.this.p[SmallPolygonsVis.this.polys[n][n2]].y, SmallPolygonsVis.this.p[SmallPolygonsVis.this.polys[n][(n2 + 1) % n3]].x, 699 - SmallPolygonsVis.this.p[SmallPolygonsVis.this.polys[n][(n2 + 1) % n3]].y);
                    }
                    if (SmallPolygonsVis.this.badEdges.size() <= 0) continue;
                    graphics2D.setColor(Color.RED);
                    graphics2D.setStroke(new BasicStroke(3.0f));
                    for (n2 = 0; n2 < n3; ++n2) {
                        if (!SmallPolygonsVis.this.badEdges.contains(SmallPolygonsVis.this.polys[n][n2])) continue;
                        graphics2D.drawLine(SmallPolygonsVis.this.p[SmallPolygonsVis.this.polys[n][n2]].x, 699 - SmallPolygonsVis.this.p[SmallPolygonsVis.this.polys[n][n2]].y, SmallPolygonsVis.this.p[SmallPolygonsVis.this.polys[n][(n2 + 1) % n3]].x, 699 - SmallPolygonsVis.this.p[SmallPolygonsVis.this.polys[n][(n2 + 1) % n3]].y);
                    }
                    graphics2D.setStroke(new BasicStroke(1.0f));
                }
                graphics2D.setColor(new Color(6591981));
                for (n = 0; n < SmallPolygonsVis.this.Ncur; ++n) {
                    graphics2D.drawLine(SmallPolygonsVis.this.p[SmallPolygonsVis.this.Pcur[n]].x, 699 - SmallPolygonsVis.this.p[SmallPolygonsVis.this.Pcur[n]].y, SmallPolygonsVis.this.p[SmallPolygonsVis.this.Pcur[(n + 1) % SmallPolygonsVis.this.Ncur]].x, 699 - SmallPolygonsVis.this.p[SmallPolygonsVis.this.Pcur[(n + 1) % SmallPolygonsVis.this.Ncur]].y);
                }
                if (manual) {
                    graphics2D.setColor(Color.BLACK);
                    cArray = "SUBMIT".toCharArray();
                    graphics2D.setFont(new Font("Arial", 1, 16));
                    graphics2D.drawChars(cArray, 0, cArray.length, 720, 30);
                    graphics2D.drawRect(712, 8, 90, 30);
                    cArray = "ADD POLY".toCharArray();
                    graphics2D.setFont(new Font("Arial", 1, 14));
                    graphics2D.drawChars(cArray, 0, cArray.length, 718, 109);
                    graphics2D.drawRect(712, 88, 90, 30);
                    cArray = "DEL POLY".toCharArray();
                    graphics2D.setFont(new Font("Arial", 1, 14));
                    graphics2D.drawChars(cArray, 0, cArray.length, 719, 149);
                    graphics2D.drawRect(712, 128, 90, 30);
                }
                cArray = ("" + SmallPolygonsVis.this.calcScore()).toCharArray();
                graphics2D.setFont(new Font("Arial", 1, 14));
                graphics2D.drawChars(cArray, 0, cArray.length, 710, 200);
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics2D.setFont(new Font("Arial", 0, 10));
                for (n = 0; n < SmallPolygonsVis.this.NP; ++n) {
                    if (SmallPolygonsVis.this.used[n] > -1) {
                        if (SmallPolygonsVis.this.valid[SmallPolygonsVis.this.used[n]]) {
                            graphics2D.setColor(Color.GREEN);
                        } else {
                            graphics2D.setColor(Color.RED);
                        }
                    } else if (SmallPolygonsVis.this.used[n] == -1) {
                        if (SmallPolygonsVis.this.Pcur[SmallPolygonsVis.this.Ncur - 1] == n) {
                            graphics2D.setColor(new Color(6591981));
                        } else {
                            graphics2D.setColor(new Color(128));
                        }
                    } else {
                        graphics2D.setColor(Color.BLACK);
                    }
                    graphics2D.fillOval(SmallPolygonsVis.this.p[n].x - 2, 699 - SmallPolygonsVis.this.p[n].y - 2, 5, 5);
                    if (!debug) continue;
                    graphics2D.setColor(Color.BLACK);
                    cArray = (n + "").toCharArray();
                    graphics2D.drawChars(cArray, 0, cArray.length, SmallPolygonsVis.this.p[n].x + 2, 699 - SmallPolygonsVis.this.p[n].y - 2);
                }
                graphics.drawImage(bufferedImage, 0, 0, 812, 712, null);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public Vis() {
            if (manual) {
                this.addMouseListener(this);
            }
            SmallPolygonsVis.this.jf.addWindowListener(this);
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            if (n > 700) {
                int n3;
                if (n2 >= 8 && n2 <= 38) {
                    SmallPolygonsVis.this.ready = true;
                }
                if (n2 >= 88 && n2 <= 118) {
                    String string = SmallPolygonsVis.this.validatePoly(SmallPolygonsVis.this.Pcur, SmallPolygonsVis.this.Ncur);
                    if (string.length() != 0) {
                        System.out.println("Current polygon is invalid: " + string);
                    } else {
                        for (n3 = 0; n3 < SmallPolygonsVis.this.polys.length && SmallPolygonsVis.this.polysVert[n3] != 0; ++n3) {
                        }
                        if (n3 == SmallPolygonsVis.this.polys.length) {
                            System.out.println("Can't have more than " + SmallPolygonsVis.this.polys.length + " polygons.");
                        } else {
                            if (debug) {
                                System.out.println("Adding current polygon to slot " + n3);
                            }
                            SmallPolygonsVis.this.polysVert[n3] = SmallPolygonsVis.this.Ncur;
                            SmallPolygonsVis.this.valid[n3] = true;
                            if (SmallPolygonsVis.this.polys[n3] == null || SmallPolygonsVis.this.polys[n3].length < SmallPolygonsVis.this.Ncur) {
                                SmallPolygonsVis.this.polys[n3] = new int[SmallPolygonsVis.this.Ncur];
                            }
                            for (int i = 0; i < SmallPolygonsVis.this.Ncur; ++i) {
                                SmallPolygonsVis.this.polys[n3][i] = SmallPolygonsVis.this.Pcur[i];
                                SmallPolygonsVis.this.used[SmallPolygonsVis.this.Pcur[i]] = n3;
                            }
                            SmallPolygonsVis.this.Ncur = 0;
                            ++SmallPolygonsVis.this.Npoly;
                        }
                    }
                }
                if (n2 >= 128 && n2 <= 158) {
                    if (debug) {
                        System.out.println("Deleting current polygon");
                    }
                    for (n3 = 0; n3 < SmallPolygonsVis.this.Ncur; ++n3) {
                        SmallPolygonsVis.this.used[SmallPolygonsVis.this.Pcur[n3]] = -2;
                    }
                    SmallPolygonsVis.this.Ncur = 0;
                }
                SmallPolygonsVis.this.draw();
                return;
            }
            int n4 = SmallPolygonsVis.this.coordToPoint[n][n2 = 700 - n2 - 1];
            if (n4 == -1) {
                return;
            }
            int n5 = SmallPolygonsVis.this.used[n4];
            if (SmallPolygonsVis.this.Ncur == 0 && n5 > -1) {
                if (debug) {
                    System.out.println("Editing polygon " + n5);
                }
                SmallPolygonsVis.this.Ncur = SmallPolygonsVis.this.polysVert[n5];
                SmallPolygonsVis.this.polysVert[n5] = 0;
                SmallPolygonsVis.this.valid[n5] = false;
                for (int i = 0; i < SmallPolygonsVis.this.Ncur; ++i) {
                    SmallPolygonsVis.this.Pcur[i] = SmallPolygonsVis.this.polys[n5][i];
                    SmallPolygonsVis.this.polys[n5][i] = -1;
                    SmallPolygonsVis.this.used[SmallPolygonsVis.this.Pcur[i]] = -1;
                }
                --SmallPolygonsVis.this.Npoly;
            } else if (SmallPolygonsVis.this.Ncur > 0 && n5 == -1 && SmallPolygonsVis.this.Pcur[SmallPolygonsVis.this.Ncur - 1] == n4) {
                if (debug) {
                    System.out.println("Removing point " + n4 + " from current polygon");
                }
                --SmallPolygonsVis.this.Ncur;
                SmallPolygonsVis.this.used[n4] = -2;
                SmallPolygonsVis.this.Pcur[SmallPolygonsVis.this.Ncur] = -2;
            } else if (n5 == -2) {
                if (debug) {
                    System.out.println("Adding point " + n4 + " to current polygon");
                }
                SmallPolygonsVis.this.Pcur[SmallPolygonsVis.this.Ncur] = n4;
                ++SmallPolygonsVis.this.Ncur;
                SmallPolygonsVis.this.used[n4] = -1;
            } else {
                if (debug) {
                    System.out.println("Invalid action");
                }
                return;
            }
            SmallPolygonsVis.this.draw();
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            if (proc != null) {
                try {
                    proc.destroy();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            System.exit(0);
        }

        @Override
        public void windowActivated(WindowEvent windowEvent) {
        }

        @Override
        public void windowDeactivated(WindowEvent windowEvent) {
        }

        @Override
        public void windowOpened(WindowEvent windowEvent) {
        }

        @Override
        public void windowClosed(WindowEvent windowEvent) {
        }

        @Override
        public void windowIconified(WindowEvent windowEvent) {
        }

        @Override
        public void windowDeiconified(WindowEvent windowEvent) {
        }
    }
}

