/*
 * Decompiled with CFR 0.152.
 */
class Edge {
    public Pnt p1;
    public Pnt p2;
    public Pnt vect;
    public double norm;

    public Edge() {
    }

    public Edge(Pnt pnt, Pnt pnt2) {
        this.p1 = pnt;
        this.p2 = pnt2;
        this.vect = G2D.substr(this.p2, this.p1);
        this.norm = G2D.norm(this.vect);
    }

    public Edge(int n, int n2, int n3, int n4) {
        this.p1 = new Pnt(n, n2);
        this.p2 = new Pnt(n3, n4);
        this.vect = G2D.substr(this.p2, this.p1);
        this.norm = G2D.norm(this.vect);
    }

    boolean eq(double d, double d2) {
        return Math.abs(d - d2) < 1.0E-9;
    }

    public boolean intersect(Edge edge) {
        if (Math.min(this.p1.x, this.p2.x) > Math.max(edge.p1.x, edge.p2.x)) {
            return false;
        }
        if (Math.max(this.p1.x, this.p2.x) < Math.min(edge.p1.x, edge.p2.x)) {
            return false;
        }
        if (Math.min(this.p1.y, this.p2.y) > Math.max(edge.p1.y, edge.p2.y)) {
            return false;
        }
        if (Math.max(this.p1.y, this.p2.y) < Math.min(edge.p1.y, edge.p2.y)) {
            return false;
        }
        int n = edge.vect.y * this.vect.x - edge.vect.x * this.vect.y;
        int n2 = edge.vect.x * (this.p1.y - edge.p1.y) - edge.vect.y * (this.p1.x - edge.p1.x);
        int n3 = this.vect.x * (this.p1.y - edge.p1.y) - this.vect.y * (this.p1.x - edge.p1.x);
        if (n == 0) {
            if (Math.min(edge.dist2(this), this.dist2(edge)) > 0.0) {
                return false;
            }
            return !(this.p1 == edge.p1 && this.eq(G2D.dist(this.p2, edge.p2), this.norm + edge.norm) || this.p1 == edge.p2 && this.eq(G2D.dist(this.p2, edge.p1), this.norm + edge.norm) || this.p2 == edge.p1 && this.eq(G2D.dist(this.p1, edge.p2), this.norm + edge.norm)) && (this.p2 != edge.p2 || !this.eq(G2D.dist(this.p1, edge.p1), this.norm + edge.norm));
        }
        if (this.p1 == edge.p1 || this.p1 == edge.p2 || this.p2 == edge.p1 || this.p2 == edge.p2) {
            return false;
        }
        double d = (double)n2 * 1.0 / (double)n;
        double d2 = (double)n3 * 1.0 / (double)n;
        return !(d < 0.0 || d > 1.0 || d2 < 0.0) && !(d2 > 1.0);
    }

    public double dist(Pnt pnt) {
        if (G2D.dot(this.vect, G2D.substr(pnt, this.p1)) <= 0) {
            return G2D.dist(pnt, this.p1);
        }
        if (G2D.dot(this.vect, G2D.substr(pnt, this.p2)) >= 0) {
            return G2D.dist(pnt, this.p2);
        }
        return (double)Math.abs(-this.vect.y * pnt.x + this.vect.x * pnt.y + this.p1.x * this.p2.y - this.p1.y * this.p2.x) / this.norm;
    }

    public double dist2(Edge edge) {
        return Math.min(this.dist(edge.p1), this.dist(edge.p2));
    }
}

