/*
 * Decompiled with CFR 0.152.
 */
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Label;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.util.Random;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Packing {
    Controller c;
    View v;
    String[] paramNames = new String[]{"seed", "rows", "cols"};
    static Object runlock = new Object();
    String[][] pieces = new String[][]{{"XX", "XX"}, {"XXXX"}, {"XXX", ".X."}, {"XXX", "..X"}, {"XXX", "X.."}, {"XX.", ".XX"}, {".XX", "XX."}, {"XXXXX"}, {"XXX", "XX."}, {"XXX", ".XX"}, {"XXXX", ".X.."}, {"XXXX", "..X."}, {"XXX", "X.X"}, {"XX.", ".XX", ".X."}, {".XX", "XX.", "X.."}, {"XXX.", "..XX"}, {".XXX", "XX.."}, {".XX", "XX.", ".X."}, {"XXXX", "X..."}, {"XXXX", "...X"}, {"XX.", ".X.", ".XX"}, {".XX", ".X.", "XX."}, {"X..", "X..", "XXX"}, {"XXX", ".X.", ".X."}, {".X.", "XXX", ".X."}};

    public String getProcess() {
        if (this.v != null) {
            return this.v.fileName.getText();
        }
        return this.c.process;
    }

    public void setProcess(String string) {
        this.c.process = string;
        if (this.v != null) {
            this.v.fileName.setText(string);
        }
    }

    public static void main(String[] stringArray) {
        new Packing(stringArray);
    }

    public Packing(String[] stringArray) {
        int n = 1000;
        int n2 = 1000;
        boolean bl = false;
        boolean bl2 = false;
        this.c = new Controller();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-exec")) {
                bl2 = true;
                this.setProcess(stringArray[++i]);
                continue;
            }
            if (stringArray[i].equals("-drop")) {
                this.c.setDrop(true);
                continue;
            }
            if (stringArray[i].equals("-go")) {
                bl = true;
                continue;
            }
            if (stringArray[i].equals("-novis")) {
                bl = true;
                this.c.novis = true;
                continue;
            }
            if (stringArray[i].equals("-width")) {
                n2 = Integer.parseInt(stringArray[++i]);
                continue;
            }
            if (stringArray[i].equals("-height")) {
                n = Integer.parseInt(stringArray[++i]);
                continue;
            }
            if (stringArray[i].equals("-speed")) {
                int n3 = Integer.parseInt(stringArray[++i]);
                this.c.setSlide(n3);
                if (n3 >= 80) {
                    this.c.setPause(100 - n3);
                    continue;
                }
                this.c.setPause((int)(5000.0 * Math.pow(0.9333096363135965, n3)));
                continue;
            }
            if (!stringArray[i].startsWith("-")) continue;
            String string = stringArray[i].substring(1);
            String string2 = stringArray[++i];
            try {
                Field field = this.c.getClass().getDeclaredField(string);
                field.set(this.c, new Integer(string2));
                continue;
            }
            catch (Exception exception) {
                System.err.println("Invalid parameters");
                return;
            }
        }
        if (this.c.novis && !bl2) {
            System.err.println("You must specify the executable when using -novis");
            return;
        }
        this.c.generate(false, this.c.getSeed());
        if (!this.c.novis) {
            this.v = new View(n);
            this.v.setSize(n2, n);
            this.v.setVisible(true);
        } else {
            System.out.println("rows = " + this.c.rows + ", cols = " + this.c.cols);
        }
        if (bl) {
            this.c.start();
        }
    }

    class ManualPlay
    implements MouseMotionListener,
    MouseListener {
        int idx;
        int rotate;
        int px;
        int py;
        int pr;

        int x(MouseEvent mouseEvent) {
            if (this.rotate % 2 == 0) {
                return Packing.this.v.sim.x(mouseEvent.getX()) - Packing.this.pieces[this.idx][0].length() + 1;
            }
            return Packing.this.v.sim.x(mouseEvent.getX()) - Packing.this.pieces[this.idx].length + 1;
        }

        int y(MouseEvent mouseEvent) {
            if (this.rotate % 2 == 1) {
                return Packing.this.v.sim.y(mouseEvent.getY()) - Packing.this.pieces[this.idx][0].length() + 1;
            }
            return Packing.this.v.sim.y(mouseEvent.getY()) - Packing.this.pieces[this.idx].length + 1;
        }

        private void move(int n, int n2) {
            if (n != this.px || n2 != this.py || this.rotate != this.pr) {
                Packing.this.c.tmpPlace(this.idx, this.px, this.py, this.pr, -1);
                this.px = n;
                this.py = n2;
                this.pr = this.rotate;
                Packing.this.c.tmpPlace(this.idx, this.px, this.py, this.pr, this.idx);
                Packing.this.v.repaintSim(false);
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            this.move(this.x(mouseEvent), this.y(mouseEvent));
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            this.move(this.x(mouseEvent), this.y(mouseEvent));
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.getButton() == 1) {
                if (Packing.this.c.tryPlace(this.idx, this.x(mouseEvent), this.y(mouseEvent), this.rotate)) {
                    this.idx = Packing.this.c.r.nextInt(Packing.this.pieces.length);
                }
                Packing.this.v.repaintSim(false);
            } else if (mouseEvent.getButton() == 2) {
                this.rotate = (this.rotate + 1) % 4;
                this.move(this.x(mouseEvent), this.y(mouseEvent));
            } else if (mouseEvent.getButton() == 3) {
                this.rotate = (this.rotate + 3) % 4;
                this.move(this.x(mouseEvent), this.y(mouseEvent));
            }
        }

        public ManualPlay() {
            this.idx = Packing.this.c.r.nextInt(Packing.this.pieces.length);
            this.rotate = 0;
        }
    }

    class View
    extends JFrame
    implements WindowListener,
    ChangeListener {
        JTextArea err;
        JTextField fileName;
        JScrollPane scroll;
        JTextField[] params;
        JCheckBox manual;
        int position;
        Vis sim;

        public void windowActivated(WindowEvent windowEvent) {
        }

        public void windowDeactivated(WindowEvent windowEvent) {
        }

        public void windowOpened(WindowEvent windowEvent) {
        }

        public void windowClosing(WindowEvent windowEvent) {
            Packing.this.c.stop();
            System.exit(0);
        }

        public void windowClosed(WindowEvent windowEvent) {
        }

        public void windowIconified(WindowEvent windowEvent) {
        }

        public void windowDeiconified(WindowEvent windowEvent) {
        }

        public View(int n) {
            JSlider jSlider = new JSlider(0, 0, 100, Packing.this.c.getSlide());
            jSlider.addChangeListener(this);
            jSlider.setMajorTickSpacing(20);
            jSlider.setMinorTickSpacing(5);
            jSlider.setPaintTicks(true);
            jSlider.setPaintLabels(true);
            jSlider.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
            this.sim = new Vis();
            this.err = new JTextArea("Standard Error from your program, as well as other messages will appear here");
            this.scroll = new JScrollPane(this.err);
            JSplitPane jSplitPane = new JSplitPane(0, this.sim, this.scroll);
            jSplitPane.setDividerLocation(n - 300);
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 3));
            JLabel jLabel = new JLabel("Speed");
            jLabel.setAlignmentX(0.5f);
            jSplitPane.setAlignmentX(0.5f);
            jPanel.add(jLabel);
            jPanel.add(jSlider);
            this.err.setEditable(false);
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new BoxLayout(jPanel2, 2));
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout(new BoxLayout(jPanel3, 2));
            this.params = new JTextField[Packing.this.paramNames.length];
            for (int i = 0; i < Packing.this.paramNames.length; ++i) {
                this.params[i] = new JTextField(Packing.this.c.getParameter(Packing.this.paramNames[i]));
                if (i <= this.params.length / 2) {
                    jPanel2.add(new Label(Packing.this.paramNames[i] + ": "));
                    jPanel2.add(this.params[i]);
                    continue;
                }
                jPanel3.add(new Label(Packing.this.paramNames[i] + ": "));
                jPanel3.add(this.params[i]);
            }
            this.manual = new JCheckBox("Manual Play");
            jPanel3.add(this.manual);
            jPanel2.setAlignmentX(0.5f);
            jPanel3.setAlignmentX(0.5f);
            JPanel jPanel4 = new JPanel();
            jPanel4.setLayout(new BoxLayout(jPanel4, 2));
            JButton jButton = new JButton("Generate Map");
            JButton jButton2 = new JButton("New Parameters and Map");
            JButton jButton3 = new JButton("Start Simulation");
            JButton jButton4 = new JButton("Stop Simulation");
            jPanel4.add(jButton);
            jPanel4.add(jButton2);
            jPanel4.add(jButton3);
            jPanel4.add(jButton4);
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Packing.this.c.stop();
                    Packing.this.c.generate(false, Integer.parseInt(View.this.params[0].getText()));
                    View.this.sim.bi = null;
                    View.this.sim.rebuffer();
                    View.this.repaintSim(false);
                }
            });
            jButton2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Packing.this.c.stop();
                    if (Packing.this.c.getSeed() == Integer.parseInt(View.this.params[0].getText())) {
                        View.this.params[0].setText(String.valueOf(Packing.this.c.newSeed()));
                        Packing.this.c.generate(true, Integer.parseInt(View.this.params[0].getText()));
                    } else {
                        Packing.this.c.generate(true, Integer.parseInt(View.this.params[0].getText()));
                    }
                    for (int i = 1; i < View.this.params.length; ++i) {
                        View.this.params[i].setText(Packing.this.c.getParameter(Packing.this.paramNames[i]));
                    }
                    View.this.sim.bi = null;
                    View.this.sim.rebuffer();
                    View.this.repaintSim(false);
                }
            });
            jButton3.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Packing.this.c.stop();
                    try {
                        Thread.sleep(20L);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    Packing.this.c.generate(false, Integer.parseInt(View.this.params[0].getText()));
                    View.this.sim.bi = null;
                    View.this.sim.rebuffer();
                    View.this.repaintSim(false);
                    Packing.this.c.start();
                }
            });
            jButton4.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Packing.this.c.stop();
                }
            });
            JPanel jPanel5 = new JPanel();
            JButton jButton5 = new JButton("Select Executable");
            this.fileName = new JTextField(Packing.this.c.process);
            jPanel5.add(jButton5);
            jPanel5.add(this.fileName);
            jPanel5.setLayout(new BoxLayout(jPanel5, 2));
            jButton5.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JFileChooser jFileChooser = new JFileChooser();
                    int n = jFileChooser.showOpenDialog(View.this);
                    if (n == 0) {
                        View.this.fileName.setText(jFileChooser.getSelectedFile().getPath());
                        Packing.this.c.process = jFileChooser.getSelectedFile().getPath();
                    }
                }
            });
            JPanel jPanel6 = new JPanel();
            jPanel6.setLayout(new BoxLayout(jPanel6, 3));
            jPanel6.add(jPanel2);
            jPanel6.add(jPanel3);
            jPanel6.add(jPanel4);
            jPanel6.add(jPanel5);
            this.add((Component)jPanel, "North");
            this.add((Component)jSplitPane, "Center");
            this.add((Component)jPanel6, "South");
            this.addWindowListener(this);
        }

        public void stateChanged(ChangeEvent changeEvent) {
            JSlider jSlider = (JSlider)changeEvent.getSource();
            if (jSlider.getValue() >= 80) {
                Packing.this.c.setPause(100 - jSlider.getValue());
            } else {
                Packing.this.c.setPause((int)(5000.0 * Math.pow(0.9333096363135965, jSlider.getValue())));
            }
        }

        void addMessage(final String string) {
            final JScrollBar jScrollBar = this.scroll.getVerticalScrollBar();
            if (!(jScrollBar.getValueIsAdjusting() || jScrollBar.getValue() + jScrollBar.getVisibleAmount() != jScrollBar.getMaximum() && jScrollBar.getValue() != this.position)) {
                Runnable runnable = new Runnable(){

                    public void run() {
                        View.this.err.append(string);
                        View.this.position = jScrollBar.getMaximum() - jScrollBar.getVisibleAmount();
                        jScrollBar.setValue(View.this.position);
                    }
                };
                try {
                    SwingUtilities.invokeAndWait(runnable);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else {
                this.position = -1;
                this.err.append(string);
            }
        }

        void repaintSim(boolean bl) {
            Runnable runnable = new Runnable(){

                public void run() {
                    View.this.sim.paintImmediately(0, 0, View.this.sim.getWidth(), View.this.sim.getHeight());
                }
            };
            if (bl && !Packing.this.c.drop()) {
                try {
                    SwingUtilities.invokeAndWait(runnable);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else {
                this.sim.repaint();
            }
        }

        public String getParam(int n) {
            String string = this.params[n].getText();
            return string;
        }

        class Vis
        extends JPanel {
            Color[] cs = new Color[26];
            int size = 12;
            BufferedImage bi = null;
            double scale;
            double xoff;
            double yoff;

            Vis() {
                this.cs[0] = Color.white;
                this.cs[1] = Color.blue;
                this.cs[2] = Color.red;
                this.cs[3] = Color.green;
                this.cs[4] = Color.black;
                this.cs[5] = Color.cyan;
                this.cs[6] = Color.yellow;
                this.cs[7] = Color.magenta;
                Random random = new Random(33L);
                for (int i = 8; i < this.cs.length; ++i) {
                    int n;
                    int n2;
                    int n3 = random.nextInt(6);
                    if (n3 + (n2 = random.nextInt(6)) + (n = random.nextInt(6)) >= 10) {
                        --i;
                        continue;
                    }
                    this.cs[i] = new Color(n3 * 51, n2 * 51, n * 51);
                }
            }

            public int x(int n) {
                return (int)(((double)n / this.scale - this.xoff) / 12.0);
            }

            public int y(int n) {
                return (int)(((double)n / this.scale - this.yoff) / 12.0);
            }

            public void paint(Graphics graphics) {
                if (this.bi == null) {
                    this.rebuffer();
                }
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics2D.setColor(Color.white);
                graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
                this.scale = Math.min((double)this.getWidth() / (double)this.bi.getWidth(), (double)this.getHeight() / (double)this.bi.getHeight());
                if (this.scale > 1.0) {
                    this.scale = (int)this.scale;
                } else {
                    int n = 1;
                    while (true) {
                        if (this.scale > 1.0 / (double)n) {
                            this.scale = 1.0 / (double)n;
                            break;
                        }
                        ++n;
                    }
                }
                this.xoff = ((double)this.getWidth() - (double)this.bi.getWidth() * this.scale) / 2.0 / this.scale;
                this.yoff = ((double)this.getHeight() - (double)this.bi.getHeight() * this.scale) / 2.0 / this.scale;
                AffineTransform affineTransform = new AffineTransform();
                affineTransform.scale(this.scale, this.scale);
                affineTransform.translate(this.xoff, this.yoff);
                AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, 2);
                AffineTransform affineTransform2 = graphics2D.getTransform();
                graphics2D.drawImage(this.bi, affineTransformOp, 0, 0);
                graphics2D.setTransform(affineTransform2);
                Font font = new Font(graphics2D.getFont().getName(), 0, 40);
                graphics2D.setFont(font);
                FontMetrics fontMetrics = graphics2D.getFontMetrics();
                int n = fontMetrics.getAscent();
                String string = Packing.this.c.filled + " / " + Packing.this.c.rows * Packing.this.c.cols;
                int n2 = fontMetrics.stringWidth(string);
                graphics2D.setColor(Color.black);
                graphics2D.drawString(string, 0, n);
            }

            public void update(int n, int n2, int n3, boolean bl) {
                Color color;
                Color color2;
                int n4 = 3;
                if (!bl) {
                    color2 = Color.white;
                    color = Color.black;
                } else {
                    color2 = Color.black;
                    color = Color.white;
                }
                Graphics2D graphics2D = (Graphics2D)this.bi.getGraphics();
                graphics2D.setComposite(AlphaComposite.getInstance(n4, bl ? 0.6f : 1.0f));
                graphics2D.setColor(bl ? Color.black : this.cs[n3]);
                graphics2D.fillRect(n2 * this.size, n * this.size, this.size, this.size);
                graphics2D.setComposite(AlphaComposite.getInstance(n4, 0.33f));
                graphics2D.setColor(color2);
                graphics2D.drawRect(n2 * this.size + 2, n * this.size + 2, this.size - 2, this.size - 2);
                graphics2D.setColor(color);
                graphics2D.drawRect(n2 * this.size, n * this.size, this.size - 2, this.size - 2);
                graphics2D.setComposite(AlphaComposite.getInstance(n4, 0.66f));
                graphics2D.setColor(color2);
                graphics2D.drawRect(n2 * this.size + 1, n * this.size + 1, this.size - 1, this.size - 1);
                graphics2D.setColor(color);
                graphics2D.drawRect(n2 * this.size, n * this.size, this.size - 1, this.size - 1);
                graphics2D.setComposite(AlphaComposite.getInstance(n4, 1.0f));
                graphics2D.setColor(Color.gray);
                graphics2D.drawRect(n2 * this.size, n * this.size, this.size, this.size);
            }

            public void rebuffer() {
                int n;
                int n2;
                this.bi = new BufferedImage(Packing.this.c.cols * this.size, Packing.this.c.rows * this.size, 1);
                Graphics2D graphics2D = (Graphics2D)this.bi.getGraphics();
                graphics2D.setColor(Color.white);
                graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
                graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f));
                for (n2 = 0; n2 < Packing.this.c.rows; ++n2) {
                    for (n = 0; n < Packing.this.c.cols; ++n) {
                        graphics2D.setColor(this.cs[0]);
                        graphics2D.fillRect(n * this.size, n2 * this.size, this.size, this.size);
                    }
                }
                graphics2D.setComposite(AlphaComposite.getInstance(3, 0.33f));
                for (n2 = 0; n2 < Packing.this.c.rows; ++n2) {
                    for (n = 0; n < Packing.this.c.cols; ++n) {
                        graphics2D.setColor(Color.white);
                        graphics2D.drawRect(n * this.size + 2, n2 * this.size + 2, this.size - 2, this.size - 2);
                        graphics2D.setColor(Color.black);
                        graphics2D.drawRect(n * this.size, n2 * this.size, this.size - 2, this.size - 2);
                    }
                }
                graphics2D.setComposite(AlphaComposite.getInstance(3, 0.66f));
                for (n2 = 0; n2 < Packing.this.c.rows; ++n2) {
                    for (n = 0; n < Packing.this.c.cols; ++n) {
                        graphics2D.setColor(Color.white);
                        graphics2D.drawRect(n * this.size + 1, n2 * this.size + 1, this.size - 1, this.size - 1);
                        graphics2D.setColor(Color.black);
                        graphics2D.drawRect(n * this.size, n2 * this.size, this.size - 1, this.size - 1);
                    }
                }
                graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f));
                for (n2 = 0; n2 < Packing.this.c.rows; ++n2) {
                    for (n = 0; n < Packing.this.c.cols; ++n) {
                        graphics2D.setColor(Color.gray);
                        graphics2D.drawRect(n * this.size, n2 * this.size, this.size, this.size);
                    }
                }
            }
        }
    }

    class Controller {
        String process = "Enter your executable and its arguments here";
        Runner current;
        Random r;
        int ST = 20;
        int slide = 80;
        int seed;
        boolean running;
        boolean novis;
        boolean drop;
        int rows;
        int cols;
        int filled;
        int idx;
        char[][] board;
        int[] fixed = new int[]{10, 20, 40, 70, 100};
        String placementError;

        Controller() {
        }

        public void generate(boolean bl, int n) {
            this.seed = n;
            this.r = new Random(n);
            if (bl) {
                if (n >= 1 && n <= 5) {
                    this.rows = this.cols = this.fixed[n - 1];
                } else {
                    this.cols = this.r.nextInt(91) + 10;
                    this.rows = this.r.nextInt(91) + 10;
                }
            } else {
                if (this.cols == 0) {
                    this.cols = this.r.nextInt(91) + 10;
                    if (n >= 1 && n <= 5) {
                        this.cols = this.fixed[n - 1];
                    }
                } else {
                    this.r.nextInt(91);
                }
                if (this.rows == 0) {
                    this.rows = this.r.nextInt(91) + 10;
                    if (n >= 1 && n <= 5) {
                        this.rows = this.fixed[n - 1];
                    }
                } else {
                    this.r.nextInt(91);
                }
                if (Packing.this.v != null) {
                    try {
                        for (int i = 1; i < Packing.this.paramNames.length; ++i) {
                            Field field = this.getClass().getDeclaredField(Packing.this.paramNames[i]);
                            field.set(this, new Integer(Packing.this.v.getParam(i)));
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
            this.filled = 0;
            this.board = new char[this.rows][this.cols];
        }

        String[] tos() {
            String[] stringArray = new String[this.board.length];
            char[] cArray = new char[this.board[0].length];
            for (int i = 0; i < stringArray.length; ++i) {
                for (int j = 0; j < cArray.length; ++j) {
                    cArray[j] = this.board[i][j] == '\u0000' ? 46 : 88;
                }
                stringArray[i] = new String(cArray);
            }
            return stringArray;
        }

        boolean tryPlace(int n, int n2, int n3, int n4) {
            int n5;
            int n6;
            String[] stringArray = Packing.this.pieces[n];
            if (n4 < 0 || n4 > 3) {
                this.placementError = "Invalid rotation value.";
                return false;
            }
            if (n2 < 0 || n3 < 0) {
                this.placementError = "Attempted to place outside of box.";
                return false;
            }
            while (n4 > 0) {
                String[] stringArray2 = new String[stringArray[0].length()];
                for (n6 = 0; n6 < stringArray[0].length(); ++n6) {
                    stringArray2[stringArray[0].length() - n6 - 1] = "";
                    for (int i = 0; i < stringArray.length; ++i) {
                        int n7 = stringArray[0].length() - n6 - 1;
                        stringArray2[n7] = stringArray2[n7] + stringArray[i].charAt(n6);
                    }
                }
                stringArray = stringArray2;
                --n4;
            }
            if (stringArray.length + n3 > this.rows || stringArray[0].length() + n2 > this.cols) {
                this.placementError = "Attempted to place outside of box.";
                return false;
            }
            for (n5 = 0; n5 < stringArray.length; ++n5) {
                for (n6 = 0; n6 < stringArray[n5].length(); ++n6) {
                    if (stringArray[n5].charAt(n6) != 'X' || this.board[n3 + n5][n2 + n6] <= '\u0000') continue;
                    this.placementError = "Placement causes an overlap.";
                    return false;
                }
            }
            for (n5 = 0; n5 < stringArray.length; ++n5) {
                for (n6 = 0; n6 < stringArray[n5].length(); ++n6) {
                    if (stringArray[n5].charAt(n6) != 'X') continue;
                    this.board[n3 + n5][n2 + n6] = (char)(n + 1);
                    ++this.filled;
                    if (this.novis) continue;
                    Packing.this.v.sim.update(n3 + n5, n2 + n6, n + 1, false);
                }
            }
            return true;
        }

        void tmpPlace(int n, int n2, int n3, int n4, int n5) {
            int n6;
            String[] stringArray = Packing.this.pieces[n];
            while (n4 > 0) {
                String[] stringArray2 = new String[stringArray[0].length()];
                for (n6 = 0; n6 < stringArray[0].length(); ++n6) {
                    stringArray2[stringArray[0].length() - n6 - 1] = "";
                    for (int i = 0; i < stringArray.length; ++i) {
                        int n7 = stringArray[0].length() - n6 - 1;
                        stringArray2[n7] = stringArray2[n7] + stringArray[i].charAt(n6);
                    }
                }
                stringArray = stringArray2;
                --n4;
            }
            for (int i = 0; i < stringArray.length; ++i) {
                for (n6 = 0; n6 < stringArray[i].length(); ++n6) {
                    if (stringArray[i].charAt(n6) != 'X') continue;
                    if (n5 >= 0) {
                        Packing.this.v.sim.update(n3 + i, n2 + n6, n5 + 1, true);
                        continue;
                    }
                    if (n3 + i < 0 || n3 + i >= this.board.length || n2 + n6 < 0 || n2 + n6 >= this.board[0].length) continue;
                    Packing.this.v.sim.update(n3 + i, n2 + n6, this.board[n3 + i][n2 + n6], false);
                }
            }
        }

        void start() {
            if (Packing.this.v != null) {
                Packing.this.v.err.setText("");
            }
            this.current = new Runner();
            this.current.start();
        }

        void stop() {
            this.running = false;
            if (this.current != null) {
                if (this.current.manual) {
                    Packing.this.v.sim.removeMouseListener(this.current.mp);
                    Packing.this.v.sim.removeMouseMotionListener(this.current.mp);
                } else {
                    try {
                        if (this.current.pr != null) {
                            this.current.pr.destroy();
                            this.current.pr.waitFor();
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                this.current = null;
            }
        }

        public int newSeed() {
            return this.r.nextInt();
        }

        public void setSeed(int n) {
            this.seed = n;
        }

        public int getSeed() {
            return this.seed;
        }

        public String getParameter(String string) {
            try {
                Field field = this.getClass().getDeclaredField(string);
                return field.get(this).toString();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return "ERR";
            }
        }

        public void setParameter(String string, String string2) {
            try {
                Field field = this.getClass().getDeclaredField(string);
                field.set(this, Integer.parseInt(string2));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public int getSlide() {
            return this.slide;
        }

        public void setSlide(int n) {
            this.slide = n;
        }

        public void setPause(int n) {
            this.ST = n;
        }

        public void addMessage(String string) {
            if (this.novis) {
                System.out.print(string);
            } else {
                Packing.this.v.addMessage(string);
            }
        }

        public void addFatalError(String string) {
            this.addMessage(string);
        }

        public boolean drop() {
            return this.drop;
        }

        public void setDrop(boolean bl) {
            this.drop = bl;
        }

        class Runner
        extends Thread {
            Process pr;
            BufferedReader input;
            InputStream error;
            DataOutputStream os;
            boolean writeboard = true;
            boolean manual = false;
            ManualPlay mp;

            Runner() {
            }

            void write(String[] stringArray) throws IOException {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(stringArray.length).append(' ');
                stringBuffer.append(stringArray[0].length()).append('\n');
                for (int i = 0; i < stringArray.length; ++i) {
                    stringBuffer.append(stringArray[i]).append('\n');
                }
                this.os.write(stringBuffer.toString().getBytes());
                this.os.flush();
            }

            void writeBoard() throws IOException {
                this.write(Controller.this.tos());
            }

            int[] next() throws IOException {
                try {
                    String string = this.input.readLine();
                    if (string == null) {
                        return null;
                    }
                    StringTokenizer stringTokenizer = new StringTokenizer(string);
                    while (!stringTokenizer.hasMoreTokens()) {
                        string = this.input.readLine();
                        if (string == null) {
                            return null;
                        }
                        stringTokenizer = new StringTokenizer(string);
                    }
                    int[] nArray = new int[3];
                    for (int i = 0; i < nArray.length; ++i) {
                        while (!stringTokenizer.hasMoreTokens()) {
                            string = this.input.readLine();
                            if (string == null) {
                                return null;
                            }
                            stringTokenizer = new StringTokenizer(string);
                        }
                        nArray[i] = Integer.parseInt(stringTokenizer.nextToken());
                    }
                    return nArray;
                }
                catch (Exception exception) {
                    return null;
                }
            }

            public void run() {
                if (Controller.this.novis || !Packing.this.v.manual.isSelected()) {
                    this.runTest();
                    this.pr.destroy();
                } else {
                    this.manual = true;
                    this.mp = new ManualPlay();
                    Packing.this.v.sim.addMouseListener(this.mp);
                    Packing.this.v.sim.addMouseMotionListener(this.mp);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void runTest() {
                Controller.this.running = true;
                try {
                    Object object = runlock;
                    synchronized (object) {
                        this.pr = Runtime.getRuntime().exec(Packing.this.getProcess());
                        this.input = new BufferedReader(new InputStreamReader(this.pr.getInputStream()));
                        this.error = this.pr.getErrorStream();
                        this.os = new DataOutputStream(this.pr.getOutputStream());
                        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                            public void run() {
                                Runner.this.pr.destroy();
                            }
                        }));
                        Thread thread = new Thread(new Runnable(){

                            public void run() {
                                try {
                                    int n;
                                    byte[] byArray = new byte[50000];
                                    while ((n = Runner.this.error.read(byArray)) > 0 && Controller.this.running) {
                                        Controller.this.addMessage(new String(byArray, 0, n));
                                    }
                                    Controller.this.addMessage("\n");
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        });
                        thread.start();
                        if (!this.writeboard) {
                            this.os.write((Packing.this.c.rows + " " + Packing.this.c.cols + "\n").getBytes());
                            this.os.flush();
                        }
                        while (Controller.this.running) {
                            if (this.writeboard) {
                                this.writeBoard();
                            }
                            Controller.this.idx = Controller.this.r.nextInt(Packing.this.pieces.length);
                            this.write(Packing.this.pieces[Controller.this.idx]);
                            int[] nArray = this.next();
                            if (nArray == null) break;
                            if (nArray.length != 3) {
                                Controller.this.addMessage("Your output was not a properly formatted array of length 3.\n");
                                break;
                            }
                            if (!Controller.this.tryPlace(Controller.this.idx, nArray[0], nArray[1], nArray[2])) {
                                Controller.this.addMessage(Controller.this.placementError + "\n");
                                break;
                            }
                            if (Controller.this.novis) continue;
                            Packing.this.v.repaintSim(true);
                            if (Controller.this.ST == 0) continue;
                            Thread.sleep(Controller.this.ST);
                        }
                        if (Controller.this.novis) {
                            Controller.this.addMessage("You filled " + Controller.this.filled + " squares, leaving " + (Controller.this.rows * Controller.this.cols - Controller.this.filled) + " squares unfilled\n");
                        }
                    }
                }
                catch (IOException iOException) {
                    Controller.this.addMessage("Simulation over because communication between the visualizer and your process ended.\n");
                    Controller.this.addMessage(iOException.getMessage() + "\n");
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }
}

