/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Graphics;

public class voronoi {
    float borderMinX;
    float borderMaxX;
    float borderMinY;
    float borderMaxY;
    int siteidx = 0;
    float xmin;
    float xmax;
    float ymin;
    float ymax;
    float deltax;
    float deltay;
    int nvertices;
    int nedges;
    int nsites;
    Hfreelist hfl;
    Efreelist efl;
    Sfreelist sfl;
    Site[] sites = null;
    Site bottomsite;
    int sqrt_nsites;
    float minDistanceBetweenSites = 0.0f;
    int PQcount;
    int PQmin;
    int PQhashsize;
    Halfedge[] PQhash;
    public static int le = 0;
    public static int re = 1;
    int ELhashsize;
    Halfedge[] ELhash;
    Halfedge ELleftend;
    Halfedge ELrightend;
    GraphEdge allEdges = null;
    GraphEdge iteratorEdges = null;
    Boolean VorSim = false;
    Graphics g = null;
    Canvas c = null;
    int w = 0;
    int h = 0;
    double lasty = 0.0;
    int[] beachline_bake = null;

    voronoi() {
    }

    public void VorSim(boolean bl, Graphics graphics, int n, int n2, Canvas canvas) {
        this.VorSim = bl;
        this.c = canvas;
        this.g = graphics;
        this.w = n;
        this.h = n2;
    }

    void cleanupSites() {
        if (this.sites != null) {
            for (int i = 0; i < this.sites.length; ++i) {
                this.sites[i] = null;
            }
        }
        this.sites = null;
    }

    void cleanupEdges() {
        GraphEdge graphEdge = this.allEdges;
        while (graphEdge != null && graphEdge.next != null) {
            GraphEdge graphEdge2 = graphEdge;
            graphEdge = graphEdge.next;
            graphEdge2 = null;
        }
        this.allEdges = null;
    }

    void dVoronoiDiagramGenerator() {
        this.cleanupSites();
        this.cleanupEdges();
        this.sfl = null;
        this.efl = null;
    }

    int scomp(Site site, Site site2) {
        Point point = site.coord;
        Point point2 = site2.coord;
        if (point.y < point2.y) {
            return -1;
        }
        if (point.y > point2.y) {
            return 1;
        }
        if (point.x < point2.x) {
            return -1;
        }
        if (point.x > point2.x) {
            return 1;
        }
        return 0;
    }

    void qsort(Site[] siteArray, int n) {
        if (n == 1) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            for (int j = i + 1; j < n; ++j) {
                if (this.scomp(siteArray[i], siteArray[j]) <= 0) continue;
                Site site = siteArray[i];
                siteArray[i] = siteArray[j];
                siteArray[j] = site;
            }
        }
    }

    public void sortNode(float[] fArray, float[] fArray2, int n) {
        this.nsites = n;
        this.sites = new Site[this.nsites];
        this.xmin = fArray[0];
        this.ymin = fArray2[0];
        this.xmax = fArray[0];
        this.ymax = fArray2[0];
        for (int i = 0; i < this.nsites; ++i) {
            this.sites[i] = new Site();
            this.sites[i].coord.setPoint(fArray[i], fArray2[i]);
            this.sites[i].sitenbr = i;
            if (fArray[i] < this.xmin) {
                this.xmin = fArray[i];
            } else if (fArray[i] > this.xmax) {
                this.xmax = fArray[i];
            }
            if (fArray2[i] < this.ymin) {
                this.ymin = fArray2[i];
                continue;
            }
            if (!(fArray2[i] > this.ymax)) continue;
            this.ymax = fArray2[i];
        }
        this.qsort(this.sites, this.nsites);
        this.deltay = this.ymax - this.ymin;
        this.deltax = this.xmax - this.xmin;
    }

    Site nextone() {
        if (this.siteidx < this.nsites) {
            Site site = this.sites[this.siteidx];
            ++this.siteidx;
            return site;
        }
        return null;
    }

    Edge bisect(Site site, Site site2) {
        Edge edge = new Edge();
        edge.reg[0] = site;
        edge.reg[1] = site2;
        edge.ep[0] = null;
        edge.ep[1] = null;
        float f = site2.coord.x - site.coord.x;
        float f2 = site2.coord.y - site.coord.y;
        float f3 = f > 0.0f ? f : -f;
        float f4 = f2 > 0.0f ? f2 : -f2;
        edge.c = (float)((double)(site.coord.x * f + site.coord.y * f2) + (double)(f * f + f2 * f2) * 0.5);
        if (f3 > f4) {
            edge.a = 1.0f;
            edge.b = f2 / f;
            edge.c /= f;
        } else {
            edge.b = 1.0f;
            edge.a = f / f2;
            edge.c /= f2;
        }
        edge.edgenbr = this.nedges++;
        return edge;
    }

    void resetIterator() {
        this.iteratorEdges = this.allEdges;
    }

    GraphEdge getNext() {
        if (this.iteratorEdges != null) {
            GraphEdge graphEdge = this.iteratorEdges;
            this.iteratorEdges = this.iteratorEdges.next;
            return graphEdge;
        }
        return null;
    }

    void Sort(cVertexList cVertexList2) {
        this.dVoronoiDiagramGenerator();
        this.nsites = cVertexList2.n;
        this.minDistanceBetweenSites = 3.0f;
        this.nvertices = 0;
        this.sfl = new Sfreelist();
        this.nedges = 0;
        this.efl = new Efreelist();
        float f = (float)this.nsites + 4.0f;
        this.sqrt_nsites = (int)Math.sqrt(f);
        int n = cVertexList2.n;
        float[] fArray = new float[n];
        float[] fArray2 = new float[n];
        for (int i = 0; i < n; ++i) {
            fArray[i] = cVertexList2.GetElement((int)i).v.x;
            fArray2[i] = cVertexList2.GetElement((int)i).v.y;
        }
        this.sortNode(fArray, fArray2, n);
    }

    void makevertex(Site site) {
        site.sitenbr = this.nvertices++;
    }

    boolean PQinitialize() {
        this.PQcount = 0;
        this.PQmin = 0;
        this.PQhashsize = 4 * this.sqrt_nsites;
        this.PQhash = new Halfedge[this.PQhashsize];
        for (int i = 0; i < this.PQhashsize; ++i) {
            this.PQhash[i] = new Halfedge();
        }
        return true;
    }

    int PQbucket(Halfedge halfedge) {
        int n = (int)((halfedge.ystar - this.ymin) / this.deltay * (float)this.PQhashsize);
        if (n < 0) {
            n = 0;
        }
        if (n >= this.PQhashsize) {
            n = this.PQhashsize - 1;
        }
        if (n < this.PQmin) {
            this.PQmin = n;
        }
        return n;
    }

    void PQinsert(Halfedge halfedge, Site site, float f) {
        Halfedge halfedge2;
        halfedge.vertex = site;
        halfedge.ystar = site.coord.y + f;
        Halfedge halfedge3 = this.PQhash[this.PQbucket(halfedge)];
        while ((halfedge2 = halfedge3.PQnext) != null && (halfedge.ystar > halfedge2.ystar || halfedge.ystar == halfedge2.ystar && site.coord.x > halfedge2.vertex.coord.x)) {
            halfedge3 = halfedge2;
        }
        halfedge.PQnext = halfedge3.PQnext;
        halfedge3.PQnext = halfedge;
        ++this.PQcount;
    }

    void PQdelete(Halfedge halfedge) {
        if (halfedge.vertex != null) {
            Halfedge halfedge2 = this.PQhash[this.PQbucket(halfedge)];
            while (halfedge2.PQnext != halfedge) {
                halfedge2 = halfedge2.PQnext;
            }
            halfedge2.PQnext = halfedge.PQnext;
            --this.PQcount;
            halfedge.vertex = null;
        }
    }

    boolean PQempty() {
        return this.PQcount == 0;
    }

    Point PQ_min() {
        Point point = new Point();
        while (this.PQhash[this.PQmin].PQnext == null) {
            ++this.PQmin;
        }
        point.x = this.PQhash[this.PQmin].PQnext.vertex.coord.x;
        point.y = this.PQhash[this.PQmin].PQnext.ystar;
        return point;
    }

    Halfedge PQextractmin() {
        Halfedge halfedge = this.PQhash[this.PQmin].PQnext;
        this.PQhash[this.PQmin].PQnext = halfedge.PQnext;
        --this.PQcount;
        return halfedge;
    }

    Halfedge HEcreate(Edge edge, int n) {
        Halfedge halfedge = new Halfedge();
        halfedge.ELedge = edge;
        halfedge.ELpm = n;
        halfedge.PQnext = null;
        halfedge.vertex = null;
        return halfedge;
    }

    boolean ELinitialize() {
        this.ELhashsize = 2 * this.sqrt_nsites;
        this.ELhash = new Halfedge[this.ELhashsize];
        for (int i = 0; i < this.ELhashsize; ++i) {
            this.ELhash[i] = null;
        }
        this.ELleftend = this.HEcreate(null, 0);
        this.ELrightend = this.HEcreate(null, 0);
        this.ELleftend.ELleft = null;
        this.ELleftend.ELright = this.ELrightend;
        this.ELrightend.ELleft = this.ELleftend;
        this.ELrightend.ELright = null;
        this.ELhash[0] = this.ELleftend;
        this.ELhash[this.ELhashsize - 1] = this.ELrightend;
        return true;
    }

    Halfedge ELright(Halfedge halfedge) {
        return halfedge.ELright;
    }

    Halfedge ELleft(Halfedge halfedge) {
        return halfedge.ELleft;
    }

    Site leftreg(Halfedge halfedge) {
        if (halfedge.ELedge == null) {
            return this.bottomsite;
        }
        return halfedge.ELpm == le ? halfedge.ELedge.reg[le] : halfedge.ELedge.reg[re];
    }

    void ELinsert(Halfedge halfedge, Halfedge halfedge2) {
        halfedge2.ELleft = halfedge;
        halfedge2.ELright = halfedge.ELright;
        halfedge.ELright.ELleft = halfedge2;
        halfedge.ELright = halfedge2;
    }

    void ELdelete(Halfedge halfedge) {
        halfedge.ELleft.ELright = halfedge.ELright;
        halfedge.ELright.ELleft = halfedge.ELleft;
        halfedge.deleted = true;
    }

    Halfedge ELgethash(int n) {
        if (n < 0 || n >= this.ELhashsize) {
            return null;
        }
        Halfedge halfedge = this.ELhash[n];
        if (halfedge == null || !halfedge.deleted) {
            return halfedge;
        }
        this.ELhash[n] = null;
        return null;
    }

    Halfedge ELleftbnd(Point point) {
        Halfedge halfedge;
        int n = (int)((point.x - this.xmin) / this.deltax * (float)this.ELhashsize);
        if (n < 0) {
            n = 0;
        }
        if (n >= this.ELhashsize) {
            n = this.ELhashsize - 1;
        }
        if ((halfedge = this.ELgethash(n)) == null) {
            for (int i = 1; i < this.ELhashsize && (halfedge = this.ELgethash(n - i)) == null && (halfedge = this.ELgethash(n + i)) == null; ++i) {
            }
        }
        if (halfedge == this.ELleftend || halfedge != this.ELrightend && this.right_of(halfedge, point)) {
            while ((halfedge = halfedge.ELright) != this.ELrightend && this.right_of(halfedge, point)) {
            }
            halfedge = halfedge.ELleft;
        } else {
            while ((halfedge = halfedge.ELleft) != this.ELleftend && !this.right_of(halfedge, point)) {
            }
        }
        if (n > 0 && n < this.ELhashsize - 1) {
            this.ELhash[n] = halfedge;
        }
        return halfedge;
    }

    void pushGraphEdge(float f, float f2, float f3, float f4) {
        GraphEdge graphEdge = new GraphEdge();
        graphEdge.next = this.allEdges;
        this.allEdges = graphEdge;
        graphEdge.x1 = f;
        graphEdge.y1 = f2;
        graphEdge.x2 = f3;
        graphEdge.y2 = f4;
    }

    void line(float f, float f2, float f3, float f4) {
        this.pushGraphEdge(f, f2, f3, f4);
        if (this.VorSim.booleanValue()) {
            this.g.setColor(Color.red);
            this.g.drawLine((int)f, (int)f2, (int)f3, (int)f4);
            this.c.repaint();
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    void clip_line(Edge edge) {
        Site site;
        Site site2;
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        f2 = edge.reg[1].coord.x;
        f = edge.reg[0].coord.x;
        f4 = edge.reg[1].coord.y;
        f3 = edge.reg[0].coord.y;
        if (Math.sqrt((f2 - f) * (f2 - f) + (f4 - f3) * (f4 - f3)) < (double)this.minDistanceBetweenSites) {
            return;
        }
        float f5 = this.borderMinX;
        float f6 = this.borderMaxX;
        float f7 = this.borderMinY;
        float f8 = this.borderMaxY;
        if ((double)edge.a == 1.0 && (double)edge.b >= 0.0) {
            site2 = edge.ep[1];
            site = edge.ep[0];
        } else {
            site2 = edge.ep[0];
            site = edge.ep[1];
        }
        if ((double)edge.a == 1.0) {
            f3 = f7;
            if (site2 != null && site2.coord.y > f7) {
                f3 = site2.coord.y;
            }
            if (f3 > f8) {
                f3 = f8;
            }
            f = edge.c - edge.b * f3;
            f4 = f8;
            if (site != null && site.coord.y < f8) {
                f4 = site.coord.y;
            }
            if (f4 < f7) {
                f4 = f7;
            }
            if (f > f6 & (f2 = edge.c - edge.b * f4) > f6 | f < f5 & f2 < f5) {
                return;
            }
            if (f > f6) {
                f = f6;
                f3 = (edge.c - f) / edge.b;
            }
            if (f < f5) {
                f = f5;
                f3 = (edge.c - f) / edge.b;
            }
            if (f2 > f6) {
                f2 = f6;
                f4 = (edge.c - f2) / edge.b;
            }
            if (f2 < f5) {
                f2 = f5;
                f4 = (edge.c - f2) / edge.b;
            }
        } else {
            f = f5;
            if (site2 != null && site2.coord.x > f5) {
                f = site2.coord.x;
            }
            if (f > f6) {
                f = f6;
            }
            f3 = edge.c - edge.a * f;
            f2 = f6;
            if (site != null && site.coord.x < f6) {
                f2 = site.coord.x;
            }
            if (f2 < f5) {
                f2 = f5;
            }
            if (f3 > f8 & (f4 = edge.c - edge.a * f2) > f8 | f3 < f7 & f4 < f7) {
                return;
            }
            if (f3 > f8) {
                f3 = f8;
                f = (edge.c - f3) / edge.a;
            }
            if (f3 < f7) {
                f3 = f7;
                f = (edge.c - f3) / edge.a;
            }
            if (f4 > f8) {
                f4 = f8;
                f2 = (edge.c - f4) / edge.a;
            }
            if (f4 < f7) {
                f4 = f7;
                f2 = (edge.c - f4) / edge.a;
            }
        }
        this.line(f, f3, f2, f4);
    }

    void endpoint(Edge edge, int n, Site site) {
        edge.ep[n] = site;
        if (edge.ep[re - n] == null) {
            return;
        }
        this.clip_line(edge);
    }

    boolean right_of(Halfedge halfedge, Point point) {
        boolean bl;
        Edge edge = halfedge.ELedge;
        Site site = edge.reg[1];
        boolean bl2 = point.x > site.coord.x;
        if (bl2 && halfedge.ELpm == le) {
            return true;
        }
        if (!bl2 && halfedge.ELpm == re) {
            return false;
        }
        if ((double)edge.a == 1.0) {
            float f = point.y - site.coord.y;
            float f2 = point.x - site.coord.x;
            boolean bl3 = false;
            if (!bl2 & (double)edge.b < 0.0 | bl2 & (double)edge.b >= 0.0) {
                bl3 = bl = f >= edge.b * f2;
            } else {
                boolean bl4 = bl = point.x + point.y * edge.b > edge.c;
                if ((double)edge.b < 0.0) {
                    boolean bl5 = bl = !bl;
                }
                if (!bl) {
                    bl3 = true;
                }
            }
            if (!bl3) {
                float f3 = site.coord.x - edge.reg[0].coord.x;
                boolean bl6 = bl = (double)(edge.b * (f2 * f2 - f * f)) < (double)(f3 * f) * (1.0 + 2.0 * (double)f2 / (double)f3 + (double)(edge.b * edge.b));
                if ((double)edge.b < 0.0) {
                    bl = !bl;
                }
            }
        } else {
            float f = edge.c - edge.a * point.x;
            float f4 = point.y - f;
            float f5 = point.x - site.coord.x;
            float f6 = f - site.coord.y;
            boolean bl7 = bl = f4 * f4 > f5 * f5 + f6 * f6;
        }
        return halfedge.ELpm == le ? bl : !bl;
    }

    Site rightreg(Halfedge halfedge) {
        if (halfedge.ELedge == (Edge)null) {
            return this.bottomsite;
        }
        return halfedge.ELpm == le ? halfedge.ELedge.reg[re] : halfedge.ELedge.reg[le];
    }

    float dist(Site site, Site site2) {
        float f = site.coord.x - site2.coord.x;
        float f2 = site.coord.y - site2.coord.y;
        return (float)Math.sqrt(f * f + f2 * f2);
    }

    Site intersect(Halfedge halfedge, Halfedge halfedge2) {
        boolean bl;
        Edge edge;
        Halfedge halfedge3;
        Edge edge2 = halfedge.ELedge;
        Edge edge3 = halfedge2.ELedge;
        if (edge2 == null || edge3 == null) {
            return null;
        }
        if (edge2.reg[1] == edge3.reg[1]) {
            return null;
        }
        float f = edge2.a * edge3.b - edge2.b * edge3.a;
        if (-1.0E-10 < (double)f && (double)f < 1.0E-10) {
            return null;
        }
        float f2 = (edge2.c * edge3.b - edge3.c * edge2.b) / f;
        float f3 = (edge3.c * edge2.a - edge2.c * edge3.a) / f;
        if (edge2.reg[1].coord.y < edge3.reg[1].coord.y || edge2.reg[1].coord.y == edge3.reg[1].coord.y && edge2.reg[1].coord.x < edge3.reg[1].coord.x) {
            halfedge3 = halfedge;
            edge = edge2;
        } else {
            halfedge3 = halfedge2;
            edge = edge3;
        }
        boolean bl2 = bl = f2 >= edge.reg[1].coord.x;
        if (bl && halfedge3.ELpm == le || !bl && halfedge3.ELpm == re) {
            return null;
        }
        Site site = new Site();
        site.coord.x = f2;
        site.coord.y = f3;
        return site;
    }

    void out_triple(Site site, Site site2, Site site3) {
        if (this.VorSim.booleanValue()) {
            double d = site.coord.x;
            double d2 = site.coord.y;
            double d3 = site2.coord.x;
            double d4 = site2.coord.y;
            double d5 = site3.coord.x;
            double d6 = site3.coord.y;
            double d7 = d3 - d;
            double d8 = d4 - d2;
            double d9 = (d2 * d2 - d4 * d4 + d * d - d3 * d3) * 0.5;
            double d10 = d3 - d5;
            double d11 = d4 - d6;
            double d12 = (d6 * d6 - d4 * d4 + d5 * d5 - d3 * d3) * 0.5;
            if (d7 * d11 == d8 * d10) {
                return;
            }
            double d13 = (d9 * d11 - d8 * d12) / (d8 * d10 - d7 * d11);
            double d14 = (d7 * d12 - d9 * d10) / (d8 * d10 - d7 * d11);
            double d15 = Math.sqrt(Math.pow((double)site.coord.x - d13, 2.0) + Math.pow((double)site.coord.y - d14, 2.0));
            this.g.setColor(Color.red);
            this.g.fillOval((int)d - this.w / 2, (int)d2 - this.h / 2, this.w, this.h);
            this.g.fillOval((int)d3 - this.w / 2, (int)d4 - this.h / 2, this.w, this.h);
            this.g.fillOval((int)d5 - this.w / 2, (int)d6 - this.h / 2, this.w, this.h);
            this.g.setColor(Color.blue);
            this.g.drawOval((int)(d13 - d15), (int)(d14 - d15), (int)(2.0 * d15), (int)(2.0 * d15));
            this.c.repaint();
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.g.setColor(Color.lightGray);
            this.g.drawOval((int)(d13 - d15), (int)(d14 - d15), (int)(2.0 * d15), (int)(2.0 * d15));
            this.g.setColor(Color.black);
            this.g.fillOval((int)d - this.w / 2, (int)d2 - this.h / 2, this.w, this.h);
            this.g.fillOval((int)d3 - this.w / 2, (int)d4 - this.h / 2, this.w, this.h);
            this.g.fillOval((int)d5 - this.w / 2, (int)d6 - this.h / 2, this.w, this.h);
            this.c.repaint();
        }
    }

    void out_beachline() {
        if (this.VorSim.booleanValue()) {
            int n;
            if (this.beachline_bake == null) {
                this.beachline_bake = new int[(int)(this.borderMaxX - this.borderMinX)];
                for (n = (int)this.borderMinX; n < (int)this.borderMaxX; ++n) {
                    this.beachline_bake[n] = 0;
                }
            }
            for (n = (int)this.borderMinX; n < (int)this.borderMaxX; ++n) {
                this.g.setColor(Color.lightGray);
                this.g.fillOval(n, this.beachline_bake[n], 1, 1);
                Site site = this.sites[this.siteidx - 1];
                float f = site.coord.y;
                Halfedge halfedge = this.ELleftend;
                int n2 = 0;
                do {
                    Site site2 = this.rightreg(halfedge);
                    float f2 = site2.coord.x;
                    float f3 = site2.coord.y;
                    int n3 = (int)((f * f - (f2 - (float)n) * (f2 - (float)n) - f3 * f3) / (2.0f * f - 2.0f * f3));
                    if (n3 > n2) {
                        n2 = n3;
                    }
                    halfedge = halfedge.ELright;
                } while (halfedge.ELright != null);
                if (n2 == 0) continue;
                this.g.setColor(Color.red);
                this.g.fillOval(n, n2, 1, 1);
                this.c.repaint();
                this.beachline_bake[n] = n2;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    void out_site(Site site) {
        if (this.VorSim.booleanValue()) {
            if (site == null) {
                return;
            }
            double d = site.coord.x;
            double d2 = site.coord.y;
            this.g.setColor(Color.lightGray);
            this.g.drawLine((int)this.borderMinX, (int)this.lasty, (int)this.borderMaxX, (int)this.lasty);
            this.g.setColor(Color.black);
            this.g.drawLine((int)this.borderMinX, (int)d2, (int)this.borderMaxX, (int)d2);
            this.g.setColor(Color.red);
            this.g.fillOval((int)d - this.w / 2, (int)d2 - this.h / 2, this.w, this.h);
            this.c.repaint();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.g.setColor(Color.black);
            this.g.drawLine((int)this.borderMinX, (int)d2, (int)this.borderMaxX, (int)d2);
            this.g.fillOval((int)d - this.w / 2, (int)d2 - this.h / 2, this.w, this.h);
            this.c.repaint();
            this.lasty = d2;
        }
    }

    boolean voronoi_bd() {
        Edge edge;
        Halfedge halfedge;
        Point point = null;
        this.PQinitialize();
        this.ELinitialize();
        this.bottomsite = this.nextone();
        this.out_site(this.bottomsite);
        Site site = this.nextone();
        while (true) {
            Site site2;
            Halfedge halfedge2;
            Site site3;
            Halfedge halfedge3;
            if (!this.PQempty()) {
                point = this.PQ_min();
            }
            if (site != null && (this.PQempty() || site.coord.y < point.y || site.coord.y == point.y && site.coord.x < point.x)) {
                this.out_site(site);
                halfedge = this.ELleftbnd(site.coord);
                halfedge3 = this.ELright(halfedge);
                site3 = this.rightreg(halfedge);
                edge = this.bisect(site3, site);
                halfedge2 = this.HEcreate(edge, le);
                this.ELinsert(halfedge, halfedge2);
                site2 = this.intersect(halfedge, halfedge2);
                if (site2 != null) {
                    this.PQdelete(halfedge);
                    this.PQinsert(halfedge, site2, this.dist(site2, site));
                }
                halfedge = halfedge2;
                halfedge2 = this.HEcreate(edge, re);
                this.ELinsert(halfedge, halfedge2);
                site2 = this.intersect(halfedge2, halfedge3);
                if (site2 != null) {
                    this.PQinsert(halfedge2, site2, this.dist(site2, site));
                }
                this.out_beachline();
                site = this.nextone();
                continue;
            }
            if (this.PQempty()) break;
            halfedge = this.PQextractmin();
            Halfedge halfedge4 = this.ELleft(halfedge);
            halfedge3 = this.ELright(halfedge);
            Halfedge halfedge5 = this.ELright(halfedge3);
            site3 = this.leftreg(halfedge);
            Site site4 = this.rightreg(halfedge3);
            this.out_triple(site3, site4, this.rightreg(halfedge));
            Site site5 = halfedge.vertex;
            this.makevertex(site5);
            this.endpoint(halfedge.ELedge, halfedge.ELpm, site5);
            this.endpoint(halfedge3.ELedge, halfedge3.ELpm, site5);
            this.ELdelete(halfedge);
            this.PQdelete(halfedge3);
            this.ELdelete(halfedge3);
            int n = le;
            if (site3.coord.y > site4.coord.y) {
                Site site6 = site3;
                site3 = site4;
                site4 = site6;
                n = re;
            }
            edge = this.bisect(site3, site4);
            halfedge2 = this.HEcreate(edge, n);
            this.ELinsert(halfedge4, halfedge2);
            this.endpoint(edge, re - n, site5);
            site2 = this.intersect(halfedge4, halfedge2);
            if (site2 != null) {
                this.PQdelete(halfedge4);
                this.PQinsert(halfedge4, site2, this.dist(site2, site3));
            }
            if ((site2 = this.intersect(halfedge2, halfedge5)) == null) continue;
            this.PQinsert(halfedge2, site2, this.dist(site2, site3));
        }
        halfedge = this.ELright(this.ELleftend);
        while (halfedge != this.ELrightend) {
            edge = halfedge.ELedge;
            this.clip_line(edge);
            halfedge = this.ELright(halfedge);
        }
        this.endsim();
        return true;
    }

    public boolean generateVoronoi(float f, float f2, float f3, float f4) {
        float f5 = 0.0f;
        if (f > f2) {
            f5 = f;
            f = f2;
            f2 = f5;
        }
        if (f3 > f4) {
            f5 = f3;
            f3 = f4;
            f4 = f5;
        }
        this.borderMinX = f;
        this.borderMinY = f3;
        this.borderMaxX = f2;
        this.borderMaxY = f4;
        this.siteidx = 0;
        this.voronoi_bd();
        return true;
    }

    void endsim() {
        if (this.VorSim.booleanValue()) {
            this.g.setColor(Color.lightGray);
            this.g.drawLine((int)this.borderMinX, (int)this.lasty, (int)this.borderMaxX, (int)this.lasty);
            if (this.beachline_bake != null) {
                for (int i = (int)this.borderMinX; i < (int)this.borderMaxX; ++i) {
                    this.g.setColor(Color.lightGray);
                    this.g.fillOval(i, this.beachline_bake[i], 1, 1);
                }
            }
            this.c.repaint();
        }
    }

    void DrawVor(Graphics graphics) {
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 1000.0f;
        float f4 = 1000.0f;
        this.generateVoronoi(f, f3, f2, f4);
        this.resetIterator();
        GraphEdge graphEdge = null;
        graphics.setColor(Color.red);
        while ((graphEdge = this.getNext()) != null) {
            graphics.drawLine((int)graphEdge.x1, (int)graphEdge.y1, (int)graphEdge.x2, (int)graphEdge.y2);
        }
    }
}

