/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Scanner;

public class Runner {
    boolean paused = false;
    boolean running = false;
    Process pr;
    Scanner input;
    InputStream error;
    DataOutputStream os;
    Problem prob;
    Display dis;
    int pause;

    public Runner(Problem problem, Display display) {
        this.prob = problem;
        this.dis = display;
    }

    public void write(int[] nArray) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(nArray.length);
        for (int i = 0; i < nArray.length; ++i) {
            stringBuffer.append(' ');
            stringBuffer.append(nArray[i]);
        }
        stringBuffer.append('\n');
        this.os.write(stringBuffer.toString().getBytes());
    }

    public void start(boolean bl) {
        this.running = true;
        this.paused = false;
        try {
            this.pr = Runtime.getRuntime().exec(Main.getProcess());
            this.input = new Scanner(this.pr.getInputStream());
            this.error = this.pr.getErrorStream();
            this.os = new DataOutputStream(this.pr.getOutputStream());
            new ErrorReader().start();
            this.write(this.prob.x);
            this.write(this.prob.y);
            this.write(this.prob.serviceImportance);
            this.write(this.prob.serviceCost);
            this.os.write((this.prob.budget + "\n").getBytes());
            this.os.flush();
            int n = this.input.nextInt() / 2;
            int[] nArray = new int[n * 2];
            int[] nArray2 = new int[n];
            int[] nArray3 = new int[n];
            for (int i = 0; i < n; ++i) {
                nArray2[i] = this.input.nextInt();
                nArray3[i] = this.input.nextInt();
                nArray[i * 2] = nArray2[i];
                nArray[i * 2 + 1] = nArray3[i];
            }
            double d = this.prob.runTest(nArray);
            if (!Main.novis) {
                this.dis.score(d);
                this.dis.color(nArray2, nArray3);
            }
            Main.addFatalError("Score = " + d);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public void stop() {
        this.running = false;
        if (this.pr != null) {
            this.pr.destroy();
            this.pr = null;
        }
    }

    public void setPause(int n) {
        this.pause = n;
    }

    public class ErrorReader
    extends Thread {
        public void run() {
            try {
                int n;
                byte[] byArray = new byte[50000];
                while ((n = Runner.this.error.read(byArray)) > 0 && Runner.this.running) {
                    String string = new String(byArray, 0, n);
                    Main.addMessage(string);
                }
                Main.addMessage("\n");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

