/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import java.util.Arrays;
import javax.swing.JPanel;

public class Display
extends JPanel {
    BufferedImage bi;
    Problem p;
    int size = 5;
    JPanel vis;
    double score;
    Object lock = new Object();
    int SCALE = 99;
    int SHIFT = 5;
    DecimalFormat df = new DecimalFormat("0.000E0");
    int[] colors;
    Color[] colorList = new Color[]{Color.blue, Color.red, Color.green, Color.cyan, Color.magenta, Color.yellow, Color.orange, Color.pink, Color.darkGray, Color.lightGray};
    int displayColor = -1;

    public Display(Problem problem) {
        this.p = problem;
        this.vis = new Vis();
        this.setLayout(new BorderLayout());
        this.add((Component)this.vis, "Center");
    }

    public void color(int[] nArray, int[] nArray2) {
        this.colors = new int[this.p.x.length];
        Arrays.fill(this.colors, -1);
        for (int i = 0; i < nArray.length; ++i) {
            this.colors[nArray2[i]] = nArray[i];
        }
        this.vis.repaint();
    }

    public void repaintSim(boolean bl) {
        this.bi = null;
        this.repaint();
    }

    void setDisplayColor(int n) {
        this.displayColor = n;
        this.vis.repaint();
    }

    void score(double d) {
        this.score = d;
    }

    public class Vis
    extends JPanel {
        public void paint(Graphics graphics) {
            int n;
            Graphics2D graphics2D = (Graphics2D)graphics;
            BufferedImage bufferedImage = new BufferedImage(1000, 1000, 2);
            Graphics2D graphics2D2 = (Graphics2D)bufferedImage.getGraphics();
            graphics2D2.setStroke(new BasicStroke(2.0f));
            graphics2D2.setColor(Color.white);
            graphics2D2.setColor(Color.black);
            int n2 = this.getWidth();
            int n3 = this.getHeight();
            graphics.setColor(Color.white);
            graphics.fillRect(0, 0, n2, n3);
            Font font = new Font(graphics2D.getFont().getName(), 0, 20);
            graphics2D.setFont(font);
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            int n4 = fontMetrics.getAscent();
            double d = Math.min((double)(this.getWidth() - 5) / 1000.0, (double)(this.getHeight() - n4 * 2 - 5) / 1000.0);
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.translate(0.0, n4 * 2);
            affineTransform.scale(d * 10.0, d * 10.0);
            AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, 3);
            if (Display.this.colors != null && Display.this.displayColor != -1) {
                int n5;
                BufferedImage bufferedImage2 = new BufferedImage(100, 100, 1);
                int[] nArray = new int[200];
                int[] nArray2 = new int[200];
                n = 0;
                for (n5 = 0; n5 < Display.this.colors.length; ++n5) {
                    if (Display.this.colors[n5] != Display.this.displayColor) continue;
                    nArray[n] = Display.this.p.x[n5];
                    nArray2[n] = Display.this.p.y[n5];
                    ++n;
                }
                for (n5 = 0; n5 < 100; ++n5) {
                    for (int i = 0; i < 100; ++i) {
                        double d2 = 1.0E9;
                        for (int j = 0; j < n; ++j) {
                            double d3 = Math.hypot((double)n5 + 0.5 - (double)nArray[j], (double)i + 0.5 - (double)nArray2[j]);
                            if (!(d3 < d2)) continue;
                            d2 = d3;
                        }
                        double d4 = 1.0 - d2 / 100.0;
                        int n6 = (int)(d4 * d4 * 256.0);
                        if (n6 < 0) {
                            n6 = 0;
                        }
                        bufferedImage2.setRGB(n5, i, n6 << 16 | n6 << 8 | n6);
                    }
                }
                graphics2D.drawImage(bufferedImage2, affineTransformOp, 0, 0);
            }
            for (int i = 0; i < Display.this.p.x.length; ++i) {
                int n7 = 9;
                if (Display.this.colors == null || Display.this.colors[i] == -1) {
                    graphics2D2.setColor(Color.black);
                } else {
                    graphics2D2.setColor(Display.this.colorList[Display.this.colors[i] % Display.this.colorList.length]);
                    if (Display.this.colors[i] == Display.this.displayColor) {
                        n7 = 21;
                    }
                }
                int n8 = Display.this.p.x[i] * 10;
                n = Display.this.p.y[i] * 10;
                graphics2D2.fillOval(n8 - n7 / 2, n - n7 / 2, n7, n7);
            }
            affineTransform = new AffineTransform();
            affineTransform.translate(0.0, n4 * 2);
            affineTransform.scale(d, d);
            affineTransformOp = new AffineTransformOp(affineTransform, 3);
            graphics2D.drawImage(bufferedImage, affineTransformOp, 0, 0);
            graphics2D.setColor(Color.black);
            graphics2D.drawString("Score = " + Display.this.df.format(Display.this.score), 0, n4);
            if (Display.this.displayColor != -1 && Display.this.displayColor < Display.this.p.score.length) {
                graphics2D.drawString("Score From Service " + Display.this.displayColor + " = " + Display.this.df.format(Display.this.p.score[Display.this.displayColor]), 0, n4 * 2);
            }
        }
    }
}

