/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Controls
extends JPanel {
    Runner r;
    Display d;
    Problem p;
    Errors e;
    JTextField fileName;
    JTextField[] params;
    int initspeed = 100;
    JSlider speed;

    public Controls(Problem problem, Display display, Runner runner, Errors errors) {
        this.e = errors;
        this.p = problem;
        this.d = display;
        this.r = runner;
        this.speed = new JSlider(0, -1, 15, -1);
        this.speed.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                JSlider jSlider = (JSlider)changeEvent.getSource();
                Controls.this.d.setDisplayColor(jSlider.getValue());
            }
        });
        this.speed.setMajorTickSpacing(5);
        this.speed.setMinorTickSpacing(1);
        this.speed.setPaintTicks(true);
        this.speed.setSnapToTicks(true);
        this.speed.setPaintLabels(true);
        Hashtable<Integer, JComponent> hashtable = this.speed.createStandardLabels(5, 0);
        hashtable.put(-1, new JLabel("None"));
        this.speed.setLabelTable(hashtable);
        this.speed.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 3));
        JLabel jLabel = new JLabel("Service");
        jLabel.setAlignmentX(0.5f);
        this.speed.setPreferredSize(new Dimension(400, 60));
        jPanel.add(jLabel);
        jPanel.add(this.speed);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 2));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 2));
        this.params = new JTextField[Main.paramNames.length];
        for (int i = 0; i < Main.paramNames.length; ++i) {
            this.params[i] = new JTextField(Main.getParameter(Main.paramNames[i]).toString());
            if (i <= this.params.length / 2 || this.params.length <= 4) {
                jPanel2.add(new Label(Main.paramNames[i] + ": "));
                jPanel2.add(this.params[i]);
                continue;
            }
            jPanel3.add(new Label(Main.paramNames[i] + ": "));
            jPanel3.add(this.params[i]);
        }
        jPanel2.setAlignmentX(0.5f);
        jPanel3.setAlignmentX(0.5f);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 2));
        JButton jButton = new JButton("Generate");
        JButton jButton2 = new JButton("New Parameters");
        JButton jButton3 = new JButton("Restart");
        JButton jButton4 = new JButton("Stop");
        JButton jButton5 = new JButton("Pause");
        JButton jButton6 = new JButton("Step");
        jPanel4.add(jButton);
        jPanel4.add(jButton2);
        jPanel4.add(jButton3);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Controls.this.r.stop();
                Controls.this.d.colors = null;
                Controls.this.d.score(0.0);
                for (int i = 0; i < Controls.this.params.length; ++i) {
                    Main.setParameter(i, Controls.this.params[i].getText());
                }
                Controls.this.p.generate(false, Integer.parseInt(Controls.this.params[0].getText()));
                Controls.this.d.repaintSim(false);
            }
        });
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Controls.this.r.stop();
                Controls.this.d.colors = null;
                Controls.this.d.score(0.0);
                if (Main.getSeed() == (long)Integer.parseInt(Controls.this.params[0].getText())) {
                    Controls.this.params[0].setText(String.valueOf(Main.getSeed() + 1L));
                    Controls.this.p.generate(true, Integer.parseInt(Controls.this.params[0].getText()));
                } else {
                    Controls.this.p.generate(true, Integer.parseInt(Controls.this.params[0].getText()));
                }
                for (int i = 1; i < Controls.this.params.length; ++i) {
                    Controls.this.params[i].setText(Main.getParameter(Main.paramNames[i]).toString());
                }
                Controls.this.d.repaintSim(false);
            }
        });
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Controls.this.r.stop();
                try {
                    Thread.sleep(20L);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                for (int i = 0; i < Controls.this.params.length; ++i) {
                    Main.setParameter(i, Controls.this.params[i].getText());
                }
                Controls.this.p.generate(false, Integer.parseInt(Controls.this.params[0].getText()));
                Controls.this.d.repaintSim(false);
                Controls.this.e.reset();
                Controls.this.r.start(true);
            }
        });
        jButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Controls.this.r.stop();
            }
        });
        JPanel jPanel5 = new JPanel();
        JButton jButton7 = new JButton("Select Executable");
        this.fileName = new JTextField(Main.process);
        jPanel5.add(jButton7);
        jPanel5.add(this.fileName);
        jPanel5.setLayout(new BoxLayout(jPanel5, 2));
        jButton7.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = new JFileChooser();
                int n = jFileChooser.showOpenDialog(Controls.this);
                if (n == 0) {
                    Controls.this.fileName.setText(jFileChooser.getSelectedFile().getPath());
                }
            }
        });
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BoxLayout(jPanel6, 3));
        jPanel6.add(jPanel2);
        if (this.params.length > 4) {
            jPanel6.add(jPanel3);
        }
        jPanel6.add(jPanel4);
        jPanel6.add(jPanel5);
        this.add((Component)jPanel, "North");
        this.add((Component)jPanel6, "South");
        this.setPreferredSize(new Dimension(400, 170));
    }
}

