/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class SameColorPairsVis {
    static int minS = 10;
    static int maxS = 100;
    static int minC = 2;
    static int maxC = 6;
    int H;
    int W;
    volatile char[][] board;
    volatile int curTiles;
    List<Pair> removed;
    JFrame jf;
    Vis v;
    static String exec;
    static boolean vis;
    static boolean manual;
    static boolean debug;
    static Process proc;
    static int del;
    InputStream is;
    OutputStream os;
    BufferedReader br;
    static int SZ;
    volatile boolean manualReady;
    volatile boolean firstClick = true;
    volatile int firstR = -1;
    volatile int firstC = -1;
    static final int[] colors;
    BufferedImage cacheBoard;
    char[][] cache;

    boolean isInside(int n, int n2) {
        return n >= 0 && n < this.H && n2 >= 0 && n2 < this.W;
    }

    String generate(String string) {
        try {
            Object object;
            int n;
            SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
            long l = Long.parseLong(string);
            secureRandom.setSeed(l);
            this.H = secureRandom.nextInt(maxS - minS + 1) + minS;
            this.W = secureRandom.nextInt(maxS - minS + 1) + minS;
            if (this.W * this.H % 2 == 1) {
                if (secureRandom.nextInt(2) == 0) {
                    ++this.W;
                } else {
                    ++this.H;
                }
            }
            if (l == 1L) {
                this.H = 10;
                this.W = 10;
            } else if (l == 2L) {
                this.H = 30;
                this.W = 30;
            } else if (l == 3L) {
                this.H = 100;
                this.W = 100;
            }
            int n2 = secureRandom.nextInt(maxC - minC + 1) + minC;
            if (l <= 3L) {
                n2 = (int)l * 2;
            }
            this.board = new char[this.H][this.W];
            do {
                int n3;
                int n4;
                object = new int[n2];
                for (n = 0; n < this.H; ++n) {
                    for (n4 = 0; n4 < this.W; ++n4) {
                        n3 = secureRandom.nextInt(n2);
                        this.board[n][n4] = (char)(48 + n3);
                        Object object2 = object;
                        int n5 = n3;
                        object2[n5] = object2[n5] + true;
                    }
                }
                for (n = 0; n < n2; ++n) {
                    if (object[n] % 2 != 1) continue;
                    for (n4 = n + 1; n4 < n2; ++n4) {
                        if (object[n4] % 2 != 1) continue;
                        block7: for (n3 = 0; n3 < this.H && object[n4] % 2 == true; ++n3) {
                            for (int i = 0; i < this.W; ++i) {
                                if (this.board[n3][i] != (char)(48 + n4)) continue;
                                Object object3 = object;
                                int n6 = n4;
                                object3[n6] = object3[n6] - true;
                                Object object4 = object;
                                int n7 = n;
                                object4[n7] = object4[n7] + true;
                                this.board[n3][i] = (char)(48 + n);
                                continue block7;
                            }
                        }
                    }
                }
                n = 1;
                for (n4 = 0; n4 < n2; ++n4) {
                    n &= object[n4] > 0 ? 1 : 0;
                }
            } while (n == 0);
            object = new StringBuffer();
            ((StringBuffer)object).append("H = ").append(this.H).append('\n');
            ((StringBuffer)object).append("W = ").append(this.W).append('\n');
            ((StringBuffer)object).append("C = ").append(n2).append('\n');
            for (n = 0; n < this.H; ++n) {
                ((StringBuffer)object).append(new String(this.board[n])).append('\n');
            }
            return ((StringBuffer)object).toString();
        }
        catch (Exception exception) {
            this.addFatalError("An exception occurred while generating test case.");
            exception.printStackTrace();
            return "";
        }
    }

    double getScore() {
        return (double)this.curTiles * 1.0 / (double)(this.H * this.W);
    }

    String removePair(int n, int n2, int n3, int n4) {
        if (this.board[n][n2] == '.' || this.board[n3][n4] == '.') {
            return "Both tiles you're trying to remove must still be on the board.";
        }
        if (this.board[n][n2] != this.board[n3][n4]) {
            return "Both tiles you're trying to remove must have the same color.";
        }
        if (n == n3 && n2 == n4) {
            return "The tiles you're trying to remove must be distinct.";
        }
        char c = this.board[n][n2];
        for (int i = Math.min(n, n3); i <= Math.max(n, n3); ++i) {
            for (int j = Math.min(n2, n4); j <= Math.max(n2, n4); ++j) {
                if (this.board[i][j] == c || this.board[i][j] == '.') continue;
                return "The rectangle specified by the tiles you're trying to remove must not contain tiles of any other color.";
            }
        }
        this.removed.add(new Pair(n, n2, n3, n4, this.board[n][n2]));
        this.board[n3][n4] = 46;
        this.board[n][n2] = 46;
        this.curTiles += 2;
        return "";
    }

    public double runTest(String string) {
        try {
            String string2 = this.generate(string);
            if (debug) {
                System.out.println(string2);
            }
            this.curTiles = 0;
            this.removed = new ArrayList<Pair>();
            if (vis) {
                this.jf.setSize((this.W + 3) * SZ + 50, this.H * SZ + 40);
                this.jf.setVisible(true);
                this.manualReady = false;
                this.firstC = -1;
                this.firstR = -1;
                this.draw();
            }
            if (proc != null) {
                String[] stringArray;
                String[] stringArray2 = new String[this.H];
                for (int i = 0; i < this.H; ++i) {
                    stringArray2[i] = new String(this.board[i]);
                }
                try {
                    stringArray = this.removePairs(stringArray2);
                }
                catch (Exception exception) {
                    this.addFatalError("Failed to get result from removePairs.");
                    return -1.0;
                }
                if (stringArray == null) {
                    this.addFatalError("Your return contained invalid number of elements.");
                    return -1.0;
                }
                if (stringArray.length > this.W * this.H / 2) {
                    this.addFatalError("Your return contained more than " + this.W * this.H / 2 + " elements.");
                    return -1.0;
                }
                for (int i = 0; i < stringArray.length; ++i) {
                    int n;
                    int n2;
                    int n3;
                    int n4;
                    String[] stringArray3 = stringArray[i].split(" ");
                    if (stringArray3.length != 4) {
                        this.addFatalError("Move " + i + ": Each element of your return must be formatted as \"R1 C1 R2 C2\"");
                        return -1.0;
                    }
                    try {
                        n4 = Integer.parseInt(stringArray3[0]);
                        n3 = Integer.parseInt(stringArray3[1]);
                        n2 = Integer.parseInt(stringArray3[2]);
                        n = Integer.parseInt(stringArray3[3]);
                    }
                    catch (Exception exception) {
                        this.addFatalError("Move " + i + ": All numbers in each element of your return must be integers.");
                        return -1.0;
                    }
                    if (!this.isInside(n4, n3)) {
                        this.addFatalError("Move " + i + ": R1 and C1 in each element of your return must specify a cell within the board.");
                        return -1.0;
                    }
                    if (!this.isInside(n2, n)) {
                        this.addFatalError("Move " + i + ": R2 and C2 in each element of your return must specify a cell within the board.");
                        return -1.0;
                    }
                    String string3 = this.removePair(n4, n3, n2, n);
                    if (!string3.equals("")) {
                        this.addFatalError("Move " + i + ": " + string3);
                        return -1.0;
                    }
                    if (!vis) continue;
                    this.draw();
                }
            }
            if (manual) {
                this.addFatalError("Manual play on");
                while (!this.manualReady) {
                    try {
                        Thread.sleep(50L);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
            return this.getScore();
        }
        catch (Exception exception) {
            this.addFatalError("An exception occurred while trying to get your program's results.");
            exception.printStackTrace();
            return -1.0;
        }
    }

    String[] removePairs(String[] stringArray) throws IOException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.H).append("\n");
        for (n = 0; n < this.H; ++n) {
            stringBuffer.append(stringArray[n]).append("\n");
        }
        this.os.write(stringBuffer.toString().getBytes());
        this.os.flush();
        n = Integer.parseInt(this.br.readLine());
        String[] stringArray2 = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray2[i] = this.br.readLine();
        }
        return stringArray2;
    }

    void draw() {
        if (!vis) {
            return;
        }
        this.v.repaint();
        try {
            Thread.sleep(del);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void DrawStartingBoard() {
        int n;
        this.cacheBoard = new BufferedImage(this.W * SZ + 120, this.H * SZ + 40, 1);
        Graphics2D graphics2D = (Graphics2D)this.cacheBoard.getGraphics();
        graphics2D.setColor(new Color(0xDDDDDD));
        graphics2D.fillRect(0, 0, this.W * SZ + 120, this.H * SZ + 40);
        graphics2D.setColor(Color.WHITE);
        graphics2D.fillRect(0, 0, this.W * SZ, this.H * SZ);
        this.cache = new char[this.H][this.W];
        for (n = 0; n < this.H; ++n) {
            for (int i = 0; i < this.W; ++i) {
                this.cache[n][i] = this.board[n][i];
                if (this.board[n][i] == '.') continue;
                graphics2D.setColor(new Color(colors[this.board[n][i] - 48]));
                graphics2D.fillRect(i * SZ + 1, n * SZ + 1, SZ - 1, SZ - 1);
            }
        }
        graphics2D.setColor(Color.BLACK);
        for (n = 0; n <= this.H; ++n) {
            graphics2D.drawLine(0, n * SZ, this.W * SZ, n * SZ);
        }
        for (n = 0; n <= this.W; ++n) {
            graphics2D.drawLine(n * SZ, 0, n * SZ, this.H * SZ);
        }
        graphics2D.setFont(new Font("Arial", 1, 14));
        graphics2D.drawString("READY", SZ * this.W + 25, 30);
        graphics2D.drawRect(SZ * this.W + 12, 10, 70, 30);
        graphics2D.drawString("UNDO", SZ * this.W + 25, 70);
        graphics2D.drawRect(SZ * this.W + 12, 50, 70, 30);
    }

    static BufferedImage deepCopy(BufferedImage bufferedImage) {
        BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), bufferedImage.getType());
        Graphics graphics = bufferedImage2.getGraphics();
        graphics.drawImage(bufferedImage, 0, 0, null);
        graphics.dispose();
        return bufferedImage2;
    }

    public SameColorPairsVis(String string) {
        try {
            if (vis) {
                this.jf = new JFrame();
                this.v = new Vis();
                this.jf.getContentPane().add(this.v);
            }
            if (exec != null) {
                try {
                    Runtime runtime = Runtime.getRuntime();
                    proc = runtime.exec(exec);
                    this.os = proc.getOutputStream();
                    this.is = proc.getInputStream();
                    this.br = new BufferedReader(new InputStreamReader(this.is));
                    new ErrorReader(proc.getErrorStream()).start();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            System.out.println("Score = " + this.runTest(string));
            if (proc != null) {
                try {
                    proc.destroy();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        String string = "1";
        vis = true;
        manual = false;
        del = 100;
        SZ = 20;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-seed")) {
                string = stringArray[++i];
            }
            if (stringArray[i].equals("-exec")) {
                exec = stringArray[++i];
            }
            if (stringArray[i].equals("-delay")) {
                del = Integer.parseInt(stringArray[++i]);
            }
            if (stringArray[i].equals("-novis")) {
                vis = false;
            }
            if (stringArray[i].equals("-manual")) {
                manual = true;
            }
            if (stringArray[i].equals("-size")) {
                SZ = Integer.parseInt(stringArray[++i]);
            }
            if (!stringArray[i].equals("-debug")) continue;
            debug = true;
        }
        if (string.equals("1")) {
            SZ = 30;
        }
        if (exec == null) {
            manual = true;
        }
        if (manual) {
            vis = true;
        }
        SameColorPairsVis sameColorPairsVis = new SameColorPairsVis(string);
    }

    void addFatalError(String string) {
        System.out.println(string);
    }

    static {
        colors = new int[]{0x4000FF, 0xFF00BF, 49151, 0xFFBF00, 0x40FF00, 0xBF0000};
    }

    public class Vis
    extends JPanel
    implements MouseListener,
    WindowListener {
        @Override
        public void paint(Graphics graphics) {
            if (SameColorPairsVis.this.cacheBoard == null) {
                SameColorPairsVis.this.DrawStartingBoard();
            }
            Graphics2D graphics2D = (Graphics2D)SameColorPairsVis.this.cacheBoard.getGraphics();
            for (int i = 0; i < SameColorPairsVis.this.H; ++i) {
                for (int j = 0; j < SameColorPairsVis.this.W; ++j) {
                    if (SameColorPairsVis.this.cache[i][j] == SameColorPairsVis.this.board[i][j]) continue;
                    SameColorPairsVis.this.cache[i][j] = SameColorPairsVis.this.board[i][j];
                    graphics2D.setColor(SameColorPairsVis.this.cache[i][j] == '.' ? Color.WHITE : new Color(colors[SameColorPairsVis.this.cache[i][j] - 48]));
                    graphics2D.fillRect(j * SZ + 1, i * SZ + 1, SZ - 1, SZ - 1);
                }
            }
            graphics2D.dispose();
            BufferedImage bufferedImage = SameColorPairsVis.deepCopy(SameColorPairsVis.this.cacheBoard);
            graphics2D = (Graphics2D)bufferedImage.getGraphics();
            graphics2D.setColor(Color.GRAY);
            if (SameColorPairsVis.this.firstR >= 0) {
                graphics2D.setStroke(new BasicStroke(4.0f));
                graphics2D.drawLine(SameColorPairsVis.this.firstC * SZ, SameColorPairsVis.this.firstR * SZ, (SameColorPairsVis.this.firstC + 1) * SZ, SameColorPairsVis.this.firstR * SZ);
                graphics2D.drawLine(SameColorPairsVis.this.firstC * SZ, SameColorPairsVis.this.firstR * SZ, SameColorPairsVis.this.firstC * SZ, (SameColorPairsVis.this.firstR + 1) * SZ);
                graphics2D.drawLine((SameColorPairsVis.this.firstC + 1) * SZ, (SameColorPairsVis.this.firstR + 1) * SZ, (SameColorPairsVis.this.firstC + 1) * SZ, SameColorPairsVis.this.firstR * SZ);
                graphics2D.drawLine((SameColorPairsVis.this.firstC + 1) * SZ, (SameColorPairsVis.this.firstR + 1) * SZ, SameColorPairsVis.this.firstC * SZ, (SameColorPairsVis.this.firstR + 1) * SZ);
            }
            graphics2D.setColor(Color.BLACK);
            graphics2D.setFont(new Font("Arial", 1, 14));
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            graphics2D.drawString(String.format("%.4f", SameColorPairsVis.this.getScore()), SameColorPairsVis.this.W * SZ + 25, 110 + fontMetrics.getHeight());
            graphics.drawImage(bufferedImage, 0, 0, SameColorPairsVis.this.W * SZ + 120, SameColorPairsVis.this.H * SZ + 40, null);
        }

        public Vis() {
            this.addMouseListener(this);
            SameColorPairsVis.this.jf.addWindowListener(this);
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            if (proc != null) {
                try {
                    proc.destroy();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            System.exit(0);
        }

        @Override
        public void windowActivated(WindowEvent windowEvent) {
        }

        @Override
        public void windowDeactivated(WindowEvent windowEvent) {
        }

        @Override
        public void windowOpened(WindowEvent windowEvent) {
        }

        @Override
        public void windowClosed(WindowEvent windowEvent) {
        }

        @Override
        public void windowIconified(WindowEvent windowEvent) {
        }

        @Override
        public void windowDeiconified(WindowEvent windowEvent) {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            int n;
            if (!manual || SameColorPairsVis.this.manualReady) {
                return;
            }
            int n2 = mouseEvent.getX() - SZ * SameColorPairsVis.this.W - 12;
            int n3 = mouseEvent.getY() - 10;
            if (n2 >= 0 && n2 <= 70 && n3 >= 0 && n3 <= 30) {
                SameColorPairsVis.this.manualReady = true;
                return;
            }
            if (n2 >= 0 && n2 <= 70 && n3 >= 40 && n3 <= 70) {
                if (SameColorPairsVis.this.removed.isEmpty()) {
                    return;
                }
                int n4 = SameColorPairsVis.this.removed.size() - 1;
                Pair pair = SameColorPairsVis.this.removed.get(n4);
                SameColorPairsVis.this.removed.remove(n4);
                char c = pair.col;
                SameColorPairsVis.this.board[pair.r2][pair.c2] = c;
                SameColorPairsVis.this.board[pair.r1][pair.c1] = c;
                SameColorPairsVis.this.curTiles -= 2;
                this.repaint();
                return;
            }
            int n5 = mouseEvent.getY() / SZ;
            if (!SameColorPairsVis.this.isInside(n5, n = mouseEvent.getX() / SZ)) {
                return;
            }
            if (SameColorPairsVis.this.board[n5][n] == '.') {
                return;
            }
            if (SameColorPairsVis.this.firstClick) {
                SameColorPairsVis.this.firstR = n5;
                SameColorPairsVis.this.firstC = n;
                SameColorPairsVis.this.firstClick = false;
                this.repaint();
                return;
            }
            if (n5 == SameColorPairsVis.this.firstR && n == SameColorPairsVis.this.firstC) {
                SameColorPairsVis.this.firstC = -1;
                SameColorPairsVis.this.firstR = -1;
                SameColorPairsVis.this.firstClick = true;
                this.repaint();
                return;
            }
            String string = SameColorPairsVis.this.removePair(SameColorPairsVis.this.firstR, SameColorPairsVis.this.firstC, n5, n);
            if (!string.equals("")) {
                SameColorPairsVis.this.addFatalError(string);
                return;
            }
            SameColorPairsVis.this.firstC = -1;
            SameColorPairsVis.this.firstR = -1;
            this.repaint();
            SameColorPairsVis.this.firstClick = true;
            if (SameColorPairsVis.this.curTiles >= SameColorPairsVis.this.H * SameColorPairsVis.this.W - 1) {
                SameColorPairsVis.this.manualReady = true;
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }
    }
}

