/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.security.SecureRandom;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class RobotVisionTrackerVis {
    public static int NUM_OF_TESTING_FRAMES = 50;
    public static long seed = 1L;
    public static int delay = 100;
    public static boolean debug = true;
    public static boolean visualize = true;
    public static String execCommand = null;
    public static String testingFile = null;
    public static String trainingFile = null;
    public static String folder = "";
    public SecureRandom rnd;
    public static int W;
    public static int H;
    public static Process solution;
    public final Object worldLock = new Object();

    public void printMessage(String string) {
        if (debug) {
            System.out.println(string);
        }
    }

    public int[] imageToArray(String string) throws Exception {
        this.printMessage("Reading image from " + string);
        BufferedImage bufferedImage = ImageIO.read(new File(string));
        H = bufferedImage.getHeight();
        W = bufferedImage.getWidth();
        int[] nArray = new int[H * W];
        int n = 0;
        byte[] byArray = ((DataBufferByte)bufferedImage.getRaster().getDataBuffer()).getData();
        for (int i = 0; i < byArray.length; i += 3) {
            int n2;
            int n3;
            int n4 = byArray[i];
            if (n4 < 0) {
                n4 += 256;
            }
            if ((n3 = byArray[i + 1]) < 0) {
                n3 += 256;
            }
            if ((n2 = byArray[i + 2]) < 0) {
                n2 += 256;
            }
            nArray[n++] = n4 | n3 << 8 | n2 << 16;
        }
        return nArray;
    }

    public void correctOutOfBounds(int[] nArray, int[] nArray2) {
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] >= 0 && nArray[i] <= 639 && nArray2[i] >= 0 && nArray2[i] <= 479) continue;
            nArray[i] = -1;
            nArray2[i] = -1;
        }
    }

    public double countFrameCorrect(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, int n) {
        double d = 0.0;
        for (int i = 0; i < nArray.length; ++i) {
            double d2;
            double d3;
            if (nArray[i] < 0 && nArray3[i] < 0) {
                d += 1.0 / (double)NUM_OF_TESTING_FRAMES;
                continue;
            }
            if (nArray[i] < 0 && nArray3[i] >= 0 || nArray[i] >= 0 && nArray3[i] < 0 || !((d3 = (double)(nArray[i] - nArray3[i])) * d3 + (d2 = (double)(nArray2[i] - nArray4[i])) * d2 <= (double)n)) continue;
            d += 1.0 / (double)NUM_OF_TESTING_FRAMES;
        }
        return d;
    }

    public double doExec() throws Exception {
        int n;
        Object object;
        Object object2;
        Object object3;
        try {
            this.rnd = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (Exception exception) {
            System.err.println("ERROR: unable to generate test case.");
            System.exit(1);
        }
        this.rnd.setSeed(seed);
        this.printMessage("Executing your solution: " + execCommand);
        solution = Runtime.getRuntime().exec(execCommand);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(solution.getInputStream()));
        PrintWriter printWriter = new PrintWriter(solution.getOutputStream());
        new ErrorStreamRedirector(solution.getErrorStream()).start();
        VideoFrame videoFrame = new VideoFrame();
        VideoAnnotations videoAnnotations = new VideoAnnotations();
        if (trainingFile != null) {
            BufferedReader bufferedReader2 = new BufferedReader(new FileReader(trainingFile));
            int n2 = Integer.parseInt(bufferedReader2.readLine());
            this.printMessage("Training with " + n2 + " videos");
            printWriter.println(n2);
            printWriter.flush();
            for (int i = 0; i < n2; ++i) {
                object3 = bufferedReader2.readLine();
                videoAnnotations.Load(folder + (String)object3 + "_Left_annotation_pt.txt", true);
                videoAnnotations.Load(folder + (String)object3 + "_Right_annotation_pt.txt", false);
                printWriter.println(videoAnnotations.numFrames - 1);
                printWriter.flush();
                boolean bl = false;
                for (int j = 1; j < videoAnnotations.numFrames; ++j) {
                    int n32;
                    object2 = folder + (String)object3 + "_Left_" + String.format("%05d.png", j);
                    object = folder + (String)object3 + "_Right_" + String.format("%05d.png", j);
                    videoFrame.Load((String)object2, (String)object);
                    for (int n32 : videoFrame.leftImg) {
                        printWriter.println(n32);
                    }
                    printWriter.flush();
                    for (int n32 : videoFrame.rightImg) {
                        printWriter.println(n32);
                    }
                    printWriter.flush();
                    int n4 = videoAnnotations.leftX.get(j);
                    int n5 = videoAnnotations.leftY.get(j);
                    int n6 = videoAnnotations.rightX.get(j);
                    n32 = videoAnnotations.rightY.get(j);
                    printWriter.println(n4);
                    printWriter.println(n5);
                    printWriter.println(n6);
                    printWriter.println(n32);
                    printWriter.flush();
                    n = Integer.parseInt(bufferedReader.readLine());
                    if (n != 1) continue;
                    bl = true;
                    break;
                }
                if (bl) break;
            }
            bufferedReader2.close();
        } else {
            System.out.println("ERROR: Training file not provided");
            System.exit(0);
        }
        double d = 0.0;
        int[] nArray = new int[NUM_OF_TESTING_FRAMES];
        object3 = new int[NUM_OF_TESTING_FRAMES];
        int[] nArray2 = new int[NUM_OF_TESTING_FRAMES];
        int[] nArray3 = new int[NUM_OF_TESTING_FRAMES];
        object2 = new int[NUM_OF_TESTING_FRAMES];
        object = new int[NUM_OF_TESTING_FRAMES];
        int[] nArray4 = new int[NUM_OF_TESTING_FRAMES];
        int[] nArray5 = new int[NUM_OF_TESTING_FRAMES];
        Drawer drawer = null;
        if (visualize) {
            drawer = new Drawer();
            drawer.pauseMode = false;
        }
        VideoAnnotations[] videoAnnotationsArray = new VideoAnnotations[5];
        for (n = 0; n < 5; ++n) {
            videoAnnotationsArray[n] = new VideoAnnotations();
        }
        if (testingFile != null) {
            int n7;
            BufferedReader bufferedReader3 = new BufferedReader(new FileReader(testingFile));
            int n8 = Integer.parseInt(bufferedReader3.readLine());
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 0; i < n8; ++i) {
                arrayList.add(bufferedReader3.readLine());
            }
            bufferedReader3.close();
            String[] stringArray = new String[5];
            int[] nArray6 = new int[5];
            for (int i = 0; i < 5; ++i) {
                int n9 = this.rnd.nextInt(n8);
                stringArray[i] = (String)arrayList.get(n9);
                videoAnnotationsArray[i].Load(folder + stringArray[i] + "_Left_annotation_pt.txt", true);
                videoAnnotationsArray[i].Load(folder + stringArray[i] + "_Right_annotation_pt.txt", false);
                nArray6[i] = Math.max(1, 1 + this.rnd.nextInt(videoAnnotationsArray[i].numFrames - NUM_OF_TESTING_FRAMES / 5));
                this.printMessage("Testing with video " + stringArray[i] + " starting at frame " + nArray6[i]);
            }
            long l = 0L;
            printWriter.println(NUM_OF_TESTING_FRAMES);
            printWriter.flush();
            for (n7 = 0; n7 < NUM_OF_TESTING_FRAMES; ++n7) {
                nArray5[n7] = -1;
                nArray4[n7] = -1;
                object[n7] = -1;
                object2[n7] = -1;
            }
            for (n7 = 0; n7 < NUM_OF_TESTING_FRAMES; ++n7) {
                int n10 = n7 / 10;
                int n11 = n7 % 10;
                printWriter.println(n10);
                printWriter.println(n11);
                printWriter.flush();
                String string = folder + stringArray[n10] + "_Left_" + String.format("%05d.png", n11 + nArray6[n10]);
                String string2 = folder + stringArray[n10] + "_Right_" + String.format("%05d.png", n11 + nArray6[n10]);
                videoFrame.Load(string, string2);
                nArray[n7] = videoAnnotationsArray[n10].leftX.get(n11 + nArray6[n10]);
                object3[n7] = videoAnnotationsArray[n10].leftY.get(n11 + nArray6[n10]);
                nArray2[n7] = videoAnnotationsArray[n10].rightX.get(n11 + nArray6[n10]);
                nArray3[n7] = videoAnnotationsArray[n10].rightY.get(n11 + nArray6[n10]);
                for (int n12 : videoFrame.leftImg) {
                    printWriter.println(n12);
                }
                printWriter.flush();
                for (int n12 : videoFrame.rightImg) {
                    printWriter.println(n12);
                }
                printWriter.flush();
                long l2 = System.currentTimeMillis();
                object2[n7] = Integer.parseInt(bufferedReader.readLine());
                object[n7] = Integer.parseInt(bufferedReader.readLine());
                nArray4[n7] = Integer.parseInt(bufferedReader.readLine());
                nArray5[n7] = Integer.parseInt(bufferedReader.readLine());
                long l3 = System.currentTimeMillis();
                l += l3 - l2;
                if (!visualize) continue;
                drawer.update(string, string2, nArray[n7], object3[n7], nArray2[n7], nArray3[n7], object2[n7], object[n7], nArray4[n7], nArray5[n7]);
                if (n7 == 0) {
                    drawer.pauseMode = true;
                }
                drawer.repaint();
                drawer.processPause();
                try {
                    Thread.sleep(delay);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.correctOutOfBounds(nArray, (int[])object3);
            this.correctOutOfBounds(nArray2, nArray3);
            double d2 = this.countFrameCorrect(nArray, (int[])object3, (int[])object2, (int[])object, 100);
            double d3 = this.countFrameCorrect(nArray, (int[])object3, (int[])object2, (int[])object, 400);
            double d4 = this.countFrameCorrect(nArray, (int[])object3, (int[])object2, (int[])object, 2500);
            double d5 = this.countFrameCorrect(nArray2, nArray3, nArray4, nArray5, 100);
            double d6 = this.countFrameCorrect(nArray2, nArray3, nArray4, nArray5, 400);
            double d7 = this.countFrameCorrect(nArray2, nArray3, nArray4, nArray5, 2500);
            this.printMessage("R[10] = " + d2 + " " + d5);
            this.printMessage("R[20] = " + d3 + " " + d6);
            this.printMessage("R[50] = " + d4 + " " + d7);
            double d8 = 10000.0 * (50.0 * (d2 + d5) + 35.0 * (d3 + d6) + 15.0 * (d4 + d7));
            System.out.println("Accuracy Score = " + d8);
            System.out.println("Processing Time = " + l + "ms");
            double d9 = 1.0;
            double d10 = 0.001 * (double)l;
            if (d10 > 3.33) {
                d9 = 1.3536 - 0.2939 * Math.log(d10);
            }
            if (d10 > 100.0) {
                d9 = 0.0;
            }
            System.out.println("Time Multiplier = " + (d9 += 1.0));
            d = d9 * d8;
        } else {
            System.out.println("ERROR: Testing file not provided");
            System.exit(0);
        }
        RobotVisionTrackerVis.stopSolution();
        return d;
    }

    public static void stopSolution() {
        if (solution != null) {
            try {
                solution.destroy();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void main(String[] stringArray) throws Exception {
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-folder")) {
                folder = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-exec")) {
                execCommand = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-seed")) {
                seed = Long.parseLong(stringArray[++i]);
                continue;
            }
            if (stringArray[i].equals("-train")) {
                trainingFile = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-test")) {
                testingFile = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-silent")) {
                debug = false;
                continue;
            }
            if (stringArray[i].equals("-delay")) {
                delay = Integer.parseInt(stringArray[++i]);
                continue;
            }
            if (stringArray[i].equals("-novis")) {
                visualize = false;
                continue;
            }
            System.out.println("WARNING: unknown argument " + stringArray[i] + ".");
        }
        RobotVisionTrackerVis robotVisionTrackerVis = new RobotVisionTrackerVis();
        try {
            double d = robotVisionTrackerVis.doExec();
            System.out.println("Score  = " + d);
        }
        catch (Exception exception) {
            System.out.println("FAILURE: " + exception.getMessage());
            exception.printStackTrace();
            RobotVisionTrackerVis.stopSolution();
        }
    }

    class ErrorStreamRedirector
    extends Thread {
        public BufferedReader reader;

        public ErrorStreamRedirector(InputStream inputStream) {
            this.reader = new BufferedReader(new InputStreamReader(inputStream));
        }

        @Override
        public void run() {
            while (true) {
                String string;
                try {
                    string = this.reader.readLine();
                }
                catch (Exception exception) {
                    return;
                }
                if (string == null) break;
                System.out.println(string);
            }
        }
    }

    class VideoAnnotations {
        ArrayList<Integer> leftX = new ArrayList();
        ArrayList<Integer> rightX = new ArrayList();
        ArrayList<Integer> leftY = new ArrayList();
        ArrayList<Integer> rightY = new ArrayList();
        int numFrames;

        VideoAnnotations() {
        }

        public void Load(String string, boolean bl) throws Exception {
            String string2;
            if (bl) {
                this.leftX.clear();
                this.leftY.clear();
                this.rightX.clear();
                this.rightY.clear();
            }
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            RobotVisionTrackerVis.this.printMessage("Loading annotation file " + string);
            while ((string2 = bufferedReader.readLine()) != null) {
                int n = Integer.parseInt(string2.substring(0, 5));
                while (this.leftX.size() <= n) {
                    this.leftX.add(-1);
                    this.leftY.add(-1);
                    this.rightX.add(-1);
                    this.rightY.add(-1);
                }
                String string3 = bufferedReader.readLine();
                String string4 = bufferedReader.readLine();
                String[] stringArray = string4.split(" ");
                if (bl) {
                    this.leftX.set(n, (int)Double.parseDouble(stringArray[0]));
                    this.leftY.set(n, (int)Double.parseDouble(stringArray[1]));
                    continue;
                }
                this.rightX.set(n, (int)Double.parseDouble(stringArray[0]));
                this.rightY.set(n, (int)Double.parseDouble(stringArray[1]));
            }
            this.numFrames = this.leftX.size();
        }
    }

    class VideoFrame {
        int[] leftImg;
        int[] rightImg;

        VideoFrame() {
        }

        public void Load(String string, String string2) throws Exception {
            this.leftImg = RobotVisionTrackerVis.this.imageToArray(string);
            this.rightImg = RobotVisionTrackerVis.this.imageToArray(string2);
        }
    }

    class Drawer
    extends JFrame {
        public DrawerPanel panel;
        public int width;
        public int height;
        public boolean pauseMode = false;
        public BufferedImage imgLeft = null;
        public BufferedImage imgRight = null;
        public int gtfLeftX;
        public int gtfLeftY;
        public int gtfRightX;
        public int gtfRightY;
        public int userLeftX;
        public int userLeftY;
        public int userRightX;
        public int userRightY;
        final Object keyMutex = new Object();
        boolean keyPressed;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void update(String string, String string2, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) throws Exception {
            Object object = RobotVisionTrackerVis.this.worldLock;
            synchronized (object) {
                this.imgLeft = ImageIO.read(new File(string));
                this.imgRight = ImageIO.read(new File(string2));
                this.gtfLeftX = n;
                this.gtfLeftY = n2;
                this.gtfRightX = n3;
                this.gtfRightY = n4;
                this.userLeftX = n5;
                this.userLeftY = n6;
                this.userRightX = n7;
                this.userRightY = n8;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void processPause() {
            Object object = this.keyMutex;
            synchronized (object) {
                if (!this.pauseMode) {
                    return;
                }
                this.keyPressed = false;
                while (!this.keyPressed) {
                    try {
                        this.keyMutex.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }

        public Drawer() {
            this.panel = new DrawerPanel();
            this.getContentPane().add(this.panel);
            this.addWindowListener(new DrawerWindowListener());
            this.width = 1280;
            this.height = 480;
            this.addKeyListener(new DrawerKeyListener());
            this.setSize(this.width, this.height);
            this.setTitle("Handle Tracking Marathon Match");
            this.setResizable(false);
            this.setVisible(true);
        }

        class DrawerWindowListener
        extends WindowAdapter {
            DrawerWindowListener() {
            }

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                RobotVisionTrackerVis.stopSolution();
                System.exit(0);
            }
        }

        class DrawerPanel
        extends JPanel {
            DrawerPanel() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void paint(Graphics graphics) {
                Object object = RobotVisionTrackerVis.this.worldLock;
                synchronized (object) {
                    if (Drawer.this.imgLeft != null) {
                        graphics.drawImage(Drawer.this.imgLeft, 0, 0, null);
                        if (Drawer.this.gtfLeftX >= 0) {
                            graphics.setColor(Color.RED);
                            graphics.fillOval(Drawer.this.gtfLeftX - 5, Drawer.this.gtfLeftY - 5, 10, 10);
                        }
                        if (Drawer.this.userLeftX >= 0) {
                            graphics.setColor(Color.GREEN);
                            graphics.fillOval(Drawer.this.userLeftX - 5, Drawer.this.userLeftY - 5, 10, 10);
                        }
                    }
                    if (Drawer.this.imgRight != null) {
                        graphics.drawImage(Drawer.this.imgRight, 640, 0, null);
                        if (Drawer.this.gtfRightX >= 0) {
                            graphics.setColor(Color.RED);
                            graphics.fillOval(640 + Drawer.this.gtfRightX - 5, Drawer.this.gtfRightY - 5, 10, 10);
                        }
                        if (Drawer.this.userRightX >= 0) {
                            graphics.setColor(Color.GREEN);
                            graphics.fillOval(640 + Drawer.this.userRightX - 5, Drawer.this.userRightY - 5, 10, 10);
                        }
                    }
                }
            }
        }

        class DrawerKeyListener
        extends KeyAdapter {
            DrawerKeyListener() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void keyPressed(KeyEvent keyEvent) {
                Object object = Drawer.this.keyMutex;
                synchronized (object) {
                    if (keyEvent.getKeyChar() == ' ') {
                        Drawer.this.pauseMode = !Drawer.this.pauseMode;
                    }
                    Drawer.this.keyPressed = true;
                    Drawer.this.keyMutex.notifyAll();
                }
            }
        }
    }
}

