/*
 * Decompiled with CFR 0.152.
 */
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Label;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Robot {
    Controller c;
    View v;
    String[] paramNames = new String[]{"seed", "C", "M", "N", "K", "rowGap", "colGap", "P", "R"};
    static Object runlock = new Object();
    static Object movelock = new Object();

    public String getProcess() {
        if (this.v != null) {
            return this.v.fileName.getText();
        }
        return this.c.process;
    }

    public void setProcess(String string) {
        this.c.process = string;
        if (this.v != null) {
            this.v.fileName.setText(string);
        }
    }

    public static void main(String[] stringArray) {
        new Robot(stringArray);
    }

    public Robot(String[] stringArray) {
        int n = 1000;
        int n2 = 1000;
        boolean bl = false;
        boolean bl2 = false;
        this.c = new Controller();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-exec")) {
                bl2 = true;
                this.setProcess(stringArray[++i]);
                continue;
            }
            if (stringArray[i].equals("-drop")) {
                this.c.setDrop(true);
                continue;
            }
            if (stringArray[i].equals("-go")) {
                bl = true;
                continue;
            }
            if (stringArray[i].equals("-novis")) {
                bl = true;
                this.c.novis = true;
                continue;
            }
            if (stringArray[i].equals("-width")) {
                n2 = Integer.parseInt(stringArray[++i]);
                continue;
            }
            if (stringArray[i].equals("-height")) {
                n = Integer.parseInt(stringArray[++i]);
                continue;
            }
            if (stringArray[i].equals("-speed")) {
                int n3 = Integer.parseInt(stringArray[++i]);
                this.c.setSlide(n3);
                if (n3 >= 80) {
                    this.c.setPause(100 - n3);
                    continue;
                }
                this.c.setPause((int)(5000.0 * Math.pow(0.9333096363135965, n3)));
                continue;
            }
            if (!stringArray[i].startsWith("-")) continue;
            String string = stringArray[i].substring(1);
            String string2 = stringArray[++i];
            try {
                Field field = this.c.getClass().getDeclaredField(string);
                field.set(this.c, new Integer(string2));
                continue;
            }
            catch (Exception exception) {
                System.err.println("Invalid parameters");
                return;
            }
        }
        if (this.c.novis && !bl2) {
            System.err.println("You must specify the executable when using -novis");
            return;
        }
        this.c.generate(false, this.c.getSeed());
        if (!this.c.novis) {
            this.v = new View(n);
            this.v.setSize(n, n2);
            this.v.setVisible(true);
        } else {
            System.out.println("M = " + this.c.M + ", N = " + this.c.N + ", K = " + this.c.K + ", R = " + this.c.robotX.length + ", C = " + this.c.C + ", rowGap = " + this.c.rowGap + ", colGap = " + this.c.colGap + ", P = " + this.c.products.length);
        }
        if (bl) {
            this.c.start();
        }
    }

    class View
    extends JFrame
    implements WindowListener,
    ChangeListener {
        JTextArea err;
        JTextField fileName;
        JScrollPane scroll;
        JTextField[] params;
        int position;
        Vis sim;

        public void windowActivated(WindowEvent windowEvent) {
        }

        public void windowDeactivated(WindowEvent windowEvent) {
        }

        public void windowOpened(WindowEvent windowEvent) {
        }

        public void windowClosing(WindowEvent windowEvent) {
            Robot.this.c.stop();
            System.exit(0);
        }

        public void windowClosed(WindowEvent windowEvent) {
        }

        public void windowIconified(WindowEvent windowEvent) {
        }

        public void windowDeiconified(WindowEvent windowEvent) {
        }

        public View(int n) {
            JSlider jSlider = new JSlider(0, 0, 100, Robot.this.c.getSlide());
            jSlider.addChangeListener(this);
            jSlider.setMajorTickSpacing(20);
            jSlider.setMinorTickSpacing(5);
            jSlider.setPaintTicks(true);
            jSlider.setPaintLabels(true);
            jSlider.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
            this.sim = new Vis();
            this.err = new JTextArea("Standard Error from your program, as well as other messages will appear here");
            this.scroll = new JScrollPane(this.err);
            JSplitPane jSplitPane = new JSplitPane(0, this.sim, this.scroll);
            jSplitPane.setDividerLocation(n - 300);
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 3));
            JLabel jLabel = new JLabel("Speed");
            jLabel.setAlignmentX(0.5f);
            jSplitPane.setAlignmentX(0.5f);
            jPanel.add(jLabel);
            jPanel.add(jSlider);
            this.err.setEditable(false);
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new BoxLayout(jPanel2, 2));
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout(new BoxLayout(jPanel3, 2));
            this.params = new JTextField[Robot.this.paramNames.length];
            for (int i = 0; i < Robot.this.paramNames.length; ++i) {
                this.params[i] = new JTextField(Robot.this.c.getParameter(Robot.this.paramNames[i]));
                if (i <= this.params.length / 2) {
                    jPanel2.add(new Label(Robot.this.paramNames[i] + ": "));
                    jPanel2.add(this.params[i]);
                    continue;
                }
                jPanel3.add(new Label(Robot.this.paramNames[i] + ": "));
                jPanel3.add(this.params[i]);
            }
            jPanel2.setAlignmentX(0.5f);
            jPanel3.setAlignmentX(0.5f);
            JPanel jPanel4 = new JPanel();
            jPanel4.setLayout(new BoxLayout(jPanel4, 2));
            JButton jButton = new JButton("Generate Map");
            JButton jButton2 = new JButton("New Parameters and Map");
            JButton jButton3 = new JButton("Start Simulation");
            JButton jButton4 = new JButton("Stop Simulation");
            jPanel4.add(jButton);
            jPanel4.add(jButton2);
            jPanel4.add(jButton3);
            jPanel4.add(jButton4);
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Robot.this.c.stop();
                    Robot.this.c.generate(false, Integer.parseInt(View.this.params[0].getText()));
                    View.this.repaintSim(false);
                }
            });
            jButton2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Robot.this.c.stop();
                    if (Robot.this.c.getSeed() == Integer.parseInt(View.this.params[0].getText())) {
                        View.this.params[0].setText(String.valueOf(Robot.this.c.newSeed()));
                        Robot.this.c.generate(true, Integer.parseInt(View.this.params[0].getText()));
                    } else {
                        Robot.this.c.generate(true, Integer.parseInt(View.this.params[0].getText()));
                    }
                    for (int i = 1; i < View.this.params.length; ++i) {
                        View.this.params[i].setText(Robot.this.c.getParameter(Robot.this.paramNames[i]));
                    }
                    View.this.repaintSim(false);
                }
            });
            jButton3.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Robot.this.c.stop();
                    try {
                        Thread.sleep(20L);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    Robot.this.c.generate(false, Integer.parseInt(View.this.params[0].getText()));
                    View.this.repaintSim(false);
                    Robot.this.c.start();
                }
            });
            jButton4.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Robot.this.c.stop();
                }
            });
            JPanel jPanel5 = new JPanel();
            JButton jButton5 = new JButton("Select Executable");
            this.fileName = new JTextField(Robot.this.c.process);
            jPanel5.add(jButton5);
            jPanel5.add(this.fileName);
            jPanel5.setLayout(new BoxLayout(jPanel5, 2));
            jButton5.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JFileChooser jFileChooser = new JFileChooser();
                    int n = jFileChooser.showOpenDialog(View.this);
                    if (n == 0) {
                        View.this.fileName.setText(jFileChooser.getSelectedFile().getPath());
                        Robot.this.c.process = jFileChooser.getSelectedFile().getPath();
                    }
                }
            });
            JPanel jPanel6 = new JPanel();
            jPanel6.setLayout(new BoxLayout(jPanel6, 3));
            jPanel6.add(jPanel2);
            jPanel6.add(jPanel3);
            jPanel6.add(jPanel4);
            jPanel6.add(jPanel5);
            this.add((Component)jPanel, "North");
            this.add((Component)jSplitPane, "Center");
            this.add((Component)jPanel6, "South");
            this.addWindowListener(this);
        }

        public void stateChanged(ChangeEvent changeEvent) {
            JSlider jSlider = (JSlider)changeEvent.getSource();
            if (jSlider.getValue() >= 80) {
                Robot.this.c.setPause(100 - jSlider.getValue());
            } else {
                Robot.this.c.setPause((int)(5000.0 * Math.pow(0.9333096363135965, jSlider.getValue())));
            }
        }

        void addMessage(final String string) {
            final JScrollBar jScrollBar = this.scroll.getVerticalScrollBar();
            if (!(jScrollBar.getValueIsAdjusting() || jScrollBar.getValue() + jScrollBar.getVisibleAmount() != jScrollBar.getMaximum() && jScrollBar.getValue() != this.position)) {
                Runnable runnable = new Runnable(){

                    public void run() {
                        View.this.err.append(string);
                        View.this.position = jScrollBar.getMaximum() - jScrollBar.getVisibleAmount();
                        jScrollBar.setValue(View.this.position);
                    }
                };
                try {
                    SwingUtilities.invokeAndWait(runnable);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else {
                this.position = -1;
                this.err.append(string);
            }
        }

        void repaintSim(boolean bl) {
            Runnable runnable = new Runnable(){

                public void run() {
                    View.this.sim.paintImmediately(0, 0, View.this.sim.getWidth(), View.this.sim.getHeight());
                }
            };
            if (bl && !Robot.this.c.drop()) {
                try {
                    SwingUtilities.invokeAndWait(runnable);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else {
                this.sim.repaint();
            }
        }

        public String getParam(int n) {
            String string = this.params[n].getText();
            return string;
        }

        class Vis
        extends JPanel {
            Vis() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void paint(Graphics graphics) {
                int n;
                boolean[] blArray;
                boolean[] blArray2;
                int[] nArray;
                int[] nArray2;
                char[][] cArray;
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.setColor(Color.white);
                graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
                Object object = movelock;
                synchronized (object) {
                    cArray = Robot.this.c.getMap();
                    nArray2 = (int[])Robot.this.c.crobotX.clone();
                    nArray = (int[])Robot.this.c.crobotY.clone();
                    blArray2 = (boolean[])Robot.this.c.cput.clone();
                    blArray = (boolean[])Robot.this.c.ctake.clone();
                }
                int n2 = Math.min(this.getWidth() / cArray[0].length, this.getHeight() / cArray.length);
                int n3 = this.getWidth() / 2;
                int n4 = this.getHeight() / 2;
                graphics2D.setColor(Color.gray);
                for (int i = 0; i < Robot.this.c.N; ++i) {
                    for (int j = 0; j < Robot.this.c.M; ++j) {
                        int n5 = n4 - (cArray.length / 2 - i * (2 + Robot.this.c.rowGap) - 2) * n2 - n2 / 2;
                        n = n3 - (cArray[0].length / 2 - j * (Robot.this.c.colGap + Robot.this.c.K) - 2) * n2 - n2 / 2;
                        graphics2D.fillRect(n, n5, Robot.this.c.K * n2, 2 * n2);
                    }
                }
                Color[] colorArray = new Color[]{Color.red, Color.blue, new Color(0, 64, 255), new Color(0, 128, 255), new Color(0, 192, 255), new Color(0, 255, 255), new Color(51, 204, 255), new Color(102, 153, 255), new Color(153, 102, 255), new Color(204, 51, 255), new Color(255, 0, 255)};
                Color color = Color.yellow;
                Color color2 = Color.green;
                for (n = 0; n < nArray2.length; ++n) {
                    int n6 = nArray[n];
                    int n7 = nArray2[n];
                    if (blArray2[n]) {
                        graphics2D.setColor(color2);
                    } else if (blArray[n]) {
                        graphics2D.setColor(color);
                    } else {
                        graphics2D.setColor(colorArray[Robot.this.c.ccnt[n]]);
                    }
                    graphics2D.fillRect(n3 - (cArray[0].length / 2 - n7) * n2 - n2 / 2, n4 - (cArray.length / 2 - n6) * n2 - n2 / 2, n2, n2);
                }
                graphics2D.setColor(Color.black);
                graphics2D.drawRect(n3 - cArray[0].length / 2 * n2 - n2 / 2 - 1, n4 - cArray.length / 2 * n2 - n2 / 2 - 1, n2 * cArray[0].length + 1, n2 * cArray.length + 1);
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                Font font = new Font(graphics2D.getFont().getName(), 0, 40);
                graphics2D.setFont(font);
                FontMetrics fontMetrics = graphics2D.getFontMetrics();
                String string = Robot.this.c.getScore() + " / " + Robot.this.c.getTime();
                int n8 = fontMetrics.stringWidth(string);
                int n9 = fontMetrics.getAscent();
                graphics2D.setColor(Color.blue);
                graphics2D.setComposite(AlphaComposite.getInstance(3, 0.5f));
                graphics2D.drawString(string, n3 - n8 / 2, n4 + n9 / 2);
                graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f));
            }
        }
    }

    class Controller {
        String process = "Enter your executable and its arguments here";
        Runner current;
        Random r;
        int ST = 20;
        int slide = 80;
        int seed;
        boolean running;
        boolean novis;
        boolean drop;
        int C;
        int M;
        int N;
        int K;
        int P;
        int R;
        int rowGap;
        int colGap;
        int[] robotX;
        int[] robotY;
        int[] taskID;
        int[] taskY;
        int[] crobotX;
        int[] crobotY;
        boolean[] put;
        boolean[] take;
        boolean[] cput;
        boolean[] ctake;
        int TASKS = 10000;
        char[][] start;
        char[][] action;
        String[] products;
        int[][] locs;
        HashMap<Integer, Integer> deliver;
        int[][] carrying;
        int[] ccnt;
        int[] dx = new int[]{0, 1, 0, -1, 0};
        int[] dy = new int[]{-1, 0, 1, 0, 0};
        int score;
        int time;

        Controller() {
        }

        void generate(boolean bl, int n) {
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            int n7;
            this.score = 0;
            this.time = 0;
            this.deliver = new HashMap();
            this.seed = n;
            this.r = new Random(n);
            if (bl) {
                this.C = this.r.nextInt(10) + 1;
                this.M = this.r.nextInt(20) + 1;
                this.N = this.r.nextInt(26) + 5;
                this.K = this.r.nextInt(11) + 5;
                this.rowGap = this.r.nextInt(2) + 1;
                this.colGap = this.r.nextInt(2) + 1;
                this.P = this.r.nextInt(9901) + 100;
                this.R = this.r.nextInt(this.N * this.M * this.K * this.rowGap / 2 - 9) + 10;
            } else {
                if (this.C == 0) {
                    this.C = this.r.nextInt(10) + 1;
                } else {
                    this.r.nextInt(10);
                }
                if (this.M == 0) {
                    this.M = this.r.nextInt(20) + 1;
                } else {
                    this.r.nextInt(20);
                }
                if (this.N == 0) {
                    this.N = this.r.nextInt(26) + 5;
                } else {
                    this.r.nextInt(26);
                }
                if (this.K == 0) {
                    this.K = this.r.nextInt(11) + 5;
                } else {
                    this.r.nextInt(11);
                }
                if (this.rowGap == 0) {
                    this.rowGap = this.r.nextInt(2) + 1;
                } else {
                    this.r.nextInt(2);
                }
                if (this.colGap == 0) {
                    this.colGap = this.r.nextInt(2) + 1;
                } else {
                    this.r.nextInt(2);
                }
                if (this.P == 0) {
                    this.P = this.r.nextInt(9901) + 100;
                } else {
                    this.r.nextInt(9901);
                }
                if (this.R == 0) {
                    this.R = this.r.nextInt(this.N * this.M * this.K * this.rowGap / 2 - 9) + 10;
                } else {
                    this.r.nextInt(this.N * this.M * this.K - 9);
                }
                if (Robot.this.v != null) {
                    try {
                        for (n7 = 1; n7 < Robot.this.paramNames.length; ++n7) {
                            Field field = this.getClass().getDeclaredField(Robot.this.paramNames[n7]);
                            field.set(this, new Integer(Robot.this.v.getParam(n7)));
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
            this.start = new char[(2 + this.rowGap) * this.N - this.rowGap + 4][this.M * (this.K + this.colGap) - this.colGap + 4];
            n7 = this.start.length * this.start[0].length - this.M * this.N * this.K * 2;
            if (this.R > n7 - 1) {
                this.R = n7 - 1;
            }
            this.carrying = new int[this.R][this.C];
            this.ccnt = new int[this.R];
            this.products = new String[this.P];
            this.locs = new int[this.P][];
            this.robotX = new int[this.R];
            this.robotY = new int[this.R];
            this.take = new boolean[this.R];
            this.put = new boolean[this.R];
            this.crobotX = this.robotX;
            this.crobotY = this.robotY;
            this.cput = this.put;
            this.ctake = this.take;
            for (n6 = 0; n6 < this.start.length; ++n6) {
                for (n5 = 0; n5 < this.start[n6].length; ++n5) {
                    this.start[n6][n5] = 46;
                }
            }
            for (n6 = 0; n6 < this.N; ++n6) {
                n5 = n6 * (2 + this.rowGap) + 2;
                for (n4 = 0; n4 < this.M; ++n4) {
                    n3 = n4 * (this.K + this.colGap) + 2;
                    for (n2 = 0; n2 < this.K; ++n2) {
                        this.start[n5 + 1][n3 + n2] = 88;
                        this.start[n5][n3 + n2] = 88;
                    }
                }
            }
            for (n6 = 0; n6 < this.R; ++n6) {
                n5 = this.r.nextInt(this.start.length);
                n4 = this.r.nextInt(this.start[0].length);
                while (this.start[n5][n4] != '.') {
                    n5 = this.r.nextInt(this.start.length);
                    n4 = this.r.nextInt(this.start[0].length);
                }
                this.start[n5][n4] = 82;
                this.robotY[n6] = n5;
                this.robotX[n6] = n4;
            }
            StringBuffer stringBuffer = new StringBuffer(100);
            for (n5 = 0; n5 < this.P; ++n5) {
                stringBuffer.delete(0, stringBuffer.length());
                n4 = this.r.nextInt(5) + 1;
                this.locs[n5] = new int[n4 * 2];
                for (n3 = 0; n3 < n4; ++n3) {
                    int n8;
                    n2 = this.r.nextInt(this.N) * (2 + this.rowGap) + 2 + this.r.nextInt(2);
                    this.locs[n5][n3 * 2] = n8 = this.r.nextInt(this.M) * (this.K + this.colGap) + 2 + this.r.nextInt(this.K);
                    this.locs[n5][n3 * 2 + 1] = n2;
                    if (n3 != 0) {
                        stringBuffer.append(' ');
                    }
                    stringBuffer.append(n8).append(',').append(n2);
                }
                this.products[n5] = stringBuffer.toString();
            }
            this.taskID = new int[this.TASKS];
            this.taskY = new int[this.TASKS];
            for (n5 = 0; n5 < this.taskID.length; ++n5) {
                this.taskID[n5] = this.r.nextInt(this.P);
                this.taskY[n5] = this.r.nextInt(this.start.length);
                Integer n9 = this.taskID[n5] << 10 | this.taskY[n5];
                Integer n10 = this.deliver.get(n9);
                if (n10 == null) {
                    this.deliver.put(n9, 1);
                    continue;
                }
                this.deliver.put(n9, n10 + 1);
            }
        }

        public char[][] getMap() {
            return this.start;
        }

        public int getScore() {
            return this.score;
        }

        public int getTime() {
            return this.time;
        }

        void start() {
            if (Robot.this.v != null) {
                Robot.this.v.err.setText("");
            }
            this.current = new Runner();
            this.current.start();
        }

        void stop() {
            this.running = false;
            if (this.current != null) {
                try {
                    if (this.current.pr != null) {
                        this.current.pr.destroy();
                        this.current.pr.waitFor();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                this.current = null;
            }
        }

        public int newSeed() {
            return this.r.nextInt();
        }

        public void setSeed(int n) {
            this.seed = n;
        }

        public int getSeed() {
            return this.seed;
        }

        public String getParameter(String string) {
            try {
                Field field = this.getClass().getDeclaredField(string);
                return field.get(this).toString();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return "ERR";
            }
        }

        public void setParameter(String string, String string2) {
            try {
                Field field = this.getClass().getDeclaredField(string);
                field.set(this, Integer.parseInt(string2));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public int getSlide() {
            return this.slide;
        }

        public void setSlide(int n) {
            this.slide = n;
        }

        public void setPause(int n) {
            this.ST = n;
        }

        public void addMessage(String string) {
            if (this.novis) {
                System.out.print(string);
            } else {
                Robot.this.v.addMessage(string);
            }
        }

        public void addFatalError(String string) {
            this.addMessage(string);
        }

        public boolean drop() {
            return this.drop;
        }

        public void setDrop(boolean bl) {
            this.drop = bl;
        }

        class Runner
        extends Thread {
            Process pr;
            BufferedReader input;
            InputStream error;
            DataOutputStream os;

            Runner() {
            }

            String ia(int[] nArray) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(nArray.length);
                for (int i = 0; i < nArray.length; ++i) {
                    stringBuffer.append(' ').append(nArray[i]);
                }
                return stringBuffer.toString();
            }

            void writeParams(int n, int n2, int n3, int n4, int n5, int n6, int[] nArray, int[] nArray2, String[] stringArray, int[] nArray3, int[] nArray4) throws IOException {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(n).append(' ');
                stringBuffer.append(n2).append(' ');
                stringBuffer.append(n3).append(' ');
                stringBuffer.append(n4).append(' ');
                stringBuffer.append(n5).append(' ');
                stringBuffer.append(n6).append('\n');
                stringBuffer.append(this.ia(nArray)).append('\n');
                stringBuffer.append(this.ia(nArray2)).append('\n');
                stringBuffer.append(stringArray.length).append('\n');
                for (int i = 0; i < stringArray.length; ++i) {
                    stringBuffer.append(stringArray[i]).append('\n');
                }
                stringBuffer.append(this.ia(nArray3)).append('\n');
                stringBuffer.append(this.ia(nArray4)).append('\n');
                this.os.write(stringBuffer.toString().getBytes());
            }

            String next() throws IOException {
                return this.input.readLine();
            }

            public void run() {
                this.runTest();
                this.pr.destroy();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void runTest() {
                Controller.this.running = true;
                try {
                    Object object = runlock;
                    synchronized (object) {
                        int n;
                        String string;
                        this.pr = Runtime.getRuntime().exec(Robot.this.getProcess());
                        this.input = new BufferedReader(new InputStreamReader(this.pr.getInputStream()));
                        this.error = this.pr.getErrorStream();
                        this.os = new DataOutputStream(this.pr.getOutputStream());
                        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                            public void run() {
                                Runner.this.pr.destroy();
                            }
                        }));
                        Controller.this.time = 0;
                        Controller.this.score = 0;
                        Thread thread = new Thread(new Runnable(){

                            public void run() {
                                try {
                                    int n;
                                    byte[] byArray = new byte[50000];
                                    while ((n = Runner.this.error.read(byArray)) > 0 && Controller.this.running) {
                                        Controller.this.addMessage(new String(byArray, 0, n));
                                    }
                                    Controller.this.addMessage("\n");
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        });
                        thread.start();
                        this.writeParams(Controller.this.C, Controller.this.M, Controller.this.N, Controller.this.K, Controller.this.rowGap, Controller.this.colGap, (int[])Controller.this.robotX.clone(), (int[])Controller.this.robotY.clone(), Controller.this.products, Controller.this.taskID, Controller.this.taskY);
                        Controller.this.action = new char[Controller.this.start.length][Controller.this.start[0].length];
                        int n2 = 0;
                        HashMap hashMap = (HashMap)Robot.this.c.deliver.clone();
                        Robot.this.c.crobotX = (int[])Controller.this.robotX.clone();
                        Robot.this.c.crobotY = (int[])Controller.this.robotY.clone();
                        Robot.this.c.cput = (boolean[])Controller.this.put.clone();
                        Robot.this.c.ctake = (boolean[])Controller.this.take.clone();
                        while (Controller.this.running && (string = this.next()) != null && n2 < 50000) {
                            int n3;
                            int n4;
                            int n5;
                            int n6 = 0;
                            string = string + " ";
                            for (n5 = 0; n5 < string.length(); ++n5) {
                                n4 = string.charAt(n5);
                                if (n4 == 32) continue;
                                if (n6 == Controller.this.robotX.length) {
                                    Controller.this.addFatalError("You issued too many actions at time step " + n2);
                                    return;
                                }
                                if ("UDLRSTP".indexOf(n4) == -1) {
                                    Controller.this.addFatalError("Character " + n5 + " of element " + n2 + " of your return is invalid: '" + (char)n4 + "'");
                                    return;
                                }
                                n3 = -1;
                                Robot.this.c.put[n6] = false;
                                Robot.this.c.take[n6] = false;
                                if (n4 == 84 || n4 == 80) {
                                    int n7;
                                    int n8;
                                    n = string.charAt(n5 + 1);
                                    while (n == 32 && n5 + 2 < string.length()) {
                                        n = string.charAt(++n5 + 1);
                                    }
                                    while (n >= 48 && n <= 57) {
                                        if (n3 == -1) {
                                            n3 = 0;
                                        }
                                        n3 = n3 * 10 + n - 48;
                                        n = string.charAt(++n5 + 1);
                                    }
                                    if (n3 < 0 || n3 > Controller.this.products.length) {
                                        Controller.this.addFatalError("Invalid action for robot " + n6 + " at time " + n2);
                                        return;
                                    }
                                    if (n4 == 84) {
                                        boolean bl = false;
                                        for (int i = 0; i < Controller.this.locs[n3].length; i += 2) {
                                            n8 = Math.abs(Controller.this.locs[n3][i] - Controller.this.robotX[n6]);
                                            if (n8 + (n7 = Math.abs(Controller.this.locs[n3][i + 1] - Controller.this.robotY[n6])) != 1) continue;
                                            bl = true;
                                        }
                                        if (!bl) {
                                            Controller.this.addFatalError("Robot " + n6 + " tried to pick up a non-adjacent product at time " + n2 + "\n");
                                            return;
                                        }
                                        if (Controller.this.ccnt[n6] == Controller.this.C) {
                                            Controller.this.addFatalError("Robot " + n6 + " tried to pick up when full at time " + n2 + "\n");
                                            return;
                                        }
                                        Robot.this.c.take[n6] = true;
                                        int n9 = n6;
                                        int n10 = Controller.this.ccnt[n9];
                                        Controller.this.ccnt[n9] = n10 + 1;
                                        Controller.this.carrying[n6][n10] = n3;
                                    } else if (n4 == 80) {
                                        if (Controller.this.robotX[n6] != 0) {
                                            Controller.this.addFatalError("Robot " + n6 + " tried to drop off at " + Controller.this.robotX[n6] + "," + Controller.this.robotY[n6] + " at time " + n2 + "\n");
                                            return;
                                        }
                                        Integer n11 = n3 << 10 | Controller.this.robotY[n6];
                                        Integer n12 = (Integer)hashMap.get(n11);
                                        if (n12 == null || n12 == 0) {
                                            Controller.this.addFatalError("Robot " + n6 + " tried to drop off " + n3 + " at " + Controller.this.robotX[n6] + "," + Controller.this.robotY[n6] + " at time " + n2 + " when it wasn't needed. \n");
                                            return;
                                        }
                                        n8 = 0;
                                        for (n7 = 0; n7 < Controller.this.ccnt[n6]; ++n7) {
                                            if (Controller.this.carrying[n6][n7] != n3) continue;
                                            n8 = 1;
                                            int n13 = n6;
                                            int n14 = Controller.this.ccnt[n13] - 1;
                                            Controller.this.ccnt[n13] = n14;
                                            Controller.this.carrying[n6][n7] = Controller.this.carrying[n6][n14];
                                            break;
                                        }
                                        if (n8 == 0) {
                                            Controller.this.addFatalError("Robot " + n6 + " tried to drop off " + n3 + " at " + Controller.this.robotX[n6] + "," + Controller.this.robotY[n6] + " at time " + n2 + " when it wasn't carrying it.\n");
                                            return;
                                        }
                                        Robot.this.c.put[n6] = true;
                                        ++Controller.this.score;
                                        hashMap.put(n11, n12 - 1);
                                    }
                                    Controller.this.action[Controller.this.robotY[n6]][Controller.this.robotX[n6]] = 83;
                                } else {
                                    Controller.this.action[Controller.this.robotY[n6]][Controller.this.robotX[n6]] = n4;
                                }
                                ++n6;
                            }
                            if (n6 != Controller.this.robotX.length) {
                                Controller.this.addFatalError("Not all robots performed an action at time " + n2 + "\n");
                                return;
                            }
                            for (n5 = 0; n5 < Controller.this.robotX.length; ++n5) {
                                n4 = "URDLS".indexOf(Controller.this.action[Controller.this.robotY[n5]][Controller.this.robotX[n5]]);
                                n3 = Controller.this.robotY[n5] + Controller.this.dy[n4];
                                n = Controller.this.robotX[n5] + Controller.this.dx[n4];
                                if (n < 0 || n3 < 0 || n >= Controller.this.start[0].length || n3 >= Controller.this.start.length) {
                                    Controller.this.addFatalError("Robot " + n5 + " attempted to move off the board at time " + n2 + ".\n");
                                    return;
                                }
                                if (Controller.this.start[n3][n] == 'X') {
                                    Controller.this.addFatalError("Robot " + n5 + " attempted to move into a shelf at time " + n2 + ". \n");
                                    return;
                                }
                                if (Controller.this.start[n3][n] != 'R' || Controller.this.action[Controller.this.robotY[n5]][Controller.this.robotX[n5]] == 'S' || Controller.this.action[n3][n] != 'S' && "URDLS".indexOf(Controller.this.action[n3][n]) != (n4 + 2) % 4) continue;
                                Controller.this.addFatalError("Robot " + n5 + " collided with another robot at time " + n2 + ".\n");
                                return;
                            }
                            for (n5 = 0; n5 < Controller.this.robotX.length; ++n5) {
                                n4 = "URDLS".indexOf(Controller.this.action[Controller.this.robotY[n5]][Controller.this.robotX[n5]]);
                                n3 = Controller.this.robotY[n5] + Controller.this.dy[n4];
                                n = Controller.this.robotX[n5] + Controller.this.dx[n4];
                                Controller.this.action[Controller.this.robotY[n5]][Controller.this.robotX[n5]] = 46;
                                Controller.this.start[Controller.this.robotY[n5]][Controller.this.robotX[n5]] = 46;
                                Controller.this.robotY[n5] = n3;
                                Controller.this.robotX[n5] = n;
                            }
                            for (n5 = 0; n5 < Controller.this.robotX.length; ++n5) {
                                if (Controller.this.start[Controller.this.robotY[n5]][Controller.this.robotX[n5]] == 'R') {
                                    Controller.this.addFatalError("You directed two (or more) robots into the same location (" + Controller.this.robotY[n5] + "," + Controller.this.robotX[n5] + ") at time " + n2 + "\n");
                                    return;
                                }
                                Controller.this.start[Controller.this.robotY[n5]][Controller.this.robotX[n5]] = 82;
                            }
                            Controller.this.time = ++n2;
                            Object object2 = movelock;
                            synchronized (object2) {
                                System.arraycopy(Robot.this.c.robotX, 0, Robot.this.c.crobotX, 0, Robot.this.c.robotX.length);
                                System.arraycopy(Robot.this.c.robotY, 0, Robot.this.c.crobotY, 0, Robot.this.c.robotY.length);
                                System.arraycopy(Robot.this.c.put, 0, Robot.this.c.cput, 0, Robot.this.c.put.length);
                                System.arraycopy(Robot.this.c.take, 0, Robot.this.c.ctake, 0, Robot.this.c.take.length);
                            }
                            if (Controller.this.novis) continue;
                            Robot.this.v.repaintSim(true);
                            if (Controller.this.ST == 0) continue;
                            Thread.sleep(Controller.this.ST);
                        }
                        this.pr.destroy();
                        Iterator iterator = hashMap.values().iterator();
                        int n15 = 0;
                        double d = 1.0;
                        while (iterator.hasNext()) {
                            n = (Integer)iterator.next();
                            n15 += n;
                            d *= Math.pow(0.99, n);
                        }
                        String string2 = "You delivered " + (10000 - n15) + " items in " + n2 + " steps.\n";
                        Controller.this.addMessage(string2);
                        if (d < 1.0) {
                            d /= 2.0;
                        }
                    }
                }
                catch (IOException iOException) {
                    Controller.this.addMessage("Simulation over because communication between the visualizer and your process ended.\n");
                    Controller.this.addMessage(iOException.getMessage() + "\n");
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }
}

