/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.security.SecureRandom;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class RobonautVisionVis {
    public static long seed = 1L;
    public static boolean debug = true;
    public static boolean visualize = true;
    public static boolean renderFaces = false;
    public static String execCommand = null;
    public static String testingFile = null;
    public static String trainingFile = null;
    public static String[] modelFiles = new String[]{"drill_scaled.ply", "handrail_scaled.ply", "rfid_reader_scaled.ply", "soft_goods_box_scaled.ply"};
    public static String folder = "";
    public SecureRandom rnd;
    public static int W;
    public static int H;
    public static double D;
    public static Process solution;
    public final Object worldLock = new Object();
    public Transform TX = new Transform();
    Vertex[] vertexData = null;
    Face[] faceData = null;

    public void printMessage(String string) {
        if (debug) {
            System.out.println(string);
        }
    }

    public void parseModel(String[] stringArray) {
        String[] stringArray2;
        int n;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (!stringArray[n4].equals("end_header")) {
            String[] stringArray3 = stringArray[n4].split(" ");
            if (stringArray3[0].equals("element")) {
                if (stringArray3[1].equals("vertex")) {
                    n2 = Integer.parseInt(stringArray3[2]);
                } else if (stringArray3[1].equals("face")) {
                    n3 = Integer.parseInt(stringArray3[2]);
                }
            }
            ++n4;
        }
        ++n4;
        this.printMessage("Model contains " + n2 + " vertices and " + n3 + " faces.");
        this.vertexData = new Vertex[n2];
        for (n = 0; n < n2; ++n) {
            stringArray2 = stringArray[n4++].split(" ");
            this.vertexData[n] = new Vertex(Double.parseDouble(stringArray2[0]), Double.parseDouble(stringArray2[1]), Double.parseDouble(stringArray2[2]));
        }
        this.faceData = new Face[n3];
        for (n = 0; n < n3; ++n) {
            stringArray2 = stringArray[n4++].split(" ");
            int[] nArray = new int[Integer.parseInt(stringArray2[0])];
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = Integer.parseInt(stringArray2[1 + i]);
            }
            this.faceData[n] = new Face(nArray);
        }
        D = 1.0E-4;
        for (n = 0; n < n2; ++n) {
            for (int i = n + 1; i < n2; ++i) {
                double d = this.vertexData[n].x - this.vertexData[i].x;
                double d2 = this.vertexData[n].y - this.vertexData[i].y;
                double d3 = this.vertexData[n].z - this.vertexData[i].z;
                double d4 = d * d + d2 * d2 + d3 * d3;
                D = Math.max(D, d4);
            }
        }
        D = Math.sqrt(D);
        this.printMessage("Longest Dimension = " + D);
    }

    public int[] imageToArray(String string) throws Exception {
        this.printMessage("Reading image from " + string);
        BufferedImage bufferedImage = ImageIO.read(new File(string));
        H = bufferedImage.getHeight();
        W = bufferedImage.getWidth();
        int[] nArray = new int[H * W];
        int n = 0;
        byte[] byArray = ((DataBufferByte)bufferedImage.getRaster().getDataBuffer()).getData();
        for (int i = 0; i < byArray.length; i += 3) {
            int n2;
            int n3;
            int n4 = byArray[i];
            if (n4 < 0) {
                n4 += 256;
            }
            if ((n3 = byArray[i + 1]) < 0) {
                n3 += 256;
            }
            if ((n2 = byArray[i + 2]) < 0) {
                n2 += 256;
            }
            nArray[n++] = n4 | n3 << 8 | n2 << 16;
        }
        return nArray;
    }

    public ArrayList<SingleFrame> loadPairs(String string) throws Exception {
        String string2;
        ArrayList<SingleFrame> arrayList = new ArrayList<SingleFrame>();
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        int n = Integer.parseInt(bufferedReader.readLine());
        for (int i = 0; i < n && (string2 = bufferedReader.readLine()) != null; ++i) {
            String[] stringArray = string2.split(",");
            int n2 = Integer.parseInt(stringArray[0]);
            if ((long)n2 != seed) continue;
            double[] dArray = null;
            dArray = stringArray.length > 10 ? new double[14] : new double[7];
            for (int j = 0; j < dArray.length; ++j) {
                dArray[j] = Double.parseDouble(stringArray[3 + j]);
            }
            SingleFrame singleFrame = new SingleFrame(folder + stringArray[1], folder + stringArray[2], dArray);
            arrayList.add(singleFrame);
        }
        bufferedReader.close();
        return arrayList;
    }

    public double calcScore(Position position, Position position2, int n) {
        double d = 0.0;
        for (int i = 0; i < this.vertexData.length; ++i) {
            double[] dArray = this.TX.rotate(this.vertexData[i].x, this.vertexData[i].y, this.vertexData[i].z, position.dt[3], position.dt[4], position.dt[5], position.dt[6]);
            dArray[0] = dArray[0] + position.dt[0];
            dArray[1] = dArray[1] + position.dt[1];
            dArray[2] = dArray[2] + position.dt[2];
            double[] dArray2 = this.TX.rotate(this.vertexData[i].x, this.vertexData[i].y, this.vertexData[i].z, position2.dt[3], position2.dt[4], position2.dt[5], position2.dt[6]);
            dArray2[0] = dArray2[0] + position2.dt[0];
            dArray2[1] = dArray2[1] + position2.dt[1];
            dArray2[2] = dArray2[2] + position2.dt[2];
            d += Math.sqrt((dArray2[0] - dArray[0]) * (dArray2[0] - dArray[0]) + (dArray2[1] - dArray[1]) * (dArray2[1] - dArray[1]) + (dArray2[2] - dArray[2]) * (dArray2[2] - dArray[2]));
        }
        this.printMessage("AverageT = " + (d /= (double)this.vertexData.length));
        double d2 = 1.0 / (1.0 + d / (0.1 * D));
        this.printMessage("AD = " + d2);
        this.printMessage("Image pairs training on = " + n);
        double d3 = 1000000.0 * d2 / (1.0 + 0.01 * (double)n);
        return d3;
    }

    public double doExec() throws Exception {
        int n;
        String[] stringArray;
        try {
            this.rnd = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (Exception exception) {
            System.err.println("ERROR: unable to generate test case.");
            System.exit(1);
        }
        this.rnd.setSeed(seed);
        this.printMessage("Executing your solution: " + execCommand);
        solution = Runtime.getRuntime().exec(execCommand);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(solution.getInputStream()));
        PrintWriter printWriter = new PrintWriter(solution.getOutputStream());
        new ErrorStreamRedirector(solution.getErrorStream()).start();
        String[] stringArray2 = null;
        ArrayList<SingleFrame> arrayList = this.loadPairs(trainingFile);
        ArrayList<SingleFrame> arrayList2 = this.loadPairs(testingFile);
        if (modelFiles[(int)seed - 1] != null) {
            ArrayList<String> arrayList3 = new ArrayList<String>();
            stringArray = new BufferedReader(new FileReader(modelFiles[(int)seed - 1]));
            String string = stringArray.readLine();
            while (string != null) {
                arrayList3.add(string);
                string = stringArray.readLine();
            }
            stringArray.close();
            stringArray2 = arrayList3.toArray(new String[0]);
            this.parseModel(stringArray2);
        }
        int n2 = 0;
        printWriter.println(stringArray2.length);
        stringArray = stringArray2;
        int n22 = stringArray.length;
        for (int i = 0; i < n22; ++i) {
            BufferedReader objectArray = stringArray[i];
            printWriter.println((String)((Object)objectArray));
        }
        printWriter.flush();
        int n3 = Integer.parseInt(bufferedReader.readLine());
        if (n3 == 0) {
            if (trainingFile != null) {
                this.printMessage("Available training images: " + arrayList.size());
                printWriter.println(arrayList.size());
                printWriter.flush();
                for (n22 = 0; n22 < arrayList.size(); ++n22) {
                    SingleFrame singleFrame = arrayList.get(n22);
                    singleFrame.Load();
                    for (int n4 : singleFrame.leftImg) {
                        printWriter.println(n4);
                    }
                    printWriter.flush();
                    for (int n4 : singleFrame.rightImg) {
                        printWriter.println(n4);
                    }
                    printWriter.flush();
                    printWriter.println(singleFrame.gtf.dt.length);
                    double[] dArray = singleFrame.gtf.dt;
                    int n5 = dArray.length;
                    for (n = 0; n < n5; ++n) {
                        double d = dArray[n];
                        printWriter.println(d);
                    }
                    printWriter.flush();
                    ++n2;
                    n3 = Integer.parseInt(bufferedReader.readLine());
                    if (n3 != 1) {
                        continue;
                    }
                    break;
                }
            } else {
                System.out.println("ERROR: Training file not provided");
                System.exit(0);
            }
        }
        double d = 0.0;
        Drawer drawer = null;
        if (visualize) {
            drawer = new Drawer();
            drawer.pauseMode = false;
        }
        if (testingFile != null) {
            this.printMessage("Testing with " + arrayList2.size() + " image pairs");
            String[] stringArray3 = new String[arrayList2.size()];
            printWriter.println(arrayList2.size());
            printWriter.flush();
            for (n = 0; n < arrayList2.size(); ++n) {
                SingleFrame singleFrame = arrayList2.get(n);
                singleFrame.Load();
                for (int n6 : singleFrame.leftImg) {
                    printWriter.println(n6);
                }
                printWriter.flush();
                for (int n6 : singleFrame.rightImg) {
                    printWriter.println(n6);
                }
                printWriter.flush();
                Position position = new Position(Double.parseDouble(bufferedReader.readLine()), Double.parseDouble(bufferedReader.readLine()), Double.parseDouble(bufferedReader.readLine()), Double.parseDouble(bufferedReader.readLine()), Double.parseDouble(bufferedReader.readLine()), Double.parseDouble(bufferedReader.readLine()), Double.parseDouble(bufferedReader.readLine()));
                double d2 = this.calcScore(position, singleFrame.gtf, n2);
                if (singleFrame.gtf2 != null) {
                    d2 = Math.max(d2, this.calcScore(position, singleFrame.gtf2, n2));
                }
                System.err.println("Score for image pair = " + d2 + "\n");
                d += d2;
                if (!visualize) continue;
                drawer.update(singleFrame.leftFile, singleFrame.rightFile, position, singleFrame.gtf);
                drawer.pauseMode = true;
                drawer.repaint();
                drawer.processPause();
            }
        } else {
            System.out.println("ERROR: Testing file not provided");
            System.exit(0);
        }
        RobonautVisionVis.stopSolution();
        return d;
    }

    public static void stopSolution() {
        if (solution != null) {
            try {
                solution.destroy();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void main(String[] stringArray) throws Exception {
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-folder")) {
                folder = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-exec")) {
                execCommand = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-seed")) {
                seed = Long.parseLong(stringArray[++i]);
                continue;
            }
            if (stringArray[i].equals("-train")) {
                trainingFile = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-test")) {
                testingFile = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-silent")) {
                debug = false;
                continue;
            }
            if (stringArray[i].equals("-faces")) {
                renderFaces = true;
                continue;
            }
            if (stringArray[i].equals("-novis")) {
                visualize = false;
                continue;
            }
            System.out.println("WARNING: unknown argument " + stringArray[i] + ".");
        }
        RobonautVisionVis robonautVisionVis = new RobonautVisionVis();
        try {
            double d = robonautVisionVis.doExec();
            System.out.println("Score  = " + d);
            if (visualize) {
                System.exit(0);
            }
        }
        catch (Exception exception) {
            System.out.println("FAILURE: " + exception.getMessage());
            exception.printStackTrace();
            RobonautVisionVis.stopSolution();
        }
    }

    class ErrorStreamRedirector
    extends Thread {
        public BufferedReader reader;

        public ErrorStreamRedirector(InputStream inputStream) {
            this.reader = new BufferedReader(new InputStreamReader(inputStream));
        }

        @Override
        public void run() {
            while (true) {
                String string;
                try {
                    string = this.reader.readLine();
                }
                catch (Exception exception) {
                    return;
                }
                if (string == null) break;
                System.out.println(string);
            }
        }
    }

    class SingleFrame {
        int[] leftImg;
        int[] rightImg;
        Position gtf;
        Position gtf2 = null;
        String leftFile;
        String rightFile;

        public SingleFrame(String string, String string2, double[] dArray) {
            this.leftFile = string;
            this.rightFile = string2;
            this.gtf = new Position(dArray);
            if (dArray.length > 7) {
                this.gtf2 = new Position(dArray[7], dArray[8], dArray[9], dArray[10], dArray[11], dArray[12], dArray[13]);
            }
        }

        public void Load() throws Exception {
            this.leftImg = RobonautVisionVis.this.imageToArray(this.leftFile);
            this.rightImg = RobonautVisionVis.this.imageToArray(this.rightFile);
        }
    }

    class Drawer
    extends JFrame {
        public DrawerPanel panel;
        public int width;
        public int height;
        public boolean pauseMode = false;
        public BufferedImage imgLeft = null;
        public BufferedImage imgRight = null;
        public Position userPos;
        public Position gtfPos;
        final Object keyMutex = new Object();
        boolean keyPressed;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void update(String string, String string2, Position position, Position position2) throws Exception {
            Object object = RobonautVisionVis.this.worldLock;
            synchronized (object) {
                this.imgLeft = ImageIO.read(new File(string));
                this.imgRight = ImageIO.read(new File(string2));
                this.gtfPos = position2;
                this.userPos = position;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void processPause() {
            Object object = this.keyMutex;
            synchronized (object) {
                if (!this.pauseMode) {
                    return;
                }
                this.keyPressed = false;
                while (!this.keyPressed) {
                    this.repaint();
                    try {
                        this.keyMutex.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }

        public Drawer() {
            this.panel = new DrawerPanel();
            this.getContentPane().add(this.panel);
            this.addWindowListener(new DrawerWindowListener());
            this.width = 1600;
            this.height = 600;
            this.addKeyListener(new DrawerKeyListener());
            this.setSize(this.width, this.height);
            this.setTitle("Robonaut Vision Tool Manipulation Marathon Match");
            this.setResizable(false);
            this.setVisible(true);
        }

        class DrawerWindowListener
        extends WindowAdapter {
            DrawerWindowListener() {
            }

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                RobonautVisionVis.stopSolution();
                System.exit(0);
            }
        }

        class DrawerPanel
        extends JPanel {
            DrawerPanel() {
            }

            public void renderModel(Graphics graphics, Position position) {
                int n;
                double[][] dArrayArray = new double[RobonautVisionVis.this.vertexData.length][];
                for (n = 0; n < RobonautVisionVis.this.vertexData.length; ++n) {
                    double[] dArray = RobonautVisionVis.this.TX.rotate(RobonautVisionVis.this.vertexData[n].x, RobonautVisionVis.this.vertexData[n].y, RobonautVisionVis.this.vertexData[n].z, position.dt[3], position.dt[4], position.dt[5], position.dt[6]);
                    dArrayArray[n] = RobonautVisionVis.this.TX.transform3Dto2D(dArray[0] + position.dt[0], dArray[1] + position.dt[1], dArray[2] + position.dt[2]);
                }
                for (n = 0; n < RobonautVisionVis.this.vertexData.length; ++n) {
                    if (dArrayArray[n][0] >= 0.0 && dArrayArray[n][0] < 1600.0 && dArrayArray[n][1] >= 0.0 && dArrayArray[n][1] < 1200.0) {
                        graphics.fillOval((int)dArrayArray[n][0] / 2 - 1, (int)dArrayArray[n][1] / 2 - 1, 2, 2);
                    }
                    if (dArrayArray[n][2] >= 0.0 && dArrayArray[n][2] < 1600.0 && dArrayArray[n][3] >= 0.0 && dArrayArray[n][3] < 1200.0) {
                        graphics.fillOval(800 + (int)dArrayArray[n][2] / 2 - 1, (int)dArrayArray[n][3] / 2 - 1, 2, 2);
                    }
                    double[] dArray = dArrayArray[n];
                    dArray[0] = dArray[0] / 2.0;
                    double[] dArray2 = dArrayArray[n];
                    dArray2[1] = dArray2[1] / 2.0;
                    double[] dArray3 = dArrayArray[n];
                    dArray3[2] = dArray3[2] / 2.0;
                    double[] dArray4 = dArrayArray[n];
                    dArray4[3] = dArray4[3] / 2.0;
                }
                if (renderFaces) {
                    for (n = 0; n < RobonautVisionVis.this.faceData.length; ++n) {
                        for (int i = 0; i < 2; ++i) {
                            int n2;
                            int n3;
                            int n4;
                            graphics.setClip(800 * i, 0, 800, 600);
                            double d = 0.0;
                            for (n4 = 0; n4 < RobonautVisionVis.this.faceData[n].vi.length; ++n4) {
                                n3 = RobonautVisionVis.this.faceData[n].vi[n4];
                                n2 = RobonautVisionVis.this.faceData[n].vi[(n4 + 1) % RobonautVisionVis.this.faceData[n].vi.length];
                                d += (dArrayArray[n2][i * 2] - dArrayArray[n3][i * 2]) * (dArrayArray[n2][i * 2 + 1] + dArrayArray[n3][i * 2 + 1]);
                            }
                            if (!(d > 0.0)) continue;
                            for (n4 = 0; n4 < RobonautVisionVis.this.faceData[n].vi.length; ++n4) {
                                n3 = RobonautVisionVis.this.faceData[n].vi[n4];
                                n2 = RobonautVisionVis.this.faceData[n].vi[(n4 + 1) % RobonautVisionVis.this.faceData[n].vi.length];
                                graphics.drawLine(800 * i + (int)dArrayArray[n3][i * 2], (int)dArrayArray[n3][i * 2 + 1], 800 * i + (int)dArrayArray[n2][i * 2], (int)dArrayArray[n2][i * 2 + 1]);
                            }
                        }
                        graphics.setClip(0, 0, 1600, 600);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void paint(Graphics graphics) {
                Object object = RobonautVisionVis.this.worldLock;
                synchronized (object) {
                    if (Drawer.this.imgLeft != null) {
                        graphics.drawImage(Drawer.this.imgLeft, 0, 0, Drawer.this.imgLeft.getWidth() / 2, Drawer.this.imgLeft.getHeight() / 2, 0, 0, Drawer.this.imgLeft.getWidth(), Drawer.this.imgLeft.getHeight(), null);
                    }
                    if (Drawer.this.imgRight != null) {
                        graphics.drawImage(Drawer.this.imgRight, 800, 0, Drawer.this.imgRight.getWidth(), Drawer.this.imgRight.getHeight() / 2, 0, 0, Drawer.this.imgRight.getWidth(), Drawer.this.imgRight.getHeight(), null);
                    }
                    graphics.setColor(Color.GREEN);
                    if (Drawer.this.gtfPos != null) {
                        this.renderModel(graphics, Drawer.this.gtfPos);
                    }
                    graphics.setColor(Color.RED);
                    if (Drawer.this.userPos != null) {
                        this.renderModel(graphics, Drawer.this.userPos);
                    }
                }
            }
        }

        class DrawerKeyListener
        extends KeyAdapter {
            DrawerKeyListener() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void keyPressed(KeyEvent keyEvent) {
                Object object = Drawer.this.keyMutex;
                synchronized (object) {
                    if (keyEvent.getKeyChar() == ' ') {
                        Drawer.this.pauseMode = !Drawer.this.pauseMode;
                        Drawer.this.keyPressed = true;
                    }
                    Drawer.this.keyMutex.notifyAll();
                }
            }
        }
    }

    class Transform {
        public double[] T = new double[]{145.626654332161, 1.65379695634088, -3.65966860066967};
        public double[] Q = new double[]{0.999985, 6.80463E-5, -7.05536E-7, 0.00540286};
        public double CxL = 5.29185E-4;
        public double CyL = 5.28196E-4;
        public double CxR = 5.29527E-4;
        public double CyR = 5.28341E-4;
        public double KL = -2.41479E-8;
        public double KR = -2.21532E-8;
        public double[] C0 = new double[]{800.0, 600.0};

        Transform() {
        }

        public double[] crossProduct(double[] dArray, double[] dArray2) {
            return new double[]{dArray[1] * dArray2[2] - dArray[2] * dArray2[1], dArray[2] * dArray2[0] - dArray[0] * dArray2[2], dArray[0] * dArray2[1] - dArray[1] * dArray2[0]};
        }

        public double[] rotate(double d, double d2, double d3, double d4, double d5, double d6, double d7) {
            double[] dArray = new double[]{d, d2, d3};
            double[] dArray2 = new double[]{d5, d6, d7};
            double[] dArray3 = this.crossProduct(dArray2, dArray);
            double[] dArray4 = this.crossProduct(dArray2, dArray3);
            dArray3[0] = dArray3[0] * (2.0 * d4);
            dArray3[1] = dArray3[1] * (2.0 * d4);
            dArray3[2] = dArray3[2] * (2.0 * d4);
            dArray4[0] = dArray4[0] * 2.0;
            dArray4[1] = dArray4[1] * 2.0;
            dArray4[2] = dArray4[2] * 2.0;
            return new double[]{dArray[0] + dArray3[0] + dArray4[0], dArray[1] + dArray3[1] + dArray4[1], dArray[2] + dArray3[2] + dArray4[2]};
        }

        public double[] transform3Dto2D(double d, double d2, double d3) {
            double[] dArray = new double[4];
            double[] dArray2 = new double[]{d + this.T[0] / 2.0, d2 + this.T[1] / 2.0, d3 + this.T[2] / 2.0};
            double[] dArray3 = new double[]{dArray2[0] / dArray2[2] / this.CxL, dArray2[1] / dArray2[2] / this.CyL};
            double[] dArray4 = new double[]{dArray3[0] * (1.0 + this.KL * (dArray3[0] * dArray3[0] + dArray3[1] * dArray3[1])) + this.C0[0], dArray3[1] * (1.0 + this.KL * (dArray3[0] * dArray3[0] + dArray3[1] * dArray3[1])) + this.C0[1]};
            dArray[0] = dArray4[0];
            dArray[0] = dArray[0] + (-4.72664 + 0.00264009 * dArray4[0] + 3.68547E-7 * dArray4[0] * dArray4[0] - 0.003594 * dArray4[1] + 4.59175E-7 * dArray4[0] * dArray4[1] + 5.21369E-6 * dArray4[1] * dArray4[1]);
            dArray[1] = dArray4[1];
            dArray[1] = dArray[1] + (9.60826 - 0.00203106 * dArray4[0] - 3.99045E-6 * dArray4[0] * dArray4[0] - 0.0121255 * dArray4[1] + 5.57403E-6 * dArray4[0] * dArray4[1] + 1.79152E-6 * dArray4[1] * dArray4[1]);
            dArray2 = new double[]{d - this.T[0] / 2.0, d2 - this.T[1] / 2.0, d3 - this.T[2] / 2.0};
            dArray2 = this.rotate(dArray2[0], dArray2[1], dArray2[2], this.Q[0], this.Q[1], this.Q[2], this.Q[3]);
            dArray3 = new double[]{dArray2[0] / dArray2[2] / this.CxR, dArray2[1] / dArray2[2] / this.CyR};
            dArray4 = new double[]{dArray3[0] * (1.0 + this.KR * (dArray3[0] * dArray3[0] + dArray3[1] * dArray3[1])) + this.C0[0], dArray3[1] * (1.0 + this.KR * (dArray3[0] * dArray3[0] + dArray3[1] * dArray3[1])) + this.C0[1]};
            dArray[2] = dArray4[0];
            dArray[2] = dArray[2] + (-11.058 + 0.0103577 * dArray4[0] - 4.38807E-6 * dArray4[0] * dArray4[0] + 0.0126752 * dArray4[1] + 7.04229E-7 * dArray4[0] * dArray4[1] - 5.02606E-6 * dArray4[1] * dArray4[1]);
            dArray[3] = dArray4[1];
            dArray[3] = dArray[3] + (1.05562 + 0.0044762 * dArray4[0] - 1.55134E-6 * dArray4[0] * dArray4[0] + 0.00646057 * dArray4[1] - 9.63543E-6 * dArray4[0] * dArray4[1] - 3.60981E-6 * dArray4[1] * dArray4[1]);
            return dArray;
        }
    }

    class Position {
        double[] dt = new double[7];

        public Position(double d, double d2, double d3, double d4, double d5, double d6, double d7) {
            this.dt[0] = d;
            this.dt[1] = d2;
            this.dt[2] = d3;
            this.dt[3] = d4;
            this.dt[4] = d5;
            this.dt[5] = d6;
            this.dt[6] = d7;
            this.normalize();
        }

        public Position(double[] dArray) {
            this.dt = dArray;
            this.normalize();
        }

        public void normalize() {
            double d = this.dt[3] * this.dt[3] + this.dt[4] * this.dt[4] + this.dt[5] * this.dt[5] + this.dt[6] * this.dt[6];
            d = Math.sqrt(d);
            this.dt[3] = this.dt[3] / d;
            this.dt[4] = this.dt[4] / d;
            this.dt[5] = this.dt[5] / d;
            this.dt[6] = this.dt[6] / d;
        }
    }

    class Face {
        int[] vi = null;

        public Face(int[] nArray) {
            this.vi = nArray;
        }
    }

    class Vertex {
        double x;
        double y;
        double z;

        public Vertex(double d, double d2, double d3) {
            this.x = d;
            this.y = d2;
            this.z = d3;
        }
    }
}

