/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.security.SecureRandom;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class RestrictionDigestVis {
    static final int MIN_DNA_LEN = 5000;
    static final int MAX_DNA_LEN = 100000;
    static final int LOW_FRAGMENT_CNT = 3;
    static final int HIGH_FRAGMENT_CNT = 15;
    String dna;
    String[] enzymesPar;
    String[] restrictionsPar;
    int N;
    boolean circular;
    String[] codes;
    String[] rs;
    int[] nCuts;
    int[] A1;
    int[] B1;
    int[] A2;
    int[] B2;
    int minFragmentCount;
    int maxFragmentCount;
    int minFragmentLength;
    int maxFragmentLength;
    int minRSLength;
    int maxEnzymes;
    int minFragmentDiff;
    int[] rangeLeft;
    int[] rangeRight;
    List<Set<Integer>> enzymeCuts;
    final char NO_CHAR_HERE = '#';
    static final boolean[][] wcs = new boolean[91][91];
    static String exec;
    static Process proc;
    static boolean debug;
    InputStream is;
    OutputStream os;
    BufferedReader br;

    private long ceiling(long A, long B) {
        return (A + B - 1L) / B;
    }

    private int genMaxFragmentLength(SecureRandom rnd, int from, int to) {
        double x = rnd.nextDouble();
        while (x == 0.0 || (int)Math.floor((double)from / x) > to) {
            x = rnd.nextDouble();
        }
        return (int)Math.floor((double)from / x);
    }

    void generate(long seed) {
        try {
            SecureRandom r1 = SecureRandom.getInstance("SHA1PRNG");
            r1.setSeed(seed);
            BufferedReader br = new BufferedReader(new FileReader("enzymes.txt"));
            int NE = Integer.parseInt(br.readLine());
            this.enzymesPar = new String[NE];
            this.codes = new String[NE];
            this.rs = new String[NE];
            this.nCuts = new int[NE];
            this.A1 = new int[NE];
            this.B1 = new int[NE];
            this.A2 = new int[NE];
            this.B2 = new int[NE];
            int i = 0;
            while (i < NE) {
                this.enzymesPar[i] = br.readLine();
                String[] s = this.enzymesPar[i].split(" ");
                this.codes[i] = s[0];
                this.rs[i] = s[1];
                this.A1[i] = Integer.parseInt(s[2]);
                this.B1[i] = Integer.parseInt(s[3]);
                if (s.length == 4) {
                    this.nCuts[i] = 2;
                } else {
                    this.nCuts[i] = 4;
                    this.A2[i] = Integer.parseInt(s[4]);
                    this.B2[i] = Integer.parseInt(s[5]);
                }
                ++i;
            }
            br.close();
            int modelInd = -1;
            modelInd = r1.nextInt(3) == 0 ? 10 : r1.nextInt(10);
            MarkovChain model = new MarkovChain("models/distr" + (modelInd + 1) + ".dat");
            if (debug) {
                System.out.println("Model = " + modelInd);
            }
            this.N = r1.nextInt(95001) + 5000;
            if (debug) {
                System.out.println("DNA length = " + this.N);
            }
            StringBuilder dnaSB = new StringBuilder();
            String prev = "";
            i = 0;
            while (i < this.N) {
                char next = model.genNext(prev, r1);
                dnaSB.append(next);
                prev = String.valueOf(prev) + next;
                if (prev.length() == 4) {
                    prev = prev.substring(1);
                }
                ++i;
            }
            this.dna = dnaSB.toString();
            this.circular = r1.nextBoolean();
            if (debug) {
                System.out.println(this.circular ? "Circular" : "Linear");
            }
            this.minFragmentCount = -1;
            this.maxFragmentCount = -1;
            do {
                this.minFragmentCount = r1.nextInt(13) + 3;
                this.maxFragmentCount = r1.nextInt(13) + 3;
            } while (this.maxFragmentCount < this.minFragmentCount);
            this.minFragmentLength = -1;
            this.maxFragmentLength = -1;
            this.minFragmentDiff = -1;
            int lowBnd = this.N / this.minFragmentCount;
            int highBnd = (int)this.ceiling(this.N, this.maxFragmentCount);
            while (true) {
                this.minFragmentLength = r1.nextInt(lowBnd) + 1;
                this.maxFragmentLength = this.genMaxFragmentLength(r1, highBnd, this.N);
                if (this.minFragmentLength > this.maxFragmentLength) continue;
                this.minFragmentDiff = r1.nextInt(10001);
                while (this.minFragmentDiff == 10000) {
                    this.minFragmentDiff = r1.nextInt(10001);
                }
                long sum = 0L;
                long cur = this.minFragmentLength;
                boolean ok = true;
                i = 0;
                while (i < this.minFragmentCount) {
                    if (cur > (long)this.maxFragmentLength) {
                        ok = false;
                        break;
                    }
                    sum += cur;
                    cur = this.ceiling(10000L * cur, 10000 - this.minFragmentDiff);
                    ++i;
                }
                if (!ok || sum > (long)this.N) continue;
                sum = 0L;
                cur = this.maxFragmentLength;
                ok = true;
                i = 0;
                while (i < this.maxFragmentCount) {
                    if (cur < (long)this.minFragmentLength) {
                        if (i >= this.minFragmentCount) break;
                        ok = false;
                        break;
                    }
                    sum += cur;
                    cur = cur * (long)(10000 - this.minFragmentDiff) / 10000L;
                    ++i;
                }
                if (ok && sum >= (long)this.N) break;
            }
            int minRS = 20;
            int maxRS = 0;
            i = 0;
            while (i < this.rs.length) {
                minRS = Math.min(minRS, this.rs[i].length());
                maxRS = Math.max(maxRS, this.rs[i].length());
                ++i;
            }
            this.minRSLength = r1.nextInt((maxRS + minRS) / 2 - minRS + 1) + minRS;
            this.maxEnzymes = r1.nextInt((this.maxFragmentCount + 1) / 2 + 1) + this.maxFragmentCount / 2;
            if (r1.nextBoolean()) {
                this.rangeLeft = new int[0];
                this.rangeRight = new int[0];
            } else {
                int nr = r1.nextInt(3) + 1;
                this.rangeLeft = new int[nr];
                this.rangeRight = new int[nr];
                i = 0;
                while (i < nr) {
                    if (!this.circular) {
                        this.rangeRight[i] = r1.nextInt(this.N - 1);
                        this.rangeLeft[i] = r1.nextInt(this.rangeRight[i] + 1);
                    } else {
                        this.rangeLeft[i] = r1.nextInt(this.N);
                        this.rangeRight[i] = r1.nextInt(this.N);
                    }
                    ++i;
                }
            }
            this.restrictionsPar = new String[8];
            this.restrictionsPar[0] = "" + this.minFragmentCount;
            this.restrictionsPar[1] = "" + this.maxFragmentCount;
            this.restrictionsPar[2] = "" + this.minFragmentLength;
            this.restrictionsPar[3] = "" + this.maxFragmentLength;
            DecimalFormatSymbols dfs = new DecimalFormatSymbols();
            dfs.setDecimalSeparator('.');
            this.restrictionsPar[4] = new DecimalFormat("0.000", dfs).format((double)this.minFragmentDiff / 1000.0);
            this.restrictionsPar[5] = "" + this.minRSLength;
            this.restrictionsPar[6] = "" + this.maxEnzymes;
            if (this.rangeLeft.length == 0) {
                this.restrictionsPar[7] = "none";
            } else {
                this.restrictionsPar[7] = String.valueOf(this.rangeLeft[0]) + " " + this.rangeRight[0];
                i = 1;
                while (i < this.rangeLeft.length) {
                    this.restrictionsPar[7] = String.valueOf(this.restrictionsPar[7]) + "," + this.rangeLeft[i] + " " + this.rangeRight[i];
                    ++i;
                }
            }
            if (debug) {
                System.out.println("Restrictions:");
                i = 0;
                while (i < 8) {
                    System.out.println(this.restrictionsPar[i]);
                    ++i;
                }
            }
        }
        catch (Exception e) {
            System.err.println("An exception occurred while generating test case.");
            e.printStackTrace();
        }
    }

    void initializeWcMap() {
        RestrictionDigestVis.wcs[65][65] = true;
        RestrictionDigestVis.wcs[67][67] = true;
        RestrictionDigestVis.wcs[71][71] = true;
        RestrictionDigestVis.wcs[84][84] = true;
        RestrictionDigestVis.wcs[77][65] = true;
        RestrictionDigestVis.wcs[77][67] = true;
        RestrictionDigestVis.wcs[82][65] = true;
        RestrictionDigestVis.wcs[82][71] = true;
        RestrictionDigestVis.wcs[87][65] = true;
        RestrictionDigestVis.wcs[87][84] = true;
        RestrictionDigestVis.wcs[83][67] = true;
        RestrictionDigestVis.wcs[83][71] = true;
        RestrictionDigestVis.wcs[89][67] = true;
        RestrictionDigestVis.wcs[89][84] = true;
        RestrictionDigestVis.wcs[75][71] = true;
        RestrictionDigestVis.wcs[75][84] = true;
        RestrictionDigestVis.wcs[86][65] = true;
        RestrictionDigestVis.wcs[86][67] = true;
        RestrictionDigestVis.wcs[86][71] = true;
        RestrictionDigestVis.wcs[72][65] = true;
        RestrictionDigestVis.wcs[72][67] = true;
        RestrictionDigestVis.wcs[72][84] = true;
        RestrictionDigestVis.wcs[68][65] = true;
        RestrictionDigestVis.wcs[68][71] = true;
        RestrictionDigestVis.wcs[68][84] = true;
        RestrictionDigestVis.wcs[66][67] = true;
        RestrictionDigestVis.wcs[66][71] = true;
        RestrictionDigestVis.wcs[66][84] = true;
        RestrictionDigestVis.wcs[88][71] = true;
        RestrictionDigestVis.wcs[88][65] = true;
        RestrictionDigestVis.wcs[88][84] = true;
        RestrictionDigestVis.wcs[88][67] = true;
        RestrictionDigestVis.wcs[78][71] = true;
        RestrictionDigestVis.wcs[78][65] = true;
        RestrictionDigestVis.wcs[78][84] = true;
        RestrictionDigestVis.wcs[78][67] = true;
    }

    int modulo(int value) {
        while (value >= this.N) {
            value -= this.N;
        }
        while (value < 0) {
            value += this.N;
        }
        return value;
    }

    boolean matches(char fromDna, char fromEnz) {
        return wcs[fromEnz][fromDna];
    }

    char getCharAtDNA(int pos) {
        if (!(pos >= 0 && pos < this.N || this.circular)) {
            return '#';
        }
        return this.dna.charAt(this.modulo(pos));
    }

    boolean validCuts(int enzymeInd, int stPos, int multi) {
        if (this.getCharAtDNA(stPos + multi * (this.A1[enzymeInd] - 1)) == '#' || this.getCharAtDNA(stPos + multi * this.A1[enzymeInd]) == '#' || this.getCharAtDNA(stPos + multi * (this.B1[enzymeInd] - 1)) == '#' || this.getCharAtDNA(stPos + multi * this.B1[enzymeInd]) == '#') {
            return false;
        }
        if (this.nCuts[enzymeInd] == 2) {
            return true;
        }
        return this.getCharAtDNA(stPos + multi * (this.A2[enzymeInd] - 1)) != '#' && this.getCharAtDNA(stPos + multi * this.A2[enzymeInd]) != '#' && this.getCharAtDNA(stPos + multi * (this.B2[enzymeInd] - 1)) != '#' && this.getCharAtDNA(stPos + multi * this.B2[enzymeInd]) != '#';
    }

    boolean validForwardCuts(int enz, int stPos) {
        return this.validCuts(enz, stPos, 1);
    }

    boolean validBackwardCuts(int enz, int stPos) {
        return this.validCuts(enz, stPos, -1);
    }

    char complementary(char c) {
        if (c == 'A') {
            return 'T';
        }
        if (c == 'T') {
            return 'A';
        }
        if (c == 'C') {
            return 'G';
        }
        if (c == 'G') {
            return 'C';
        }
        return c;
    }

    public Set<Integer> getCutSet(int enzymeInd) {
        int i;
        boolean ok;
        HashSet<Integer> cuts = new HashSet<Integer>();
        int M = this.rs[enzymeInd].length();
        if (M < this.minRSLength) {
            return cuts;
        }
        int st = 0;
        while (st < this.N) {
            ok = true;
            i = 0;
            while (i < M) {
                if (!this.matches(this.getCharAtDNA(st + i), this.rs[enzymeInd].charAt(i))) {
                    ok = false;
                    break;
                }
                ++i;
            }
            if (ok && this.validForwardCuts(enzymeInd, st)) {
                cuts.add(this.modulo(st + this.A1[enzymeInd] - 1));
                if (this.nCuts[enzymeInd] == 4) {
                    cuts.add(this.modulo(st + this.A2[enzymeInd] - 1));
                }
                if (cuts.size() > this.maxFragmentCount + 1) {
                    return cuts;
                }
            }
            ++st;
        }
        st = 0;
        while (st < this.N) {
            ok = true;
            i = 0;
            while (i < M) {
                if (!this.matches(this.complementary(this.getCharAtDNA(st - i)), this.rs[enzymeInd].charAt(i))) {
                    ok = false;
                    break;
                }
                ++i;
            }
            if (ok && this.validBackwardCuts(enzymeInd, st)) {
                cuts.add(this.modulo(st - this.B1[enzymeInd]));
                if (this.nCuts[enzymeInd] == 4) {
                    cuts.add(this.modulo(st - this.B2[enzymeInd]));
                }
                if (cuts.size() > this.maxFragmentCount + 1) {
                    return cuts;
                }
            }
            ++st;
        }
        return cuts;
    }

    boolean validateSet(int[] enzymes) {
        HashMap<Integer, Integer> cutsPosNum = new HashMap<Integer, Integer>();
        int i = 0;
        while (i < enzymes.length) {
            for (int pos : this.enzymeCuts.get(enzymes[i])) {
                if (cutsPosNum.containsKey(pos)) {
                    cutsPosNum.put(pos, (Integer)cutsPosNum.get(pos) + 1);
                    continue;
                }
                cutsPosNum.put(pos, 1);
            }
            if (cutsPosNum.size() > this.maxFragmentCount + 1) {
                this.addFatalError("Restriction 1 violation: set of enzymes produces more than " + this.maxFragmentCount + " fragments.");
                return false;
            }
            ++i;
        }
        int numFragments = cutsPosNum.size() + (this.circular ? 0 : 1);
        if (numFragments > this.maxFragmentCount) {
            this.addFatalError("Restriction 1 violation: set of enzymes produces more than " + this.maxFragmentCount + " fragments.");
            return false;
        }
        if (numFragments < this.minFragmentCount) {
            this.addFatalError("Restriction 0 violation: set of enzymes produces less than " + this.minFragmentCount + " fragments.");
            return false;
        }
        ArrayList cutPos = new ArrayList(cutsPosNum.keySet());
        Collections.sort(cutPos);
        ArrayList<Integer> fragments = new ArrayList<Integer>();
        if (!this.circular) {
            fragments.add((Integer)cutPos.get(0) + 1);
        }
        i = 0;
        while (i + 1 < cutPos.size()) {
            fragments.add((Integer)cutPos.get(i + 1) - (Integer)cutPos.get(i));
            ++i;
        }
        int totalLen = 0;
        Iterator iterator = fragments.iterator();
        while (iterator.hasNext()) {
            int len = (Integer)iterator.next();
            totalLen += len;
        }
        fragments.add(this.N - totalLen);
        Collections.sort(fragments);
        if ((Integer)fragments.get(0) < this.minFragmentLength) {
            this.addFatalError("Restriction 2 violation: length of the shortest fragment less than " + this.minFragmentLength + ".");
            return false;
        }
        if ((Integer)fragments.get(fragments.size() - 1) > this.maxFragmentLength) {
            this.addFatalError("Restriction 3 violation: length of the longest fragment more than " + this.maxFragmentLength + ".");
            return false;
        }
        i = 0;
        while (i < fragments.size() - 1) {
            long lii;
            long li = ((Integer)fragments.get(i + 1)).intValue();
            if (100000L * (li - (lii = (long)((Integer)fragments.get(i)).intValue())) < (long)this.minFragmentDiff * li) {
                this.addFatalError("Restriction 4 violation.");
                return false;
            }
            ++i;
        }
        if (this.rangeLeft.length > 0) {
            i = 0;
            while (i < this.rangeLeft.length) {
                boolean found = false;
                Iterator iterator2 = cutPos.iterator();
                while (iterator2.hasNext()) {
                    int pos = (Integer)iterator2.next();
                    if ((pos < this.rangeLeft[i] || pos > this.rangeRight[i]) && (!this.circular || this.rangeLeft[i] <= this.rangeRight[i] || pos < this.rangeLeft[i] && pos > this.rangeRight[i])) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    this.addFatalError("Restriction 7 violation: range " + this.rangeLeft[i] + "-" + this.rangeRight[i] + " has no cut.");
                    return false;
                }
                ++i;
            }
        }
        i = 0;
        while (i < enzymes.length) {
            boolean need = false;
            for (int pos : this.enzymeCuts.get(enzymes[i])) {
                if ((Integer)cutsPosNum.get(pos) != 1) continue;
                need = true;
                break;
            }
            if (!need) {
                this.addFatalError("The set is reducible: can remove enzyme " + enzymes[i] + ".");
                return false;
            }
            ++i;
        }
        return true;
    }

    /*
     * Exception decompiling
     */
    public double runTest(String seed) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 14[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    String[] findEnzymeCocktail(String dna, String[] enzymes, String[] restrictions) throws IOException {
        if (proc == null) {
            return new String[0];
        }
        StringBuffer sb = new StringBuffer();
        sb.append(String.valueOf(dna) + "\n").append(String.valueOf(enzymes.length) + "\n");
        int i = 0;
        while (i < enzymes.length) {
            sb.append(String.valueOf(enzymes[i]) + "\n");
            ++i;
        }
        i = 0;
        while (i < restrictions.length) {
            sb.append(String.valueOf(restrictions[i]) + "\n");
            ++i;
        }
        this.os.write(sb.toString().getBytes());
        this.os.flush();
        int NR = Integer.parseInt(this.br.readLine());
        String[] ret = new String[NR];
        i = 0;
        while (i < NR) {
            ret[i] = this.br.readLine();
            ++i;
        }
        return ret;
    }

    public RestrictionDigestVis(String seed) {
        block11: {
            this.enzymeCuts = new ArrayList<Set<Integer>>();
            this.NO_CHAR_HERE = (char)35;
            try {
                if (exec != null) {
                    try {
                        Runtime rt = Runtime.getRuntime();
                        proc = rt.exec(exec);
                        this.os = proc.getOutputStream();
                        this.is = proc.getInputStream();
                        this.br = new BufferedReader(new InputStreamReader(this.is));
                        new ErrorReader(proc.getErrorStream()).start();
                        Runtime.getRuntime().addShutdownHook(new Thread(){

                            @Override
                            public void run() {
                                if (proc != null) {
                                    try {
                                        proc.destroy();
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                    }
                                }
                            }
                        });
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else {
                    System.out.println("No solution specified.");
                    return;
                }
                System.out.println("Score = " + this.runTest(seed));
                if (proc != null) {
                    try {
                        proc.destroy();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if (proc == null) break block11;
                try {
                    proc.destroy();
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        }
    }

    public static void main(String[] args) {
        String seed = "1";
        debug = false;
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-seed")) {
                seed = args[++i];
            }
            if (args[i].equals("-exec")) {
                exec = args[++i];
            }
            if (args[i].equals("-debug")) {
                debug = true;
            }
            ++i;
        }
        RestrictionDigestVis f = new RestrictionDigestVis(seed);
    }

    void addFatalError(String message) {
        System.out.println(message);
    }
}

