/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.security.SecureRandom;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class ReliefMapVis {
    int W;
    int H;
    double[][] hs;
    String[] contour;
    int nmes;
    int maxmes;
    boolean ok;
    int[] dx = new int[]{1, 1, 1, 0, 0, -1, -1, -1};
    int[] dy = new int[]{1, 0, -1, 1, -1, 1, 0, -1};
    char[][] cont;
    double[] ret;
    SecureRandom r;
    static String exec;
    static String file;
    static String diff;
    static double diffsc;
    static Process proc;
    InputStream is;
    OutputStream os;

    static int join(int n, int n2, int n3) {
        return n << 16 | n2 << 8 | n3;
    }

    static int color(double d) {
        double d2;
        double d3;
        double d4;
        if (d < 0.16666666666666666) {
            d4 = d * 6.0;
            d3 = 0.0;
            d2 = 0.0;
        } else if (d < 0.3333333333333333) {
            d4 = 1.0;
            d3 = 0.0;
            d2 = (d - 0.16666666666666666) * 6.0;
        } else if (d < 0.5) {
            d4 = 1.0 - (d - 0.3333333333333333) * 6.0;
            d3 = 0.0;
            d2 = 1.0;
        } else if (d < 0.6666666666666666) {
            d4 = 0.0;
            d3 = (d - 0.5) * 6.0;
            d2 = 1.0;
        } else if (d < 0.8333333333333334) {
            d4 = 0.0;
            d3 = 1.0;
            d2 = 1.0 - (d - 0.6666666666666666) * 6.0;
        } else {
            d3 = 1.0;
            d4 = (d - 0.8333333333333334) * 6.0;
            d2 = (d - 0.8333333333333334) * 6.0;
        }
        return ReliefMapVis.join((int)(255.99 * d3), (int)(255.99 * d2), (int)(255.99 * d4));
    }

    void generate(String string) {
        try {
            int n;
            int n2;
            double d;
            int n3;
            int n4;
            int n5;
            this.r = SecureRandom.getInstance("SHA1PRNG");
            this.r.setSeed(Long.parseLong(string));
            this.H = this.r.nextInt(451) + 50;
            this.W = this.r.nextInt(451) + 50;
            System.out.println("W = " + this.W + "\nH = " + this.H);
            this.hs = new double[this.H][this.W];
            int n6 = this.r.nextInt(11) + 15;
            int[] nArray = new int[n6];
            int[] nArray2 = new int[n6];
            int[] nArray3 = new int[n6];
            int[] nArray4 = new int[n6];
            double[] dArray = new double[n6];
            for (n5 = 0; n5 < n6; ++n5) {
                nArray[n5] = this.r.nextInt(this.W);
                nArray2[n5] = this.r.nextInt(this.H);
                nArray3[n5] = this.r.nextInt(100);
                nArray4[n5] = this.r.nextInt(100) + 100;
                dArray[n5] = this.r.nextDouble() * 0.5 + 0.3;
            }
            for (n4 = 0; n4 < this.H; ++n4) {
                for (n3 = 0; n3 < this.W; ++n3) {
                    double d2 = 0.0;
                    d = 0.0;
                    for (n5 = 0; n5 < n6; ++n5) {
                        double d3 = Math.sqrt(Math.pow(n4 - nArray2[n5], 2.0) + Math.pow(n3 - nArray[n5], 2.0));
                        d3 = Math.pow(d3 + (double)nArray4[n5], -dArray[n5]);
                        d2 += d3 * (double)nArray3[n5];
                        d += d3;
                    }
                    this.hs[n4][n3] = d2 / d;
                }
            }
            double d4 = this.hs[0][0];
            double d5 = this.hs[0][0];
            for (n4 = 0; n4 < this.H; ++n4) {
                for (n3 = 0; n3 < this.W; ++n3) {
                    d4 = Math.min(d4, this.hs[n4][n3]);
                    d5 = Math.max(d5, this.hs[n4][n3]);
                }
            }
            for (n4 = 0; n4 < this.H; ++n4) {
                for (n3 = 0; n3 < this.W; ++n3) {
                    this.hs[n4][n3] = (this.hs[n4][n3] - d4) / (d5 - d4) * 100.0;
                }
            }
            this.cont = new char[this.H][this.W];
            for (n4 = 0; n4 < this.H; ++n4) {
                for (n3 = 0; n3 < this.W; ++n3) {
                    this.cont[n4][n3] = 48;
                }
            }
            double d6 = this.r.nextDouble() * 8.0 + 2.0;
            System.out.println("D = " + d6);
            for (d = 0.0; d < 100.0; d += d6) {
                for (n3 = 0; n3 < this.H; ++n3) {
                    for (n5 = 0; n5 < this.W; ++n5) {
                        if (!(this.hs[n3][n5] < d)) continue;
                        for (int i = 0; i < 8; ++i) {
                            n2 = n3 + this.dx[i];
                            n = n5 + this.dy[i];
                            if (n2 < 0 || n2 >= this.H || n < 0 || n >= this.W || !(this.hs[n2][n] > d)) continue;
                            this.cont[n2][n] = 49;
                        }
                    }
                }
            }
            for (n4 = 1; n4 < this.H - 1; ++n4) {
                for (n3 = 1; n3 < this.W - 1; ++n3) {
                    n2 = 1;
                    n = 1;
                    for (n5 = 0; n5 < 8; ++n5) {
                        if (this.hs[n4][n3] <= this.hs[n4 + this.dx[n5]][n3 + this.dy[n5]]) {
                            n = 0;
                        }
                        if (!(this.hs[n4][n3] >= this.hs[n4 + this.dx[n5]][n3 + this.dy[n5]])) continue;
                        n2 = 0;
                    }
                    if (n2 == 0 && n == 0) continue;
                    this.cont[n4][n3] = 49;
                    this.cont[n4 - 1][n3] = 49;
                    this.cont[n4 + 1][n3] = 49;
                    this.cont[n4][n3 - 1] = 49;
                    this.cont[n4][n3 + 1] = 49;
                }
            }
            this.contour = new String[this.H];
            for (n4 = 0; n4 < this.H; ++n4) {
                this.contour[n4] = new String(this.cont[n4]);
            }
        }
        catch (Exception exception) {
            System.err.println("An exception occured while generating the test case.");
            exception.printStackTrace();
        }
    }

    public double measure(int n, int n2) {
        if (n < 0 || n >= this.W) {
            this.addFatalError("Invalid x-coordinate of the measurement " + n + ".");
            this.ok = false;
            return -1.0;
        }
        if (n2 < 0 || n2 >= this.H) {
            this.addFatalError("Invalid y-coordinate of the measurement " + n2 + ".");
            this.ok = false;
            return -1.0;
        }
        if (this.nmes == this.maxmes) {
            this.addFatalError("Number of measurements exceeded the maximal number of measurements avaliable.");
            this.ok = false;
            return -1.0;
        }
        ++this.nmes;
        return Math.max(Math.min(this.hs[n2][n] + this.r.nextGaussian(), 100.0), 0.0);
    }

    public double runTest(String string) {
        try {
            this.generate(string);
            this.nmes = 0;
            this.maxmes = (int)Math.sqrt(this.H * this.W);
            this.ok = true;
            this.ret = this.getMap(this.contour);
            if (!this.ok) {
                return 0.0;
            }
            double d = 0.0;
            for (int i = 0; i < this.H; ++i) {
                for (int j = 0; j < this.W; ++j) {
                    d += Math.pow(this.hs[i][j] - this.ret[i * this.W + j], 2.0);
                }
            }
            System.out.println("Average squared error = " + (d /= (double)(this.W * this.H)));
            System.out.println("Number of measurements = " + this.nmes + " of " + this.maxmes + " possible");
            return 1.0 / (d * Math.pow(100.0, (double)this.nmes * 1.0 / (double)this.maxmes));
        }
        catch (Exception exception) {
            System.err.println("An exception occurred while trying to get your program's results.");
            exception.printStackTrace();
            return 0.0;
        }
    }

    public double[] getMap(String[] stringArray) throws IOException {
        String string;
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(stringArray.length).append('\n');
        for (n = 0; n < stringArray.length; ++n) {
            stringBuffer.append(stringArray[n]).append('\n');
        }
        this.os.write(stringBuffer.toString().getBytes());
        this.os.flush();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.is));
        while ((string = bufferedReader.readLine()).equals("?")) {
            int n2 = Integer.parseInt(bufferedReader.readLine());
            int n3 = Integer.parseInt(bufferedReader.readLine());
            double d = this.measure(n2, n3);
            if (!this.ok) {
                return new double[0];
            }
            this.os.write((d + "\n").getBytes());
            this.os.flush();
        }
        double[] dArray = new double[this.H * this.W];
        for (n = 0; n < this.W * this.H; ++n) {
            dArray[n] = Double.parseDouble(bufferedReader.readLine());
        }
        return dArray;
    }

    BufferedImage drawMap(double[][] dArray, int n) {
        int n2;
        int n3;
        BufferedImage bufferedImage = new BufferedImage(this.W, this.H, 1);
        double d = dArray[0][0];
        double d2 = dArray[0][0];
        if (n == 0) {
            for (n3 = 0; n3 < this.H; ++n3) {
                for (n2 = 0; n2 < this.W; ++n2) {
                    d = Math.min(d, dArray[n3][n2]);
                    d2 = Math.max(d2, dArray[n3][n2]);
                }
            }
        }
        for (n3 = 0; n3 < this.H; ++n3) {
            for (n2 = 0; n2 < this.W; ++n2) {
                int n4 = n == 0 ? (this.contour[n3].charAt(n2) == '1' ? 0 : ReliefMapVis.color((dArray[n3][n2] - d) / (d2 - d))) : (dArray[n3][n2] >= 0.0 ? (int)(255.99 * Math.min(dArray[n3][n2] / diffsc, 1.0)) * 65536 : (int)(255.99 * Math.min(-dArray[n3][n2] / diffsc, 1.0)) * 1);
                bufferedImage.setRGB(n2, n3, n4);
            }
        }
        return bufferedImage;
    }

    public ReliefMapVis(String string) throws IOException {
        Object object;
        if (exec != null) {
            try {
                Runtime runtime = Runtime.getRuntime();
                proc = runtime.exec(exec);
                this.os = proc.getOutputStream();
                this.is = proc.getInputStream();
                new ErrorReader(proc.getErrorStream()).start();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        System.out.println("Score = " + this.runTest(string));
        int n = 0;
        if (file != null) {
            object = this.drawMap(this.hs, 0);
            if (file.equals("-")) {
                JFrame jFrame = new JFrame();
                jFrame.setSize(this.W + 8, this.H + 30);
                n = this.H + 30;
                jFrame.getContentPane().add(new JPanel((BufferedImage)object){
                    final /* synthetic */ BufferedImage val$bi;
                    {
                        this.val$bi = bufferedImage;
                    }

                    public void paint(Graphics graphics) {
                        graphics.drawImage(this.val$bi, 0, 0, null);
                    }
                });
                jFrame.setDefaultCloseOperation(3);
                jFrame.setVisible(true);
            } else {
                ImageIO.write((RenderedImage)object, "png", new File(file + ".png"));
            }
        }
        if (diff != null) {
            object = new double[this.H][this.W];
            for (int i = 0; i < this.H; ++i) {
                for (int j = 0; j < this.W; ++j) {
                    object[i][j] = this.ret[i * this.W + j] - this.hs[i][j];
                }
            }
            final BufferedImage bufferedImage = this.drawMap((double[][])object, 1);
            if (diff.equals("-")) {
                JFrame jFrame = new JFrame();
                jFrame.setLocation(0, n);
                jFrame.setSize(this.W + 8, this.H + 30);
                jFrame.getContentPane().add(new JPanel(){

                    public void paint(Graphics graphics) {
                        graphics.drawImage(bufferedImage, 0, 0, null);
                    }
                });
                jFrame.setDefaultCloseOperation(3);
                jFrame.setVisible(true);
            } else {
                ImageIO.write((RenderedImage)bufferedImage, "png", new File(diff + ".png"));
            }
        }
    }

    public static void main(String[] stringArray) throws IOException {
        String string = "1";
        diffsc = 10.0;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-seed")) {
                string = stringArray[++i];
            }
            if (stringArray[i].equals("-exec")) {
                exec = stringArray[++i];
            }
            if (stringArray[i].equals("-vis")) {
                file = stringArray[++i];
            }
            if (stringArray[i].equals("-diff")) {
                diff = stringArray[++i];
            }
            if (!stringArray[i].equals("-diffscale")) continue;
            diffsc = Double.parseDouble(stringArray[++i]);
        }
        ReliefMapVis reliefMapVis = new ReliefMapVis(string);
    }

    void addFatalError(String string) {
        System.out.println(string);
    }
}

