/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class QuakeTester {
    public static String execCommand = null;
    public static boolean debug = true;
    public static boolean training = false;
    public static String dataFolder = "data";
    public static int seed = 0;
    public static Process solution;

    public void printMessage(String string) {
        if (debug) {
            System.out.println(string);
        }
    }

    public double doExec() throws Exception {
        try {
            solution = null;
            try {
                solution = Runtime.getRuntime().exec(execCommand);
            }
            catch (Exception exception) {
                System.err.println("ERROR: Unable to execute your solution using the provided command: " + execCommand + ".");
                return -1.0;
            }
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(solution.getInputStream()));
            PrintWriter printWriter = new PrintWriter(solution.getOutputStream(), true);
            new ErrorStreamRedirector(solution.getErrorStream()).start();
            DataSet dataSet = new DataSet(dataFolder);
            printWriter.println(dataSet.sampleRate);
            printWriter.flush();
            int n = Integer.parseInt(bufferedReader.readLine());
            if (training) {
                printWriter.println(1);
                printWriter.println(dataSet.gtfEQHour);
                printWriter.println(dataSet.gtfIsQuake);
                printWriter.flush();
            } else {
                printWriter.println(0);
            }
            double d = 0.0;
            int n2 = 0;
            for (int i = 0; i < dataSet.gtfEQHour; ++i) {
                int n3;
                int n4;
                int[] nArray = null;
                try {
                    int[] nArray2 = dataSet.loadHour(dataFolder + seed + "/", i);
                    nArray = new int[10800 * dataSet.sampleRate];
                    for (int j = 0; j < 3; ++j) {
                        for (n4 = 0; n4 < 3600; ++n4) {
                            nArray[j * (dataSet.sampleRate * 3600) + n4] = nArray2[dataSet.gtfSite * (dataSet.sampleRate * 3600 * 3) + j * (dataSet.sampleRate * 3600) + n4];
                        }
                    }
                }
                catch (Exception exception) {
                    System.err.println("WARNING: Missing data for hour " + i);
                    continue;
                }
                printWriter.println(i);
                printWriter.println(nArray.length);
                for (n3 = 0; n3 < nArray.length; ++n3) {
                    printWriter.println(nArray[n3]);
                }
                printWriter.println(dataSet.EMA[i]);
                n3 = Integer.parseInt(bufferedReader.readLine());
                if (n3 != 2160) {
                    System.err.println("ERROR: The number of elements in your return is incorrect. You returned " + n3 + " it should be " + 2160);
                    return -1.0;
                }
                double[] dArray = new double[n3];
                for (n4 = 0; n4 < n3; ++n4) {
                    dArray[n4] = Double.parseDouble(bufferedReader.readLine());
                }
                if (i < 768) continue;
                double d2 = 2160.0;
                double d3 = 9.0;
                double d4 = 0.0;
                for (int j = 0; j < n3; ++j) {
                    d4 += dArray[j] * dArray[j];
                }
                double d5 = 0.0;
                if (dataSet.gtfIsQuake == 1) {
                    d5 = 2.0 * dArray[dataSet.gtfEQHour - i - 1] - 1.0 / (d3 * d2) * d4 - 1.0;
                } else {
                    double d6 = 1.0;
                    d5 = -(1.0 / (d3 * d2)) * d4 * d6;
                }
                ++n2;
                this.printMessage(d5 + " " + (d += d5));
            }
            printWriter.println(-1);
            printWriter.flush();
            return d;
        }
        catch (Exception exception) {
            System.out.println("FAILURE: " + exception.getMessage());
            exception.printStackTrace();
            return -1.0;
        }
    }

    public static void main(String[] stringArray) throws Exception {
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-folder")) {
                dataFolder = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-exec")) {
                execCommand = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-seed")) {
                seed = Integer.parseInt(stringArray[++i]);
                continue;
            }
            if (stringArray[i].equals("-train")) {
                training = true;
                continue;
            }
            if (stringArray[i].equals("-silent")) {
                debug = false;
                continue;
            }
            System.out.println("WARNING: unknown argument " + stringArray[i] + ".");
        }
        if (execCommand == null) {
            System.err.println("ERROR: You did not provide the command to execute your solution. Please use -exec <command> for this.");
            System.exit(1);
        }
        try {
            if (dataFolder != null) {
                double d = new QuakeTester().doExec();
                System.out.println("Score = " + d);
            } else {
                System.out.println("WARNING: nothing to do for this combination of arguments.");
            }
        }
        catch (Exception exception) {
            System.out.println("FAILURE: " + exception.getMessage());
            exception.printStackTrace();
        }
    }

    class ErrorStreamRedirector
    extends Thread {
        public BufferedReader reader;

        public ErrorStreamRedirector(InputStream inputStream) {
            this.reader = new BufferedReader(new InputStreamReader(inputStream));
        }

        @Override
        public void run() {
            while (true) {
                String string;
                try {
                    string = this.reader.readLine();
                }
                catch (Exception exception) {
                    return;
                }
                if (string == null) break;
                System.out.println(string);
            }
        }
    }

    public class DataSet {
        Coordinate[] sites;
        Quake[] quakes;
        int sampleRate;
        int numOfSites;
        int numOfEMA;
        int numOfQuakes;
        int[] rawData = null;
        byte[] result = null;
        double[] EMA = null;
        String gtfStartTime;
        String gtfEQtime;
        double gtfMagnitude;
        double gtfLatitude;
        double gtfLongitude;
        double gtfDistToEQ;
        double gtfEQSec;
        int gtfEQHour;
        int gtfSite;
        int gtfIsQuake;
        DocumentBuilderFactory docBuilderFactory = null;
        DocumentBuilder docBuilder = null;

        public void loadSiteInfo(String string) throws Exception {
            Document document = this.docBuilder.parse(new File(string));
            document.getDocumentElement().normalize();
            NodeList nodeList = document.getElementsByTagName("Site");
            this.numOfSites = nodeList.getLength();
            QuakeTester.this.printMessage("Total number of sites: " + this.numOfSites);
            this.sites = new Coordinate[this.numOfSites];
            for (int i = 0; i < this.numOfSites; ++i) {
                Element element = (Element)nodeList.item(i);
                if (i == 0) {
                    this.sampleRate = Integer.parseInt(element.getAttribute("sample_rate"));
                    QuakeTester.this.printMessage("Sample Rate = " + this.sampleRate);
                }
                double d = Double.parseDouble(element.getAttribute("latitude"));
                double d2 = Double.parseDouble(element.getAttribute("longitude"));
                this.sites[i] = new Coordinate(d, d2);
                QuakeTester.this.printMessage("site " + i + ": " + d + "," + d2);
            }
            this.rawData = new int[this.numOfSites * 3 * 3600 * this.sampleRate];
            this.result = new byte[3600 * this.sampleRate * 4];
        }

        public void loadEarthMagneticActivity(String string) throws Exception {
            Document document = this.docBuilder.parse(new File(string));
            document.getDocumentElement().normalize();
            NodeList nodeList = document.getElementsByTagName("kp_hr");
            this.numOfEMA = nodeList.getLength();
            QuakeTester.this.printMessage("Total number of EM activities: " + this.numOfEMA);
            this.EMA = new double[this.numOfEMA];
            for (int i = 0; i < this.numOfEMA; ++i) {
                this.EMA[i] = Double.parseDouble(nodeList.item(i).getFirstChild().getNodeValue());
            }
        }

        public DataSet(String string) throws Exception {
            BufferedReader bufferedReader = null;
            if (seed < 1000) {
                bufferedReader = new BufferedReader(new FileReader("trainlist.csv"));
            } else if (seed < 2000) {
                bufferedReader = new BufferedReader(new FileReader("provlist.csv"));
                seed -= 1000;
            } else {
                bufferedReader = new BufferedReader(new FileReader("systemlist.csv"));
                seed -= 2000;
            }
            int n = 0;
            String string2 = "";
            try {
                String string3;
                do {
                    string3 = bufferedReader.readLine();
                } while (++n != seed);
                String[] stringArray = string3.split(",");
                seed = Integer.parseInt(stringArray[0]);
                string2 = string + seed + "/";
                this.gtfSite = Integer.parseInt(stringArray[1]);
                this.gtfEQHour = Integer.parseInt(stringArray[2]);
                this.gtfIsQuake = Integer.parseInt(stringArray[3]);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            bufferedReader.close();
            this.docBuilderFactory = DocumentBuilderFactory.newInstance();
            this.docBuilder = this.docBuilderFactory.newDocumentBuilder();
            this.loadSiteInfo(string2 + "SiteInfo.xml");
            this.loadEarthMagneticActivity(string2 + "Kp.xml");
        }

        public int[] loadHour(String string, int n) throws Exception {
            String string2 = string + "test" + seed + "_" + n + ".bin";
            QuakeTester.this.printMessage("loading " + string2);
            int[] nArray = new int[this.numOfSites * 3 * 3600 * this.sampleRate];
            File file = new File(string2);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            DataInputStream dataInputStream = new DataInputStream(bufferedInputStream);
            int n2 = -1;
            for (int i = 0; i < nArray.length; ++i) {
                int n3;
                int n4;
                int n5;
                int n6 = dataInputStream.readByte();
                if (n6 < 0) {
                    n6 += 256;
                }
                if ((n6 & 3) == 1) {
                    n5 = (n6 >> 2) - 32;
                    nArray[i] = n2 + n5;
                } else if ((n6 & 3) == 2) {
                    n4 = dataInputStream.readByte();
                    if (n4 < 0) {
                        n4 += 256;
                    }
                    n5 = (n6 + (n4 << 8) >> 2) - 8192;
                    nArray[i] = n2 + n5;
                } else if ((n6 & 3) == 3) {
                    n4 = dataInputStream.readByte();
                    if (n4 < 0) {
                        n4 += 256;
                    }
                    if ((n3 = dataInputStream.readByte()) < 0) {
                        n3 += 256;
                    }
                    n5 = (n6 + (n4 << 8) + (n3 << 16) >> 2) - 0x200000;
                    nArray[i] = n2 + n5;
                } else {
                    int n7;
                    n4 = dataInputStream.readByte();
                    if (n4 < 0) {
                        n4 += 256;
                    }
                    if ((n3 = dataInputStream.readByte()) < 0) {
                        n3 += 256;
                    }
                    if ((n7 = dataInputStream.readByte()) < 0) {
                        n7 += 256;
                    }
                    nArray[i] = (n6 + (n4 << 8) + (n3 << 16) + (n7 << 24) >> 2) - 1;
                }
                n2 = nArray[i];
            }
            ((InputStream)bufferedInputStream).close();
            return nArray;
        }
    }

    public class Quake {
        int timeSecs;
        double depth;
        double magnitude;
        Coordinate coord;

        public Quake(int n, Coordinate coordinate, double d, double d2) {
            this.coord = coordinate;
            this.depth = d;
            this.magnitude = d2;
            this.timeSecs = n;
        }
    }

    public class Coordinate {
        double latitude;
        double longitude;

        public Coordinate(double d, double d2) {
            this.latitude = d;
            this.longitude = d2;
        }
    }
}

