/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Random;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessorScheduling {
    int[][] g;
    int[] jobs;
    int[] p;
    int[] m;
    int transfer;
    double prob;
    double pow;
    boolean fast = false;
    BufferedReader in;
    OutputStream out;

    void generate(long l) {
        SecureRandom secureRandom = null;
        try {
            secureRandom = SecureRandom.getInstance("SHA1PRNG");
            ((Random)secureRandom).setSeed(l);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.prob = secureRandom.nextDouble() / 20.0;
        this.pow = secureRandom.nextDouble() * 2.0;
        this.transfer = secureRandom.nextInt(1000) + 1;
        this.m = new int[secureRandom.nextInt(91) + 10];
        this.jobs = new int[secureRandom.nextInt(499991) + 10];
        if (this.fast) {
            return;
        }
        this.g = new int[this.jobs.length][];
        this.p = new int[this.jobs.length];
        for (int i = 0; i < this.m.length; ++i) {
            this.m[i] = secureRandom.nextInt(9001) + 1000;
        }
        boolean[] blArray = new boolean[this.jobs.length];
        Random random = new Random(secureRandom.nextLong());
        for (int i = 0; i < this.jobs.length; ++i) {
            int n;
            do {
                this.jobs[i] = (int)(1000.0 / Math.pow(secureRandom.nextDouble(), 1.0 / this.pow));
            } while (this.jobs[i] > 1000000000);
            this.p[i] = secureRandom.nextInt(10000) + 1;
            int n2 = 0;
            for (n = Math.max(0, i - 1000); n < i; ++n) {
                blArray[n] = random.nextDouble() < this.prob;
                n2 += blArray[n] ? 1 : 0;
            }
            this.g[i] = new int[n2];
            n2 = 0;
            for (n = Math.max(0, i - 1000); n < i; ++n) {
                if (!blArray[n]) continue;
                this.g[i][n2++] = n;
            }
        }
    }

    boolean overlap(ArrayList<long[]>[] arrayListArray) {
        for (int i = 0; i < arrayListArray.length; ++i) {
            Collections.sort(arrayListArray[i], new Comparator<long[]>(){

                @Override
                public int compare(long[] lArray, long[] lArray2) {
                    long l = lArray[0] - lArray2[0];
                    if (l > 0L) {
                        return 1;
                    }
                    if (l < 0L) {
                        return -1;
                    }
                    return 0;
                }
            });
            int n = 0;
            while (n + 1 < arrayListArray[i].size()) {
                long[] lArray = arrayListArray[i].get(n);
                long[] lArray2 = arrayListArray[i].get(n + 1);
                if (lArray2[0] < lArray[1]) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    public double score(String[] stringArray) {
        try {
            int n;
            long[] lArray;
            Object object;
            int n2;
            ArrayList[] arrayListArray = new ArrayList[this.m.length];
            for (n2 = 0; n2 < this.m.length; ++n2) {
                arrayListArray[n2] = new ArrayList();
            }
            try {
                for (n2 = 0; n2 < stringArray.length; ++n2) {
                    object = new StringTokenizer(stringArray[n2]);
                    lArray = new long[]{Long.parseLong(((StringTokenizer)object).nextToken()), Long.parseLong(((StringTokenizer)object).nextToken()), Long.parseLong(((StringTokenizer)object).nextToken())};
                    int n3 = Integer.parseInt(((StringTokenizer)object).nextToken());
                    if (lArray[0] < 0L) {
                        this.addFatalError("You can't start a job before time 0");
                        return 0.0;
                    }
                    if (lArray[1] <= lArray[0]) {
                        this.addFatalError("The end time must be greater than the start time");
                        return 0.0;
                    }
                    if ((double)lArray[1] > 1.0E10) {
                        this.addFatalError("No job may run beyond time 1E10");
                        return 0.0;
                    }
                    if (lArray[2] < 0L || lArray[2] >= (long)this.jobs.length) {
                        this.addFatalError("Invalid job index");
                        return 0.0;
                    }
                    if (n3 < 0 || n3 >= this.m.length) {
                        this.addFatalError("Invalid machine index");
                        return 0.0;
                    }
                    arrayListArray[n3].add(lArray);
                }
            }
            catch (Exception exception) {
                this.addFatalError("Your return was not formatted properly.");
                exception.printStackTrace();
                return 0.0;
            }
            if (this.overlap(arrayListArray)) {
                this.addFatalError("You have overlapping RUN intervals.");
                return 0.0;
            }
            object = new int[this.jobs.length];
            lArray = new long[this.jobs.length];
            long[] lArray2 = new long[this.jobs.length];
            long[] lArray3 = new long[this.jobs.length];
            Arrays.fill((int[])object, -1);
            long l = 0L;
            for (n2 = 0; n2 < arrayListArray.length; ++n2) {
                for (n = 0; n < arrayListArray[n2].size(); ++n) {
                    long[] lArray4 = (long[])arrayListArray[n2].get(n);
                    int n4 = (int)lArray4[2];
                    int n5 = -1;
                    long l2 = lArray4[1] - lArray4[0];
                    if (object[n4] == -1) {
                        lArray2[n4] = lArray4[0];
                        object[n4] = n2;
                    } else {
                        if (object[n4] != n2) {
                            this.addFatalError("You can't run a job on more than one machine.");
                            return 0.0;
                        }
                        l2 -= (long)this.p[n4];
                    }
                    if ((lArray[n4] + l2) * (long)this.m[n2] < (long)this.jobs[n4]) {
                        l2 -= (long)this.p[n4];
                    } else {
                        lArray3[n4] = lArray4[1];
                    }
                    if (l2 < 0L) {
                        l2 = 0L;
                    }
                    int n6 = n4;
                    lArray[n6] = lArray[n6] + l2;
                }
            }
            for (n2 = 0; n2 < lArray.length; ++n2) {
                n = 0;
                l = Math.max(l, lArray3[n2]);
                if (lArray3[n2] != 0L) continue;
                this.addFatalError("You didn't finish all jobs.");
                return 0.0;
            }
            for (n2 = 0; n2 < this.jobs.length; ++n2) {
                for (n = 0; n < this.g[n2].length && this.g[n2][n] != -1; ++n) {
                    int n7 = this.g[n2][n];
                    if (lArray2[n2] >= lArray3[n7] + (long)(object[n2] == object[n7] ? 0 : this.transfer)) continue;
                    this.addFatalError("You didn't finish all the requirements for job " + n2 + " before you started it.");
                    return 0.0;
                }
            }
            return l;
        }
        catch (Exception exception) {
            this.addFatalError(exception.toString());
            StackTraceElement[] stackTraceElementArray = exception.getStackTrace();
            for (int i = 0; i < stackTraceElementArray.length; ++i) {
                this.addFatalError(stackTraceElementArray[i].toString());
            }
            return 0.0;
        }
    }

    public ProcessorScheduling(String[] stringArray) {
        try {
            int n;
            Runtime runtime = Runtime.getRuntime();
            this.generate(Long.parseLong(stringArray[1]));
            final Process process = runtime.exec(stringArray[0]);
            Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                public void run() {
                    process.destroy();
                }
            }));
            new ErrorReader(process.getErrorStream()).start();
            this.out = process.getOutputStream();
            this.in = new BufferedReader(new InputStreamReader(process.getInputStream()));
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.m.length).append(' ').append(this.jobs.length).append(' ').append(this.transfer).append('\n');
            for (int i = 0; i < this.m.length; ++i) {
                stringBuffer.append(this.m[i]).append('\n');
            }
            this.out.write(stringBuffer.toString().getBytes());
            String[] stringArray2 = new String[this.jobs.length];
            for (n = 0; n < stringArray2.length; ++n) {
                stringBuffer.delete(0, stringBuffer.length());
                stringBuffer.append(this.jobs[n]).append(' ').append(this.p[n]);
                for (int i = 0; i < this.g[n].length; ++i) {
                    if (this.g[n][i] == -1) continue;
                    stringBuffer.append(' ').append(this.g[n][i]);
                }
                stringArray2[n] = stringBuffer.toString();
            }
            for (n = 0; n < this.jobs.length; ++n) {
                this.out.write((stringArray2[n] + '\n').getBytes());
            }
            this.out.flush();
            n = Integer.parseInt(this.in.readLine());
            String[] stringArray3 = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray3[i] = this.in.readLine();
                if (stringArray3[i].trim().length() != 0) continue;
                --i;
            }
            System.out.println("score = " + this.score(stringArray3));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void addFatalError(String string) {
        System.out.println(string);
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 2) {
            System.err.println("Usage: java -Xmx1024M -jar ProcesorScheduling.jar <command> <seed>");
            return;
        }
        new ProcessorScheduling(stringArray);
    }

    public class ErrorReader
    extends Thread {
        InputStream error;

        public ErrorReader(InputStream inputStream) {
            this.error = inputStream;
        }

        public void run() {
            try {
                int n;
                byte[] byArray = new byte[50000];
                while ((n = this.error.read(byArray)) > 0) {
                    String string = new String(byArray, 0, n);
                    System.out.print(string);
                    System.out.flush();
                }
            }
            catch (Exception exception) {
                System.err.println("Failed to read from stderr");
            }
        }
    }
}

