/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Random;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class PopulationMappingVis {
    static final int MIN_SZ = 50;
    static final int MAX_SZ = 500;
    static final double BASE_PROB = 0.5;
    static final double CELL_PROB = 0.25;
    static final double SURROUND_PROB = 0.2;
    Random r;
    int width;
    int height;
    int total;
    boolean[][] land;
    int landArea = 0;
    String[] map;
    int[][] pop;
    int target;
    int queryCount = 0;
    int[] centers = new int[0];
    int[] centersScale = new int[0];
    boolean failedQueries = false;
    ArrayList<Query> queries = new ArrayList();
    int maxpopoverall = 0;
    String[] returnMap;
    static int scale;
    static String exec;
    static boolean debug;
    static boolean vis;
    static Process proc;
    static int del;
    InputStream is;
    OutputStream os;
    BufferedReader br;
    JFrame jf;
    Vis v;

    private int centerDistance(int n, int n2) {
        int n3 = this.width + this.height;
        for (int i = 0; i < this.centers.length; ++i) {
            int n4 = this.centers[i] / 10000;
            int n5 = this.centers[i] % 10000;
            n3 = Math.min(n3, (Math.abs(n - n4) + Math.abs(n2 - n5)) / this.centersScale[i]);
        }
        return Math.max(n3, 1);
    }

    private void generateMap() {
        int n;
        int n2;
        int n3 = 6;
        int n4 = 6;
        this.land = new boolean[n4][n3];
        for (n2 = 1; n2 < 5; ++n2) {
            for (n = 1; n < 5; ++n) {
                this.land[n2][n] = this.r.nextDouble() < 0.5;
            }
        }
        while (n3 < this.width || n4 < this.height) {
            boolean[][] blArray = new boolean[n4 * 2][n3 * 2];
            for (n = 0; n < n4 * 2; ++n) {
                for (int i = 0; i < n3 * 2; ++i) {
                    double d = 0.5 + (this.land[n / 2][i / 2] ? 0.25 : -0.25);
                    if (n % 2 == 0 && n > 0) {
                        d += this.land[n / 2 - 1][i / 2] ? 0.2 : -0.2;
                    }
                    if (n % 2 == 1 && n < n4 - 1) {
                        d += this.land[n / 2 + 1][i / 2] ? 0.2 : -0.2;
                    }
                    if (i % 2 == 0 && i > 0) {
                        d += this.land[n / 2][i / 2 - 1] ? 0.2 : -0.2;
                    }
                    if (i % 2 == 1 && i < n3 - 1) {
                        d += this.land[n / 2][i / 2 + 1] ? 0.2 : -0.2;
                    }
                    blArray[n][i] = this.r.nextDouble() < d;
                }
            }
            this.land = blArray;
            n3 *= 2;
            n4 *= 2;
        }
        this.map = new String[this.height];
        for (n2 = 0; n2 < this.height; ++n2) {
            this.map[n2] = "";
            for (n = 0; n < this.width; ++n) {
                if (this.land[n2][n]) {
                    int n5 = n2;
                    this.map[n5] = this.map[n5] + "X";
                    ++this.landArea;
                    continue;
                }
                int n6 = n2;
                this.map[n6] = this.map[n6] + ".";
            }
        }
    }

    private void generateCenters() {
        int n = 5 + this.r.nextInt((this.width + this.height) / 100);
        this.centers = new int[n];
        this.centersScale = new int[n];
        for (int i = 0; i < n; ++i) {
            while (this.centers[i] == 0) {
                int n2;
                int n3 = this.r.nextInt(this.height);
                if (!this.land[n3][n2 = this.r.nextInt(this.width)]) continue;
                this.centers[i] = n3 * 10000 + n2;
                this.centersScale[i] = 1 + this.r.nextInt(5);
            }
        }
    }

    public void generateTestCase(long l) {
        int n;
        this.r = new Random(l);
        this.width = this.r.nextInt(451) + 50;
        this.height = this.r.nextInt(451) + 50;
        if (l < 3L) {
            this.width = 50 + (int)l * 10;
            this.height = 50 + (int)l * 10;
        }
        this.pop = new int[this.height][this.width];
        this.generateMap();
        this.generateCenters();
        this.total = 0;
        for (n = 0; n < this.height; ++n) {
            for (int i = 0; i < this.width; ++i) {
                if (!this.land[n][i]) continue;
                int n2 = (this.width + this.height) * 8 / this.centerDistance(n, i);
                int n3 = this.r.nextInt(n2 + 1);
                this.pop[n][i] = n3;
                this.total += n3;
                this.maxpopoverall = Math.max(this.maxpopoverall, this.pop[n][i]);
            }
        }
        this.target = 97 - (int)Math.sqrt(this.r.nextInt(9216));
        if (debug) {
            System.out.println("Width = " + this.width + "\nHeight = " + this.height + "\nTotal Population = " + this.total + "\nTarget = " + this.target + "%\nLand Area = " + this.landArea + "\n");
            for (n = 0; n < this.height; ++n) {
                System.out.println(this.map[n]);
            }
        }
    }

    public int queryRegion(int n, int n2, int n3, int n4) {
        if (n > n3 || n2 > n4 || n < 0 || n3 > this.width - 1 || n2 < 0 || n4 > this.height - 1) {
            this.failedQueries = true;
            return -1;
        }
        ++this.queryCount;
        this.queries.add(new Query(n, n2, n3, n4));
        int n5 = 0;
        for (int i = n2; i <= n4; ++i) {
            for (int j = n; j <= n3; ++j) {
                n5 += this.pop[i][j];
            }
        }
        return n5;
    }

    public double runTest(String string) {
        long l = Long.parseLong(string);
        this.generateTestCase(l);
        if (vis) {
            this.returnMap = new String[0];
            this.jf.setSize(this.width * scale + 50, this.height * scale + 40);
            this.jf.setVisible(true);
            this.draw();
        }
        String[] stringArray = this.mapPopulation(this.target, this.map, this.total);
        if (this.failedQueries) {
            this.addFatalError("One or more issued queries contained invalid parameters.");
            return -1.0;
        }
        if (stringArray.length != this.height) {
            this.addFatalError("Return array length must be the same as the initial map height.");
            return -1.0;
        }
        for (int i = 0; i < this.height; ++i) {
            if (stringArray[i].length() == this.width) continue;
            this.addFatalError("Element " + i + " of return array length must be the same as the initial map width.");
            return -1.0;
        }
        if (vis) {
            this.returnMap = stringArray;
            try {
                Thread.sleep(50L);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.draw();
        }
        long l2 = this.target * this.total / 100;
        long l3 = 0L;
        int n = 0;
        boolean[][] blArray = new boolean[this.height][this.width];
        for (int i = 0; i < stringArray.length; ++i) {
            for (int j = 0; j < stringArray[i].length(); ++j) {
                if (stringArray[i].charAt(j) != 'X' || !this.land[i][j]) continue;
                l3 += (long)this.pop[i][j];
                ++n;
            }
        }
        if (l3 > l2) {
            this.addFatalError("Selected areas count too much population.");
            return -1.0;
        }
        this.addFatalError("Area = " + n + "\nQueries = " + this.queryCount);
        return 1.0 * (double)n * Math.pow(0.996, this.queryCount);
    }

    public String checkData(String string) {
        return "";
    }

    public String displayTestCase(String string) {
        long l = Long.parseLong(string);
        this.generateTestCase(l);
        String string2 = "Width = " + this.width + "\nHeight = " + this.height + "\nTotal Population = " + this.total + "\nTarget = " + this.target + "%\nLand Area = " + this.landArea + "\n";
        if (this.height < 100 && this.width < 100) {
            for (int i = 0; i < this.height; ++i) {
                string2 = string2 + this.map[i] + "\n";
            }
        }
        return string2;
    }

    public double[] score(double[][] dArray) {
        int n;
        int n2;
        double[] dArray2 = new double[dArray.length];
        double[] dArray3 = new double[dArray[0].length];
        for (n2 = 0; n2 < dArray.length; ++n2) {
            for (n = 0; n < dArray[n2].length; ++n) {
                dArray3[n] = Math.max(dArray3[n], dArray[n2][n]);
            }
        }
        for (n2 = 0; n2 < dArray.length; ++n2) {
            for (n = 0; n < dArray[n2].length; ++n) {
                if (!(dArray[n2][n] > 0.0) || !(dArray3[n] > 0.0)) continue;
                int n3 = n2;
                dArray2[n3] = dArray2[n3] + dArray[n2][n] / dArray3[n];
            }
        }
        n2 = 0;
        while (n2 < dArray.length) {
            int n4 = n2;
            dArray2[n4] = dArray2[n4] / (double)dArray3.length;
            int n5 = n2++;
            dArray2[n5] = dArray2[n5] * 1000000.0;
        }
        return dArray2;
    }

    String[] mapPopulation(int n, String[] stringArray, int n2) {
        String[] stringArray2 = new String[]{};
        try {
            if (exec != null) {
                String string;
                int n3;
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(n).append('\n');
                stringBuffer.append(this.height).append('\n');
                for (n3 = 0; n3 < this.height; ++n3) {
                    stringBuffer.append(stringArray[n3]).append('\n');
                }
                stringBuffer.append(n2).append('\n');
                this.os.write(stringBuffer.toString().getBytes());
                this.os.flush();
                while ((string = this.br.readLine()).equals("?")) {
                    String[] stringArray3 = this.br.readLine().split(" ");
                    if (stringArray3.length != 4) {
                        return stringArray2;
                    }
                    int[] nArray = new int[4];
                    try {
                        for (n3 = 0; n3 < 4; ++n3) {
                            nArray[n3] = Integer.parseInt(stringArray3[n3]);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        return stringArray2;
                    }
                    long l = this.queryRegion(nArray[0], nArray[1], nArray[2], nArray[3]);
                    if (l < 0L) {
                        return stringArray2;
                    }
                    this.os.write((l + "\n").getBytes());
                    this.os.flush();
                }
                int n4 = Integer.parseInt(string);
                stringArray2 = new String[n4];
                for (n3 = 0; n3 < n4; ++n3) {
                    stringArray2[n3] = this.br.readLine();
                }
            }
            return stringArray2;
        }
        catch (IOException iOException) {
            return stringArray2;
        }
    }

    void draw() {
        if (!vis) {
            return;
        }
        this.v.repaint();
        try {
            Thread.sleep(del);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public PopulationMappingVis(String string) {
        try {
            if (vis) {
                this.jf = new JFrame();
                this.v = new Vis();
                this.jf.getContentPane().add(this.v);
            }
            if (exec != null) {
                try {
                    Runtime runtime = Runtime.getRuntime();
                    proc = runtime.exec(exec);
                    this.os = proc.getOutputStream();
                    this.is = proc.getInputStream();
                    this.br = new BufferedReader(new InputStreamReader(this.is));
                    new ErrorReader(proc.getErrorStream()).start();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            System.out.println("Score = " + this.runTest(string));
            if (proc != null) {
                try {
                    proc.destroy();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        String string = "1";
        vis = true;
        debug = false;
        del = 1000;
        scale = 2;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-seed")) {
                string = stringArray[++i];
            }
            if (stringArray[i].equals("-exec")) {
                exec = stringArray[++i];
            }
            if (stringArray[i].equals("-novis")) {
                vis = false;
            }
            if (stringArray[i].equals("-debug")) {
                debug = true;
            }
            if (stringArray[i].equals("-delay")) {
                del = Integer.parseInt(stringArray[++i]);
            }
            if (!stringArray[i].equals("-scale")) continue;
            scale = Integer.parseInt(stringArray[++i]);
        }
        PopulationMappingVis populationMappingVis = new PopulationMappingVis(string);
    }

    void addFatalError(String string) {
        System.out.println(string);
    }

    public class Vis
    extends JPanel
    implements WindowListener {
        @Override
        public void paint(Graphics graphics) {
            BufferedImage bufferedImage = new BufferedImage(PopulationMappingVis.this.width * scale + 150, PopulationMappingVis.this.height * scale + 1, 1);
            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
            graphics2D.setColor(new Color(0xEEEEEE));
            graphics2D.fillRect(0, 0, PopulationMappingVis.this.width * scale + 150, PopulationMappingVis.this.height * scale + 1);
            graphics2D.setColor(new Color(0xAAAAAA));
            graphics2D.fillRect(0, 0, PopulationMappingVis.this.width * scale, PopulationMappingVis.this.height * scale);
            boolean bl = PopulationMappingVis.this.returnMap.length > 0;
            for (int i = 0; i < PopulationMappingVis.this.height; ++i) {
                for (int j = 0; j < PopulationMappingVis.this.width; ++j) {
                    if (!PopulationMappingVis.this.land[i][j]) {
                        graphics2D.setColor(new Color(52428));
                    } else {
                        int n = (PopulationMappingVis.this.maxpopoverall - PopulationMappingVis.this.pop[i][j]) * 255 / PopulationMappingVis.this.maxpopoverall;
                        int n2 = !bl || PopulationMappingVis.this.returnMap[i].charAt(j) != 'X' ? 0xFF0000 + 257 * n : 0x770077 + 256 * n;
                        graphics2D.setColor(new Color(n2));
                    }
                    graphics2D.fillRect(j * scale + 1, i * scale + 1, scale, scale);
                }
            }
            graphics2D.setColor(new Color(43775));
            for (Query query : PopulationMappingVis.this.queries) {
                graphics2D.drawRect(query.x1 * scale, query.y1 * scale, (query.x2 - query.x1 + 1) * scale + 1, (query.y2 - query.y1 + 1) * scale + 1);
            }
            graphics.drawImage(bufferedImage, 0, 0, PopulationMappingVis.this.width * scale + 150, PopulationMappingVis.this.height * scale + 1, null);
        }

        public Vis() {
            PopulationMappingVis.this.jf.addWindowListener(this);
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            if (proc != null) {
                try {
                    proc.destroy();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            System.exit(0);
        }

        @Override
        public void windowActivated(WindowEvent windowEvent) {
        }

        @Override
        public void windowDeactivated(WindowEvent windowEvent) {
        }

        @Override
        public void windowOpened(WindowEvent windowEvent) {
        }

        @Override
        public void windowClosed(WindowEvent windowEvent) {
        }

        @Override
        public void windowIconified(WindowEvent windowEvent) {
        }

        @Override
        public void windowDeiconified(WindowEvent windowEvent) {
        }
    }

    class Query {
        int x1;
        int y1;
        int x2;
        int y2;

        public Query(int n, int n2, int n3, int n4) {
            this.x1 = n;
            this.y1 = n2;
            this.x2 = n3;
            this.y2 = n4;
        }
    }
}

