/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class PolyominoCoveringVis {
    private static int minN = 8;
    private static int maxN = 50;
    private static int minNum = -9;
    private static int maxNum = 9;
    private static int minTile = 2;
    private static int maxTile = 7;
    static final int[] dr = new int[]{0, 1, 0, -1};
    static final int[] dc = new int[]{-1, 0, 1, 0};
    static final int Penalty = 1000;
    static final int UncoveredCell = -1;
    int N;
    int[][] Grid;
    int[] Tiles;
    Tile T;
    Map<Integer, Tile> AllTiles;
    long Score;
    JFrame jf;
    Vis v;
    static String exec;
    static boolean vis;
    static Process proc;
    InputStream is;
    OutputStream os;
    BufferedReader br;
    static int SZ;
    static boolean Debug;
    static int[] Solution;
    static int[][] Board;

    void generate(String string) {
        try {
            int n;
            int n2;
            SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
            long l = Long.parseLong(string);
            secureRandom.setSeed(l);
            this.N = secureRandom.nextInt(maxN - minN + 1) + minN;
            if (l == 1L) {
                this.N = minN;
            }
            if (l == 2L) {
                this.N = maxN;
            }
            this.Grid = new int[this.N][this.N];
            for (n2 = 0; n2 < this.N; ++n2) {
                for (n = 0; n < this.N; ++n) {
                    this.Grid[n2][n] = secureRandom.nextInt(maxNum - minNum + 1) + minNum;
                }
            }
            this.Tiles = new int[maxTile - minTile + 1];
            n2 = this.N * this.N;
            while (n2 > 0) {
                n = secureRandom.nextInt(maxTile - minTile + 1) + minTile;
                if (n2 - n < minTile && n2 - n != 0) continue;
                int n3 = n - minTile;
                this.Tiles[n3] = this.Tiles[n3] + 1;
                n2 -= n;
            }
            if (Debug) {
                this.printTest(string);
            }
        }
        catch (Exception exception) {
            this.addFatalError("An exception occurred while generating test case.");
            exception.printStackTrace();
        }
    }

    void printTest(String string) {
        System.out.println("seed = " + string);
        System.out.println("N = " + this.N);
        System.out.print("Tiles:");
        int[] nArray = this.Tiles;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = nArray[i];
            System.out.print(" " + n2);
        }
        System.out.println();
        System.out.println("Grid:");
        for (int i = 0; i < this.N; ++i) {
            for (n = 0; n < this.N; ++n) {
                System.out.print(this.Grid[i][n] + " ");
            }
            System.out.println();
        }
    }

    public double runTest(String string) {
        try {
            this.generate(string);
            if (proc != null) {
                int n;
                try {
                    Solution = this.callSolution();
                }
                catch (Exception exception) {
                    this.addFatalError("Failed to get result from your solution.");
                    return -1.0;
                }
                if (Solution == null) {
                    this.addFatalError("Your return contained invalid number of elements.");
                    return -1.0;
                }
                if (Solution.length != this.N * this.N) {
                    this.addFatalError("Your return did not contain " + this.N * this.N + " elements.");
                    return -1.0;
                }
                Board = new int[this.N][this.N];
                int n2 = 0;
                for (int i = 0; i < this.N; ++i) {
                    n = 0;
                    while (n < this.N) {
                        PolyominoCoveringVis.Board[i][n] = Solution[n2];
                        if (Board[i][n] != -1 && Board[i][n] <= 0) {
                            this.addFatalError("Cell (" + i + "," + n + ") has illegal ID " + Board[i][n]);
                            return -1.0;
                        }
                        ++n;
                        ++n2;
                    }
                }
                boolean[][] blArray = new boolean[this.N][this.N];
                int[] nArray = new int[maxTile + 1];
                this.AllTiles = new HashMap<Integer, Tile>();
                this.Score = 0L;
                for (n = 0; n < this.N; ++n) {
                    for (int i = 0; i < this.N; ++i) {
                        if (blArray[n][i]) continue;
                        int n3 = Board[n][i];
                        if (n3 == -1) {
                            this.Score -= 1000L;
                            continue;
                        }
                        this.T = new Tile();
                        this.go(n, i, n3, blArray);
                        if (this.T.size < minTile) {
                            this.addFatalError("Tile " + n3 + " is too small");
                            return -1.0;
                        }
                        if (this.T.size > maxTile) {
                            this.addFatalError("Tile " + n3 + " is too big");
                            return -1.0;
                        }
                        if (this.AllTiles.containsKey(n3)) {
                            this.addFatalError("Tile " + n3 + " has already been used");
                            return -1.0;
                        }
                        this.AllTiles.put(n3, this.T);
                        this.Score += (long)this.T.score;
                        int n4 = this.T.size;
                        nArray[n4] = nArray[n4] + 1;
                        if (nArray[this.T.size] <= this.Tiles[this.T.size - minTile]) continue;
                        this.addFatalError("You have used too many tiles of size " + this.T.size);
                        return -1.0;
                    }
                }
                if (vis) {
                    this.jf.setSize(this.N * SZ + 150, this.N * SZ + 50);
                    this.jf.setVisible(true);
                    this.draw();
                }
            }
            return this.Score;
        }
        catch (Exception exception) {
            this.addFatalError("An exception occurred while trying to get your program's results.");
            exception.printStackTrace();
            return -1.0;
        }
    }

    void go(int n, int n2, int n3, boolean[][] blArray) {
        if (n < 0 || n >= this.N || n2 < 0 || n2 >= this.N || blArray[n][n2] || Board[n][n2] != n3) {
            return;
        }
        blArray[n][n2] = true;
        this.T.loc.add(new Loc(n, n2));
        this.T.score *= this.Grid[n][n2];
        ++this.T.size;
        for (int i = 0; i < dr.length; ++i) {
            this.go(n + dr[i], n2 + dc[i], n3, blArray);
        }
    }

    private int[] callSolution() throws IOException, NumberFormatException {
        int n;
        if (exec == null) {
            return null;
        }
        String string = this.N + "\n";
        this.os.write(string.getBytes());
        for (int i = 0; i < this.N; ++i) {
            for (n = 0; n < this.N; ++n) {
                string = this.Grid[i][n] + "\n";
                this.os.write(string.getBytes());
            }
        }
        for (int n2 : this.Tiles) {
            string = n2 + "\n";
            this.os.write(string.getBytes());
        }
        this.os.flush();
        int[] nArray = new int[Integer.parseInt(this.br.readLine())];
        for (n = 0; n < nArray.length; ++n) {
            nArray[n] = Integer.parseInt(this.br.readLine());
        }
        return nArray;
    }

    void draw() {
        if (!vis) {
            return;
        }
        this.v.repaint();
    }

    public PolyominoCoveringVis(String string) {
        try {
            if (vis) {
                this.jf = new JFrame();
                this.v = new Vis();
                this.jf.getContentPane().add(this.v);
            }
            if (exec != null) {
                try {
                    Runtime runtime = Runtime.getRuntime();
                    proc = runtime.exec(exec);
                    this.os = proc.getOutputStream();
                    this.is = proc.getInputStream();
                    this.br = new BufferedReader(new InputStreamReader(this.is));
                    new ErrorReader(proc.getErrorStream()).start();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            System.out.println("Score = " + this.runTest(string));
            if (proc != null) {
                try {
                    proc.destroy();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        String string = "1";
        vis = true;
        SZ = 20;
        Debug = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-seed")) {
                string = stringArray[++i];
            }
            if (stringArray[i].equals("-exec")) {
                exec = stringArray[++i];
            }
            if (stringArray[i].equals("-novis")) {
                vis = false;
            }
            if (stringArray[i].equals("-size")) {
                SZ = Integer.parseInt(stringArray[++i]);
            }
            if (!stringArray[i].equals("-debug")) continue;
            Debug = true;
        }
        if (string.equals("1")) {
            SZ = 50;
        }
        PolyominoCoveringVis polyominoCoveringVis = new PolyominoCoveringVis(string);
    }

    void addFatalError(String string) {
        System.out.println(string);
    }

    class Tile {
        List loc = new ArrayList();
        int score = 1;
        int size = 0;
    }

    class Loc {
        int r;
        int c;

        public Loc(int n, int n2) {
            this.r = n;
            this.c = n2;
        }
    }

    public class Vis
    extends JPanel
    implements MouseListener,
    WindowListener {
        @Override
        public void paint(Graphics graphics) {
            int n;
            int n2;
            Color[] colorArray = new Color[]{null, null, Color.GRAY, Color.GREEN, Color.CYAN, Color.YELLOW, Color.PINK, Color.MAGENTA};
            int n3 = 10;
            int n4 = 10;
            graphics.setColor(new Color(0xDDDDDD));
            graphics.fillRect(0, 0, PolyominoCoveringVis.this.N * SZ + 150, PolyominoCoveringVis.this.N * SZ + 40);
            graphics.setColor(Color.WHITE);
            graphics.fillRect(n3, n4, PolyominoCoveringVis.this.N * SZ, PolyominoCoveringVis.this.N * SZ);
            graphics.setColor(Color.BLACK);
            for (n2 = 0; n2 <= PolyominoCoveringVis.this.N; ++n2) {
                graphics.drawLine(n3, n4 + n2 * SZ, n3 + PolyominoCoveringVis.this.N * SZ, n4 + n2 * SZ);
            }
            for (n2 = 0; n2 <= PolyominoCoveringVis.this.N; ++n2) {
                graphics.drawLine(n3 + n2 * SZ, n4, n3 + n2 * SZ, n4 + PolyominoCoveringVis.this.N * SZ);
            }
            for (n2 = 0; n2 < PolyominoCoveringVis.this.N; ++n2) {
                for (n = 0; n < PolyominoCoveringVis.this.N; ++n) {
                    if (Board[n2][n] != -1) {
                        Tile tile = PolyominoCoveringVis.this.AllTiles.get(Board[n2][n]);
                        graphics.setColor(colorArray[tile.size]);
                        graphics.fillRect(n3 + n * SZ + 1, n4 + n2 * SZ + 1, SZ - 1, SZ - 1);
                    }
                    graphics.setFont(new Font("Arial", 0, 14));
                    graphics.setColor(Color.BLACK);
                    graphics.drawString("" + PolyominoCoveringVis.this.Grid[n2][n], n3 + n * SZ + SZ / 2 - 5, n4 + n2 * SZ + SZ / 2 + 5);
                }
            }
            graphics.setColor(Color.BLACK);
            graphics.setFont(new Font("Arial", 1, 14));
            graphics.drawString("SCORE", SZ * PolyominoCoveringVis.this.N + 25, 30);
            graphics.drawString(String.format("%d", PolyominoCoveringVis.this.Score), SZ * PolyominoCoveringVis.this.N + 25, 50);
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            graphics2D.setColor(Color.BLACK);
            graphics2D.setStroke(new BasicStroke(4.0f));
            for (n = 0; n < PolyominoCoveringVis.this.N; ++n) {
                for (int i = 0; i < PolyominoCoveringVis.this.N; ++i) {
                    int n5 = n;
                    int n6 = i + 1;
                    if (n6 < PolyominoCoveringVis.this.N && Board[n][i] != Board[n5][n6]) {
                        graphics2D.drawLine(n3 + (i + 1) * SZ, n4 + n * SZ, n3 + (i + 1) * SZ, n4 + (n + 1) * SZ);
                    }
                    n5 = n + 1;
                    n6 = i;
                    if (n5 >= PolyominoCoveringVis.this.N || Board[n][i] == Board[n5][n6]) continue;
                    graphics2D.drawLine(n3 + i * SZ, n4 + (n + 1) * SZ, n3 + (i + 1) * SZ, n4 + (n + 1) * SZ);
                }
            }
            graphics2D.drawRect(n3, n4, PolyominoCoveringVis.this.N * SZ, PolyominoCoveringVis.this.N * SZ);
            graphics2D.dispose();
        }

        public Vis() {
            PolyominoCoveringVis.this.jf.addWindowListener(this);
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            if (proc != null) {
                try {
                    proc.destroy();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            System.exit(0);
        }

        @Override
        public void windowActivated(WindowEvent windowEvent) {
        }

        @Override
        public void windowDeactivated(WindowEvent windowEvent) {
        }

        @Override
        public void windowOpened(WindowEvent windowEvent) {
        }

        @Override
        public void windowClosed(WindowEvent windowEvent) {
        }

        @Override
        public void windowIconified(WindowEvent windowEvent) {
        }

        @Override
        public void windowDeiconified(WindowEvent windowEvent) {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }
    }
}

